/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.sun.appserv;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.optional.sun.appserv.AppServerAdmin;

public class AdminTask
extends AppServerAdmin {
    private String command;
    private String explicitCommand;
    private File commandFile;

    public void setCommand(String string) {
        this.command = string.trim();
    }

    public void setExplicitcommand(String string) {
        this.explicitCommand = string;
    }

    public void setCommandfile(File file) {
        this.commandFile = file;
    }

    public void execute() throws BuildException {
        this.checkCommandCount();
        if (this.command != null && this.servers.size() == 0 && this.server == null) {
            this.explicitCommand = this.command;
            this.command = null;
        }
        if (this.explicitCommand != null) {
            this.execAdminCommand(this.explicitCommand);
        } else {
            super.execute();
        }
    }

    private void checkCommandCount() throws BuildException {
        int n = 0;
        if (this.command != null) {
            ++n;
        }
        if (this.explicitCommand != null) {
            ++n;
        }
        if (this.commandFile != null) {
            ++n;
        }
        if (n != 1) {
            String string = "Exactly one of the command attributes must be used (command, explicitcommand, or commandfile)";
            throw new BuildException(string, this.getLocation());
        }
    }

    protected void checkConfiguration(AppServerAdmin.Server server) throws BuildException {
    }

    protected void execute(AppServerAdmin.Server server) throws BuildException {
        StringBuffer stringBuffer;
        String[] stringArray = new String[]{"--user ", "-u "};
        String[] stringArray2 = new String[]{"--password ", "-w "};
        String[] stringArray3 = new String[]{"--host ", "-H "};
        String[] stringArray4 = new String[]{"--port ", "-p "};
        String[] stringArray5 = new String[]{"--instance ", "-i "};
        if (this.command != null) {
            String string;
            stringBuffer = new StringBuffer(this.command);
            if (!this.commandIncludes(stringBuffer, stringArray)) {
                this.insertCommandOption(stringBuffer, " --user " + server.getUser());
            }
            if (server.getPassword() != null && !this.commandIncludes(stringBuffer, stringArray2)) {
                this.insertCommandOption(stringBuffer, " --password " + server.getPassword());
            }
            if (!this.commandIncludes(stringBuffer, stringArray3)) {
                string = server.getHost();
                if (string == null) {
                    string = "localhost";
                }
                this.insertCommandOption(stringBuffer, " --host " + string);
            }
            if (!this.commandIncludes(stringBuffer, stringArray4)) {
                string = server.getPort() == 0 ? "4848" : String.valueOf(server.getPort());
                this.insertCommandOption(stringBuffer, " --port " + string);
            }
            if (server.getInstance() != null && !this.commandIncludes(stringBuffer, stringArray5)) {
                this.insertCommandOption(stringBuffer, " --instance " + server.getInstance());
            }
        } else {
            stringBuffer = new StringBuffer("multimode --file " + this.commandFile.getAbsolutePath());
        }
        this.execAdminCommand(stringBuffer.toString());
    }

    private boolean commandIncludes(StringBuffer stringBuffer, String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringBuffer.indexOf(stringArray[n]) > 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private void insertCommandOption(StringBuffer stringBuffer, String string) {
        int n = stringBuffer.indexOf(" ");
        n = n >= 0 ? n : stringBuffer.length();
        stringBuffer.insert(n, string).append(' ');
    }
}

