/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.management.jmx.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Date;
import java.util.Iterator;
import javax.management.Attribute;
import javax.management.AttributeChangeNotification;
import javax.management.AttributeChangeNotificationFilter;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.Descriptor;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;
import javax.management.RuntimeMBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.ServiceNotFoundException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.modelmbean.InvalidTargetObjectTypeException;
import javax.management.modelmbean.ModelMBean;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import javax.management.modelmbean.ModelMBeanConstructorInfo;
import javax.management.modelmbean.ModelMBeanInfo;
import javax.management.modelmbean.ModelMBeanInfoSupport;
import javax.management.modelmbean.ModelMBeanNotificationInfo;
import javax.management.modelmbean.ModelMBeanOperationInfo;

public class RequiredModelMBean
implements ModelMBean {
    ModelMBeanInfo modelMBeanInfo;
    private NotificationBroadcasterSupport generalBroadcaster = null;
    private NotificationBroadcasterSupport attributeBroadcaster = null;
    private Object managedResource = null;
    private String managedResourceType = "objectreference";
    private PrintStream logOut = null;
    private String currClass = "RequiredModelMBean";

    public RequiredModelMBean() throws MBeanException, RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("RequiredModelMBean()", "Entry and Exit");
        }
        try {
            this.load();
        }
        catch (Exception exception) {}
        this.modelMBeanInfo = this.createDefaultModelMBeanInfo();
    }

    public RequiredModelMBean(ModelMBeanInfo modelMBeanInfo) throws MBeanException, RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("RequiredModelMBean(MBeanInfo)", "Entry");
        }
        try {
            this.load();
        }
        catch (Exception exception) {}
        this.setModelMBeanInfo(modelMBeanInfo);
        if (this.tracing()) {
            this.trace("RequiredModelMBean(MBeanInfo)", "Exit");
        }
    }

    public void addAttributeChangeNotificationListener(NotificationListener notificationListener, String string, Object object) throws MBeanException, RuntimeOperationsException, IllegalArgumentException {
        if (this.tracing()) {
            this.trace("addAttributeChangeNotificationListener(NotificationListener, String, Object)", "Entry");
        }
        if (notificationListener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Listener to be registered must not be null"), "Exception occured trying to register for attribute change notification of a ModelMBean");
        }
        if (this.attributeBroadcaster == null) {
            this.attributeBroadcaster = new NotificationBroadcasterSupport();
        }
        try {
            AttributeChangeNotificationFilter attributeChangeNotificationFilter = new AttributeChangeNotificationFilter();
            attributeChangeNotificationFilter.enableAttribute(string);
            if (this.tracing()) {
                this.trace("addAttributeChangeNotificationListener", "Set attribute change filter to " + attributeChangeNotificationFilter.getEnabledAttributes().firstElement().toString());
            }
            this.attributeBroadcaster.addNotificationListener(notificationListener, attributeChangeNotificationFilter, object);
            if (this.tracing()) {
                this.trace("addAttributeChangeNotificationListener", "added for " + string);
            }
        }
        catch (RuntimeException runtimeException) {
            throw new RuntimeOperationsException(runtimeException, "addAttributeChangeNotificationListener threw " + runtimeException.getMessage());
        }
        if (this.tracing()) {
            this.trace("addAttributeChangeNotificationListener(NotificationListener, String, Object)", "Exit");
        }
    }

    private ModelMBeanNotificationInfo[] addModelMBeanAttributeChangeNotification(MBeanNotificationInfo[] mBeanNotificationInfoArray) {
        ModelMBeanNotificationInfo[] modelMBeanNotificationInfoArray;
        if (this.tracing()) {
            this.trace("addModelMBeanAttributeChangeNotification(MBeanNotificationInfo)", "entry");
        }
        DescriptorSupport descriptorSupport = new DescriptorSupport(new String[]{"name=jmx.ModelMBean.General", "descriptorType=notification", "severity=5", "MessageId=JMXMMBAC"});
        ModelMBeanNotificationInfo modelMBeanNotificationInfo = new ModelMBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "AttributeChange", "ModelMBean Attribute Change Event", descriptorSupport);
        if (this.tracing()) {
            this.trace("addModelMBeanAttributeChangeNotification", "ModelMBeanAttributeChangeNotification created: " + modelMBeanNotificationInfo);
        }
        if (this.tracing()) {
            this.trace("addModelMBeanAttributeChangeNotification(MBeanNotificationInfo)", "Adding attributeChangeNotificationInfo: name:" + modelMBeanNotificationInfo.getName() + " desc:" + modelMBeanNotificationInfo.getDescription() + " notifs:" + modelMBeanNotificationInfo.getNotifTypes()[0]);
        }
        if (mBeanNotificationInfoArray == null || mBeanNotificationInfoArray.length == 0) {
            if (this.tracing()) {
                this.trace("addModelMBeanAttributeChangeNotification(MBeanNotificationInfo)", "No MBeanInfo Notifications: adding attributeChangeNotificationInfo");
            }
            modelMBeanNotificationInfoArray = new ModelMBeanNotificationInfo[]{modelMBeanNotificationInfo};
        } else {
            modelMBeanNotificationInfoArray = new ModelMBeanNotificationInfo[mBeanNotificationInfoArray.length + 1];
            if (this.tracing()) {
                this.trace("addModelMBeanAttributeChangeNotification(MBeanNotificationInfo)", String.valueOf(mBeanNotificationInfoArray.length) + " MBeanInfo Notifications: adding attributeChangeNotificationInfo to make " + modelMBeanNotificationInfoArray.length + " notifications");
            }
            int n = 0;
            while (n < mBeanNotificationInfoArray.length) {
                if (this.tracing()) {
                    this.trace("addModelMBeanAttributeChangeNotification(MBeanNotificationInfo)", "Moving NotificationInfo " + n + ": name:" + mBeanNotificationInfoArray[n].getName() + " desc:" + mBeanNotificationInfoArray[n].getDescription() + " notifs:" + mBeanNotificationInfoArray[n].getNotifTypes()[0]);
                }
                modelMBeanNotificationInfoArray[n] = (ModelMBeanNotificationInfo)((ModelMBeanNotificationInfo)mBeanNotificationInfoArray[n]).clone();
                ++n;
            }
            modelMBeanNotificationInfoArray[modelMBeanNotificationInfoArray.length - 1] = modelMBeanNotificationInfo;
        }
        if (this.tracing()) {
            this.trace("addModelMBeanAttributeChangeNotification(MBeanNotificationInfo)", "Exit");
        }
        return modelMBeanNotificationInfoArray;
    }

    public void addNotificationListener(NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws IllegalArgumentException {
        if (this.tracing()) {
            this.trace("addNotificationListener(NotificationListener, NotificationFilter, Object)", "Entry");
        }
        if (notificationListener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("notification listener must not be null"), "Exception occured trying to add a notification listener to a RequiredModelMBean");
        }
        if (this.generalBroadcaster == null) {
            this.generalBroadcaster = new NotificationBroadcasterSupport();
        }
        this.generalBroadcaster.addNotificationListener(notificationListener, notificationFilter, object);
        if (this.tracing()) {
            this.trace("addNotificationListener(NotificationListener, NotificationFilter, Object)", "NotificationListener added");
            this.trace("addNotificationListener(NotificationListener, NotificationFilter, Object)", "Exit");
        }
    }

    private ModelMBeanInfo createDefaultModelMBeanInfo() {
        return new ModelMBeanInfoSupport(this.getClass().getName(), "Default ModelMBean", null, null, null, null);
    }

    private void createMBeanInfoFromFile(FileInputStream fileInputStream) throws IOException, MBeanException {
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            ModelMBeanInfo modelMBeanInfo = (ModelMBeanInfo)objectInputStream.readObject();
            objectInputStream.close();
            this.setModelMBeanInfo(modelMBeanInfo);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MBeanException(classNotFoundException, "Could not load serialized ModelMBeanInfo.");
        }
    }

    private void debug(String string, String string2) {
        this.debug(this.currClass, string, string2);
    }

    private void debug(String string, String string2, String string3) {
        Trace.send(2, 128, string, string2, String.valueOf(Integer.toHexString(this.hashCode())) + " " + string3);
    }

    private boolean debugging() {
        return Trace.isSelected(2, 128);
    }

    private void echo(String string) {
        this.trace("echo(txt)", string);
    }

    public Object getAttribute(String string) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Object object;
        block28: {
            if (string == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("attributeName must not be null"), "Exception occured trying to get attribute of a RequiredModelMBean");
            }
            if (this.tracing()) {
                this.trace("getAttribute(String)", "Entry with" + string);
            }
            ModelMBeanAttributeInfo modelMBeanAttributeInfo = null;
            Descriptor descriptor = null;
            object = null;
            try {
                if (this.modelMBeanInfo == null) {
                    throw new AttributeNotFoundException("getAttribute failed: ModelMBeanAttributeInfo not found for " + string);
                }
                modelMBeanAttributeInfo = this.modelMBeanInfo.getAttribute(string);
                Descriptor descriptor2 = this.modelMBeanInfo.getMBeanDescriptor();
                if (modelMBeanAttributeInfo == null) {
                    throw new AttributeNotFoundException("getAttribute failed: ModelMBeanAttributeInfo not found for " + string);
                }
                descriptor = modelMBeanAttributeInfo.getDescriptor();
                if (descriptor != null) {
                    Object object2;
                    String string2;
                    object = this.resolveForCacheValue(descriptor);
                    if (this.tracing()) {
                        this.trace("getAttribute(String)", "*** cached value is " + object);
                    }
                    if (object == null) {
                        if (this.tracing()) {
                            this.trace("getAttribute(String)", "**** cached value is null - getting getMethod");
                        }
                        if ((string2 = (String)descriptor.getFieldValue("getMethod")) != null) {
                            if (this.tracing()) {
                                this.trace("getAttribute(String)", "invoking a getMethod for " + string);
                            }
                            if ((object2 = this.invoke(string2, new Object[0], new String[0])) != null) {
                                if (this.tracing()) {
                                    this.trace("getAttribute(String)", "got a non-null response from getMethod\n");
                                }
                                object = object2;
                                String string3 = (String)descriptor.getFieldValue("currencyTimeLimit");
                                if (string3 == null && descriptor2 != null) {
                                    string3 = (String)descriptor2.getFieldValue("currencyTimeLimit");
                                }
                                if (string3 != null && !string3.equals("0")) {
                                    if (this.tracing()) {
                                        this.trace("getAttribute(String)", "setting cached value and lastUpdatedTime in descriptor");
                                    }
                                    descriptor.setField("value", object);
                                    descriptor.setField("lastUpdatedTimeStamp", new Long(new Date().getTime()).toString());
                                    modelMBeanAttributeInfo.setDescriptor(descriptor);
                                    this.modelMBeanInfo.setDescriptor(descriptor, "attribute");
                                    if (this.tracing()) {
                                        this.trace("getAttribute(String)", "new descriptor is " + descriptor.toString());
                                        this.trace("setAttribute()", "local: AttributeInfo descriptor is " + modelMBeanAttributeInfo.getDescriptor().toString());
                                        this.trace("setAttribute()", "modelMBeanInfo: AttributeInfo descriptor is " + this.modelMBeanInfo.getDescriptor(string, "attribute").toString());
                                    }
                                }
                            } else {
                                if (this.tracing()) {
                                    this.trace("getAttribute(String)", "got a null response from getMethod\n");
                                }
                                object = null;
                            }
                        } else {
                            if (this.tracing()) {
                                this.trace("getAttribute(String)", "could not find getMethod for " + string + ", returning default value");
                            }
                            object = descriptor.getFieldValue("default");
                        }
                    }
                    string2 = modelMBeanAttributeInfo.getType();
                    if (object != null && !string2.equals(object2 = object.getClass().getName())) {
                        if (this.tracing()) {
                            this.trace("getAttribute(String)", "wrong response type");
                        }
                        throw new MBeanException(new InvalidAttributeValueException("Wrong value type recieved for get attribute"), "An exception occured while trying to get an attribute value through a RequiredModelMBean");
                    }
                    break block28;
                }
                if (this.tracing()) {
                    this.trace("getAttribute(String)", "getMethod failed " + string + " not in attributeDescriptor\n");
                }
                throw new MBeanException(new InvalidAttributeValueException("Unable to resolve attribute value, no getMethod defined in descriptor for attribute"), "An exception occured while trying to get an attribute value through a RequiredModelMBean");
            }
            catch (MBeanException mBeanException) {
                throw mBeanException;
            }
            catch (Exception exception) {
                if (this.tracing()) {
                    this.trace("getAttribute(String)", "getMethod failed with " + exception.getMessage() + " exception type " + exception.getClass().toString());
                    exception.printStackTrace();
                }
                throw new MBeanException(exception, "An exception occured while trying to get an attribute value: " + exception.getMessage());
            }
        }
        if (this.tracing()) {
            this.trace("getAttribute(String)", "Exit");
        }
        return object;
    }

    public AttributeList getAttributes(String[] stringArray) {
        if (this.tracing()) {
            this.trace("getAttributes(String[])", "Entry");
        }
        AttributeList attributeList = null;
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributeNames must not be null"), "Exception occured trying to get attributes of a RequiredModelMBean");
        }
        attributeList = new AttributeList();
        int n = 0;
        while (n < stringArray.length) {
            try {
                attributeList.add(this.getAttribute(stringArray[n]));
            }
            catch (Exception exception) {}
            ++n;
        }
        if (this.tracing()) {
            this.trace("getAttributes(String[])", "Exit");
        }
        return attributeList;
    }

    public MBeanInfo getMBeanInfo() {
        if (this.tracing()) {
            this.trace("getMBeanInfo()", "Entry and Exit");
        }
        if (this.modelMBeanInfo == null) {
            if (this.tracing()) {
                this.trace("getMBeanInfo()", "modelMBeanInfo is null");
            }
            this.modelMBeanInfo = this.createDefaultModelMBeanInfo();
        }
        if (this.tracing()) {
            this.trace("RequiredModelMBean.getMBeanInfo()", "ModelMBeanInfo is " + this.modelMBeanInfo.getClassName() + " for " + this.modelMBeanInfo.getDescription());
            this.trace("RequiredModelMBean.getMBeanInfo()", this.printModelMBeanInfo(this.modelMBeanInfo));
        }
        return (MBeanInfo)this.modelMBeanInfo.clone();
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        if (this.tracing()) {
            this.trace("getNotificationInfo()", "Entry");
        }
        MBeanNotificationInfo[] mBeanNotificationInfoArray = null;
        MBeanNotificationInfo[] mBeanNotificationInfoArray2 = this.modelMBeanInfo.getNotifications();
        mBeanNotificationInfoArray = mBeanNotificationInfoArray2 == null || mBeanNotificationInfoArray2.length == 0 ? new ModelMBeanNotificationInfo[2] : new ModelMBeanNotificationInfo[mBeanNotificationInfoArray2.length + 2];
        DescriptorSupport descriptorSupport = new DescriptorSupport(new String[]{"name=GENERIC", "descriptorType=notification", "log=T", "severity=5", "displayName=jmx.modelmbean.generic"});
        mBeanNotificationInfoArray[0] = new ModelMBeanNotificationInfo(new String[]{"jmx.modelmbean.generic"}, "GENERIC", "A text notification has been issued by the managed resource", descriptorSupport);
        DescriptorSupport descriptorSupport2 = new DescriptorSupport(new String[]{"name=ATTRIBUTE_CHANGE", "descriptorType=notification", "log=T", "severity=5", "displayName=jmx.attribute.change"});
        mBeanNotificationInfoArray[1] = new ModelMBeanNotificationInfo(new String[]{"jmx.attribute.change"}, "ATTRIBUTE_CHANGE", "Signifies that an observed MBean attribute value has changed", descriptorSupport2);
        int n = 2;
        int n2 = 0;
        n2 = 0;
        while (n2 < mBeanNotificationInfoArray2.length) {
            mBeanNotificationInfoArray[n] = (ModelMBeanNotificationInfo)mBeanNotificationInfoArray2[n2];
            ++n2;
        }
        if (this.tracing()) {
            this.trace("getNotificationInfo()", "Exit");
        }
        return mBeanNotificationInfoArray;
    }

    public Object invoke(String string, Object[] objectArray, String[] stringArray) throws MBeanException, ReflectionException {
        Class<?> clazz;
        if (this.tracing()) {
            this.trace("invoke(String, Object[], String[])", "Entry");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Method name must not be null"), "An exception occured while trying to invoke a method on a RequiredModelMBean");
        }
        ModelMBeanOperationInfo modelMBeanOperationInfo = null;
        Descriptor descriptor = null;
        Object object = null;
        Method method = null;
        Class[] classArray = null;
        Object[] objectArray2 = objectArray;
        boolean[] blArray = null;
        String string2 = "";
        String string3 = string;
        int n = string.lastIndexOf(".");
        if (n > 0) {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        if ((n = string3.indexOf("(")) > 0) {
            string3 = string3.substring(0, n);
        }
        if (this.tracing()) {
            this.trace("invoke(String, Object[], String[])", "Finding operation " + string + " as " + string3);
        }
        boolean bl = true;
        if (objectArray != null && objectArray.length != 0) {
            objectArray2 = objectArray;
            classArray = new Class[objectArray.length];
            blArray = new boolean[objectArray.length];
            int n2 = 0;
            while (n2 < objectArray.length) {
                block91: {
                    try {
                        if (this.tracing()) {
                            this.trace("invoke(String, Object[], String[])", "finding class for " + stringArray[n2]);
                        }
                        if (stringArray[n2].equals(Boolean.TYPE.toString())) {
                            classArray[n2] = Boolean.TYPE;
                        } else if (stringArray[n2].equals(Integer.TYPE.toString())) {
                            classArray[n2] = Integer.TYPE;
                        } else if (stringArray[n2].equals(Character.TYPE.toString())) {
                            classArray[n2] = Character.TYPE;
                        } else if (stringArray[n2].equals(Float.TYPE.toString())) {
                            classArray[n2] = Float.TYPE;
                        } else if (stringArray[n2].equals(Long.TYPE.toString())) {
                            classArray[n2] = Long.TYPE;
                        } else if (stringArray[n2].equals(Double.TYPE.toString())) {
                            classArray[n2] = Double.TYPE;
                        } else if (stringArray[n2].equals(Byte.TYPE.toString())) {
                            classArray[n2] = Byte.TYPE;
                        } else if (stringArray[n2].equals(Short.TYPE.toString())) {
                            classArray[n2] = Short.TYPE;
                        } else {
                            blArray[n2] = true;
                            classArray[n2] = Class.forName(stringArray[n2]);
                        }
                        if (this.tracing()) {
                            clazz = objectArray2[n2] == null ? "null" : objectArray2[n2].toString();
                            this.trace("invoke(String, Object[], String[])", "invoke method found a valid argument: " + classArray[n2].toString() + " is " + (String)((Object)clazz));
                        }
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        if (!this.tracing()) break block91;
                        this.trace("invoke(String, Object[], String[])", String.valueOf(string) + " method " + string3 + "is not in RequiredModelMBean class:" + classNotFoundException.getMessage());
                        this.trace("invoke(String, Object[], String[])", "The parameter class could not be found in default class loader");
                        blArray[n2] = true;
                        classArray[n2] = null;
                        bl = false;
                    }
                }
                ++n2;
            }
        } else {
            classArray = new Class[]{};
            objectArray2 = new Object[]{};
        }
        if (bl) {
            try {
                method = this.getClass().getMethod(string3, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                bl = false;
            }
        }
        if (method != null || bl) {
            try {
                if (this.tracing()) {
                    this.trace("invoke(String, Object[], String[])", String.valueOf(string) + " being invoked on ModelMBean");
                }
                object = method.invoke((Object)this, objectArray2);
                if (this.tracing()) {
                    if (object == null) {
                        this.trace("invoke(String, Object[], String[])", "invoke returning null response from local invoke of " + string);
                    } else {
                        this.trace("invoke(String, Object[], String[])", "invoke returning non-null response from local invoke of " + string);
                    }
                }
                return object;
            }
            catch (RuntimeErrorException runtimeErrorException) {
                throw new RuntimeOperationsException(runtimeErrorException, "RuntimeException occured in RequiredModelMBean while trying to invoke operation " + string);
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeOperationsException(runtimeException, "RuntimeException occured in RequiredModelMBean while trying to invoke operation " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectionException(illegalAccessException, "IllegalAccessException occured in RequiredModelMBean while trying to invoke operation " + string);
            }
            catch (InvocationTargetException invocationTargetException) {
                clazz = invocationTargetException.getTargetException();
                if (clazz instanceof RuntimeException) {
                    throw new MBeanException((RuntimeException)((Object)clazz), "RuntimeException thrown in RequiredModelMBean while trying to invoke operation " + string);
                }
                if (clazz instanceof ReflectionException) {
                    throw (ReflectionException)((Object)clazz);
                }
                throw new MBeanException((Exception)((Object)clazz), "Exception thrown in RequiredModelMBean while trying to invoke operation " + string);
            }
            catch (Error error) {
                throw new RuntimeErrorException(error, "Error occured in RequiredModelMBean while trying to invoke operation " + string);
            }
            catch (Exception exception) {
                throw new ReflectionException(exception, "Exception occured in RequiredModelMBean while trying to invoke operation " + string);
            }
        }
        if (this.tracing()) {
            this.trace("invoke(String, Object[], String[])", String.valueOf(string) + " is not on RequiredModelMBean, looking in descriptor for " + string3);
        }
        if ((modelMBeanOperationInfo = this.modelMBeanInfo.getOperation(string)) == null) {
            throw new MBeanException(new ServiceNotFoundException("operation " + string + " execution not supported from descriptor data"), "An exception occured in RequiredModelMBean while trying to invoke an operation");
        }
        descriptor = modelMBeanOperationInfo.getDescriptor();
        if (descriptor == null) {
            throw new MBeanException(new ServiceNotFoundException("operation " + string + " execution not supported from descriptor data"), "An exception occured in RequiredModelMBean while trying to invoke an operation");
        }
        object = this.resolveForCacheValue(descriptor);
        if (object == null) {
            Method method2;
            Object object2;
            if (this.tracing()) {
                this.trace("invoke(String, Object[], String[])", "No cached value returned for operation");
            }
            if ((object2 = descriptor.getFieldValue("targetObject")) != null) {
                if (this.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "Found target object in descriptor");
                }
                if ((clazz = (String)descriptor.getFieldValue("targetObjectType")) == null || !((String)((Object)clazz)).equalsIgnoreCase("objectReference")) {
                    throw new MBeanException(new InvalidTargetObjectTypeException((String)((Object)clazz)), "An exception occured while trying to invoke an operation on a descpriptor provided target");
                }
                if (this.tracing()) {
                    this.trace("invoke(String, Object[], String[]", "target object is a valid type");
                }
            } else if (this.managedResource != null) {
                if (this.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "managedResource for invoke found");
                }
                object2 = this.managedResource;
            } else if (this.tracing()) {
                this.trace("invoke(String, Object[], String[])", "err managedResource for invoke is null");
            }
            clazz = null;
            try {
                if (this.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "getting class for operation");
                }
                clazz = string2 == null || string2.equals("") ? ((string2 = (String)descriptor.getFieldValue("class")) == null || string2.equals("") ? object2.getClass() : Class.forName(string2)) : Class.forName(string2);
                if (clazz == null) {
                    throw new MBeanException(new Exception("A valid class could not be found for " + string3), "Exception occured while trying to find class for method of invoke");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "The target object class " + string2 + " could not be found");
            }
            ClassLoader classLoader = null;
            try {
                if (this.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "setting signature with correct class loaders for operation");
                }
                if ((classLoader = object2.getClass().getClassLoader()) != null) {
                    int n3 = 0;
                    while (n3 < classArray.length) {
                        if (blArray[n3]) {
                            classArray[n3] = classLoader.loadClass(stringArray[n3]);
                        }
                        ++n3;
                    }
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ReflectionException(classNotFoundException, "The parameter class could not be found");
            }
            if (this.tracing()) {
                this.trace("invoke(String, Object[], String[])", "Looking for operations class " + string2 + " method " + string3);
            }
            try {
                method2 = clazz.getMethod(string3, classArray);
                if (method2 == null) {
                    throw new ReflectionException(new Exception("null method handle"), "Retrieved null method handle for method");
                }
                if (this.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "Retrieved valid method handle for " + string2 + "." + string3);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new ReflectionException(noSuchMethodException, "The method " + string2 + "." + string3 + " could not be found");
            }
            try {
                object = method2.invoke(object2, objectArray2);
                if (this.tracing()) {
                    this.trace("invoke(String, Object[], String[])", "invoke done for " + string);
                }
                if (object != null && descriptor != null) {
                    Descriptor descriptor2 = this.modelMBeanInfo.getMBeanDescriptor();
                    String string4 = (String)descriptor.getFieldValue("currencyTimeLimit");
                    if (string4 == null && descriptor2 != null) {
                        string4 = (String)descriptor2.getFieldValue("currencyTimeLimit");
                    }
                    if (string4 != null && !string4.equals("0")) {
                        descriptor.setField("value", object);
                        descriptor.setField("lastUpdatedTimeStamp", new Long(new Date().getTime()).toString());
                        modelMBeanOperationInfo.setDescriptor(descriptor);
                        this.modelMBeanInfo.setDescriptor(descriptor, "operation");
                        if (this.tracing()) {
                            this.trace("invoke(String,Object[],Object[])", "new descriptor is " + descriptor.toString());
                            this.trace("invoke()", "OperationInfo descriptor is " + modelMBeanOperationInfo.getDescriptor().toString());
                            this.trace("invoke()", "OperationInfo descriptor is " + this.modelMBeanInfo.getDescriptor(string, "operation").toString());
                        }
                    }
                    if (this.tracing()) {
                        this.trace("invoke(String, Object[], String[])", "invoke retrieved " + object.toString());
                    }
                }
            }
            catch (RuntimeErrorException runtimeErrorException) {
                throw new RuntimeOperationsException(runtimeErrorException, "RuntimeException occured in managed resource while trying to invoke operation " + string);
            }
            catch (RuntimeException runtimeException) {
                throw new RuntimeOperationsException(runtimeException, "RuntimeException occured in managed resource while trying to invoke operation " + string);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ReflectionException(illegalAccessException, "IllegalAccessException occured in managed resource while trying to invoke operation " + string);
            }
            catch (Error error) {
                throw new RuntimeErrorException(error, "Error occured in managed resource while trying to invoke operation " + string);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof RuntimeException) {
                    throw new RuntimeMBeanException((RuntimeException)throwable, "RuntimeException thrown in managed resource while trying to invoke operation " + string);
                }
                if (throwable instanceof Error) {
                    throw new RuntimeErrorException((Error)throwable, "Error thrown in managed resource while trying to invoke operation " + string);
                }
                if (throwable instanceof ReflectionException) {
                    throw (ReflectionException)throwable;
                }
                throw new MBeanException((Exception)throwable, "Exception thrown in managed resource while trying to invoke operation " + string);
            }
            catch (Exception exception) {
                throw new ReflectionException(exception, "Exception occured in managed resource while trying to invoke operation " + string);
            }
        }
        if (this.tracing()) {
            this.trace("invoke(String, Object[], String[])", "Exit");
        }
        return object;
    }

    private boolean isValidModelMBeanInfo(ModelMBeanInfo modelMBeanInfo) {
        if (modelMBeanInfo == null) {
            if (this.tracing()) {
                this.trace("isValidModelMBeanInfo(mbi)", "ModelMBeanInfo is invalid - null");
            }
            return false;
        }
        return true;
    }

    public void load() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        block8: {
            if (this.tracing()) {
                this.trace("load()", "Entry");
            }
            Descriptor descriptor = this.modelMBeanInfo.getMBeanDescriptor();
            String string = (String)descriptor.getFieldValue("persistLocation");
            String string2 = (String)descriptor.getFieldValue("persistName");
            String string3 = (String)descriptor.getFieldValue("name");
            if (string == null || string2 == null) {
                if (this.tracing()) {
                    this.trace("load()", "Persistence not supported for this MBean");
                }
                return;
            }
            String string4 = new String(String.valueOf(string) + File.separator + string2);
            try {
                FileInputStream fileInputStream = new FileInputStream(string4);
                this.createMBeanInfoFromFile(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (this.tracing()) {
                    this.trace("load()", "Persistent MBean file was not found");
                }
            }
            catch (IOException iOException) {
                if (!this.tracing()) break block8;
                this.trace("load()", "IO Exception loading MBean from persistent store");
            }
        }
        if (this.tracing()) {
            this.trace("load()", "Exit");
        }
    }

    private boolean persistItNow(Descriptor descriptor) {
        boolean bl = false;
        String string = null;
        if (this.tracing()) {
            this.trace("persistItNow(Descriptor)", "Entry");
        }
        if (descriptor == null) {
            if (this.tracing()) {
                this.trace("persistItNow(Descriptor)", "Input Descriptor null, no persist policy");
            }
            return bl;
        }
        string = (String)descriptor.getFieldValue("persistPolicy");
        if (string == null || string.equalsIgnoreCase("never")) {
            bl = false;
        } else if (string.equalsIgnoreCase("onUpdate") || string.equalsIgnoreCase("always")) {
            bl = true;
        } else if (string.equalsIgnoreCase("onTimer") || string.equalsIgnoreCase("noMoreOftenThan")) {
            String string2 = (String)descriptor.getFieldValue("persistPeriod");
            if (string2 == null || string2.length() == 0) {
                string2 = "0";
            }
            int n = new Integer(string2);
            String string3 = (String)descriptor.getFieldValue("lastPersistedTimeStamp");
            int n2 = 0;
            if (string3 != null) {
                n2 = new Integer(string3);
            }
            if (new Date().getTime() >= (long)(n2 + n)) {
                bl = string.equalsIgnoreCase("onTimer") ? true : true;
            }
        }
        if (this.tracing()) {
            this.trace("persistItNow(Descriptor)", "Exit with " + bl);
        }
        return bl;
    }

    private String printModelMBeanInfo(ModelMBeanInfo modelMBeanInfo) {
        String string = "";
        if (modelMBeanInfo == null) {
            if (this.tracing()) {
                this.trace("printModelMBeanInfo(ModelMBeanInfo)", "ModelMBeanInfo to print is null, printing local ModelMBeanInfo");
            }
            modelMBeanInfo = this.modelMBeanInfo;
        }
        string = string.concat("\nMBeanInfo for ModelMBean is:");
        string = string.concat("\nCLASSNAME: \t" + modelMBeanInfo.getClassName());
        string = string.concat("\nDESCRIPTION: \t" + modelMBeanInfo.getDescription());
        try {
            string = string.concat("\nMBEAN DESCRIPTOR: \t" + modelMBeanInfo.getMBeanDescriptor());
        }
        catch (Exception exception) {
            string = string.concat("\nMBEAN DESCRIPTOR: \t is invalid");
        }
        string = string.concat("\nATTRIBUTES");
        MBeanAttributeInfo[] mBeanAttributeInfoArray = modelMBeanInfo.getAttributes();
        if (mBeanAttributeInfoArray != null && mBeanAttributeInfoArray.length > 0) {
            int n = 0;
            while (n < mBeanAttributeInfoArray.length) {
                string = string.concat(" ** NAME: \t" + mBeanAttributeInfoArray[n].getName());
                string = string.concat("    DESCR: \t" + mBeanAttributeInfoArray[n].getDescription());
                string = string.concat("    TYPE: \t" + mBeanAttributeInfoArray[n].getType() + "\tREAD: " + mBeanAttributeInfoArray[n].isReadable() + "\tWRITE: " + mBeanAttributeInfoArray[n].isWritable());
                string = string.concat("    DESCRIPTOR: " + ((ModelMBeanAttributeInfo)mBeanAttributeInfoArray[n]).getDescriptor().toString());
                ++n;
            }
        } else {
            string = string.concat(" ** No attributes **");
        }
        string = string.concat("\nCONSTRUCTORS");
        MBeanConstructorInfo[] mBeanConstructorInfoArray = modelMBeanInfo.getConstructors();
        if (mBeanConstructorInfoArray != null && mBeanConstructorInfoArray.length > 0) {
            int n = 0;
            while (n < mBeanConstructorInfoArray.length) {
                string = string.concat(" ** NAME: \t" + mBeanConstructorInfoArray[n].getName());
                string = string.concat("    DESCR: \t" + mBeanConstructorInfoArray[n].getDescription());
                string = string.concat("    PARAM: \t" + mBeanConstructorInfoArray[n].getSignature().length + " parameter(s)");
                string = string.concat("    DESCRIPTOR: " + ((ModelMBeanConstructorInfo)mBeanConstructorInfoArray[n]).getDescriptor().toString());
                ++n;
            }
        } else {
            string = string.concat(" ** No Constructors **");
        }
        string = string.concat("\nOPERATIONS");
        MBeanOperationInfo[] mBeanOperationInfoArray = modelMBeanInfo.getOperations();
        if (mBeanOperationInfoArray != null && mBeanOperationInfoArray.length > 0) {
            int n = 0;
            while (n < mBeanOperationInfoArray.length) {
                string = string.concat(" ** NAME: \t" + mBeanOperationInfoArray[n].getName());
                string = string.concat("    DESCR: \t" + mBeanOperationInfoArray[n].getDescription());
                string = string.concat("    PARAM: \t" + mBeanOperationInfoArray[n].getSignature().length + " parameter(s)");
                string = string.concat("    DESCRIPTOR: " + ((ModelMBeanOperationInfo)mBeanOperationInfoArray[n]).getDescriptor().toString());
                ++n;
            }
        } else {
            string = string.concat(" ** No operations ** ");
        }
        string = string.concat("\nNOTIFICATIONS");
        MBeanNotificationInfo[] mBeanNotificationInfoArray = modelMBeanInfo.getNotifications();
        if (mBeanNotificationInfoArray != null && mBeanNotificationInfoArray.length > 0) {
            int n = 0;
            while (n < mBeanNotificationInfoArray.length) {
                string = string.concat(" ** NAME: \t" + mBeanNotificationInfoArray[n].getName());
                string = string.concat("    DESCR: \t" + mBeanNotificationInfoArray[n].getDescription());
                string = string.concat("    DESCRIPTOR: " + ((ModelMBeanNotificationInfo)mBeanNotificationInfoArray[n]).getDescriptor().toString());
                ++n;
            }
        } else {
            string = string.concat(" ** No notifications **");
        }
        string = string.concat(" ** ModelMBean: End of MBeanInfo ** ");
        return string;
    }

    public void removeAttributeChangeNotificationListener(NotificationListener notificationListener, String string) throws MBeanException, RuntimeOperationsException, ListenerNotFoundException {
        if (this.tracing()) {
            this.trace("removeAttributeChangeNotificationListener(NotificationListener, String)", "Entry");
        }
        if (notificationListener == null || string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification Listener and attribute name must not be null"), "Exception occured trying to remove an attribute change notification listener of a ModelMBean");
        }
        if (this.attributeBroadcaster == null) {
            throw new MBeanException(new ListenerNotFoundException("No attribute change notification listeners registered"), "Exception ocured trying to remove an attribute change notification of a ModelMBean");
        }
        try {
            this.attributeBroadcaster.removeNotificationListener(notificationListener);
        }
        catch (ListenerNotFoundException listenerNotFoundException) {
            throw new MBeanException(listenerNotFoundException, "removeAttributeNotificationListener threw " + listenerNotFoundException.getMessage());
        }
        if (this.tracing()) {
            this.trace("removeAttributeChangeNotificationListener(NotificationListener, String)", "Exit");
        }
    }

    public void removeNotificationListener(NotificationListener notificationListener) throws ListenerNotFoundException {
        if (this.tracing()) {
            this.trace("removeNotificationListener(NotificationListener)", "Entry");
        }
        if (notificationListener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Notification listener must not be null"), "Exception occured trying to remove notifications of a RequiredModelMBean");
        }
        if (this.generalBroadcaster == null) {
            throw new ListenerNotFoundException("No notification listeners registered");
        }
        this.generalBroadcaster.removeNotificationListener(notificationListener);
        if (this.tracing()) {
            this.trace("removeNotificationListener(NotificationListener)", "Exit");
        }
    }

    private Object resolveForCacheValue(Descriptor descriptor) throws MBeanException, RuntimeOperationsException {
        String string;
        Descriptor descriptor2;
        if (this.tracing()) {
            this.trace("resolveForCacheValue(Descriptor)", "Entry");
        }
        Object object = null;
        boolean bl = false;
        boolean bl2 = true;
        long l = 0L;
        if (descriptor == null) {
            if (this.tracing()) {
                this.trace("resolveForCacheValue(Descriptor)", "Input Descriptor is null");
            }
            return object;
        }
        if (this.tracing()) {
            this.trace("resolveForCacheValue(Descriptor)", "descriptor is " + descriptor.toString());
        }
        if ((descriptor2 = this.modelMBeanInfo.getMBeanDescriptor()) == null && this.tracing()) {
            this.trace("resolveForCacheValue(Descriptor)", "MBean Descriptor is null");
        }
        if ((string = (String)descriptor.getFieldValue("currencyTimeLimit")) == null && descriptor2 != null) {
            string = (String)descriptor2.getFieldValue("currencyTimeLimit");
        }
        if (string != null) {
            Object object2;
            if (this.tracing()) {
                this.trace("RequiredModelMBean.resolveForCacheValue", " currencyTimeLimit: " + string);
            }
            if ((l = new Long(string) * 1000000L) < 0L) {
                bl2 = true;
                bl = false;
                if (this.tracing()) {
                    this.trace("RequiredModelMBean.resolveForCacheValue", String.valueOf(l) + ": always valid Cache");
                }
            } else if (l == 0L) {
                bl2 = false;
                bl = false;
                if (this.tracing()) {
                    this.trace("RequiredModelMBean.resolveForCacheValue", " never valid Cache");
                }
            } else {
                long l2;
                object2 = (String)descriptor.getFieldValue("lastUpdatedTimeStamp");
                if (this.tracing()) {
                    this.trace("RequiredModelMBean.resolveForCacheValue", " lastUpdatedTimeStamp: " + (String)object2);
                }
                if (object2 == null) {
                    object2 = "0";
                }
                long l3 = new Long((String)object2);
                if (this.tracing()) {
                    this.trace("RequiredModelMBean.resolveForCacheValue", " currencyPeriod:" + l + " lastUpdatedTimeStamp:" + l3);
                }
                if ((l2 = new Date().getTime()) < l3 + l) {
                    bl2 = true;
                    bl = false;
                    if (this.tracing()) {
                        this.trace("RequiredModelMBean.resolveForCacheValue", " timed valid Cache for " + l2 + " < " + (l3 + l));
                    }
                } else {
                    bl2 = false;
                    bl = true;
                    if (this.tracing()) {
                        this.trace("RequiredModelMBean.resolveForCacheValue", " timed expired cache for " + l2 + " > " + (l3 + l));
                    }
                }
            }
            if (this.tracing()) {
                this.trace("RequiredModelMBean.resolveForCacheValue", "returnCachedValue:" + bl2 + " resetValue: " + bl);
            }
            if (bl2) {
                object2 = descriptor.getFieldValue("value");
                if (object2 != null) {
                    object = object2;
                    if (this.tracing()) {
                        this.trace("RequiredModelMBean.resolveForCacheValue", "valid Cache value: " + object2);
                    }
                } else {
                    object = null;
                    if (this.tracing()) {
                        this.trace("RequiredModelMBean.resolveForCacheValue", " no Cached value");
                    }
                }
            }
            if (bl) {
                descriptor.removeField("lastUpdatedTimeStamp");
                descriptor.removeField("value");
                object = null;
                this.modelMBeanInfo.setDescriptor(descriptor, null);
                if (this.tracing()) {
                    this.trace("RequiredModelMBean.resolveForCacheValue", "reset cached value to null");
                }
            }
        }
        if (this.tracing()) {
            this.trace("resolveForCache(Descriptor)", "Exit");
        }
        return object;
    }

    public void sendAttributeChangeNotification(Attribute attribute, Attribute attribute2) throws MBeanException, RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("sendAttributeChangeNotification(Attribute, Attribute)", "Entry");
        }
        if (attribute == null || attribute2 == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attribute change notification object must not be null"), "Exception occured trying to send attribute change notification of a ModelMBean");
        }
        if (this.tracing()) {
            this.trace("sendAttributeChangeNotification(Attribute,Attribute)", "Creating notification object with " + attribute.getName() + attribute.getValue() + attribute2.getName() + attribute2.getValue() + attribute2.getValue().getClass().toString());
        }
        AttributeChangeNotification attributeChangeNotification = new AttributeChangeNotification(this, 1L, new Date().getTime(), "AttributeChangeDetected", attribute.getName(), attribute2.getValue().getClass().toString(), attribute.getValue(), attribute2.getValue());
        if (this.tracing()) {
            this.trace("sendAttributeChangeNotification(Attribute,Attribute)", "Sending AttributeChangeNotification for " + this.attributeBroadcaster + " with " + attributeChangeNotification.getAttributeName() + attributeChangeNotification.getAttributeType() + attributeChangeNotification.getNewValue() + attributeChangeNotification.getOldValue());
        }
        this.sendAttributeChangeNotification(attributeChangeNotification);
        if (this.tracing()) {
            this.trace("sendAttributeChangeNotification(Attribute, Attribute)", "Exit");
        }
    }

    public void sendAttributeChangeNotification(AttributeChangeNotification attributeChangeNotification) throws MBeanException, RuntimeOperationsException {
        String string;
        String string2;
        if (this.tracing()) {
            this.trace("sendAttributeChangeNotification(AttributeChangeNotification)", "Entry");
        }
        if (attributeChangeNotification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attribute change notification object must not be null"), "Exception occured trying to send attribute change notification of a ModelMBean");
        }
        if (this.attributeBroadcaster == null) {
            throw new MBeanException(new ListenerNotFoundException("No attribute change notification listeners registered"), "Exception ocured trying to send attribute change notification of a ModelMBean");
        }
        if (this.tracing()) {
            this.trace("sendAttributeChangeNotification(AttributeChangeNotification)", "Sending AttributeChangeNotification for " + this.attributeBroadcaster + " with " + attributeChangeNotification.getAttributeName() + attributeChangeNotification.getAttributeType() + attributeChangeNotification.getNewValue() + attributeChangeNotification.getOldValue());
        }
        Descriptor descriptor = this.modelMBeanInfo.getDescriptor(attributeChangeNotification.getType(), "notification");
        Descriptor descriptor2 = this.modelMBeanInfo.getMBeanDescriptor();
        if (descriptor != null) {
            String string3 = (String)descriptor.getFieldValue("log");
            if (string3 == null && descriptor2 != null) {
                string3 = (String)descriptor2.getFieldValue("log");
            }
            if (string3 != null && (string3.equalsIgnoreCase("t") || string3.equalsIgnoreCase("true"))) {
                String string4 = (String)descriptor.getFieldValue("logfile");
                if (string4 == null && descriptor2 != null) {
                    descriptor2.getFieldValue("logfile");
                }
                if (string4 != null) {
                    this.writeToLog(string4, "LogMsg: " + new Date(attributeChangeNotification.getTimeStamp()).toString() + " " + attributeChangeNotification.getType() + " " + attributeChangeNotification.getMessage());
                }
            }
        } else if (descriptor2 != null && (string2 = (String)descriptor2.getFieldValue("log")) != null && (string2.equalsIgnoreCase("t") || string2.equalsIgnoreCase("true")) && (string = (String)descriptor2.getFieldValue("logfile")) != null) {
            this.writeToLog(string, "LogMsg: " + new Date(attributeChangeNotification.getTimeStamp()).toString() + " " + attributeChangeNotification.getType() + " " + attributeChangeNotification.getMessage());
        }
        this.attributeBroadcaster.sendNotification(attributeChangeNotification);
        if (this.tracing()) {
            this.trace("sendAttributeChangeNotification(AttributeChangeNotification)", "sent notification");
        }
        if (this.tracing()) {
            this.trace("sendAttributeChangeNotification(AttributeChangeNotification)", "Exit");
        }
    }

    public void sendNotification(String string) throws MBeanException, RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("sendNotification(String)", "Entry");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("notification message must not be null"), "Exception occured trying to send a text notification from a ModelMBean");
        }
        Notification notification = new Notification("jmx.modelmbean.generic", (Object)this, 1L, string);
        this.sendNotification(notification);
        if (this.tracing()) {
            this.trace("sendNotification(string)", "Notification sent");
        }
        if (this.tracing()) {
            this.trace("sendNotification(String)", "Exit");
        }
    }

    public void sendNotification(Notification notification) throws MBeanException, RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("sendNotification(Notification)", "Entry");
        }
        if (notification == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("notification object must not be null"), "Exception occured trying to send a notification from a RequiredModelMBean");
        }
        if (this.generalBroadcaster == null) {
            throw new MBeanException(new ListenerNotFoundException("No notification listeners registered"), "Exception ocured trying to send notification from a RequiredModelMBean");
        }
        Descriptor descriptor = this.modelMBeanInfo.getDescriptor(notification.getType(), "notification");
        Descriptor descriptor2 = this.modelMBeanInfo.getMBeanDescriptor();
        if (descriptor != null) {
            String string = (String)descriptor.getFieldValue("log");
            if (string == null && descriptor2 != null) {
                string = (String)descriptor2.getFieldValue("log");
            }
            if (string != null && (string.equalsIgnoreCase("t") || string.equalsIgnoreCase("true"))) {
                String string2 = (String)descriptor.getFieldValue("logfile");
                if (string2 == null && descriptor2 != null) {
                    descriptor2.getFieldValue("logfile");
                }
                if (string2 != null) {
                    this.writeToLog(string2, "LogMsg: " + notification.getTimeStamp() + " " + notification.getType() + " " + notification.getMessage());
                }
            }
        }
        this.generalBroadcaster.sendNotification(notification);
        if (this.tracing()) {
            this.trace("sendNotification(Notification)", "sendNotification sent provided notification object");
        }
        if (this.tracing()) {
            this.trace("sendNotification(Notification)", "Exit");
        }
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        block21: {
            if (this.tracing()) {
                this.trace("setAttribute()", "Entry");
            }
            if (attribute == null) {
                throw new RuntimeOperationsException(new IllegalArgumentException("attribute must not be null"), "Exception occured trying to set an attribute of a RequiredModelMBean");
            }
            String string = attribute.getName();
            Object object = attribute.getValue();
            try {
                ModelMBeanAttributeInfo modelMBeanAttributeInfo = this.modelMBeanInfo.getAttribute(string);
                if (modelMBeanAttributeInfo == null) {
                    throw new AttributeNotFoundException("setAttribute failed: " + string + " is not found ");
                }
                Descriptor descriptor = this.modelMBeanInfo.getMBeanDescriptor();
                Descriptor descriptor2 = modelMBeanAttributeInfo.getDescriptor();
                if (descriptor2 != null) {
                    String string2;
                    if (!modelMBeanAttributeInfo.isWritable()) {
                        throw new AttributeNotFoundException("setAttribute failed: " + string + " is not writable ");
                    }
                    Object object2 = null;
                    String string3 = (String)descriptor2.getFieldValue("setMethod");
                    String string4 = modelMBeanAttributeInfo.getType();
                    Object object3 = this.getAttribute(string);
                    Attribute attribute2 = new Attribute(string, object3);
                    if (this.tracing()) {
                        this.trace("setAttribute()", "changing attribute" + string + " from " + object3.toString() + " to " + object);
                    }
                    if (string3 != null) {
                        object2 = this.invoke(string3, new Object[]{object}, new String[]{string4});
                    }
                    if ((string2 = (String)descriptor2.getFieldValue("currencyTimeLimit")) == null && descriptor != null) {
                        string2 = (String)descriptor.getFieldValue("currencyTimeLimit");
                    }
                    if (string2 != null && !string2.equals("0")) {
                        if (this.tracing()) {
                            this.trace("setAttribute()", "setting cached value of " + string + " to " + object);
                        }
                        descriptor2.setField("value", object);
                        String string5 = new Long(new Date().getTime()).toString();
                        descriptor2.setField("lastUpdatedTimeStamp", string5);
                        modelMBeanAttributeInfo.setDescriptor(descriptor2);
                        this.modelMBeanInfo.setDescriptor(descriptor2, "attribute");
                        if (this.tracing()) {
                            this.trace("setAttribute()", "new descriptor is " + descriptor2.toString());
                            this.trace("setAttribute()", "AttributeInfo descriptor is " + modelMBeanAttributeInfo.getDescriptor().toString());
                            this.trace("setAttribute()", "AttributeInfo descriptor is " + this.modelMBeanInfo.getDescriptor(string, "attribute").toString());
                        }
                    }
                    if (this.tracing()) {
                        this.trace("setAttribute()", "sending sendAttributeNotification");
                    }
                    this.sendAttributeChangeNotification(attribute2, attribute);
                    boolean bl = false;
                    String string6 = (String)descriptor2.getFieldValue("persistPolicy");
                    if (string6 != null) {
                        boolean bl2 = this.persistItNow(descriptor2);
                        if (bl2) {
                            this.store();
                        }
                    } else if (descriptor != null && (bl = this.persistItNow(descriptor))) {
                        this.store();
                    }
                    break block21;
                }
                if (this.tracing()) {
                    this.trace("setAttribute(String)", "setMethod failed " + string + " not in attributeDescriptor\n");
                }
                throw new MBeanException(new InvalidAttributeValueException("Unable to resolve attribute value, nosetMethod defined in descriptor for attribute"), "An exception occured while trying to set an attribute value through a RequiredModelMBean");
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                if (this.tracing()) {
                    this.trace("setAttribute(String)", "setMethod failed with " + instanceNotFoundException.getMessage() + "\n");
                }
                throw new MBeanException(instanceNotFoundException, "An exception occured while trying to set an attribute value: " + instanceNotFoundException.getMessage());
            }
        }
        if (this.tracing()) {
            this.trace("setAttribute(Attribute)", "Exit");
        }
    }

    public AttributeList setAttributes(AttributeList attributeList) {
        if (this.tracing()) {
            this.trace("setAttributes(AttributeList)", "Entry");
        }
        AttributeList attributeList2 = null;
        String[] stringArray = null;
        if (attributeList == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("attributes must not be null"), "Exception occured trying to set attributes of a RequiredModelMBean");
        }
        stringArray = new String[attributeList.size()];
        int n = 0;
        Iterator iterator = ((AbstractList)attributeList).iterator();
        while (iterator.hasNext()) {
            try {
                stringArray[n] = ((Attribute)((Object)iterator)).getName();
                this.setAttribute((Attribute)iterator.next());
            }
            catch (Exception exception) {}
            ++n;
        }
        attributeList2 = this.getAttributes(stringArray);
        if (this.tracing()) {
            this.trace("setdAttributes(AttributeList)", "Exit");
        }
        return attributeList;
    }

    public void setManagedResource(Object object, String string) throws MBeanException, RuntimeOperationsException, InstanceNotFoundException, InvalidTargetObjectTypeException {
        if (this.tracing()) {
            this.trace("setManagedResource(Object,String)", "Entry");
        }
        if (object == null) {
            if (this.tracing()) {
                this.trace("setManagedResource", "ManagedResource is null");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("Managed resource object must not be null"), "Exception occured trying to set the managed resource for the MBean");
        }
        if (!(object instanceof Object)) {
            string = "not Object";
            throw new InvalidTargetObjectTypeException(string);
        }
        if (string == null || !string.equalsIgnoreCase("objectReference")) {
            if (this.tracing()) {
                this.trace("RequiredModelMBean:setManagedResource", "Managed Resouce Type is not supported: " + string);
            }
            throw new InvalidTargetObjectTypeException(string);
        }
        if (this.tracing()) {
            this.trace("RequiredModelMBean:setManagedResource", "Managed Resouce is valid");
        }
        this.managedResource = object;
        if (this.tracing()) {
            this.trace("setManagedResource(Object, String)", "Exit");
        }
    }

    public void setModelMBeanInfo(ModelMBeanInfo modelMBeanInfo) throws MBeanException, RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("setModelMBeanInfo(ModelMBeanInfo)", "Entry");
        }
        if (modelMBeanInfo == null || !this.isValidModelMBeanInfo(modelMBeanInfo)) {
            if (this.tracing()) {
                this.trace("ModelMBeanInfo is null or invalid, setting default", "Exception occured trying to initialize the MBeanInfo of the MBean");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo must not be null or invalid, default MBeanInfo created."), "Exception occured trying to initialize the ModelMBeanInfo of the RequiredModelMBean");
        }
        if (this.tracing()) {
            this.trace("setModelMBeanInfo(ModelMBeanInfo)", "Setting ModelMBeanInfo to " + this.printModelMBeanInfo(modelMBeanInfo));
            this.trace("setModelMBeanInfo(ModelMBeanInfo)", "ModelMBeanInfo notifications has " + modelMBeanInfo.getNotifications().length + " elements");
        }
        this.modelMBeanInfo = (ModelMBeanInfo)modelMBeanInfo.clone();
        if (this.modelMBeanInfo == null) {
            throw new MBeanException(new IllegalArgumentException("Constructed MBeanInfo is null"), "Exception occured trying to construct the MBeanInfo for the MBean");
        }
        if (this.tracing()) {
            this.trace("setModelMBeanInfo(ModelMBeanInfo)", "set mbeanInfo to: " + this.printModelMBeanInfo(this.modelMBeanInfo));
        }
        if (this.tracing()) {
            this.trace("setModelMBeanInfo(ModelMBeanInfo)", "Exit");
        }
    }

    public void store() throws MBeanException, RuntimeOperationsException, InstanceNotFoundException {
        if (this.tracing()) {
            this.trace("store()", "Entry");
        }
        boolean bl = false;
        if (this.modelMBeanInfo == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ModelMBeanInfo must not be null"), "Exception occured trying to set the store data for the RequiredModelMBean");
        }
        Descriptor descriptor = this.modelMBeanInfo.getMBeanDescriptor();
        bl = this.persistItNow(descriptor);
        if (bl) {
            try {
                String string = (String)descriptor.getFieldValue("persistLocation");
                String string2 = (String)descriptor.getFieldValue("persistName");
                String string3 = (String)descriptor.getFieldValue("name");
                if (string == null || string2 == null) {
                    if (this.tracing()) {
                        this.trace("load()", "Persistence not supported for this MBean");
                    }
                    return;
                }
                String string4 = new String(String.valueOf(string) + File.separator + string2);
                FileOutputStream fileOutputStream = new FileOutputStream(string4, false);
                if (this.tracing()) {
                    this.trace("store()", "Writing MBean to file " + string4);
                }
                this.writeMBeanInfoToFile(fileOutputStream);
            }
            catch (Exception exception) {
                if (this.tracing()) {
                    this.trace("store()", "Exception storing MBean into file for RequiredModelMBean " + exception.getClass() + ":" + exception.getMessage());
                }
                exception.printStackTrace();
            }
        }
        if (this.tracing()) {
            this.trace("store()", "Exit");
        }
    }

    private void trace(String string, String string2) {
        this.trace(this.currClass, string, string2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, 128, string, string2, String.valueOf(Integer.toHexString(this.hashCode())) + " " + string3);
    }

    private boolean tracing() {
        return Trace.isSelected(1, 128);
    }

    private void writeMBeanInfoToFile(FileOutputStream fileOutputStream) throws IOException, MBeanException {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.modelMBeanInfo);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (NotSerializableException notSerializableException) {
            throw new MBeanException(notSerializableException, "Could not store ModelMBeanInfo because it contained an object that was not serializable: " + notSerializableException.toString() + ".");
        }
    }

    private void writeToLog(String string, String string2) {
        block10: {
            if (this.tracing()) {
                this.trace("writeToLog()", "Notification Logging to " + string + ": " + string2);
            }
            if (string == null || string2 == null) {
                if (this.tracing()) {
                    this.trace("writeToLog()", "Bad input parameters");
                }
                return;
            }
            if (this.logOut == null) {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(string, true);
                    this.logOut = new PrintStream(fileOutputStream);
                    if (this.tracing()) {
                        this.trace("writeToLog()", "Successfully opened log " + string);
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (this.tracing()) {
                        this.trace("writeToLog", "Could not find Notification log " + string);
                    }
                }
                catch (Exception exception) {
                    if (!this.tracing()) break block10;
                    this.trace("writeToLog", "Exception occurred for:" + exception.getClass() + ": " + exception.getMessage());
                }
            }
        }
        if (this.logOut != null) {
            this.logOut.println(string2);
        }
    }
}

