/*
 * Decompiled with CFR 0.152.
 */
package javax.management.modelmbean;

import com.sun.management.jmx.Trace;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.Descriptor;
import javax.management.MBeanException;
import javax.management.RuntimeOperationsException;
import javax.management.modelmbean.XMLParseException;

public class DescriptorSupport
implements Descriptor {
    HashMap descriptor;
    private static final int DEFAULT_SIZE = 20;
    public String currClass = "DescriptorSupport";

    public DescriptorSupport() {
        if (this.tracing()) {
            this.trace("Descriptor()", "Constructor");
        }
        this.descriptor = new HashMap(20);
    }

    public DescriptorSupport(int n) throws MBeanException, RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor(maxNumFields = " + n + ")", "Constructor");
        }
        if (n <= 0) {
            if (this.tracing()) {
                this.trace("Descriptor(maxNumFields)", "Illegal arguments: initNumFields <= 0");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor field limit is invalid"), "Exception occured trying to construct a descriptor");
        }
        this.descriptor = new HashMap(n);
    }

    public DescriptorSupport(String string) throws MBeanException, RuntimeOperationsException, XMLParseException {
        if (this.tracing()) {
            this.trace("Descriptor(String ='" + string + "'", "Constructor");
        }
        if (string == null) {
            if (this.tracing()) {
                this.trace("Descriptor(String = null)", "Illegal arguments");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("Descriptor is null or invalid"), "Exception occured trying to construct a descriptor");
        }
        this.descriptor = new HashMap(20);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "<> \t\n\r\f");
        boolean bl = false;
        boolean bl2 = false;
        String string2 = null;
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.equalsIgnoreCase("FIELD")) {
                bl = true;
                continue;
            }
            if (string4.equalsIgnoreCase("/FIELD")) {
                if (string2 != null && string3 != null) {
                    this.setField(string2.toLowerCase(), string3);
                }
                string2 = null;
                string3 = null;
                bl = false;
                continue;
            }
            if (string4.equalsIgnoreCase("DESCRIPTOR")) {
                bl2 = true;
                continue;
            }
            if (string4.equalsIgnoreCase("/DESCRIPTOR")) {
                bl2 = false;
                string2 = null;
                string3 = null;
                bl = false;
                continue;
            }
            if (!bl || !bl2) continue;
            int n = string4.indexOf("=");
            if (n > 0) {
                String string5 = string4.substring(0, n);
                String string6 = string4.substring(n + 1);
                if (string5.equalsIgnoreCase("NAME")) {
                    string2 = new String(string6);
                    continue;
                }
                if (string5.equalsIgnoreCase("VALUE")) {
                    string3 = new String(string6);
                    continue;
                }
                throw new XMLParseException("expected a field value, received '" + string4 + "'");
            }
            throw new XMLParseException("expected keyword=value, received '" + string4 + "'");
        }
        if (this.tracing()) {
            this.trace("Descriptor(XMLString)", "Exit");
        }
    }

    public DescriptorSupport(DescriptorSupport descriptorSupport) {
        if (this.tracing()) {
            this.trace("Descriptor(Descriptor)", "Constructor");
        }
        this.descriptor = descriptorSupport == null || descriptorSupport.descriptor == null ? new HashMap(20) : new HashMap(descriptorSupport.descriptor);
    }

    public DescriptorSupport(String[] stringArray) {
        if (this.tracing()) {
            this.trace("Descriptor(fields)", "Constructor");
        }
        if (stringArray == null || stringArray.length == 0) {
            this.descriptor = new HashMap(20);
            return;
        }
        this.descriptor = new HashMap(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null && !stringArray[n].equals("")) {
                int n2 = stringArray[n].indexOf("=");
                if (n2 <= 0) {
                    if (this.tracing()) {
                        this.trace("Descriptor(String[])", "Illegal arguments: field does not have '=' as a name and value separator");
                    }
                    throw new RuntimeOperationsException(new IllegalArgumentException("Field in invalid format: no equals sign"), "Exception occured trying to construct a descriptor");
                }
                String string = stringArray[n].substring(0, n2);
                String string2 = null;
                if (n2 < stringArray[n].length()) {
                    string2 = stringArray[n].substring(n2 + 1);
                }
                if (string == null || string.equals("")) {
                    if (this.tracing()) {
                        this.trace("Descriptor(String[])", "Illegal arguments: fieldName is null");
                    }
                    throw new RuntimeOperationsException(new IllegalArgumentException("Field in invalid format: no equals sign"), "Exception occured trying to construct a descriptor");
                }
                this.setField(string, string2);
            }
            ++n;
        }
        if (this.tracing()) {
            this.trace("Descriptor(fields)", "Exit");
        }
    }

    public DescriptorSupport(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor(fieldNames, fieldObjects)", "Constructor");
        }
        if (stringArray == null && objectArray == null || stringArray.length == 0 && objectArray.length == 0) {
            this.descriptor = new HashMap(20);
            return;
        }
        if (stringArray == null || objectArray == null || stringArray.length != objectArray.length) {
            if (this.tracing()) {
                this.trace("Descriptor(String[],Object[])", "Illegal arguments");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames or FieldValues are null or invalid"), "Exception occured trying to construct a descriptor");
        }
        this.descriptor = new HashMap(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.setField(stringArray[n], objectArray[n]);
            ++n;
        }
        if (this.tracing()) {
            this.trace("Descriptor(fieldNames, fieldObjects)", "Exit");
        }
    }

    public Object clone() throws RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("Descriptor.clone()", "Executed");
        }
        return new DescriptorSupport(this);
    }

    public String[] getFieldNames() {
        if (this.tracing()) {
            this.trace("getFieldNames()", "Entry");
        }
        if (this.descriptor == null) {
            return new String[0];
        }
        int n = this.descriptor.size();
        String[] stringArray = new String[n];
        Set set = this.descriptor.entrySet();
        if (set == null || n == 0) {
            if (this.tracing()) {
                this.trace("getFieldNames()", "no descriptor fields found");
            }
            return new String[0];
        }
        int n2 = 0;
        if (this.tracing()) {
            this.trace("getFieldNames()", "Returning " + n + " fields");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry == null || entry.getKey() == null) {
                if (this.tracing()) {
                    this.trace("getFieldNames()", "Field is null");
                }
            } else {
                stringArray[n2] = new String(entry.getKey().toString());
            }
            ++n2;
        }
        if (this.tracing()) {
            this.trace("getFieldNames()", "Exit");
        }
        return stringArray;
    }

    public Object getFieldValue(String string) throws RuntimeOperationsException {
        if (string == null || string.equals("")) {
            if (this.tracing()) {
                this.trace("getField()", "Illegal arguments: null field name.");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("Fieldname requested is null"), "Exception occured trying to get a field from a descriptor");
        }
        Object v = this.descriptor.get(string.toLowerCase());
        if (this.tracing()) {
            this.trace("getField(" + string + ")", "Returns '" + v + "'");
        }
        return v;
    }

    public Object[] getFieldValues(String[] stringArray) {
        if (this.tracing()) {
            this.trace("getFieldValues(fieldNames)", "Entry");
        }
        if (this.descriptor == null || stringArray != null && stringArray.length == 0) {
            return new Object[0];
        }
        int n = this.descriptor.size();
        Set set = this.descriptor.entrySet();
        if (set == null || n == 0) {
            if (this.tracing()) {
                this.trace("getFieldValues()", "no descriptor fields found");
            }
            return new Object[0];
        }
        Object[] objectArray = stringArray != null ? new Object[stringArray.length] : new Object[n];
        int n2 = 0;
        if (this.tracing()) {
            this.trace("getFieldValues()", "Returning " + n + " fields");
        }
        if (stringArray == null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (entry == null || entry.getKey() == null) {
                    if (this.tracing()) {
                        this.trace("getFieldValues()", "Field is null");
                    }
                    objectArray[n2] = null;
                } else {
                    objectArray[n2] = new String((String)entry.getValue());
                }
                ++n2;
            }
        } else {
            n2 = 0;
            while (n2 < stringArray.length) {
                objectArray[n2] = stringArray[n2] == null || stringArray[n2].equals("") ? null : this.getFieldValue(stringArray[n2]);
                ++n2;
            }
        }
        if (this.tracing()) {
            this.trace("getFieldValues()", "Exit");
        }
        return objectArray;
    }

    public String[] getFields() {
        if (this.tracing()) {
            this.trace("getFields()", "Entry");
        }
        if (this.descriptor == null) {
            return new String[0];
        }
        int n = this.descriptor.size();
        if (n == 0) {
            return new String[0];
        }
        String[] stringArray = new String[n];
        Set set = this.descriptor.entrySet();
        if (set == null) {
            if (this.tracing()) {
                this.trace("getFields()", "No fields found in descriptor");
            }
            return new String[0];
        }
        int n2 = 0;
        Object object = null;
        Map.Entry entry = null;
        if (this.tracing()) {
            this.trace("getFields()", "Returning " + n + " fields");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry == null) {
                if (this.tracing()) {
                    this.trace("getFields()", "Element is null");
                }
            } else {
                object = entry.getValue();
                stringArray[n2] = object == null ? new String(String.valueOf(entry.getKey().toString()) + "=") : (object instanceof String ? new String(String.valueOf(entry.getKey().toString()) + "=" + object.toString()) : new String(String.valueOf(entry.getKey().toString()) + "=(" + object.toString() + ")"));
            }
            ++n2;
        }
        if (this.tracing()) {
            this.trace("getFields()", "Exit");
        }
        return stringArray;
    }

    public boolean isValid() throws RuntimeOperationsException {
        Set set;
        if (this.tracing()) {
            this.trace("Descriptor.isValid()", "Executed");
        }
        if ((set = this.descriptor.entrySet()) == null) {
            if (this.tracing()) {
                this.trace("Descriptor.isValid()", "returns false (null set)");
            }
            return false;
        }
        String string = (String)this.getFieldValue("name");
        String string2 = (String)this.getFieldValue("descriptorType");
        if (string == null || string2 == null || string.equals("") || string2.equals("")) {
            return false;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry == null || entry.getValue() == null || this.validateField(entry.getKey().toString(), entry.getValue().toString())) continue;
            if (this.tracing()) {
                this.trace("isValid()", "Field " + entry.getKey().toString() + "=" + entry.getValue().toString() + " is not valid");
            }
            return false;
        }
        if (this.tracing()) {
            this.trace("Descriptor.isValid()", "returns true");
        }
        return true;
    }

    public void removeField(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.descriptor.remove(string);
    }

    public void setField(String string, Object object) throws RuntimeOperationsException {
        if (string == null || string.equals("")) {
            if (this.tracing()) {
                this.trace("setField(String,String)", "Illegal arguments: null field name");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("Fieldname to be set is null"), "Exception occured trying to set a field from a descriptor");
        }
        String string2 = string.toLowerCase();
        if (this.tracing()) {
            this.trace("setField(fieldName, fieldValue)", "Entry: setting '" + string2 + "' to '" + object + "'.");
        }
        if (!this.validateField(string2, object)) {
            if (this.tracing()) {
                this.trace("setField(fieldName,FieldValue)", "Illegal arguments");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("Field value invalid: " + string2 + "=" + object), "Field " + string2 + "=" + object + " is invalid. Exception occured trying to set a field from a descriptor");
        }
        this.descriptor.put(string2, object);
        if (this.tracing()) {
            this.trace("setField(fieldName, fieldValue)", "Exit");
        }
    }

    public void setFields(String[] stringArray, Object[] objectArray) throws RuntimeOperationsException {
        if (this.tracing()) {
            this.trace("setFields(fieldNames, ObjectValues)", "Entry");
        }
        if (stringArray == null && objectArray == null || stringArray.length == 0 && objectArray.length == 0) {
            return;
        }
        if (stringArray == null || objectArray == null || stringArray.length != objectArray.length) {
            if (this.tracing()) {
                this.trace("Descriptor.setFields(String[],Object[])", "Illegal arguments");
            }
            throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames and FieldValues are null or invalid"), "Exception occured trying to set object fields a descriptor");
        }
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] == null || stringArray[n].equals("")) {
                if (this.tracing()) {
                    this.trace("Descriptor.setFields(String[],Object[])", "Null field name encountered at " + n + " element");
                }
                throw new RuntimeOperationsException(new IllegalArgumentException("FieldNames is null or invalid"), "Exception occured trying to set object fields a descriptor");
            }
            this.setField(stringArray[n], objectArray[n]);
            ++n;
        }
        if (this.tracing()) {
            this.trace("Descriptor.setFields(fieldNames, fieldObjects)", "Exit");
        }
    }

    private int toNumeric(String string) {
        int n = -1;
        try {
            n = Integer.parseInt(string);
        }
        catch (Exception exception) {
            return -1;
        }
        return n;
    }

    public String toString() {
        if (this.tracing()) {
            this.trace("Descriptor.toString()", "Entry");
        }
        String string = "";
        String[] stringArray = this.getFields();
        if (this.tracing()) {
            this.trace("Descriptor.toString()", "Printing " + stringArray.length + " fields");
        }
        if (stringArray == null || stringArray.length == 0) {
            if (this.tracing()) {
                this.trace("Descriptor.toString()", "Empty Descriptor");
            }
            return null;
        }
        int n = 0;
        while (n < stringArray.length) {
            string = n == stringArray.length - 1 ? string.concat(stringArray[n]) : string.concat(String.valueOf(stringArray[n]) + ", ");
            ++n;
        }
        if (this.tracing()) {
            this.trace("Descriptor.toString()", "Exit returning " + string);
        }
        return string;
    }

    public String toXMLString() {
        if (this.tracing()) {
            this.trace("Descriptor.toXMLString()", "Executed");
        }
        String string = new String("<Descriptor>");
        Set set = this.descriptor.entrySet();
        if (set == null) {
            if (this.tracing()) {
                this.trace("Descriptor.toXMLString()", "returnedSet is null");
            }
            return null;
        }
        int n = 0;
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (entry == null) {
                if (this.tracing()) {
                    this.trace("Descriptor.toXMLString()", "Element is null");
                }
            } else {
                string = entry.getValue() == null ? String.valueOf(string) + "<field name=\"" + entry.getKey().toString() + "\" value=\"null\"></field>" : String.valueOf(string) + "<field name=\"" + entry.getKey().toString() + "\" value=\"" + entry.getValue().toString() + "\"></field>";
            }
            ++n;
        }
        string = String.valueOf(string) + "</Descriptor>";
        if (this.tracing()) {
            this.trace("Descriptor.toXMLString()", "Returns " + string);
        }
        return string;
    }

    private void trace(String string, String string2) {
        this.trace(this.currClass, string, string2);
    }

    private void trace(String string, String string2, String string3) {
        Trace.send(1, Trace.INFO_ALL, string, string2, String.valueOf(Integer.toHexString(this.hashCode())) + " " + string3);
    }

    private boolean tracing() {
        return Trace.isSelected(1, Trace.INFO_ALL);
    }

    private boolean validateField(String string, Object object) {
        if (string == null || string.equals("")) {
            return false;
        }
        String string2 = "";
        boolean bl = false;
        if (object != null && object instanceof String) {
            string2 = (String)object;
            bl = true;
        }
        if (string.equalsIgnoreCase("Name") || string.equalsIgnoreCase("DescriptorType") || string.equalsIgnoreCase("SetMethod") || string.equalsIgnoreCase("GetMethod") || string.equalsIgnoreCase("Role") || string.equalsIgnoreCase("Class")) {
            return object != null && bl;
        }
        if (string.equalsIgnoreCase("visibility")) {
            int n;
            if (object != null && bl) {
                n = this.toNumeric(string2);
            } else if (object != null && object instanceof Integer) {
                n = (Integer)object;
            } else {
                return false;
            }
            return n >= 1 && n <= 4;
        }
        if (string.equalsIgnoreCase("severity")) {
            int n;
            if (object != null && bl) {
                n = this.toNumeric(string2);
            } else if (object != null && object instanceof Integer) {
                n = (Integer)object;
            } else {
                return false;
            }
            return n >= 0 && n <= 5;
        }
        if (string.equalsIgnoreCase("PersistPolicy")) {
            return object != null && bl && (string2.equalsIgnoreCase("OnUpdate") || string2.equalsIgnoreCase("OnTimer") || string2.equalsIgnoreCase("NoMoreOftenThan") || string2.equalsIgnoreCase("Always") || string2.equalsIgnoreCase("Never"));
        }
        if (string.equalsIgnoreCase("PersistPeriod") || string.equalsIgnoreCase("CurrencyTimeLimit") || string.equalsIgnoreCase("LastUpdatedTimeStamp") || string.equalsIgnoreCase("LastReturnedTimeStamp")) {
            int n;
            if (object != null && bl) {
                n = this.toNumeric(string2);
            } else if (object != null && object instanceof Integer) {
                n = (Integer)object;
            } else {
                return false;
            }
            return n >= -1;
        }
        if (string.equalsIgnoreCase("ReadOnly") || string.equalsIgnoreCase("log") || string.equalsIgnoreCase("Iterable")) {
            return object instanceof Boolean || bl && (string2.equalsIgnoreCase("T") || string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("F") || string2.equalsIgnoreCase("false"));
        }
        return true;
    }
}

