/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.IasCommand;
import com.iplanet.ias.tools.cli.framework.IUserOutput;
import java.io.IOException;
import java.net.URL;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLManReader
extends IasCommand {
    private URL XMLFile;
    private Document document;
    private IUserOutput io = null;
    private String nodeName = "";
    private boolean firstRow = true;
    private String Tab = "     ";
    private String Spacer = "                              ";
    private int previousDiff = 0;
    private boolean bInformalTable = false;
    private boolean bExample = false;
    private int iCountRow = 0;
    private int iCountCol = this.Tab.length();
    private int col = 79;
    private int row = 22;
    static /* synthetic */ Class class$com$iplanet$ias$tools$cli$XMLManReader;

    public XMLManReader(String string) {
        this.XMLFile = (class$com$iplanet$ias$tools$cli$XMLManReader == null ? (class$com$iplanet$ias$tools$cli$XMLManReader = XMLManReader.class$("com.iplanet.ias.tools.cli.XMLManReader")) : class$com$iplanet$ias$tools$cli$XMLManReader).getClassLoader().getResource(string);
        this.initXML();
        this.printManSections(this.document);
    }

    public XMLManReader(String string, IUserOutput iUserOutput) {
        this.XMLFile = ClassLoader.getSystemClassLoader().getResource(string);
        this.io = iUserOutput;
        this.initXML();
        this.printManSections(this.document);
    }

    public void initXML() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (this.XMLFile == null) {
                Debug.println("NoXMLFile");
                return;
            }
            InputSource inputSource = new InputSource(this.XMLFile.toString());
            this.document = documentBuilder.parse(inputSource);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Debug.println(parserConfigurationException.getLocalizedMessage());
        }
        catch (IOException iOException) {
            Debug.println(iOException.getLocalizedMessage());
        }
    }

    private void printManSections(Document document) {
        Object object;
        Object object2;
        Object object3;
        Element element;
        Object object4;
        this.printLine("");
        String string = "";
        String string2 = "";
        String string3 = "";
        NodeList nodeList = document.getElementsByTagName("refentrytitle");
        if (nodeList.getLength() > 0) {
            Element element2 = (Element)nodeList.item(0);
            string = element2.getFirstChild().getNodeValue().replace('\n', ' ');
        }
        nodeList = document.getElementsByTagName("refmiscinfo");
        int n = 0;
        while (n < nodeList.getLength()) {
            object4 = (Element)nodeList.item(n);
            if (object4.getAttribute("class").equals("sectdesc")) {
                string2 = object4.getFirstChild().getNodeValue();
            }
            ++n;
        }
        nodeList = document.getElementsByTagName("manvolnum");
        if (nodeList.getLength() > 0) {
            object4 = (Element)nodeList.item(0);
            string3 = object4.getFirstChild().getNodeValue();
        }
        this.printTitle(string2 + this.Tab + this.Tab + this.Tab + this.Tab + this.Tab + string + "(" + string3 + ")");
        this.printTitle("NAME");
        object4 = "";
        nodeList = document.getElementsByTagName("refname");
        if (nodeList.getLength() > 0) {
            element = (Element)nodeList.item(0);
            object4 = element.getFirstChild().getNodeValue();
        }
        if ((nodeList = document.getElementsByTagName("refpurpose")).getLength() > 0) {
            element = (Element)nodeList.item(0);
            this.printWord(this.Tab);
            this.printLine((String)object4 + " - " + element.getFirstChild().getNodeValue().replace('\n', ' '));
        }
        this.printLine("");
        nodeList = document.getElementsByTagName("refsynopsisdiv");
        int n2 = 0;
        while (n2 < nodeList.getLength()) {
            Element element3 = (Element)nodeList.item(n2);
            object3 = element3.getElementsByTagName("title");
            if (object3 != null) {
                Element element4 = (Element)object3.item(0);
                this.printTitle(element4.getFirstChild().getNodeValue().replace('\n', ' '));
            }
            object3 = element3.getElementsByTagName("cmdsynopsis");
            this.printWord(this.Tab);
            int n3 = 0;
            while (n3 < object3.getLength()) {
                object2 = (Element)object3.item(n3);
                object = this.getAllNodes((Node)object2, "");
                this.printLine((String)object);
                ++n3;
            }
            ++n2;
        }
        nodeList = document.getElementsByTagName("refsect1");
        int n4 = 0;
        while (n4 < nodeList.getLength()) {
            object3 = (Element)nodeList.item(n4);
            NodeList nodeList2 = object3.getElementsByTagName("title");
            object2 = "";
            if (nodeList2 != null) {
                object = (Element)nodeList2.item(0);
                object2 = object.getFirstChild().getNodeValue().replace('\n', ' ');
                this.printTitle("\n" + (String)object2);
            }
            if (((String)object2).equals(this.getLocalizedString("Description"))) {
                Object object5;
                nodeList2 = object3.getElementsByTagName("para");
                if (nodeList2.getLength() > 0) {
                    object = (Element)nodeList2.item(0);
                    this.printWord(this.Tab);
                    object5 = this.getAllNodes((Node)object, "");
                    this.printLine((String)object5);
                }
                if ((nodeList2 = object3.getElementsByTagName("informaltable")) != null && nodeList2.getLength() > 0) {
                    this.bInformalTable = true;
                    this.printLine("");
                    int n5 = 0;
                    while (n5 < nodeList2.getLength()) {
                        object5 = (Element)nodeList2.item(n5);
                        NodeList nodeList3 = object5.getElementsByTagName("row");
                        int n6 = 0;
                        while (n6 < nodeList3.getLength()) {
                            Element element5 = (Element)nodeList3.item(n6);
                            this.firstRow = true;
                            String string4 = this.getAllNodes(element5, "");
                            this.print(string4);
                            this.printLine("");
                            ++n6;
                        }
                        ++n5;
                    }
                    this.bInformalTable = false;
                }
                this.printLine("");
            } else if (((String)object2).startsWith(this.getLocalizedString("Example"))) {
                this.bExample = true;
                nodeList2 = object3.getElementsByTagName("example");
                this.checkList(nodeList2);
                this.bExample = false;
            } else {
                nodeList2 = object3.getElementsByTagName("screen");
                this.checkList(nodeList2);
                nodeList2 = object3.getElementsByTagName("varlistentry");
                if (nodeList2.getLength() > 0) {
                    this.checkList(nodeList2);
                } else {
                    nodeList2 = object3.getElementsByTagName("para");
                    this.checkList(nodeList2);
                }
            }
            ++n4;
        }
        this.printLine("");
    }

    private void checkList(NodeList nodeList) {
        if (nodeList != null && nodeList.getLength() > 0) {
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element = (Element)nodeList.item(n);
                if (element != null && element.getFirstChild() != null) {
                    this.iCountCol = this.Tab.length();
                    this.printWord(this.Tab);
                    String string = this.getAllNodes(element, "");
                    this.printWord(string);
                }
                this.printLine("");
                ++n;
            }
        }
    }

    private String getAllNodes(Node node, String string) {
        String string2 = string;
        switch (node.getNodeType()) {
            case 1: {
                this.nodeName = node.getNodeName();
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = 0;
                while (n < nodeList.getLength()) {
                    string2 = this.getAllNodes(nodeList.item(n), string2);
                    ++n;
                }
                break;
            }
            case 3: 
            case 4: {
                if (this.bInformalTable && this.nodeName.equals("para")) {
                    String string3 = node.getNodeValue().replace('\n', ' ');
                    if (string3.equals(" ")) break;
                    string2 = this.firstRow ? string2.concat(this.Tab) : string2.concat(this.Spacer.substring(0, this.previousDiff));
                    string2 = string2.concat(string3);
                    this.previousDiff = this.Spacer.length() - string3.length();
                    this.firstRow = false;
                    break;
                }
                if (this.bExample) {
                    string2 = string2.concat(node.getNodeValue());
                    break;
                }
                if (this.nodeName.equals("term")) {
                    string2 = string2.concat(node.getNodeValue().replace('\n', ' ') + " ");
                    break;
                }
                if (this.nodeName.equals("command") || this.nodeName.equals("para") || this.nodeName.equals("option")) {
                    string2 = string2.concat(node.getNodeValue().replace('\n', ' ') + " ");
                    break;
                }
                if (this.nodeName.equals("manvolnum")) {
                    char c = node.getNodeValue().charAt(0);
                    if (Character.isDigit(c)) {
                        string2 = string2.concat("(" + node.getNodeValue().replace('\n', ' ') + ")");
                        break;
                    }
                    string2 = string2.concat(node.getNodeValue().replace('\n', ' '));
                    break;
                }
                String string4 = node.getNodeValue().replace('\n', ' ');
                string2 = string2.concat(string4);
                break;
            }
        }
        return string2;
    }

    private void printAllNodes(Node node) {
        switch (node.getNodeType()) {
            case 1: {
                this.nodeName = node.getNodeName();
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = 0;
                while (n < nodeList.getLength()) {
                    this.printAllNodes(nodeList.item(n));
                    ++n;
                }
                break;
            }
            case 3: 
            case 4: {
                if (this.bInformalTable && this.nodeName.equals("para")) {
                    String string = node.getNodeValue().replace('\n', ' ');
                    if (this.firstRow) {
                        this.printWord(this.Tab);
                    } else {
                        this.printWord(this.Spacer.substring(0, this.previousDiff));
                    }
                    this.printWord(string);
                    this.previousDiff = this.Spacer.length() - string.length();
                    this.firstRow = false;
                    break;
                }
                if (this.nodeName.equals("command")) {
                    this.printWord(node.getNodeValue().replace('\n', ' ') + " ");
                    break;
                }
                String string = node.getNodeValue().replace('\n', ' ');
                this.printWord(string);
                this.iCountCol += string.length();
                if (this.iCountCol <= this.col) break;
                this.printLine("");
                this.printWord(this.Tab);
                this.iCountCol = this.Tab.length();
                break;
            }
        }
    }

    void printTitle(String string) {
        if (string != null) {
            this.println(string);
            this.checkForPrompt();
        }
    }

    void printWord(String string) {
        if (string != null) {
            if (string.length() + this.Tab.length() > this.col) {
                this.printLine(string);
            } else {
                this.print(string);
            }
        }
    }

    void println(String string) {
        if (this.io == null) {
            System.out.println(string);
        } else {
            this.io.println(string);
        }
    }

    void print(String string) {
        if (this.io == null) {
            System.out.print(string);
        } else {
            this.io.print(string);
        }
    }

    void printLine(String string) {
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
            int n = this.Spacer.length();
            while (stringTokenizer.hasMoreTokens()) {
                StringTokenizer stringTokenizer2;
                String string2 = stringTokenizer.nextToken();
                n = n + string2.length() + 1;
                if (string2.indexOf(10) > -1 && (stringTokenizer2 = new StringTokenizer(string2, "\n")).hasMoreTokens()) {
                    String string3 = stringTokenizer2.nextToken();
                    if (string2.indexOf(10) == 0) {
                        string3 = "\n" + this.Tab + string3;
                    }
                    while (stringTokenizer2.hasMoreTokens()) {
                        string3 = string3 + "\n" + this.Tab + stringTokenizer2.nextToken();
                        n = this.Spacer.length();
                    }
                    string2 = string3;
                }
                if (n > this.col) {
                    this.print("\n");
                    this.checkForPrompt();
                    this.print(this.Tab);
                    n = this.Spacer.length();
                }
                this.print(string2 + " ");
            }
            this.print("\n");
            this.checkForPrompt();
        }
    }

    private void checkForPrompt() {
        ++this.iCountRow;
        if (this.iCountRow > this.row) {
            this.print(this.getLocalizedString("PressEnterToContinue") + ">");
            try {
                while (System.in.read() != 10) {
                }
            }
            catch (IOException iOException) {
                this.println(iOException.getMessage());
            }
            this.iCountRow = 0;
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println("Usage: java XMLManReader [XML URI] ");
            System.exit(0);
        }
        String string = stringArray[0];
        XMLManReader xMLManReader = new XMLManReader(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

