/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseLifeCycleCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;

public class StopInstanceCommand
extends BaseLifeCycleCommand {
    public StopInstanceCommand() {
    }

    public StopInstanceCommand(String string) {
        this.setName(string);
    }

    public boolean validateOptions() throws CommandValidationException {
        boolean bl = super.validateOptions();
        if (!bl) {
            return bl;
        }
        if (this.isLocal()) {
            return true;
        }
        if (this.findOption("host") == null || this.findOption("port") == null || this.findOption("user") == null) {
            String string = null;
            Option option = this.findOption("host");
            string = this.findOption("host") == null ? "host" : (this.findOption("port") == null ? "port" : "user");
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{string}));
        }
        if (!this.isPasswordProvided()) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{"password"}));
            }
            this.initPasswordOption();
        }
        return bl;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        if (this.isLocal()) {
            try {
                String string = this.getDomain();
                this.stopServerInstance(string, this.getInstanceOperand(0));
                this.printMessage(this.getLocalizedString("InstanceStopped", new Object[]{this.getInstanceOperand(0)}));
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                Debug.println("Locally stopping instance, Exception caught");
                this.printMessage(this.getLocalizedString("CannotStopInstance"));
                throw new CommandException(exception.getLocalizedMessage());
            }
        }
        try {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            String string = this.getInstanceOperand(0);
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(string);
            if (!appServerInstance.isRunning()) {
                this.printMessage(this.getLocalizedString("InstanceNotRunning", new Object[]{string}));
                return;
            }
            appServerInstance.stop();
            this.printMessage(this.getLocalizedString("InstanceStopped", new Object[]{string}));
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printMessage(this.getLocalizedString("CannotStopInstance"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }
}

