/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.license.IASLicense;
import com.iplanet.ias.tools.cli.BaseLifeCycleCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Option;
import com.iplanet.ias.util.OS;

public class StartInstanceCommand
extends BaseLifeCycleCommand {
    public StartInstanceCommand() {
    }

    public StartInstanceCommand(String string) {
        this.setName(string);
    }

    public boolean validateOptions() throws CommandValidationException {
        boolean bl = super.validateOptions();
        if (!bl) {
            return bl;
        }
        if (this.isLocal()) {
            return true;
        }
        if (this.findOption("host") == null || this.findOption("port") == null || this.findOption("user") == null) {
            String string = null;
            Option option = this.findOption("host");
            string = this.findOption("host") == null ? "host" : (this.findOption("port") == null ? "port" : "user");
            throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{string}));
        }
        if (!this.isPasswordProvided()) {
            if (!this.isInteractive()) {
                throw new CommandValidationException(this.getLocalizedString("RequiredOptionsNotProvided", new Object[]{"password"}));
            }
            this.initPasswordOption();
        }
        return bl;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        if (this.isLocal()) {
            try {
                this.unsetLicenseLogger();
                IASLicense.checkCurrent((boolean)false);
                String string = this.getDomain();
                String string2 = this.getInstanceOperand(0);
                if (OS.isUnix() && this.checkIfSecurityIsON(string, string2)) {
                    this.startServerInstanceWithSecurityOn(string, string2);
                } else {
                    this.startServerInstance(string, string2);
                }
                this.printMessage(this.getLocalizedString("InstanceStarted", new Object[]{this.getInstanceOperand(0)}));
            }
            catch (Exception exception) {
                Debug.printStackTrace(exception);
                Debug.println("Locally starting instance, Exception caught ");
                this.printMessage(this.getLocalizedString("CannotStartInstance"));
                throw new CommandException(exception.getLocalizedMessage());
            }
        }
        try {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            String string = this.getInstanceOperand(0);
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(string);
            boolean bl = this.isStartDebug();
            if (appServerInstance.isRunning()) {
                this.printMessage(this.getLocalizedString("InstanceAlreadyStarted", new Object[]{string}));
                return;
            }
            String[] stringArray = appServerInstance.getSecurityPasswordTokens();
            if (stringArray != null && stringArray.length > 0) {
                if (!this.isInteractive()) {
                    throw new CommandValidationException(this.getLocalizedString("CannotGetPassword"));
                }
                String[] stringArray2 = this.getPasswords(stringArray, "");
                if (bl) {
                    int n = appServerInstance.startSecureInDebugMode(stringArray2);
                    this.printMessage(this.getLocalizedString("ListeningAtPort", new Object[]{String.valueOf(n)}));
                    this.printMessage(this.getLocalizedString("InstanceStartedInDebugMode", new Object[]{string}));
                } else {
                    appServerInstance.startSecure(stringArray2);
                    this.printMessage(this.getLocalizedString("InstanceStarted", new Object[]{string}));
                }
            } else if (bl) {
                int n = appServerInstance.startInDebugMode();
                this.printMessage(this.getLocalizedString("ListeningAtPort", new Object[]{String.valueOf(n)}));
                this.printMessage(this.getLocalizedString("InstanceStartedInDebugMode", new Object[]{string}));
            } else {
                appServerInstance.start();
                this.printMessage(this.getLocalizedString("InstanceStarted", new Object[]{string}));
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printMessage(this.getLocalizedString("CannotStartInstance"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private boolean isStartDebug() throws CommandValidationException {
        Option option = this.findOption("debug");
        if (option == null) {
            return false;
        }
        String string = option.getValue();
        Debug.println("isDebugStr = " + string);
        boolean bl = false;
        if (string == null) {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        if (string.equalsIgnoreCase("true")) {
            bl = true;
        } else if (string.equalsIgnoreCase("false")) {
            bl = false;
        } else {
            throw new CommandValidationException(this.getLocalizedString("InvalidOptionValue") + ": " + option.getName().toLowerCase());
        }
        return bl;
    }
}

