/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.JVMComponentBean;
import com.iplanet.ias.admin.servermodel.beans.Profiler;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;

public class ListProfilersCommand
extends BaseOtherCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            return;
        }
        try {
            ServerInstanceManager serverInstanceManager = this.getServerInstanceManager();
            AppServerInstance appServerInstance = serverInstanceManager.getServerInstance(this.getInstanceOperand(0));
            JVMComponentBean jVMComponentBean = appServerInstance.getJVMComponent();
            Profiler profiler = jVMComponentBean.getProfiler();
            if (profiler != null) {
                this.printMessage(profiler);
            } else {
                this.printMessage(this.getLocalizedString("NoProfilers"));
            }
            Debug.println(this.getClass().getName() + " : Command executed");
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotListProfilers"));
            throw new CommandException(exception.getLocalizedMessage());
        }
    }
}

