/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.Controllable;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.HttpServiceComponentBean;
import com.iplanet.ias.admin.servermodel.beans.VirtualServer;
import com.iplanet.ias.admin.servermodel.beans.VirtualServerClass;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseOtherCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import com.iplanet.ias.tools.cli.framework.Option;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;

public class CreateVirtualServerCommand
extends BaseOtherCommand {
    private static final String HTTP_LISTENERS = "httplisteners";
    private static final String DEFAULT_WEB_MODULE = "defaultwebmodule";
    private static final String CONFIG_FILE = "configfile";
    private static final String DEFAULT_OBJ = "defaultobj";
    private static final String STATE = "state";
    private static final String ACLS = "acls";
    private static final String ACCEPT_LANG = "acceptlang";
    private static final String LOG_FILE = "logfile";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Object object;
        Controllable controllable;
        VirtualServerClass virtualServerClass = null;
        String string = null;
        AttributeList attributeList = null;
        if (!this.validateOptions()) {
            return;
        }
        try {
            controllable = this.getServerInstanceManager();
            object = this.getHostsOption();
            String string2 = this.getMimeOption();
            string = ((Operand)this.getOperands().get(0)).getName();
            attributeList = this.getAttributeList();
            AppServerInstance appServerInstance = ((ServerInstanceManager)controllable).getServerInstance(this.getInstanceOption());
            HttpServiceComponentBean httpServiceComponentBean = appServerInstance.getHttpService();
            virtualServerClass = httpServiceComponentBean.getVirtualServerClass("defaultclass");
            virtualServerClass.createVirtualServer(string, (String)object, string2);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreateVirtualServer"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        this.printMessage(this.getLocalizedString("CreatedVirtualServer", new Object[]{string}));
        try {
            if (attributeList != null && !attributeList.isEmpty()) {
                controllable = virtualServerClass.getVirtualServer(string);
                object = ((VirtualServer)controllable).setAttributes(attributeList);
                this.validateAttributeList(attributeList, (AttributeList)object);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("UseDefaultAttribute"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private String getVirtualServerClassOption() {
        Option option = this.findOption("virtualserverclass");
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }

    private String getHostsOption() {
        Option option = this.findOption("hosts");
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }

    private String getMimeOption() {
        Option option = this.findOption("mime");
        String string = null;
        if (option != null) {
            string = option.getValue();
        }
        return string;
    }

    private AttributeList getAttributeList() throws CommandValidationException {
        Object object;
        Object object2;
        AttributeList attributeList = new AttributeList();
        if (this.getOptionValue(HTTP_LISTENERS) != null) {
            object2 = new Attribute("httpListeners", this.getOptionValue(HTTP_LISTENERS));
            attributeList.add((Attribute)object2);
        }
        if (this.getOptionValue(DEFAULT_WEB_MODULE) != null) {
            object2 = new Attribute("defaultWebModule", this.getOptionValue(DEFAULT_WEB_MODULE));
            attributeList.add((Attribute)object2);
        }
        if (this.getOptionValue(CONFIG_FILE) != null) {
            object2 = new Attribute("configFile", this.getOptionValue(CONFIG_FILE));
            attributeList.add((Attribute)object2);
        }
        if (this.getOptionValue(DEFAULT_OBJ) != null) {
            object2 = new Attribute("defaultObject", this.getOptionValue(DEFAULT_OBJ));
            attributeList.add((Attribute)object2);
        }
        if (this.getOptionValue(STATE) != null) {
            object2 = this.getOptionValue(STATE);
            if (!(((String)object2).equals("on") || ((String)object2).equals("off") || ((String)object2).equals("disabled"))) {
                throw new CommandValidationException(this.getLocalizedString("InvalidStateValue"));
            }
            object = new Attribute(STATE, object2);
            attributeList.add((Attribute)object);
        }
        if (this.getOptionValue(ACLS) != null) {
            object2 = new Attribute(ACLS, this.getOptionValue(ACLS));
            attributeList.add((Attribute)object2);
        }
        if (this.getBooleanOptionValue(ACCEPT_LANG) != null) {
            object2 = new Attribute("accepotLanguage", this.getBooleanOptionValue(ACCEPT_LANG));
            attributeList.add((Attribute)object2);
        }
        if (this.getOptionValue(LOG_FILE) != null) {
            object2 = new Attribute("logFile", this.getOptionValue(LOG_FILE));
            attributeList.add((Attribute)object2);
        }
        if (!((Properties)(object2 = this.getProperties())).isEmpty()) {
            object = "property.";
            Enumeration<?> enumeration = ((Properties)object2).propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = (String)((Properties)object2).get(string);
                Attribute attribute = new Attribute((String)object + string, string2);
                attributeList.add(attribute);
                Debug.println("Property(name,value) = " + string + " , " + string2);
            }
        }
        return attributeList;
    }
}

