/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.tools.cli;

import com.iplanet.ias.admin.servermodel.AppServerInstance;
import com.iplanet.ias.admin.servermodel.Controllable;
import com.iplanet.ias.admin.servermodel.ServerInstanceManager;
import com.iplanet.ias.admin.servermodel.beans.ServerComponent;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.tools.cli.BaseResourceCommand;
import com.iplanet.ias.tools.cli.framework.CommandException;
import com.iplanet.ias.tools.cli.framework.CommandValidationException;
import com.iplanet.ias.tools.cli.framework.Operand;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import javax.management.Attribute;
import javax.management.AttributeList;

public class CreatePersistenceManagerResourceCommand
extends BaseResourceCommand {
    private static final String FACTORY_CLASS = "factoryclass";
    private static final String JDBC_JNDI = "jdbcjndiname";
    private static final String ENABLED = "enabled";
    private static final String DESCRIPTION = "description";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        Controllable controllable;
        AppServerInstance appServerInstance = null;
        String string = null;
        AttributeList attributeList = null;
        if (!this.validateOptions()) {
            return;
        }
        try {
            string = ((Operand)this.getOperands().get(0)).getName();
            attributeList = this.getAttributeList();
            controllable = this.getServerInstanceManager();
            appServerInstance = ((ServerInstanceManager)controllable).getServerInstance(this.getInstanceOption());
            appServerInstance.createPersistenceManagerFactoryResource(string);
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("CannotCreatePersistenceManagerResource"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        this.printMessage(this.getLocalizedString("CreatedPersistenceManagerResource") + " = " + string);
        try {
            if (attributeList != null && !attributeList.isEmpty()) {
                controllable = appServerInstance.getPersistenceManagerFactoryResource(string);
                AttributeList attributeList2 = ((ServerComponent)controllable).setAttributes(attributeList);
                this.validateAttributeList(attributeList, attributeList2);
            }
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            this.printError(this.getLocalizedString("UseDefaultAttribute"));
            throw new CommandException(exception.getLocalizedMessage());
        }
        Debug.println(this.getClass().getName() + " : Command executed");
    }

    private AttributeList getAttributeList() throws CommandValidationException {
        Serializable serializable;
        AttributeList attributeList = new AttributeList();
        if (this.findOption(FACTORY_CLASS) != null) {
            serializable = new Attribute("factoryClass", this.getOptionValue(FACTORY_CLASS));
            attributeList.add((Attribute)serializable);
        }
        if (this.findOption(JDBC_JNDI) != null) {
            serializable = new Attribute("JdbcResourceJndiName", this.getOptionValue(JDBC_JNDI));
            attributeList.add((Attribute)serializable);
        }
        if (this.findOption(ENABLED) != null) {
            serializable = new Attribute(ENABLED, this.getBooleanOptionValue(ENABLED));
            attributeList.add((Attribute)serializable);
        }
        if (this.findOption(DESCRIPTION) != null) {
            serializable = new Attribute(DESCRIPTION, this.getOptionValue(DESCRIPTION));
            attributeList.add((Attribute)serializable);
        }
        serializable = this.getProperties();
        Enumeration<?> enumeration = ((Properties)serializable).propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)((Properties)serializable).get(string);
            Attribute attribute = new Attribute("property." + string, string2);
            attributeList.add(attribute);
            Debug.println("Property(name,value) = " + string + " , " + string2);
        }
        return attributeList;
    }
}

