/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.admin.servermodel.controllers;

import com.iplanet.ias.admin.comm.AdminConnectorClient;
import com.iplanet.ias.admin.comm.AuthenticationInfo;
import com.iplanet.ias.admin.comm.HttpConnectorAddress;
import com.iplanet.ias.admin.common.JMXExceptionTranslator;
import com.iplanet.ias.admin.common.MBeanServerFactory;
import com.iplanet.ias.admin.common.exception.AFException;
import com.iplanet.ias.admin.common.exception.AFTargetNotFoundException;
import com.iplanet.ias.admin.common.exception.AccessViolationException;
import com.iplanet.ias.admin.common.exception.AttributeNotFoundException;
import com.iplanet.ias.admin.common.exception.InvalidAttributeValueException;
import com.iplanet.ias.admin.servermodel.context.AdminContext;
import com.iplanet.ias.admin.servermodel.context.AuthenticationContext;
import com.iplanet.ias.admin.servermodel.context.ContextHolder;
import com.iplanet.ias.admin.util.ArgChecker;
import com.iplanet.ias.admin.util.Debug;
import com.iplanet.ias.admin.util.ExceptionUtil;
import com.iplanet.ias.admin.util.HostAndPort;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public class SOMRequestDispatcher {
    private boolean isLocal;
    private HostAndPort hostAndPort;
    private String user;
    private String password;

    public static SOMRequestDispatcher getDispatcher(ContextHolder contextHolder) {
        SOMRequestDispatcher sOMRequestDispatcher = new SOMRequestDispatcher();
        if (contextHolder != null) {
            AuthenticationContext authenticationContext;
            AdminContext adminContext = contextHolder.getAdminContext();
            if (adminContext != null && !adminContext.isLocal()) {
                sOMRequestDispatcher = new SOMRequestDispatcher(adminContext.getHostAndPort());
            }
            if ((authenticationContext = contextHolder.getAuthenticationContext()) != null) {
                String string = authenticationContext.getUser();
                String string2 = authenticationContext.getPassword();
                sOMRequestDispatcher.setClientCredentials(string, string2);
            }
        }
        return sOMRequestDispatcher;
    }

    SOMRequestDispatcher() {
        this.isLocal = true;
    }

    SOMRequestDispatcher(HostAndPort hostAndPort) {
        ArgChecker.checkValid(hostAndPort, "hAndp");
        this.hostAndPort = hostAndPort;
        this.isLocal = false;
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws AFException {
        Object object = null;
        try {
            if (this.isLocal) {
                MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
                object = mBeanServer.invoke(objectName, string, objectArray, stringArray);
            } else {
                HttpConnectorAddress httpConnectorAddress = this.getHttpConnectorAddress();
                AdminConnectorClient adminConnectorClient = new AdminConnectorClient(httpConnectorAddress);
                object = adminConnectorClient.invoke(objectName, string, objectArray, stringArray);
            }
        }
        catch (Exception exception) {
            AFException aFException = JMXExceptionTranslator.translate(exception);
            throw aFException;
        }
        return object;
    }

    public Object getAttribute(ObjectName objectName, String string) throws AttributeNotFoundException, AccessViolationException, AFTargetNotFoundException {
        Object object;
        block6: {
            object = null;
            try {
                if (this.isLocal) {
                    MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
                    object = mBeanServer.getAttribute(objectName, string);
                    break block6;
                }
                HttpConnectorAddress httpConnectorAddress = this.getHttpConnectorAddress();
                AdminConnectorClient adminConnectorClient = new AdminConnectorClient(httpConnectorAddress);
                object = adminConnectorClient.getAttribute(objectName, string);
            }
            catch (Exception exception) {
                AFException aFException = JMXExceptionTranslator.translate(exception);
                if (aFException instanceof AttributeNotFoundException) {
                    throw (AttributeNotFoundException)aFException;
                }
                if (aFException instanceof AccessViolationException) {
                    throw (AccessViolationException)aFException;
                }
                if (aFException instanceof AFTargetNotFoundException) {
                    throw (AFTargetNotFoundException)aFException;
                }
                Debug.printStackTrace(exception);
                ExceptionUtil.ignoreException(exception);
            }
        }
        return object;
    }

    public void setAttribute(ObjectName objectName, String string, Object object) throws AttributeNotFoundException, AccessViolationException, InvalidAttributeValueException, AFTargetNotFoundException {
        block7: {
            try {
                Attribute attribute = new Attribute(string, object);
                if (this.isLocal) {
                    MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
                    mBeanServer.setAttribute(objectName, attribute);
                    break block7;
                }
                HttpConnectorAddress httpConnectorAddress = this.getHttpConnectorAddress();
                AdminConnectorClient adminConnectorClient = new AdminConnectorClient(httpConnectorAddress);
                adminConnectorClient.setAttribute(objectName, attribute);
            }
            catch (Exception exception) {
                AFException aFException = JMXExceptionTranslator.translate(exception);
                if (aFException instanceof AttributeNotFoundException) {
                    throw (AttributeNotFoundException)aFException;
                }
                if (aFException instanceof AccessViolationException) {
                    throw (AccessViolationException)aFException;
                }
                if (aFException instanceof InvalidAttributeValueException) {
                    throw (InvalidAttributeValueException)aFException;
                }
                if (aFException instanceof AFTargetNotFoundException) {
                    throw (AFTargetNotFoundException)aFException;
                }
                Debug.printStackTrace(exception);
                ExceptionUtil.ignoreException(exception);
            }
        }
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws AFException {
        AttributeList attributeList = null;
        try {
            if (this.isLocal) {
                MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
                attributeList = mBeanServer.getAttributes(objectName, stringArray);
            } else {
                HttpConnectorAddress httpConnectorAddress = this.getHttpConnectorAddress();
                AdminConnectorClient adminConnectorClient = new AdminConnectorClient(httpConnectorAddress);
                attributeList = adminConnectorClient.getAttributes(objectName, stringArray);
            }
        }
        catch (Exception exception) {
            AFException aFException = JMXExceptionTranslator.translate(exception);
            throw aFException;
        }
        return attributeList;
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws AFException {
        AttributeList attributeList2 = null;
        try {
            if (this.isLocal) {
                MBeanServer mBeanServer = MBeanServerFactory.getMBeanServer();
                attributeList2 = mBeanServer.setAttributes(objectName, attributeList);
            } else {
                HttpConnectorAddress httpConnectorAddress = this.getHttpConnectorAddress();
                AdminConnectorClient adminConnectorClient = new AdminConnectorClient(httpConnectorAddress);
                attributeList2 = adminConnectorClient.setAttributes(objectName, attributeList);
            }
        }
        catch (Exception exception) {
            AFException aFException = JMXExceptionTranslator.translate(exception);
            throw aFException;
        }
        return attributeList2;
    }

    private final void setClientCredentials(String string, String string2) {
        this.user = string;
        this.password = string2;
    }

    private HttpConnectorAddress getHttpConnectorAddress() {
        HttpConnectorAddress httpConnectorAddress = new HttpConnectorAddress(this.hostAndPort);
        AuthenticationInfo authenticationInfo = new AuthenticationInfo(this.user, this.password);
        httpConnectorAddress.setAuthenticationInfo(authenticationInfo);
        return httpConnectorAddress;
    }
}

