/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

public class IndentingWriter
extends BufferedWriter {
    private boolean beginningOfLine = true;
    private int currentIndent = 0;
    private int indentStep = 4;
    private int tabSize = 8;

    public IndentingWriter(Writer writer) {
        super(writer);
    }

    public IndentingWriter(Writer writer, int n) {
        this(writer);
        if (this.indentStep < 0) {
            throw new IllegalArgumentException("negative indent step");
        }
        this.indentStep = n;
    }

    public IndentingWriter(Writer writer, int n, int n2) {
        this(writer);
        if (this.indentStep < 0) {
            throw new IllegalArgumentException("negative indent step");
        }
        this.indentStep = n;
        this.tabSize = n2;
    }

    public void write(int n) throws IOException {
        this.checkWrite();
        super.write(n);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (n2 > 0) {
            this.checkWrite();
        }
        super.write(cArray, n, n2);
    }

    public void write(String string, int n, int n2) throws IOException {
        if (n2 > 0) {
            this.checkWrite();
        }
        super.write(string, n, n2);
    }

    public void newLine() throws IOException {
        super.newLine();
        this.beginningOfLine = true;
    }

    protected void checkWrite() throws IOException {
        if (this.beginningOfLine) {
            this.beginningOfLine = false;
            int n = this.currentIndent;
            while (n >= this.tabSize) {
                super.write(9);
                n -= this.tabSize;
            }
            while (n > 0) {
                super.write(32);
                --n;
            }
        }
    }

    protected void indentIn() {
        this.currentIndent += this.indentStep;
    }

    protected void indentOut() {
        this.currentIndent -= this.indentStep;
        if (this.currentIndent < 0) {
            this.currentIndent = 0;
        }
    }

    public void pI() {
        this.indentIn();
    }

    public void pO() {
        this.indentOut();
    }

    public void p(String string) throws IOException {
        this.write(string);
    }

    public void pln() throws IOException {
        this.newLine();
    }

    public void pln(String string) throws IOException {
        this.p(string);
        this.pln();
    }

    public void plnI(String string) throws IOException {
        this.p(string);
        this.pln();
        this.pI();
    }

    public void pO(String string) throws IOException {
        this.pO();
        this.p(string);
    }

    public void pOln(String string) throws IOException {
        this.pO(string);
        this.pln();
    }

    public void pOlnI(String string) throws IOException {
        this.pO(string);
        this.pln();
        this.pI();
    }

    public void p(Object object) throws IOException {
        this.write(object.toString());
    }

    public void pln(Object object) throws IOException {
        this.p(object.toString());
        this.pln();
    }

    public void plnI(Object object) throws IOException {
        this.p(object.toString());
        this.pln();
        this.pI();
    }

    public void pO(Object object) throws IOException {
        this.pO();
        this.p(object.toString());
    }

    public void pOln(Object object) throws IOException {
        this.pO(object.toString());
        this.pln();
    }

    public void pOlnI(Object object) throws IOException {
        this.pO(object.toString());
        this.pln();
        this.pI();
    }
}

