/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs7.ContentInfo;
import org.mozilla.jss.pkcs7.SignerInfo;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.util.Assert;

public class SignedData
implements ASN1Value {
    private INTEGER version;
    private SET digestAlgorithms;
    private ContentInfo contentInfo;
    private SET certificates;
    private SET crls;
    private SET signerInfos;
    private static final INTEGER VERSION = new INTEGER(1L);
    static final Tag TAG = SEQUENCE.TAG;

    SignedData(INTEGER iNTEGER, SET sET, ContentInfo contentInfo, SET sET2, SET sET3, SET sET4) {
        SignedData.verifyNotNull(iNTEGER);
        this.version = iNTEGER;
        SignedData.verifyNotNull(sET);
        this.digestAlgorithms = sET;
        SignedData.verifyNotNull(contentInfo);
        this.contentInfo = contentInfo;
        this.certificates = sET2;
        this.crls = sET3;
        SignedData.verifyNotNull(sET4);
        this.signerInfos = sET4;
    }

    public SignedData(SET sET, ContentInfo contentInfo, SET sET2, SET sET3, SET sET4) {
        this.version = VERSION;
        this.digestAlgorithms = sET == null ? new SET() : sET;
        SignedData.verifyNotNull(contentInfo);
        this.contentInfo = contentInfo;
        this.certificates = sET2;
        this.crls = sET3;
        this.signerInfos = sET4 == null ? new SET() : sET4;
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        SEQUENCE sEQUENCE = new SEQUENCE();
        sEQUENCE.addElement(this.version);
        sEQUENCE.addElement(this.digestAlgorithms);
        sEQUENCE.addElement(this.contentInfo);
        if (this.certificates != null) {
            sEQUENCE.addElement(new Tag(0L), this.certificates);
        }
        if (this.crls != null) {
            sEQUENCE.addElement(new Tag(1L), this.crls);
        }
        sEQUENCE.addElement(this.signerInfos);
        sEQUENCE.encode(tag, outputStream);
    }

    public SET getCertificates() {
        return this.certificates;
    }

    public ContentInfo getContentInfo() {
        return this.contentInfo;
    }

    public SET getCrls() {
        return this.crls;
    }

    public SET getDigestAlgorithmIdentifiers() {
        return this.digestAlgorithms;
    }

    public SET getSignerInfos() {
        return this.signerInfos;
    }

    public Tag getTag() {
        return TAG;
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public boolean hasCertificates() {
        return this.certificates != null;
    }

    public boolean hasCrls() {
        return this.crls != null;
    }

    private static void verifyNotNull(Object object) {
        if (object == null) {
            throw new IllegalArgumentException();
        }
    }

    public static class Template
    implements ASN1Template {
        private SEQUENCE.Template seqt = new SEQUENCE.Template();

        public Template() {
            this.seqt.addElement(INTEGER.getTemplate());
            this.seqt.addElement(new SET.OF_Template(AlgorithmIdentifier.getTemplate()));
            this.seqt.addElement(ContentInfo.getTemplate());
            this.seqt.addOptionalElement(new Tag(0L), new SET.OF_Template(Certificate.getTemplate()));
            this.seqt.addOptionalElement(new Tag(1L), new SET.OF_Template(ANY.getTemplate()));
            this.seqt.addElement(new SET.OF_Template(SignerInfo.getTemplate()));
        }

        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(TAG, inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE sEQUENCE = (SEQUENCE)this.seqt.decode(tag, inputStream);
            Assert.assert(sEQUENCE.size() == 6);
            return new SignedData((INTEGER)sEQUENCE.elementAt(0), (SET)sEQUENCE.elementAt(1), (ContentInfo)sEQUENCE.elementAt(2), (SET)sEQUENCE.elementAt(3), (SET)sEQUENCE.elementAt(4), (SET)sEQUENCE.elementAt(5));
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }
    }
}

