/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.pkcs7;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.Tag;
import org.mozilla.jss.pkcs7.EncryptedContentInfo;
import org.mozilla.jss.pkcs7.RecipientInfo;
import org.mozilla.jss.util.Assert;

public class EnvelopedData
implements ASN1Value {
    public static final Tag TAG = SEQUENCE.TAG;
    private INTEGER version;
    private SET recipientInfos;
    private EncryptedContentInfo encryptedContentInfo;
    private SEQUENCE sequence = new SEQUENCE();

    private EnvelopedData() {
    }

    public EnvelopedData(INTEGER iNTEGER, SET sET, EncryptedContentInfo encryptedContentInfo) {
        this.version = iNTEGER;
        this.recipientInfos = sET;
        this.encryptedContentInfo = encryptedContentInfo;
        this.sequence.addElement(iNTEGER);
        this.sequence.addElement(sET);
        this.sequence.addElement(encryptedContentInfo);
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(this.getTag(), outputStream);
    }

    public void encode(Tag tag, OutputStream outputStream) throws IOException {
        this.sequence.encode(tag, outputStream);
    }

    public EncryptedContentInfo getEncryptedContentInfo() {
        return this.encryptedContentInfo;
    }

    public SET getRecipientInfos() {
        return this.recipientInfos;
    }

    public Tag getTag() {
        return TAG;
    }

    public INTEGER getVersion() {
        return this.version;
    }

    public static class Template
    implements ASN1Template {
        public ASN1Value decode(InputStream inputStream) throws IOException, InvalidBERException {
            return this.decode(this.getTag(), inputStream);
        }

        public ASN1Value decode(Tag tag, InputStream inputStream) throws IOException, InvalidBERException {
            SEQUENCE.Template template = new SEQUENCE.Template();
            template.addElement(new INTEGER.Template());
            template.addElement(new SET.OF_Template(new RecipientInfo.Template()));
            template.addElement(new EncryptedContentInfo.Template());
            SEQUENCE sEQUENCE = (SEQUENCE)template.decode(tag, inputStream);
            Assert.assert(sEQUENCE.size() == 3);
            return new EnvelopedData((INTEGER)sEQUENCE.elementAt(0), (SET)sEQUENCE.elementAt(1), (EncryptedContentInfo)sEQUENCE.elementAt(2));
        }

        public Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return tag.equals(TAG);
        }
    }
}

