/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.jss.asn1;

import java.io.CharConversionException;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.CharConverter;
import org.mozilla.jss.asn1.CharacterString;
import org.mozilla.jss.asn1.Form;
import org.mozilla.jss.asn1.Tag;

public class PrintableString
extends CharacterString
implements ASN1Value {
    public static final Tag TAG = new Tag(Tag.UNIVERSAL, 19L);
    public static final Form FORM = Form.PRIMITIVE;
    private static final Template templateInstance = new Template();

    public PrintableString(String string) throws CharConversionException {
        super(string);
    }

    public PrintableString(char[] cArray) throws CharConversionException {
        super(cArray);
    }

    CharConverter getCharConverter() {
        return new PrintableConverter();
    }

    public Tag getTag() {
        return TAG;
    }

    public static Template getTemplate() {
        return templateInstance;
    }

    public static class Template
    extends CharacterString.Template
    implements ASN1Template {
        protected CharacterString generateInstance(char[] cArray) throws CharConversionException {
            return new PrintableString(cArray);
        }

        protected CharConverter getCharConverter() {
            return new PrintableConverter();
        }

        protected Tag getTag() {
            return TAG;
        }

        public boolean tagMatch(Tag tag) {
            return TAG.equals(tag);
        }

        protected String typeName() {
            return "PrintableString";
        }
    }

    private static class PrintableConverter
    implements CharConverter {
        private static boolean[] isPrintable = new boolean[128];

        static {
            int n = 65;
            while (n <= 90) {
                PrintableConverter.isPrintable[n] = true;
                n = (char)(n + 1);
            }
            n = 97;
            while (n <= 122) {
                PrintableConverter.isPrintable[n] = true;
                n = (char)(n + 1);
            }
            n = 48;
            while (n <= 57) {
                PrintableConverter.isPrintable[n] = true;
                n = (char)(n + 1);
            }
            PrintableConverter.isPrintable[32] = true;
            PrintableConverter.isPrintable[39] = true;
            PrintableConverter.isPrintable[40] = true;
            PrintableConverter.isPrintable[41] = true;
            PrintableConverter.isPrintable[43] = true;
            PrintableConverter.isPrintable[44] = true;
            PrintableConverter.isPrintable[45] = true;
            PrintableConverter.isPrintable[46] = true;
            PrintableConverter.isPrintable[47] = true;
            PrintableConverter.isPrintable[58] = true;
            PrintableConverter.isPrintable[61] = true;
            PrintableConverter.isPrintable[63] = true;
        }

        PrintableConverter() {
        }

        public char[] byteToChar(byte[] byArray, int n, int n2) throws CharConversionException {
            char[] cArray = new char[n2];
            int n3 = 0;
            int n4 = n;
            while (n3 < n2) {
                if ((byArray[n4] & 0x80) == 0 && isPrintable[byArray[n4]]) {
                    cArray[n3] = (char)byArray[n4];
                }
                ++n4;
                ++n3;
            }
            return cArray;
        }

        public byte[] charToByte(char[] cArray, int n, int n2) throws CharConversionException {
            byte[] byArray = new byte[n2];
            int n3 = 0;
            int n4 = 0;
            while (n4 < n2) {
                if ((cArray[n3] & 0xFF80) != 0 || !isPrintable[cArray[n3]]) {
                    throw new CharConversionException(String.valueOf(cArray[n3]) + " is not " + "a valid character for a PrintableString");
                }
                byArray[n4] = (byte)(cArray[n3] & 0x7F);
                ++n4;
                ++n3;
            }
            return byArray;
        }
    }
}

