/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.Mark;
import org.apache.jasper.compiler.MyEntityResolver;
import org.apache.jasper.compiler.MyErrorHandler;
import org.apache.jasper.compiler.ParseException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JspUtil {
    private static final String OPEN_EXPR = "<%=";
    private static final String CLOSE_EXPR = "%>";
    private static final String OPEN_EXPR_XML = "%=";
    private static final String CLOSE_EXPR_XML = "%";
    private static ErrorHandler errorHandler = new MyErrorHandler();
    private static EntityResolver entityResolver = new MyEntityResolver();

    public static char[] removeQuotes(char[] cArray) {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '%' && cArray[n + 1] == '\\' && cArray[n + 2] == '>') {
                charArrayWriter.write(37);
                charArrayWriter.write(62);
                n += 2;
            } else {
                charArrayWriter.write(cArray[n]);
            }
            ++n;
        }
        return charArrayWriter.toCharArray();
    }

    public static char[] escapeQuotes(char[] cArray) {
        int n;
        String string = new String(cArray);
        while ((n = string.indexOf("%\\>")) >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
            stringBuffer.append(CLOSE_EXPR);
            stringBuffer.append(string.substring(n + 3));
            string = stringBuffer.toString();
        }
        cArray = string.toCharArray();
        return cArray;
    }

    public static boolean isExpression(String string, boolean bl) {
        String string2;
        String string3;
        if (bl) {
            string3 = OPEN_EXPR_XML;
            string2 = CLOSE_EXPR_XML;
        } else {
            string3 = OPEN_EXPR;
            string2 = CLOSE_EXPR;
        }
        return string.startsWith(string3) && string.endsWith(string2);
    }

    public static String getExpr(String string, boolean bl) {
        String string2;
        String string3;
        if (bl) {
            string3 = OPEN_EXPR_XML;
            string2 = CLOSE_EXPR_XML;
        } else {
            string3 = OPEN_EXPR;
            string2 = CLOSE_EXPR;
        }
        int n = string.length();
        String string4 = string.startsWith(string3) && string.endsWith(string2) ? string.substring(string3.length(), n - string2.length()) : "";
        return string4;
    }

    public static String getExprInXml(String string) {
        int n = string.length();
        String string2 = string.startsWith(OPEN_EXPR) && string.endsWith(CLOSE_EXPR) ? string.substring(1, n - 1) : string;
        return JspUtil.escapeXml(string2);
    }

    public static Document parseXMLDoc(String string, InputStream inputStream) throws JasperException {
        return JspUtil.parseXMLDocJaxp(string, inputStream);
    }

    public static Document parseXMLDocJaxp(String string, InputStream inputStream) throws JasperException {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(true);
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(entityResolver);
            documentBuilder.setErrorHandler(errorHandler);
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml", new Object[]{string, parserConfigurationException.getMessage()}));
        }
        catch (SAXParseException sAXParseException) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml.line", new Object[]{string, new Integer(sAXParseException.getLineNumber()), new Integer(sAXParseException.getColumnNumber()), sAXParseException.getMessage()}));
        }
        catch (SAXException sAXException) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml", new Object[]{string, sAXException.getMessage()}));
        }
        catch (IOException iOException) {
            throw new JasperException(Constants.getString("jsp.error.parse.xml", new Object[]{string, iOException.toString()}));
        }
    }

    public static void checkAttributes(String string, Attributes attributes, ValidAttribute[] validAttributeArray, Mark mark) throws JasperException {
        int n;
        boolean bl = true;
        int n2 = attributes.getLength();
        Vector<String> vector = new Vector<String>(n2, 1);
        int n3 = 0;
        while (n3 < n2) {
            vector.addElement(attributes.getQName(n3));
            ++n3;
        }
        String string2 = null;
        int n4 = 0;
        while (n4 < validAttributeArray.length) {
            if (validAttributeArray[n4].mandatory) {
                n = vector.indexOf(validAttributeArray[n4].name);
                if (n != -1) {
                    vector.remove(n);
                    bl = true;
                } else {
                    bl = false;
                    string2 = validAttributeArray[n4].name;
                    break;
                }
            }
            ++n4;
        }
        if (!bl) {
            throw new ParseException(mark, Constants.getString("jsp.error.mandatory.attribute", new Object[]{string, string2}));
        }
        n = vector.size();
        if (n == 0) {
            return;
        }
        String string3 = null;
        int n5 = 0;
        while (n5 < n) {
            bl = false;
            string3 = (String)vector.elementAt(n5);
            int n6 = 0;
            while (n6 < validAttributeArray.length) {
                if (string3.equals(validAttributeArray[n6].name)) {
                    bl = true;
                    break;
                }
                ++n6;
            }
            if (!bl) {
                throw new ParseException(mark, Constants.getString("jsp.error.invalid.attribute", new Object[]{string, string3}));
            }
            ++n5;
        }
    }

    public static String escapeQueryString(String string) {
        if (string == null) {
            return null;
        }
        String string2 = "";
        String string3 = "\\\"";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (string3.indexOf(c) != -1) {
                string2 = string2 + "\\";
            }
            string2 = string2 + c;
            ++n;
        }
        return string2;
    }

    public static String escapeXml(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '<') {
                stringBuffer.append("&lt;");
            } else if (c == '>') {
                stringBuffer.append("&gt;");
            } else if (c == '\'') {
                stringBuffer.append("&apos;");
            } else if (c == '&') {
                stringBuffer.append("&amp;");
            } else if (c == '\"') {
                stringBuffer.append("&quot;");
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public static Hashtable attrsToHashtable(Attributes attributes) {
        int n = attributes.getLength();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n);
        int n2 = 0;
        while (n2 < n) {
            hashtable.put(attributes.getQName(n2), attributes.getValue(n2));
            ++n2;
        }
        return hashtable;
    }

    public static String getElementChildTextData(Element element) {
        String string = null;
        Text text = (Text)element.getFirstChild();
        if (text != null && (string = text.getData()) != null) {
            string = string.trim();
        }
        return string;
    }

    public static boolean booleanValue(String string) {
        boolean bl = false;
        if (string != null) {
            bl = string.equalsIgnoreCase("yes") ? true : Boolean.valueOf(string);
        }
        return bl;
    }

    public static class ValidAttribute {
        String name;
        boolean mandatory;

        public ValidAttribute(String string, boolean bl) {
            this.name = string;
            this.mandatory = bl;
        }

        public ValidAttribute(String string) {
            this(string, false);
        }
    }
}

