/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpServletResponse;

public class ProcessHelper {
    private String command = null;
    private Hashtable env = null;
    private File wd = null;
    private Hashtable params = null;
    private InputStream stdin = null;
    private HttpServletResponse response = null;
    private boolean readyToRun = false;
    private int debug = 0;
    private int iClientInputTimeout;

    public ProcessHelper(String string, Hashtable hashtable, File file, Hashtable hashtable2) {
        this.command = string;
        this.env = hashtable;
        this.wd = file;
        this.params = hashtable2;
        this.updateReadyStatus();
    }

    protected void updateReadyStatus() {
        this.readyToRun = this.command != null && this.env != null && this.wd != null && this.params != null && this.response != null;
    }

    public boolean isReady() {
        return this.readyToRun;
    }

    public void setResponse(HttpServletResponse httpServletResponse) {
        this.response = httpServletResponse;
        this.updateReadyStatus();
    }

    public void setInput(InputStream inputStream) {
        this.stdin = inputStream;
        this.updateReadyStatus();
    }

    private String[] hashToStringArray(Hashtable hashtable) throws NullPointerException {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            objectArray = enumeration.nextElement().toString();
            vector.add((String)objectArray + "=" + hashtable.get(objectArray));
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void run() throws IOException {
        String string;
        if (!this.isReady()) {
            throw new IOException(this.getClass().getName() + ": not ready to run.");
        }
        if (this.debug >= 1) {
            this.log("runCGI(envp=[" + this.env + "], command=" + this.command + ")");
        }
        if (this.command.indexOf(File.separator + "." + File.separator) >= 0 || this.command.indexOf(File.separator + "..") >= 0 || this.command.indexOf(".." + File.separator) >= 0) {
            throw new IOException(this.getClass().getName() + "Illegal Character in CGI command " + "path ('.' or '..') detected.  Not " + "running CGI [" + this.command + "].");
        }
        Runtime runtime = null;
        BufferedReader bufferedReader = null;
        BufferedReader bufferedReader2 = null;
        BufferedOutputStream bufferedOutputStream = null;
        Process process = null;
        byte[] byArray = new byte[1024];
        char[] cArray = new char[1024];
        int n = -1;
        Enumeration enumeration = this.params.keys();
        StringBuffer stringBuffer = new StringBuffer(this.command);
        if (enumeration != null && enumeration.hasMoreElements()) {
            stringBuffer.append(" ");
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                String string2 = this.params.get(string).toString();
                if (string.indexOf("=") >= 0 || string2.indexOf("=") >= 0) continue;
                stringBuffer.append(string);
                stringBuffer.append("=");
                string2 = URLEncoder.encode(string2);
                stringBuffer.append(string2);
                stringBuffer.append(" ");
            }
        }
        string = this.getPostInput(this.params);
        int n2 = string.length() + System.getProperty("line.separator").length();
        if ("POST".equals(this.env.get("REQUEST_METHOD"))) {
            this.env.put("CONTENT_LENGTH", new Integer(n2));
        }
        runtime = Runtime.getRuntime();
        process = runtime.exec(stringBuffer.toString(), this.hashToStringArray(this.env), this.wd);
        bufferedOutputStream = new BufferedOutputStream(process.getOutputStream());
        if (this.debug >= 2) {
            this.log("runCGI stdin=[" + this.stdin + "], qs=" + this.env.get("QUERY_STRING"));
        }
        if ("POST".equals(this.env.get("REQUEST_METHOD"))) {
            if (this.debug >= 2) {
                this.log("runCGI: writing ---------------\n");
                this.log(string);
                this.log("runCGI: new content_length=" + n2 + "---------------\n");
            }
            bufferedOutputStream.write(string.getBytes());
        }
        if (this.stdin != null) {
            if (this.stdin.available() <= 0) {
                if (this.debug >= 2) {
                    this.log("runCGI stdin is NOT available [" + this.stdin.available() + "]");
                }
                try {
                    Thread.currentThread();
                    Thread.sleep(this.iClientInputTimeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.stdin.available() > 0) {
                if (this.debug >= 2) {
                    this.log("runCGI stdin IS available [" + this.stdin.available() + "]");
                }
                byArray = new byte[1024];
                n = -1;
                try {
                    while ((n = this.stdin.read(byArray)) != -1) {
                        if (this.debug >= 2) {
                            this.log("runCGI: read [" + n + "] bytes from stdin");
                        }
                        bufferedOutputStream.write(byArray, 0, n);
                    }
                    if (this.debug >= 2) {
                        this.log("runCGI: DONE READING from stdin");
                    }
                }
                catch (IOException iOException) {
                    this.log("runCGI: couldn't write all bytes.");
                    iOException.printStackTrace();
                }
            }
        }
        bufferedOutputStream.flush();
        bufferedOutputStream.close();
        boolean bl = true;
        bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        bufferedReader2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        BufferedWriter bufferedWriter = null;
        try {
            if (this.response.getOutputStream() != null) {
                bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)this.response.getOutputStream()));
            }
        }
        catch (IOException iOException) {}
        while (bl) {
            try {
                cArray = new char[1024];
                while ((n = bufferedReader2.read(cArray)) != -1) {
                    if (bufferedWriter == null) continue;
                    bufferedWriter.write(cArray, 0, n);
                }
                String string3 = null;
                while ((string3 = bufferedReader.readLine()) != null && !"".equals(string3)) {
                    if (this.debug >= 2) {
                        this.log("runCGI: addHeader(\"" + string3 + "\")");
                    }
                    if (string3.startsWith("HTTP")) continue;
                    this.response.addHeader(string3.substring(0, string3.indexOf(":")).trim(), string3.substring(string3.indexOf(":") + 1).trim());
                }
                cArray = new char[1024];
                while ((n = bufferedReader.read(cArray)) != -1) {
                    if (bufferedWriter == null) continue;
                    if (this.debug >= 4) {
                        this.log("runCGI: write(\"" + cArray + "\")");
                    }
                    bufferedWriter.write(cArray, 0, n);
                }
                if (bufferedWriter != null) {
                    bufferedWriter.flush();
                }
                process.exitValue();
                bl = false;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                try {
                    Thread.currentThread();
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected String getPostInput(Hashtable hashtable) {
        String string = System.getProperty("line.separator");
        Enumeration enumeration = hashtable.keys();
        StringBuffer stringBuffer = new StringBuffer("");
        StringBuffer stringBuffer2 = new StringBuffer("");
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = hashtable.get(string2).toString();
                if (string2.indexOf("=") >= 0 || string3.indexOf("=") >= 0) continue;
                stringBuffer.append(string2);
                stringBuffer2.append(string2);
                stringBuffer.append("=");
                stringBuffer2.append("=");
                stringBuffer.append(string3);
                stringBuffer2.append(string3);
                stringBuffer.append(string);
                stringBuffer2.append("&");
            }
        }
        stringBuffer2.append(string);
        return stringBuffer2.append(stringBuffer).toString();
    }

    private void log(String string) {
        System.out.println(string);
    }

    public int getIClientInputTimeout() {
        return this.iClientInputTimeout;
    }

    public void setIClientInputTimeout(int n) {
        this.iClientInputTimeout = n;
    }
}

