/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.catalina.servlets.DefaultServlet;
import org.apache.catalina.servlets.WebdavStatus;
import org.apache.catalina.util.DOMWriter;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.XMLWriter;
import org.apache.naming.resources.Resource;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class WebdavServlet
extends DefaultServlet {
    private static final String METHOD_HEAD = "HEAD";
    private static final String METHOD_PROPFIND = "PROPFIND";
    private static final String METHOD_PROPPATCH = "PROPPATCH";
    private static final String METHOD_MKCOL = "MKCOL";
    private static final String METHOD_COPY = "COPY";
    private static final String METHOD_MOVE = "MOVE";
    private static final String METHOD_LOCK = "LOCK";
    private static final String METHOD_UNLOCK = "UNLOCK";
    private static final int INFINITY = 3;
    private static final int FIND_BY_PROPERTY = 0;
    private static final int FIND_ALL_PROP = 1;
    private static final int FIND_PROPERTY_NAMES = 2;
    private static final int LOCK_CREATION = 0;
    private static final int LOCK_REFRESH = 1;
    private static final int DEFAULT_TIMEOUT = 3600;
    private static final int MAX_TIMEOUT = 604800;
    protected static final String DEFAULT_NAMESPACE = "DAV:";
    protected static final SimpleDateFormat creationDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private Hashtable resourceLocks = new Hashtable();
    private Hashtable lockNullResources = new Hashtable();
    private Vector collectionLocks = new Vector();
    private String secret = "catalina";

    public void init() throws ServletException {
        super.init();
        String string = null;
        try {
            string = this.getServletConfig().getInitParameter("secret");
            if (string != null) {
                this.secret = string;
            }
        }
        catch (Throwable throwable) {}
    }

    protected DocumentBuilder getDocumentBuilder() throws ServletException {
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ServletException(DefaultServlet.sm.getString("webdavservlet.jaxpfailed"));
        }
        return documentBuilder;
    }

    protected void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = httpServletRequest.getMethod();
        if (this.debug > 0) {
            String string2 = this.getRelativePath(httpServletRequest);
            System.out.println("[" + string + "] " + string2);
        }
        if (string.equals(METHOD_PROPFIND)) {
            this.doPropfind(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_PROPPATCH)) {
            this.doProppatch(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_MKCOL)) {
            this.doMkcol(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_COPY)) {
            this.doCopy(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_MOVE)) {
            this.doMove(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_LOCK)) {
            this.doLock(httpServletRequest, httpServletResponse);
        } else if (string.equals(METHOD_UNLOCK)) {
            this.doUnlock(httpServletRequest, httpServletResponse);
        } else {
            super.service(httpServletRequest, httpServletResponse);
        }
    }

    protected boolean checkIfHeaders(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DefaultServlet.ResourceInfo resourceInfo) throws IOException {
        return super.checkIfHeaders(httpServletRequest, httpServletResponse, resourceInfo);
    }

    protected void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        httpServletResponse.addHeader("DAV", "1,2");
        String string2 = null;
        DirContext dirContext = this.getResources();
        if (dirContext == null) {
            httpServletResponse.sendError(500);
            return;
        }
        boolean bl = true;
        Object object = null;
        try {
            object = dirContext.lookup(string);
        }
        catch (NamingException namingException) {
            bl = false;
        }
        if (!bl) {
            string2 = "OPTIONS, MKCOL, PUT, LOCK";
            httpServletResponse.addHeader("Allow", string2);
            return;
        }
        string2 = "OPTIONS, GET, HEAD, POST, DELETE, TRACE, PROPFIND, PROPPATCH, COPY, MOVE, LOCK, UNLOCK";
        if (!(object instanceof DirContext)) {
            string2 = string2 + ", PUT";
        }
        httpServletResponse.addHeader("Allow", string2);
        httpServletResponse.addHeader("MS-Author-Via", "DAV");
    }

    /*
     * Unable to fully structure code
     */
    protected void doPropfind(HttpServletRequest var1_1, HttpServletResponse var2_2) throws ServletException, IOException {
        block44: {
            if (!this.listings) {
                var2_2.sendError(405);
                return;
            }
            var3_3 = this.getRelativePath(var1_1);
            if (var3_3.endsWith("/")) {
                var3_3 = var3_3.substring(0, var3_3.length() - 1);
            }
            if (var3_3.toUpperCase().startsWith("/WEB-INF") || var3_3.toUpperCase().startsWith("/META-INF")) {
                var2_2.sendError(403);
                return;
            }
            var4_4 = null;
            var5_5 = 3;
            var6_6 = 1;
            var7_7 = var1_1.getHeader("Depth");
            if (var7_7 == null) {
                var5_5 = 3;
            } else if (var7_7.equals("0")) {
                var5_5 = 0;
            } else if (var7_7.equals("1")) {
                var5_5 = 1;
            } else if (var7_7.equals("infinity")) {
                var5_5 = 3;
            }
            var8_8 = null;
            var9_9 = this.getDocumentBuilder();
            try {
                var10_10 = var9_9.parse(new InputSource((InputStream)var1_1.getInputStream()));
                var11_12 = var10_10.getDocumentElement();
                var12_15 = var11_12.getChildNodes();
                var13_16 = 0;
                while (var13_16 < var12_15.getLength()) {
                    var14_20 = var12_15.item(var13_16);
                    switch (var14_20.getNodeType()) {
                        case 3: {
                            break;
                        }
                        case 1: {
                            if (var14_20.getNodeName().endsWith("prop")) {
                                var6_6 = 0;
                                var8_8 = var14_20;
                            }
                            if (var14_20.getNodeName().endsWith("propname")) {
                                var6_6 = 2;
                            }
                            if (!var14_20.getNodeName().endsWith("allprop")) break;
                            var6_6 = 1;
                        }
                    }
                    ++var13_16;
                }
            }
            catch (Exception var10_11) {
                // empty catch block
            }
            if (var6_6 == 0) {
                var4_4 = new Vector<Object>();
                var10_10 = var8_8.getChildNodes();
                var11_13 = 0;
                while (var11_13 < var10_10.getLength()) {
                    var12_15 = var10_10.item(var11_13);
                    switch (var12_15.getNodeType()) {
                        case 3: {
                            break;
                        }
                        case 1: {
                            var13_17 = var12_15.getNodeName();
                            var14_20 = null;
                            var14_20 = var13_17.indexOf(58) != -1 ? var13_17.substring(var13_17.indexOf(58) + 1) : var13_17;
                            var4_4.addElement(var14_20);
                        }
                    }
                    ++var11_13;
                }
            }
            if ((var10_10 = this.getResources()) == null) {
                var2_2.sendError(500);
                return;
            }
            var11_14 = true;
            var12_15 = null;
            try {
                var12_15 = var10_10.lookup(var3_3);
                break block44;
            }
            catch (NamingException var13_18) {
                var11_14 = false;
                var14_21 = var3_3.lastIndexOf(47);
                if (var14_21 == -1 || (var16_24 = (Vector)this.lockNullResources.get(var15_23 = var3_3.substring(0, var14_21))) == null) break block44;
                var17_25 = var16_24.elements();
                ** while (var17_25.hasMoreElements())
            }
lbl-1000:
            // 1 sources

            {
                var18_28 = (String)var17_25.nextElement();
                if (!var18_28.equals(var3_3)) continue;
                var2_2.setStatus(207);
                var2_2.setContentType("text/xml; charset=UTF-8");
                var19_29 = new XMLWriter(var2_2.getWriter());
                var19_29.writeXMLHeader();
                var19_29.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
                this.parseLockNullProperties(var1_1, var19_29, (String)var18_28, var6_6, var4_4);
                var19_29.writeElement(null, "multistatus", 1);
                var19_29.sendData();
                return;
            }
        }
        if (!var11_14) {
            var2_2.sendError(404, var3_3);
            return;
        }
        var2_2.setStatus(207);
        var2_2.setContentType("text/xml; charset=UTF-8");
        var13_19 = new XMLWriter(var2_2.getWriter());
        var13_19.writeXMLHeader();
        var13_19.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
        if (var5_5 == 0) {
            this.parseProperties(var1_1, (DirContext)var10_10, var13_19, var3_3, var6_6, var4_4);
        } else {
            var14_22 = new Stack<String>();
            var14_22.push(var3_3);
            var15_23 = new Stack<E>();
            while (!var14_22.isEmpty() && var5_5 >= 0) {
                var16_24 = (String)var14_22.pop();
                this.parseProperties(var1_1, (DirContext)var10_10, var13_19, (String)var16_24, var6_6, var4_4);
                try {
                    var12_15 = var10_10.lookup((String)var16_24);
                }
                catch (NamingException var17_26) {
                    continue;
                }
                if (var12_15 instanceof DirContext && var5_5 > 0) {
                    try {
                        var17_25 = var10_10.list((String)var16_24);
                        while (var17_25.hasMoreElements()) {
                            var18_28 = (NameClassPair)var17_25.nextElement();
                            var19_30 = var16_24;
                            if (!var19_30.endsWith("/")) {
                                var19_30 = (String)var19_30 + "/";
                            }
                            var19_30 = (String)var19_30 + var18_28.getName();
                            var15_23.push(var19_30);
                        }
                    }
                    catch (NamingException var17_27) {
                        var2_2.sendError(500, var3_3);
                        return;
                    }
                    var17_25 = var16_24;
                    if (var17_25.endsWith("/")) {
                        var17_25 = var17_25.substring(0, var17_25.length() - 1);
                    }
                    if ((var18_28 = (Vector)this.lockNullResources.get(var17_25)) != null) {
                        var19_30 = var18_28.elements();
                        while (var19_30.hasMoreElements()) {
                            var20_31 = (String)var19_30.nextElement();
                            this.parseLockNullProperties(var1_1, var13_19, var20_31, var6_6, var4_4);
                        }
                    }
                }
                if (var14_22.isEmpty()) {
                    --var5_5;
                    var14_22 = var15_23;
                    var15_23 = new Stack<Object>();
                }
                var13_19.sendData();
            }
        }
        var13_19.writeElement(null, "multistatus", 1);
        var13_19.sendData();
    }

    protected void doProppatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        httpServletResponse.sendError(405);
    }

    protected void doMkcol(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        if (string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            httpServletResponse.sendError(403);
            return;
        }
        DirContext dirContext = this.getResources();
        if (dirContext == null) {
            httpServletResponse.sendError(500);
            return;
        }
        boolean bl = true;
        Object object = null;
        try {
            object = dirContext.lookup(string);
        }
        catch (NamingException namingException) {
            bl = false;
        }
        if (bl) {
            httpServletResponse.sendError(405);
            return;
        }
        boolean bl2 = true;
        try {
            dirContext.createSubcontext(string);
        }
        catch (NamingException namingException) {
            bl2 = false;
        }
        if (!bl2) {
            httpServletResponse.sendError(409, WebdavStatus.getStatusText(409));
        } else {
            httpServletResponse.setStatus(201);
            this.lockNullResources.remove(string);
        }
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        this.deleteResource(httpServletRequest, httpServletResponse);
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        super.doPut(httpServletRequest, httpServletResponse);
        String string = this.getRelativePath(httpServletRequest);
        this.lockNullResources.remove(string);
    }

    protected void doCopy(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        this.copyResource(httpServletRequest, httpServletResponse);
    }

    protected void doMove(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        if (this.copyResource(httpServletRequest, httpServletResponse)) {
            this.deleteResource(string, httpServletRequest, httpServletResponse);
        }
    }

    protected void doLock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        Object object3;
        Enumeration<Object> enumeration;
        Object object4;
        Object object5;
        Object object6;
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        Object object7 = new LockInfo();
        String string = httpServletRequest.getHeader("Depth");
        ((LockInfo)object7).depth = string == null ? 3 : (string.equals("0") ? 0 : 3);
        int n = 3600;
        String string2 = httpServletRequest.getHeader("Timeout");
        if (string2 == null) {
            n = 3600;
        } else {
            if (string2.startsWith("Second-")) {
                n = new Integer(string2.substring(7));
            } else if (string2.equalsIgnoreCase("infinity")) {
                n = 604800;
            } else {
                try {
                    n = new Integer(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    n = 604800;
                }
            }
            if (n == 0) {
                n = 3600;
            }
            if (n > 604800) {
                n = 604800;
            }
        }
        ((LockInfo)object7).expiresAt = System.currentTimeMillis() + (long)(n * 1000);
        boolean bl = false;
        Node node = null;
        DocumentBuilder documentBuilder = this.getDocumentBuilder();
        try {
            object6 = documentBuilder.parse(new InputSource((InputStream)httpServletRequest.getInputStream()));
            object5 = object6.getDocumentElement();
            node = object5;
        }
        catch (Exception exception) {
            bl = true;
        }
        if (node != null) {
            object6 = node.getChildNodes();
            object5 = null;
            DOMWriter dOMWriter = null;
            object4 = null;
            enumeration = null;
            object3 = null;
            int n2 = 0;
            while (n2 < object6.getLength()) {
                Node node2 = object6.item(n2);
                switch (node2.getNodeType()) {
                    case 3: {
                        break;
                    }
                    case 1: {
                        object2 = node2.getNodeName();
                        if (((String)object2).endsWith("lockscope")) {
                            object4 = node2;
                        }
                        if (((String)object2).endsWith("locktype")) {
                            enumeration = node2;
                        }
                        if (!((String)object2).endsWith("owner")) break;
                        object3 = node2;
                    }
                }
                ++n2;
            }
            if (object4 != null) {
                object6 = object4.getChildNodes();
                int n3 = 0;
                while (n3 < object6.getLength()) {
                    object2 = object6.item(n3);
                    switch (object2.getNodeType()) {
                        case 3: {
                            break;
                        }
                        case 1: {
                            object = object2.getNodeName();
                            ((LockInfo)object7).scope = ((String)object).indexOf(58) != -1 ? ((String)object).substring(((String)object).indexOf(58) + 1) : object;
                        }
                    }
                    ++n3;
                }
                if (((LockInfo)object7).scope == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                httpServletResponse.setStatus(400);
            }
            if (enumeration != null) {
                object6 = enumeration.getChildNodes();
                int n4 = 0;
                while (n4 < object6.getLength()) {
                    object2 = object6.item(n4);
                    switch (object2.getNodeType()) {
                        case 3: {
                            break;
                        }
                        case 1: {
                            object = object2.getNodeName();
                            ((LockInfo)object7).type = ((String)object).indexOf(58) != -1 ? ((String)object).substring(((String)object).indexOf(58) + 1) : object;
                        }
                    }
                    ++n4;
                }
                if (((LockInfo)object7).type == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                httpServletResponse.setStatus(400);
            }
            if (object3 != null) {
                object6 = object3.getChildNodes();
                int n5 = 0;
                while (n5 < object6.getLength()) {
                    object2 = object6.item(n5);
                    switch (object2.getNodeType()) {
                        case 3: {
                            ((LockInfo)object7).owner = ((LockInfo)object7).owner + object2.getNodeValue();
                            break;
                        }
                        case 1: {
                            object5 = new StringWriter();
                            dOMWriter = new DOMWriter((Writer)object5, true);
                            dOMWriter.print((Node)object2);
                            ((LockInfo)object7).owner = ((LockInfo)object7).owner + ((StringWriter)object5).toString();
                        }
                    }
                    ++n5;
                }
                if (((LockInfo)object7).owner == null) {
                    httpServletResponse.setStatus(400);
                }
            } else {
                ((LockInfo)object7).owner = new String();
            }
        }
        ((LockInfo)object7).path = object6 = this.getRelativePath(httpServletRequest);
        object5 = this.getResources();
        if (object5 == null) {
            httpServletResponse.sendError(500);
            return;
        }
        boolean bl2 = true;
        object4 = null;
        try {
            object4 = object5.lookup((String)object6);
        }
        catch (NamingException namingException) {
            bl2 = false;
        }
        enumeration = null;
        if (!bl) {
            object3 = httpServletRequest.getServletPath() + "-" + ((LockInfo)object7).type + "-" + ((LockInfo)object7).scope + "-" + httpServletRequest.getUserPrincipal() + "-" + ((LockInfo)object7).depth + "-" + ((LockInfo)object7).owner + "-" + ((LockInfo)object7).tokens + "-" + ((LockInfo)object7).expiresAt + "-" + System.currentTimeMillis() + "-" + this.secret;
            String string3 = DefaultServlet.md5Encoder.encode(DefaultServlet.md5Helper.digest(((String)object3).getBytes()));
            if (bl2 && object4 instanceof DirContext && ((LockInfo)object7).depth == 3) {
                Vector<String> vector = new Vector<String>();
                enumeration = this.collectionLocks.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (LockInfo)enumeration.nextElement();
                    if (((LockInfo)object2).hasExpired()) {
                        this.resourceLocks.remove(((LockInfo)object2).path);
                        continue;
                    }
                    if (!((LockInfo)object2).path.startsWith(((LockInfo)object7).path) || !((LockInfo)object2).isExclusive() && !((LockInfo)object7).isExclusive()) continue;
                    vector.addElement(((LockInfo)object2).path);
                }
                enumeration = this.resourceLocks.elements();
                while (enumeration.hasMoreElements()) {
                    object2 = (LockInfo)enumeration.nextElement();
                    if (((LockInfo)object2).hasExpired()) {
                        this.resourceLocks.remove(((LockInfo)object2).path);
                        continue;
                    }
                    if (!((LockInfo)object2).path.startsWith(((LockInfo)object7).path) || !((LockInfo)object2).isExclusive() && !((LockInfo)object7).isExclusive()) continue;
                    vector.addElement(((LockInfo)object2).path);
                }
                if (!vector.isEmpty()) {
                    object2 = vector.elements();
                    httpServletResponse.setStatus(409);
                    object = new XMLWriter();
                    ((XMLWriter)object).writeXMLHeader();
                    ((XMLWriter)object).writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
                    while (object2.hasMoreElements()) {
                        ((XMLWriter)object).writeElement(null, "response", 0);
                        ((XMLWriter)object).writeElement(null, "href", 0);
                        ((XMLWriter)object).writeText((String)object2.nextElement());
                        ((XMLWriter)object).writeElement(null, "href", 1);
                        ((XMLWriter)object).writeElement(null, "status", 0);
                        ((XMLWriter)object).writeText("HTTP/1.1 423 " + WebdavStatus.getStatusText(423));
                        ((XMLWriter)object).writeElement(null, "status", 1);
                        ((XMLWriter)object).writeElement(null, "response", 1);
                    }
                    ((XMLWriter)object).writeElement(null, "multistatus", 1);
                    PrintWriter printWriter = httpServletResponse.getWriter();
                    ((Writer)printWriter).write(((XMLWriter)object).toString());
                    ((Writer)printWriter).close();
                    return;
                }
                boolean bl3 = true;
                enumeration = this.collectionLocks.elements();
                while (enumeration.hasMoreElements()) {
                    object = (LockInfo)enumeration.nextElement();
                    if (!((LockInfo)object).path.equals(((LockInfo)object7).path)) continue;
                    if (((LockInfo)object).isExclusive()) {
                        httpServletResponse.sendError(423);
                        return;
                    }
                    if (((LockInfo)object7).isExclusive()) {
                        httpServletResponse.sendError(423);
                        return;
                    }
                    ((LockInfo)object).tokens.addElement(string3);
                    object7 = object;
                    bl3 = false;
                }
                if (bl3) {
                    ((LockInfo)object7).tokens.addElement(string3);
                    this.collectionLocks.addElement(object7);
                }
            } else {
                LockInfo lockInfo = (LockInfo)this.resourceLocks.get(((LockInfo)object7).path);
                if (lockInfo != null) {
                    if (lockInfo.isExclusive() || ((LockInfo)object7).isExclusive()) {
                        httpServletResponse.sendError(412);
                        return;
                    }
                    lockInfo.tokens.addElement(string3);
                    object7 = lockInfo;
                } else {
                    ((LockInfo)object7).tokens.addElement(string3);
                    this.resourceLocks.put(((LockInfo)object7).path, object7);
                    bl2 = true;
                    try {
                        object4 = object5.lookup((String)object6);
                    }
                    catch (NamingException namingException) {
                        bl2 = false;
                    }
                    if (!bl2) {
                        int n6 = ((LockInfo)object7).path.lastIndexOf(47);
                        object = ((LockInfo)object7).path.substring(0, n6);
                        Vector<String> vector = (Vector<String>)this.lockNullResources.get(object);
                        if (vector == null) {
                            vector = new Vector<String>();
                            this.lockNullResources.put(object, vector);
                        }
                        vector.addElement(((LockInfo)object7).path);
                    }
                }
            }
        }
        if (bl) {
            object3 = httpServletRequest.getHeader("If");
            if (object3 == null) {
                object3 = "";
            }
            LockInfo lockInfo = (LockInfo)this.resourceLocks.get(object6);
            Enumeration enumeration2 = null;
            if (object7 != null) {
                enumeration2 = lockInfo.tokens.elements();
                while (enumeration2.hasMoreElements()) {
                    String string4 = (String)enumeration2.nextElement();
                    if (((String)object3).indexOf(string4) == -1) continue;
                    lockInfo.expiresAt = ((LockInfo)object7).expiresAt;
                    object7 = lockInfo;
                }
            }
            Enumeration enumeration3 = this.collectionLocks.elements();
            while (enumeration3.hasMoreElements()) {
                lockInfo = (LockInfo)enumeration3.nextElement();
                if (!((String)object6).equals(lockInfo.path)) continue;
                enumeration2 = lockInfo.tokens.elements();
                while (enumeration2.hasMoreElements()) {
                    object = (String)enumeration2.nextElement();
                    if (((String)object3).indexOf((String)object) == -1) continue;
                    lockInfo.expiresAt = ((LockInfo)object7).expiresAt;
                    object7 = lockInfo;
                }
            }
        }
        object3 = new XMLWriter();
        ((XMLWriter)object3).writeXMLHeader();
        ((XMLWriter)object3).writeElement(null, "prop" + this.generateNamespaceDeclarations(), 0);
        ((XMLWriter)object3).writeElement(null, "lockdiscovery", 0);
        ((LockInfo)object7).toXML((XMLWriter)object3, true);
        ((XMLWriter)object3).writeElement(null, "lockdiscovery", 1);
        ((XMLWriter)object3).writeElement(null, "prop", 1);
        httpServletResponse.setStatus(200);
        httpServletResponse.setContentType("text/xml; charset=UTF-8");
        PrintWriter printWriter = httpServletResponse.getWriter();
        ((Writer)printWriter).write(((XMLWriter)object3).toString());
        ((Writer)printWriter).close();
    }

    protected void doUnlock(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        if (this.readOnly) {
            httpServletResponse.sendError(403);
            return;
        }
        if (this.isLocked(httpServletRequest)) {
            httpServletResponse.sendError(423);
            return;
        }
        String string = this.getRelativePath(httpServletRequest);
        String string2 = httpServletRequest.getHeader("Lock-Token");
        if (string2 == null) {
            string2 = "";
        }
        LockInfo lockInfo = (LockInfo)this.resourceLocks.get(string);
        Enumeration enumeration = null;
        if (lockInfo != null) {
            enumeration = lockInfo.tokens.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                if (string2.indexOf((String)object) == -1) continue;
                lockInfo.tokens.removeElement(object);
            }
            if (lockInfo.tokens.isEmpty()) {
                this.resourceLocks.remove(string);
                this.lockNullResources.remove(string);
            }
        }
        object = this.collectionLocks.elements();
        while (object.hasMoreElements()) {
            lockInfo = (LockInfo)object.nextElement();
            if (!string.equals(lockInfo.path)) continue;
            enumeration = lockInfo.tokens.elements();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (string2.indexOf(string3) == -1) continue;
                lockInfo.tokens.removeElement(string3);
                break;
            }
            if (!lockInfo.tokens.isEmpty()) continue;
            this.collectionLocks.removeElement(lockInfo);
            this.lockNullResources.remove(string);
        }
        httpServletResponse.setStatus(204);
    }

    private String generateNamespaceDeclarations() {
        return " xmlns=\"DAV:\"";
    }

    private boolean isLocked(HttpServletRequest httpServletRequest) {
        String string;
        String string2 = this.getRelativePath(httpServletRequest);
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string = httpServletRequest.getHeader("Lock-Token")) == null) {
            string = "";
        }
        return this.isLocked(string2, string3 + string);
    }

    private boolean isLocked(String string, String string2) {
        LockInfo lockInfo = (LockInfo)this.resourceLocks.get(string);
        Enumeration enumeration = null;
        if (lockInfo != null && lockInfo.hasExpired()) {
            this.resourceLocks.remove(string);
        } else if (lockInfo != null) {
            enumeration = lockInfo.tokens.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                if (string2.indexOf(string3) == -1) continue;
                bl = true;
            }
            if (!bl) {
                return true;
            }
        }
        Enumeration enumeration2 = this.collectionLocks.elements();
        while (enumeration2.hasMoreElements()) {
            lockInfo = (LockInfo)enumeration2.nextElement();
            if (lockInfo.hasExpired()) {
                this.collectionLocks.removeElement(lockInfo);
                continue;
            }
            if (!string.startsWith(lockInfo.path)) continue;
            enumeration = lockInfo.tokens.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                if (string2.indexOf(string4) == -1) continue;
                bl = true;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    private boolean copyResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        DirContext dirContext;
        String string;
        String string2;
        String string3 = httpServletRequest.getHeader("Destination");
        if (string3 == null) {
            httpServletResponse.sendError(400);
            return false;
        }
        int n = string3.indexOf("://");
        if (n >= 0) {
            int n2 = string3.indexOf("/", n + 4);
            string3 = n2 < 0 ? "/" : string3.substring(n2);
        } else {
            int n3;
            String string4 = httpServletRequest.getServerName();
            if (string4 != null && string3.startsWith(string4)) {
                string3 = string3.substring(string4.length());
            }
            if ((n3 = string3.indexOf(":")) >= 0) {
                string3 = string3.substring(n3);
            }
            if (string3.startsWith(":")) {
                int n4 = string3.indexOf("/");
                string3 = n4 < 0 ? "/" : string3.substring(n4);
            }
        }
        String string5 = httpServletRequest.getContextPath();
        if (string5 != null && string3.startsWith(string5)) {
            string3 = string3.substring(string5.length());
        }
        if ((string2 = httpServletRequest.getPathInfo()) != null && (string = httpServletRequest.getServletPath()) != null && string3.startsWith(string)) {
            string3 = string3.substring(string.length());
        }
        string3 = RequestUtil.URLDecode(this.normalize(string3), "UTF8");
        if (this.debug > 0) {
            System.out.println("Dest path :" + string3);
        }
        if (string3.toUpperCase().startsWith("/WEB-INF") || string3.toUpperCase().startsWith("/META-INF")) {
            httpServletResponse.sendError(403);
            return false;
        }
        String string6 = this.getRelativePath(httpServletRequest);
        if (string6.toUpperCase().startsWith("/WEB-INF") || string6.toUpperCase().startsWith("/META-INF")) {
            httpServletResponse.sendError(403);
            return false;
        }
        if (string3.equals(string6)) {
            httpServletResponse.sendError(403);
            return false;
        }
        boolean bl = true;
        String string7 = httpServletRequest.getHeader("Overwrite");
        if (string7 != null) {
            bl = string7.equalsIgnoreCase("T");
        }
        if ((dirContext = this.getResources()) == null) {
            httpServletResponse.sendError(500);
            return false;
        }
        boolean bl2 = true;
        try {
            dirContext.lookup(string3);
        }
        catch (NamingException namingException) {
            bl2 = false;
        }
        if (bl) {
            if (bl2) {
                if (!this.deleteResource(string3, httpServletRequest, httpServletResponse)) {
                    return false;
                }
                httpServletResponse.setStatus(204);
            } else {
                httpServletResponse.setStatus(201);
            }
        } else if (bl2) {
            httpServletResponse.sendError(412);
            return false;
        }
        Hashtable hashtable = new Hashtable();
        boolean bl3 = this.copyResource(dirContext, hashtable, string6, string3);
        if (!bl3 || !hashtable.isEmpty()) {
            this.sendReport(httpServletRequest, httpServletResponse, hashtable);
            return false;
        }
        this.lockNullResources.remove(string3);
        return true;
    }

    private boolean copyResource(DirContext dirContext, Hashtable hashtable, String string, String string2) {
        if (this.debug > 1) {
            System.out.println("Copy: " + string + " To: " + string2);
        }
        Object object = null;
        try {
            object = dirContext.lookup(string);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (object instanceof DirContext) {
            try {
                dirContext.createSubcontext(string2);
            }
            catch (NamingException namingException) {
                hashtable.put(string2, new Integer(409));
                return false;
            }
            try {
                NamingEnumeration<NameClassPair> namingEnumeration = dirContext.list(string);
                while (namingEnumeration.hasMoreElements()) {
                    NameClassPair nameClassPair = (NameClassPair)namingEnumeration.nextElement();
                    String string3 = string2;
                    if (!string3.equals("/")) {
                        string3 = string3 + "/";
                    }
                    string3 = string3 + nameClassPair.getName();
                    String string4 = string;
                    if (!string4.equals("/")) {
                        string4 = string4 + "/";
                    }
                    string4 = string4 + nameClassPair.getName();
                    this.copyResource(dirContext, hashtable, string4, string3);
                }
            }
            catch (NamingException namingException) {
                hashtable.put(string2, new Integer(500));
                return false;
            }
        }
        if (object instanceof Resource) {
            try {
                dirContext.bind(string2, object);
            }
            catch (NamingException namingException) {
                hashtable.put(string, new Integer(500));
                return false;
            }
        } else {
            hashtable.put(string, new Integer(500));
            return false;
        }
        return true;
    }

    private boolean deleteResource(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string = this.getRelativePath(httpServletRequest);
        return this.deleteResource(string, httpServletRequest, httpServletResponse);
    }

    private boolean deleteResource(String string, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        String string2;
        if (string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            httpServletResponse.sendError(403);
            return false;
        }
        String string3 = httpServletRequest.getHeader("If");
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = httpServletRequest.getHeader("Lock-Token")) == null) {
            string2 = "";
        }
        if (this.isLocked(string, string3 + string2)) {
            httpServletResponse.sendError(423);
            return false;
        }
        DirContext dirContext = this.getResources();
        if (dirContext == null) {
            httpServletResponse.sendError(500);
            return false;
        }
        boolean bl = true;
        Object object = null;
        try {
            object = dirContext.lookup(string);
        }
        catch (NamingException namingException) {
            bl = false;
        }
        if (!bl) {
            httpServletResponse.sendError(404);
            return false;
        }
        boolean bl2 = object instanceof DirContext;
        if (!bl2) {
            try {
                dirContext.unbind(string);
            }
            catch (NamingException namingException) {
                httpServletResponse.sendError(500);
                return false;
            }
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        this.deleteCollection(httpServletRequest, dirContext, string, hashtable);
        try {
            dirContext.unbind(string);
        }
        catch (NamingException namingException) {
            hashtable.put(string, new Integer(500));
        }
        if (!hashtable.isEmpty()) {
            this.sendReport(httpServletRequest, httpServletResponse, hashtable);
            return false;
        }
        httpServletResponse.setStatus(204);
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private void deleteCollection(HttpServletRequest var1_1, DirContext var2_2, String var3_3, Hashtable var4_4) {
        if (this.debug > 1) {
            System.out.println("Delete:" + var3_3);
        }
        if (var3_3.toUpperCase().startsWith("/WEB-INF") || var3_3.toUpperCase().startsWith("/META-INF")) {
            var4_4.put(var3_3, new Integer(403));
            return;
        }
        var5_5 = var1_1.getHeader("If");
        if (var5_5 == null) {
            var5_5 = "";
        }
        if ((var6_6 = var1_1.getHeader("Lock-Token")) == null) {
            var6_6 = "";
        }
        var7_7 = null;
        try {
            var7_7 = var2_2.list(var3_3);
            if (true) ** GOTO lbl44
        }
        catch (NamingException var8_8) {
            var4_4.put(var3_3, new Integer(500));
            return;
        }
        do {
            var8_9 = (NameClassPair)var7_7.nextElement();
            var9_10 = var3_3;
            if (!var9_10.equals("/")) {
                var9_10 = var9_10 + "/";
            }
            if (this.isLocked(var9_10 = var9_10 + var8_9.getName(), var5_5 + var6_6)) {
                var4_4.put(var9_10, new Integer(423));
                continue;
            }
            try {
                var10_11 = var2_2.lookup(var9_10);
                if (var10_11 instanceof DirContext) {
                    this.deleteCollection(var1_1, var2_2, var9_10, var4_4);
                }
                try {
                    var2_2.unbind(var9_10);
                }
                catch (NamingException var11_13) {
                    if (var10_11 instanceof DirContext) continue;
                    var4_4.put(var9_10, new Integer(500));
                }
            }
            catch (NamingException var10_12) {
                var4_4.put(var9_10, new Integer(500));
            }
lbl44:
            // 6 sources

        } while (var7_7.hasMoreElements());
    }

    private void sendReport(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Hashtable hashtable) throws ServletException, IOException {
        Object object;
        httpServletResponse.setStatus(207);
        String string = httpServletRequest.getRequestURI();
        String string2 = this.getRelativePath(httpServletRequest);
        XMLWriter xMLWriter = new XMLWriter();
        xMLWriter.writeXMLHeader();
        xMLWriter.writeElement(null, "multistatus" + this.generateNamespaceDeclarations(), 0);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            int n = (Integer)hashtable.get(object);
            xMLWriter.writeElement(null, "response", 0);
            xMLWriter.writeElement(null, "href", 0);
            String string3 = ((String)object).substring(string2.length());
            if (!string3.startsWith("/")) {
                string3 = "/" + string3;
            }
            xMLWriter.writeText(string + string3);
            xMLWriter.writeElement(null, "href", 1);
            xMLWriter.writeElement(null, "status", 0);
            xMLWriter.writeText("HTTP/1.1 " + n + " " + WebdavStatus.getStatusText(n));
            xMLWriter.writeElement(null, "status", 1);
            xMLWriter.writeElement(null, "response", 1);
        }
        xMLWriter.writeElement(null, "multistatus", 1);
        object = httpServletResponse.getWriter();
        ((Writer)object).write(xMLWriter.toString());
        ((Writer)object).close();
    }

    private void parseProperties(HttpServletRequest httpServletRequest, DirContext dirContext, XMLWriter xMLWriter, String string, int n, Vector vector) {
        if (string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            return;
        }
        DefaultServlet.ResourceInfo resourceInfo = new DefaultServlet.ResourceInfo(string, dirContext);
        xMLWriter.writeElement(null, "response", 0);
        String string2 = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText(200));
        xMLWriter.writeElement(null, "href", 0);
        String string3 = httpServletRequest.getContextPath();
        string3 = string3.endsWith("/") && string.startsWith("/") ? string3 + string.substring(1) : string3 + string;
        if (resourceInfo.collection && !string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        xMLWriter.writeText(this.rewriteUrl(string3));
        xMLWriter.writeElement(null, "href", 1);
        String string4 = string;
        int n2 = string.lastIndexOf(47);
        if (n2 != -1) {
            string4 = string4.substring(n2 + 1);
        }
        switch (n) {
            case 1: {
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                xMLWriter.writeProperty(null, "creationdate", this.getISOCreationDate(resourceInfo.creationDate));
                xMLWriter.writeElement(null, "displayname", 0);
                xMLWriter.writeData(string4);
                xMLWriter.writeElement(null, "displayname", 1);
                xMLWriter.writeProperty(null, "getcontentlanguage", Locale.getDefault().toString());
                if (!resourceInfo.collection) {
                    xMLWriter.writeProperty(null, "getlastmodified", resourceInfo.httpDate);
                    xMLWriter.writeProperty(null, "getcontentlength", String.valueOf(resourceInfo.length));
                    xMLWriter.writeProperty(null, "getcontenttype", this.getServletContext().getMimeType(resourceInfo.path));
                    xMLWriter.writeProperty(null, "getetag", this.getETagValue(resourceInfo, true));
                    xMLWriter.writeElement(null, "resourcetype", 2);
                } else {
                    xMLWriter.writeElement(null, "resourcetype", 0);
                    xMLWriter.writeElement(null, "collection", 2);
                    xMLWriter.writeElement(null, "resourcetype", 1);
                }
                xMLWriter.writeProperty(null, "source", "");
                String string5 = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                xMLWriter.writeElement(null, "supportedlock", 0);
                xMLWriter.writeText(string5);
                xMLWriter.writeElement(null, "supportedlock", 1);
                this.generateLockDiscovery(string, xMLWriter);
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
                break;
            }
            case 2: {
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                xMLWriter.writeElement(null, "creationdate", 2);
                xMLWriter.writeElement(null, "displayname", 2);
                if (!resourceInfo.collection) {
                    xMLWriter.writeElement(null, "getcontentlanguage", 2);
                    xMLWriter.writeElement(null, "getcontentlength", 2);
                    xMLWriter.writeElement(null, "getcontenttype", 2);
                    xMLWriter.writeElement(null, "getetag", 2);
                    xMLWriter.writeElement(null, "getlastmodified", 2);
                }
                xMLWriter.writeElement(null, "resourcetype", 2);
                xMLWriter.writeElement(null, "source", 2);
                xMLWriter.writeElement(null, "lockdiscovery", 2);
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
                break;
            }
            case 0: {
                Object object;
                Vector<Object> vector2 = new Vector<Object>();
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    if (((String)object).equals("creationdate")) {
                        xMLWriter.writeProperty(null, "creationdate", this.getISOCreationDate(resourceInfo.creationDate));
                        continue;
                    }
                    if (((String)object).equals("displayname")) {
                        xMLWriter.writeElement(null, "displayname", 0);
                        xMLWriter.writeData(string4);
                        xMLWriter.writeElement(null, "displayname", 1);
                        continue;
                    }
                    if (((String)object).equals("getcontentlanguage")) {
                        if (resourceInfo.collection) {
                            vector2.addElement(object);
                            continue;
                        }
                        xMLWriter.writeProperty(null, "getcontentlanguage", Locale.getDefault().toString());
                        continue;
                    }
                    if (((String)object).equals("getcontentlength")) {
                        if (resourceInfo.collection) {
                            vector2.addElement(object);
                            continue;
                        }
                        xMLWriter.writeProperty(null, "getcontentlength", String.valueOf(resourceInfo.length));
                        continue;
                    }
                    if (((String)object).equals("getcontenttype")) {
                        if (resourceInfo.collection) {
                            vector2.addElement(object);
                            continue;
                        }
                        xMLWriter.writeProperty(null, "getcontenttype", this.getServletContext().getMimeType(resourceInfo.path));
                        continue;
                    }
                    if (((String)object).equals("getetag")) {
                        if (resourceInfo.collection) {
                            vector2.addElement(object);
                            continue;
                        }
                        xMLWriter.writeProperty(null, "getetag", this.getETagValue(resourceInfo, true));
                        continue;
                    }
                    if (((String)object).equals("getlastmodified")) {
                        if (resourceInfo.collection) {
                            vector2.addElement(object);
                            continue;
                        }
                        xMLWriter.writeProperty(null, "getlastmodified", resourceInfo.httpDate);
                        continue;
                    }
                    if (((String)object).equals("resourcetype")) {
                        if (resourceInfo.collection) {
                            xMLWriter.writeElement(null, "resourcetype", 0);
                            xMLWriter.writeElement(null, "collection", 2);
                            xMLWriter.writeElement(null, "resourcetype", 1);
                            continue;
                        }
                        xMLWriter.writeElement(null, "resourcetype", 2);
                        continue;
                    }
                    if (((String)object).equals("source")) {
                        xMLWriter.writeProperty(null, "source", "");
                        continue;
                    }
                    if (((String)object).equals("supportedlock")) {
                        String string6 = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                        xMLWriter.writeElement(null, "supportedlock", 0);
                        xMLWriter.writeText(string6);
                        xMLWriter.writeElement(null, "supportedlock", 1);
                        continue;
                    }
                    if (((String)object).equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(string, xMLWriter)) continue;
                        vector2.addElement(object);
                        continue;
                    }
                    vector2.addElement(object);
                }
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
                object = vector2.elements();
                if (!object.hasMoreElements()) break;
                string2 = new String("HTTP/1.1 404 " + WebdavStatus.getStatusText(404));
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                while (object.hasMoreElements()) {
                    xMLWriter.writeElement(null, (String)object.nextElement(), 2);
                }
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
            }
        }
        xMLWriter.writeElement(null, "response", 1);
    }

    private void parseLockNullProperties(HttpServletRequest httpServletRequest, XMLWriter xMLWriter, String string, int n, Vector vector) {
        if (string.toUpperCase().startsWith("/WEB-INF") || string.toUpperCase().startsWith("/META-INF")) {
            return;
        }
        LockInfo lockInfo = (LockInfo)this.resourceLocks.get(string);
        if (lockInfo == null) {
            return;
        }
        xMLWriter.writeElement(null, "response", 0);
        String string2 = new String("HTTP/1.1 200 " + WebdavStatus.getStatusText(200));
        xMLWriter.writeElement(null, "href", 0);
        String string3 = httpServletRequest.getRequestURI();
        String string4 = this.getRelativePath(httpServletRequest);
        String string5 = string.substring(string4.length());
        if (!string5.startsWith("/")) {
            string5 = "/" + string5;
        }
        xMLWriter.writeText(this.rewriteUrl(this.normalize(string3 + string5)));
        xMLWriter.writeElement(null, "href", 1);
        String string6 = string;
        int n2 = string.lastIndexOf(47);
        if (n2 != -1) {
            string6 = string6.substring(n2 + 1);
        }
        switch (n) {
            case 1: {
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                xMLWriter.writeProperty(null, "creationdate", this.getISOCreationDate(lockInfo.creationDate.getTime()));
                xMLWriter.writeElement(null, "displayname", 0);
                xMLWriter.writeData(string6);
                xMLWriter.writeElement(null, "displayname", 1);
                xMLWriter.writeProperty(null, "getcontentlanguage", Locale.getDefault().toString());
                xMLWriter.writeProperty(null, "getlastmodified", DefaultServlet.formats[0].format(lockInfo.creationDate));
                xMLWriter.writeProperty(null, "getcontentlength", String.valueOf(0));
                xMLWriter.writeProperty(null, "getcontenttype", "");
                xMLWriter.writeProperty(null, "getetag", "");
                xMLWriter.writeElement(null, "resourcetype", 0);
                xMLWriter.writeElement(null, "lock-null", 2);
                xMLWriter.writeElement(null, "resourcetype", 1);
                xMLWriter.writeProperty(null, "source", "");
                String string7 = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                xMLWriter.writeElement(null, "supportedlock", 0);
                xMLWriter.writeText(string7);
                xMLWriter.writeElement(null, "supportedlock", 1);
                this.generateLockDiscovery(string, xMLWriter);
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
                break;
            }
            case 2: {
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                xMLWriter.writeElement(null, "creationdate", 2);
                xMLWriter.writeElement(null, "displayname", 2);
                xMLWriter.writeElement(null, "getcontentlanguage", 2);
                xMLWriter.writeElement(null, "getcontentlength", 2);
                xMLWriter.writeElement(null, "getcontenttype", 2);
                xMLWriter.writeElement(null, "getetag", 2);
                xMLWriter.writeElement(null, "getlastmodified", 2);
                xMLWriter.writeElement(null, "resourcetype", 2);
                xMLWriter.writeElement(null, "source", 2);
                xMLWriter.writeElement(null, "lockdiscovery", 2);
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
                break;
            }
            case 0: {
                Object object;
                Vector<Object> vector2 = new Vector<Object>();
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    if (((String)object).equals("creationdate")) {
                        xMLWriter.writeProperty(null, "creationdate", this.getISOCreationDate(lockInfo.creationDate.getTime()));
                        continue;
                    }
                    if (((String)object).equals("displayname")) {
                        xMLWriter.writeElement(null, "displayname", 0);
                        xMLWriter.writeData(string6);
                        xMLWriter.writeElement(null, "displayname", 1);
                        continue;
                    }
                    if (((String)object).equals("getcontentlanguage")) {
                        xMLWriter.writeProperty(null, "getcontentlanguage", Locale.getDefault().toString());
                        continue;
                    }
                    if (((String)object).equals("getcontentlength")) {
                        xMLWriter.writeProperty(null, "getcontentlength", String.valueOf(0));
                        continue;
                    }
                    if (((String)object).equals("getcontenttype")) {
                        xMLWriter.writeProperty(null, "getcontenttype", "");
                        continue;
                    }
                    if (((String)object).equals("getetag")) {
                        xMLWriter.writeProperty(null, "getetag", "");
                        continue;
                    }
                    if (((String)object).equals("getlastmodified")) {
                        xMLWriter.writeProperty(null, "getlastmodified", DefaultServlet.formats[0].format(lockInfo.creationDate));
                        continue;
                    }
                    if (((String)object).equals("resourcetype")) {
                        xMLWriter.writeElement(null, "resourcetype", 0);
                        xMLWriter.writeElement(null, "lock-null", 2);
                        xMLWriter.writeElement(null, "resourcetype", 1);
                        continue;
                    }
                    if (((String)object).equals("source")) {
                        xMLWriter.writeProperty(null, "source", "");
                        continue;
                    }
                    if (((String)object).equals("supportedlock")) {
                        String string8 = "<lockentry><lockscope><exclusive/></lockscope><locktype><write/></locktype></lockentry><lockentry><lockscope><shared/></lockscope><locktype><write/></locktype></lockentry>";
                        xMLWriter.writeElement(null, "supportedlock", 0);
                        xMLWriter.writeText(string8);
                        xMLWriter.writeElement(null, "supportedlock", 1);
                        continue;
                    }
                    if (((String)object).equals("lockdiscovery")) {
                        if (this.generateLockDiscovery(string, xMLWriter)) continue;
                        vector2.addElement(object);
                        continue;
                    }
                    vector2.addElement(object);
                }
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
                object = vector2.elements();
                if (!object.hasMoreElements()) break;
                string2 = new String("HTTP/1.1 404 " + WebdavStatus.getStatusText(404));
                xMLWriter.writeElement(null, "propstat", 0);
                xMLWriter.writeElement(null, "prop", 0);
                while (object.hasMoreElements()) {
                    xMLWriter.writeElement(null, (String)object.nextElement(), 2);
                }
                xMLWriter.writeElement(null, "prop", 1);
                xMLWriter.writeElement(null, "status", 0);
                xMLWriter.writeText(string2);
                xMLWriter.writeElement(null, "status", 1);
                xMLWriter.writeElement(null, "propstat", 1);
            }
        }
        xMLWriter.writeElement(null, "response", 1);
    }

    private boolean generateLockDiscovery(String string, XMLWriter xMLWriter) {
        LockInfo lockInfo = (LockInfo)this.resourceLocks.get(string);
        Enumeration enumeration = this.collectionLocks.elements();
        boolean bl = false;
        if (lockInfo != null) {
            bl = true;
            xMLWriter.writeElement(null, "lockdiscovery", 0);
            lockInfo.toXML(xMLWriter);
        }
        while (enumeration.hasMoreElements()) {
            LockInfo lockInfo2 = (LockInfo)enumeration.nextElement();
            if (!string.startsWith(lockInfo2.path)) continue;
            if (!bl) {
                bl = true;
                xMLWriter.writeElement(null, "lockdiscovery", 0);
            }
            lockInfo2.toXML(xMLWriter);
        }
        if (!bl) {
            return false;
        }
        xMLWriter.writeElement(null, "lockdiscovery", 1);
        return true;
    }

    private String getISOCreationDate(long l) {
        StringBuffer stringBuffer = new StringBuffer(creationDateFormat.format(new Date(l)));
        return stringBuffer.toString();
    }

    static {
        creationDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
    }

    private class Property {
        public String name;
        public String value;
        public String namespace;
        public String namespaceAbbrev;
        public int status = 200;

        private Property() {
        }
    }

    private class LockInfo {
        String path = "/";
        String type = "write";
        String scope = "exclusive";
        int depth = 0;
        String owner = "";
        Vector tokens = new Vector();
        long expiresAt = 0L;
        Date creationDate = new Date();

        public String toString() {
            String string = "Type:" + this.type + "\n";
            string = string + "Scope:" + this.scope + "\n";
            string = string + "Depth:" + this.depth + "\n";
            string = string + "Owner:" + this.owner + "\n";
            string = string + "Expiration:" + DefaultServlet.formats[0].format(new Date(this.expiresAt)) + "\n";
            Enumeration enumeration = this.tokens.elements();
            while (enumeration.hasMoreElements()) {
                string = string + "Token:" + enumeration.nextElement() + "\n";
            }
            return string;
        }

        public boolean hasExpired() {
            return System.currentTimeMillis() > this.expiresAt;
        }

        public boolean isExclusive() {
            return this.scope.equals("exclusive");
        }

        public void toXML(XMLWriter xMLWriter) {
            this.toXML(xMLWriter, false);
        }

        public void toXML(XMLWriter xMLWriter, boolean bl) {
            xMLWriter.writeElement(null, "activelock", 0);
            xMLWriter.writeElement(null, "locktype", 0);
            xMLWriter.writeElement(null, this.type, 2);
            xMLWriter.writeElement(null, "locktype", 1);
            xMLWriter.writeElement(null, "lockscope", 0);
            xMLWriter.writeElement(null, this.scope, 2);
            xMLWriter.writeElement(null, "lockscope", 1);
            xMLWriter.writeElement(null, "depth", 0);
            if (this.depth == 3) {
                xMLWriter.writeText("Infinity");
            } else {
                xMLWriter.writeText("0");
            }
            xMLWriter.writeElement(null, "depth", 1);
            xMLWriter.writeElement(null, "owner", 0);
            xMLWriter.writeText(this.owner);
            xMLWriter.writeElement(null, "owner", 1);
            xMLWriter.writeElement(null, "timeout", 0);
            long l = (this.expiresAt - System.currentTimeMillis()) / 1000L;
            xMLWriter.writeText("Second-" + l);
            xMLWriter.writeElement(null, "timeout", 1);
            xMLWriter.writeElement(null, "locktoken", 0);
            if (bl) {
                Enumeration enumeration = this.tokens.elements();
                while (enumeration.hasMoreElements()) {
                    xMLWriter.writeElement(null, "href", 0);
                    xMLWriter.writeText("opaquelocktoken:" + enumeration.nextElement());
                    xMLWriter.writeElement(null, "href", 1);
                }
            } else {
                xMLWriter.writeElement(null, "href", 0);
                xMLWriter.writeText("opaquelocktoken:dummytoken");
                xMLWriter.writeElement(null, "href", 1);
            }
            xMLWriter.writeElement(null, "locktoken", 1);
            xMLWriter.writeElement(null, "activelock", 1);
        }
    }
}

