/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import org.apache.catalina.Response;

public class ResponseFacade
implements ServletResponse {
    protected ServletResponse response = null;
    protected Response resp = null;

    public ResponseFacade(Response response) {
        this.resp = response;
        this.response = (ServletResponse)response;
    }

    public void finish() {
        this.resp.setSuspended(true);
    }

    public boolean isFinished() {
        return this.resp.isSuspended();
    }

    public String getCharacterEncoding() {
        return this.response.getCharacterEncoding();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        ServletOutputStream servletOutputStream = this.response.getOutputStream();
        if (this.isFinished()) {
            this.resp.setSuspended(true);
        }
        return servletOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        PrintWriter printWriter = this.response.getWriter();
        if (this.isFinished()) {
            this.resp.setSuspended(true);
        }
        return printWriter;
    }

    public void setContentLength(int n) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentLength(n);
    }

    public void setContentType(String string) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setContentType(string);
    }

    public void setBufferSize(int n) {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.setBufferSize(n);
    }

    public int getBufferSize() {
        return this.response.getBufferSize();
    }

    public void flushBuffer() throws IOException {
        if (this.isFinished()) {
            return;
        }
        this.resp.setAppCommitted(true);
        this.response.flushBuffer();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.resetBuffer();
    }

    public boolean isCommitted() {
        return this.resp.isAppCommitted();
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException();
        }
        this.response.reset();
    }

    public void setLocale(Locale locale) {
        if (this.isCommitted()) {
            return;
        }
        this.response.setLocale(locale);
    }

    public Locale getLocale() {
        return this.response.getLocale();
    }
}

