/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator;

import com.iplanet.ias.security.Audit;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Random;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.catalina.Authenticator;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.authenticator.SingleSignOn;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public abstract class AuthenticatorBase
extends ValveBase
implements Authenticator,
Lifecycle {
    protected static final String DEFAULT_ALGORITHM = "MD5";
    protected static final int SESSION_ID_BYTES = 16;
    protected String algorithm = "MD5";
    protected boolean cache = true;
    protected Context context = null;
    protected int debug = 0;
    protected MessageDigest digest = null;
    protected String entropy = null;
    protected static final String info = "org.apache.catalina.authenticator.AuthenticatorBase/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected Random random = null;
    protected String randomClass = "java.security.SecureRandom";
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.authenticator");
    protected SingleSignOn sso = null;
    protected boolean started = false;
    private static final String constantDateOne = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US).format(new Date(1L));

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String string) {
        this.algorithm = string;
    }

    public boolean getCache() {
        return this.cache;
    }

    public void setCache(boolean bl) {
        this.cache = bl;
    }

    public Container getContainer() {
        return this.context;
    }

    public void setContainer(Container container) {
        if (!(container instanceof Context)) {
            throw new IllegalArgumentException(sm.getString("authenticator.notContext"));
        }
        super.setContainer(container);
        this.context = (Context)container;
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int n) {
        this.debug = n;
    }

    public String getEntropy() {
        if (this.entropy == null) {
            this.setEntropy(this.toString());
        }
        return this.entropy;
    }

    public void setEntropy(String string) {
        this.entropy = string;
    }

    public String getInfo() {
        return info;
    }

    public String getRandomClass() {
        return this.randomClass;
    }

    public void setRandomClass(String string) {
        this.randomClass = string;
    }

    public int invoke(Request request, Response response) throws IOException, ServletException {
        Object object;
        Object object2;
        if (!(request instanceof HttpRequest) || !(response instanceof HttpResponse)) {
            return 1;
        }
        if (!(request.getRequest() instanceof HttpServletRequest) || !(response.getResponse() instanceof HttpServletResponse)) {
            return 1;
        }
        HttpRequest httpRequest = (HttpRequest)request;
        HttpResponse httpResponse = (HttpResponse)response;
        if (this.debug >= 1) {
            this.log("Security checking request " + ((HttpServletRequest)request.getRequest()).getMethod() + " " + ((HttpServletRequest)request.getRequest()).getRequestURI());
        }
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (this.cache && (object2 = ((HttpServletRequest)request.getRequest()).getUserPrincipal()) == null && (object = this.getSession(httpRequest)) != null && (object2 = object.getPrincipal()) != null) {
            if (this.debug >= 1) {
                this.log("We have cached auth type " + object.getAuthType() + " for principal " + object.getPrincipal());
            }
            httpRequest.setAuthType(object.getAuthType());
            httpRequest.setUserPrincipal((Principal)object2);
        }
        object2 = this.context.getPath();
        object = ((HttpServletRequest)request.getRequest()).getRequestURI();
        if (((String)object).startsWith((String)object2) && ((String)object).endsWith("/j_security_check") && !this.authenticate(httpRequest, httpResponse, loginConfig)) {
            if (this.debug >= 1) {
                this.log(" Failed authenticate() test");
            }
            return 2;
        }
        SecurityConstraint securityConstraint = this.findConstraint(httpRequest);
        if (securityConstraint == null) {
            if (this.debug >= 1) {
                this.log(" Not subject to any constraint");
            }
            return 1;
        }
        if (this.debug >= 1 && securityConstraint != null) {
            this.log(" Subject to constraint " + securityConstraint);
        }
        if (!((HttpServletRequest)httpRequest.getRequest()).isSecure()) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)response.getResponse();
            httpServletResponse.setHeader("Pragma", "No-cache");
            httpServletResponse.setHeader("Cache-Control", "no-cache");
            httpServletResponse.setHeader("Expires", constantDateOne);
        }
        if (this.debug >= 1) {
            this.log(" Calling checkUserData()");
        }
        if (!this.checkUserData(httpRequest, httpResponse, securityConstraint)) {
            if (this.debug >= 1) {
                this.log(" Failed checkUserData() test");
            }
            return 2;
        }
        if (securityConstraint.getAuthConstraint()) {
            if (this.debug >= 1) {
                this.log(" Calling authenticate()");
            }
            if (!this.authenticate(httpRequest, httpResponse, loginConfig)) {
                if (this.debug >= 1) {
                    this.log(" Failed authenticate() test");
                }
                return 2;
            }
        }
        if (securityConstraint.getAuthConstraint()) {
            if (this.debug >= 1) {
                this.log(" Calling accessControl()");
            }
            if (!this.accessControl(httpRequest, httpResponse, securityConstraint)) {
                if (Audit.isActive()) {
                    Audit.webInvocation(httpRequest, false);
                }
                if (this.debug >= 1) {
                    this.log(" Failed accessControl() test");
                }
                return 2;
            }
        }
        if (Audit.isActive()) {
            Audit.webInvocation(httpRequest, true);
        }
        if (this.debug >= 1) {
            this.log(" Successfully passed all security constraints");
        }
        return 1;
    }

    protected boolean accessControl(HttpRequest httpRequest, HttpResponse httpResponse, SecurityConstraint securityConstraint) throws IOException {
        Object object;
        Object object2;
        Object object3;
        if (securityConstraint == null) {
            return true;
        }
        LoginConfig loginConfig = this.context.getLoginConfig();
        if (loginConfig != null && "FORM".equals(loginConfig.getAuthMethod())) {
            object3 = ((HttpServletRequest)httpRequest.getRequest()).getRequestURI();
            object2 = this.context.getPath() + loginConfig.getLoginPage();
            if (((String)object2).equals(object3)) {
                if (this.debug >= 1) {
                    this.log(" Allow access to login page " + (String)object2);
                }
                return true;
            }
            object = this.context.getPath() + loginConfig.getErrorPage();
            if (((String)object).equals(object3)) {
                if (this.debug >= 1) {
                    this.log(" Allow access to error page " + (String)object);
                }
                return true;
            }
            if (((String)object3).endsWith("/j_security_check")) {
                if (this.debug >= 1) {
                    this.log(" Allow access to username/password submission");
                }
                return true;
            }
        }
        if ((object3 = ((HttpServletRequest)httpRequest.getRequest()).getUserPrincipal()) == null) {
            if (this.debug >= 2) {
                this.log("  No user authenticated, cannot grant access");
            }
            ((HttpServletResponse)httpResponse.getResponse()).sendError(500, sm.getString("authenticator.notAuthenticated"));
            return false;
        }
        object2 = this.context.getRealm();
        object = securityConstraint.findAuthRoles();
        if (object == null) {
            object = new String[]{};
        }
        if (securityConstraint.getAllRoles()) {
            return true;
        }
        if (((String[])object).length == 0 && securityConstraint.getAuthConstraint()) {
            ((HttpServletResponse)httpResponse.getResponse()).sendError(403, sm.getString("authenticator.forbidden"));
            return false;
        }
        int n = 0;
        while (n < ((String[])object).length) {
            if (object2.hasRole((Principal)object3, object[n])) {
                return true;
            }
            ++n;
        }
        ((HttpServletResponse)httpResponse.getResponse()).sendError(403, sm.getString("authenticator.forbidden"));
        return false;
    }

    protected void associate(String string, Session session) {
        if (this.sso == null) {
            return;
        }
        this.sso.associate(string, session);
    }

    protected abstract boolean authenticate(HttpRequest var1, HttpResponse var2, LoginConfig var3) throws IOException;

    protected boolean checkUserData(HttpRequest httpRequest, HttpResponse httpResponse, SecurityConstraint securityConstraint) throws IOException {
        String string;
        if (securityConstraint == null) {
            if (this.debug >= 2) {
                this.log("  No applicable security constraint defined");
            }
            return true;
        }
        String string2 = securityConstraint.getUserConstraint();
        if (string2 == null) {
            if (this.debug >= 2) {
                this.log("  No applicable user data constraint defined");
            }
            return true;
        }
        if (string2.equals("NONE")) {
            if (this.debug >= 2) {
                this.log("  User data constraint has no restrictions");
            }
            return true;
        }
        if (httpRequest.getRequest().isSecure()) {
            if (this.debug >= 2) {
                this.log("  User data constraint already satisfied");
            }
            return true;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpRequest.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)httpResponse.getResponse();
        int n = httpRequest.getConnector().getRedirectPort();
        if (n <= 0) {
            if (this.debug >= 2) {
                this.log("  SSL redirect is disabled");
            }
            httpServletResponse.sendError(403, httpServletRequest.getRequestURI());
            return false;
        }
        String string3 = "https";
        String string4 = httpServletRequest.getServerName();
        StringBuffer stringBuffer = new StringBuffer(httpServletRequest.getRequestURI());
        String string5 = httpServletRequest.getRequestedSessionId();
        if (string5 != null && httpServletRequest.isRequestedSessionIdFromURL()) {
            stringBuffer.append(";jsessionid=");
            stringBuffer.append(string5);
        }
        if ((string = httpServletRequest.getQueryString()) != null) {
            stringBuffer.append('?');
            stringBuffer.append(string);
        }
        URL uRL = null;
        try {
            uRL = new URL(string3, string4, n, stringBuffer.toString());
            if (this.debug >= 2) {
                this.log("  Redirecting to " + uRL.toString());
            }
            httpServletResponse.sendRedirect(uRL.toString());
            return false;
        }
        catch (MalformedURLException malformedURLException) {
            if (this.debug >= 2) {
                this.log("  Cannot create new URL", malformedURLException);
            }
            httpServletResponse.sendError(500, httpServletRequest.getRequestURI());
            return false;
        }
    }

    protected SecurityConstraint findConstraint(HttpRequest httpRequest) {
        SecurityConstraint[] securityConstraintArray = this.context.findConstraints();
        if (securityConstraintArray == null || securityConstraintArray.length == 0) {
            if (this.debug >= 2) {
                this.log("  No applicable constraints defined");
            }
            return null;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpRequest.getRequest();
        String string = httpServletRequest.getRequestURI();
        String string2 = httpServletRequest.getContextPath();
        if (string2.length() > 0) {
            string = string.substring(string2.length());
        }
        String string3 = httpServletRequest.getMethod();
        int n = 0;
        while (n < securityConstraintArray.length) {
            if (this.debug >= 2) {
                this.log("  Checking constraint '" + securityConstraintArray[n] + "' against " + string3 + " " + string + " --> " + securityConstraintArray[n].included(string, string3));
            }
            if (securityConstraintArray[n].included(string, string3)) {
                return securityConstraintArray[n];
            }
            ++n;
        }
        if (this.debug >= 2) {
            this.log("  No applicable constraint located");
        }
        return null;
    }

    protected synchronized String generateSessionId() {
        Random random = this.getRandom();
        byte[] byArray = new byte[16];
        this.getRandom().nextBytes(byArray);
        byArray = this.getDigest().digest(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < byArray.length) {
            byte by = (byte)((byArray[n] & 0xF0) >> 4);
            byte by2 = (byte)(byArray[n] & 0xF);
            if (by < 10) {
                stringBuffer.append((char)(48 + by));
            } else {
                stringBuffer.append((char)(65 + (by - 10)));
            }
            if (by2 < 10) {
                stringBuffer.append((char)(48 + by2));
            } else {
                stringBuffer.append((char)(65 + (by2 - 10)));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    protected synchronized MessageDigest getDigest() {
        block4: {
            if (this.digest != null) break block4;
            try {
                this.digest = MessageDigest.getInstance(this.algorithm);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                try {
                    this.digest = MessageDigest.getInstance(DEFAULT_ALGORITHM);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException2) {
                    this.digest = null;
                }
            }
        }
        return this.digest;
    }

    protected synchronized Random getRandom() {
        block3: {
            if (this.random != null) break block3;
            try {
                Class<?> clazz = Class.forName(this.randomClass);
                this.random = (Random)clazz.newInstance();
                long l = System.currentTimeMillis();
                char[] cArray = this.getEntropy().toCharArray();
                int n = 0;
                while (n < cArray.length) {
                    long l2 = (byte)cArray[n] << n % 8 * 8;
                    l ^= l2;
                    ++n;
                }
                this.random.setSeed(l);
            }
            catch (Exception exception) {
                this.random = new Random();
            }
        }
        return this.random;
    }

    protected Session getSession(HttpRequest httpRequest) {
        return this.getSession(httpRequest, false);
    }

    protected Session getSession(HttpRequest httpRequest, boolean bl) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)httpRequest.getRequest();
        HttpSession httpSession = httpServletRequest.getSession(bl);
        if (httpSession == null) {
            return null;
        }
        Manager manager = this.context.getManager();
        if (manager == null) {
            return null;
        }
        try {
            return manager.findSession(httpSession.getId());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected void log(String string) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("Authenticator[" + this.context.getPath() + "]: " + string);
        } else {
            System.out.println("Authenticator[" + this.context.getPath() + "]: " + string);
        }
    }

    protected void log(String string, Throwable throwable) {
        Logger logger = this.context.getLogger();
        if (logger != null) {
            logger.log("Authenticator[" + this.context.getPath() + "]: " + string, throwable);
        } else {
            System.out.println("Authenticator[" + this.context.getPath() + "]: " + string);
            throwable.printStackTrace(System.out);
        }
    }

    protected void register(HttpRequest httpRequest, HttpResponse httpResponse, Principal principal, String string, String string2, String string3) {
        Session session;
        if (this.debug >= 1) {
            this.log("Authenticated '" + principal.getName() + "' with type '" + string + "'");
        }
        httpRequest.setAuthType(string);
        httpRequest.setUserPrincipal(principal);
        if (this.cache && (session = this.getSession(httpRequest, false)) != null) {
            session.setAuthType(string);
            session.setPrincipal(principal);
            if (string2 != null) {
                session.setNote("org.apache.catalina.session.USERNAME", string2);
            } else {
                session.removeNote("org.apache.catalina.session.USERNAME");
            }
            if (string3 != null) {
                session.setNote("org.apache.catalina.session.PASSWORD", string3);
            } else {
                session.removeNote("org.apache.catalina.session.PASSWORD");
            }
        }
        if (this.sso == null) {
            return;
        }
        session = (HttpServletRequest)httpRequest.getRequest();
        HttpServletResponse httpServletResponse = (HttpServletResponse)httpResponse.getResponse();
        String string4 = this.generateSessionId();
        Cookie cookie = new Cookie("JSESSIONIDSSO", string4);
        cookie.setMaxAge(-1);
        cookie.setPath("/");
        httpServletResponse.addCookie(cookie);
        this.sso.register(string4, principal, string, string2, string3);
        httpRequest.setNote("org.apache.catalina.request.SSOID", string4);
    }

    public void addLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.addLifecycleListener(lifecycleListener);
    }

    public void removeLifecycleListener(LifecycleListener lifecycleListener) {
        this.lifecycle.removeLifecycleListener(lifecycleListener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(sm.getString("authenticator.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        if (this.context instanceof StandardContext) {
            this.setDebug(((StandardContext)this.context).getDebug());
        }
        this.started = true;
        Container container = this.context.getParent();
        while (this.sso == null && container != null) {
            if (!(container instanceof Pipeline)) {
                container = container.getParent();
                continue;
            }
            Valve[] valveArray = ((Pipeline)((Object)container)).getValves();
            int n = 0;
            while (n < valveArray.length) {
                if (valveArray[n] instanceof SingleSignOn) {
                    this.sso = (SingleSignOn)valveArray[n];
                    break;
                }
                ++n;
            }
            if (this.sso != null) continue;
            container = container.getParent();
        }
        if (this.debug >= 1) {
            if (this.sso != null) {
                this.log("Found SingleSignOn Valve at " + this.sso);
            } else {
                this.log("No SingleSignOn Valve is present");
            }
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(sm.getString("authenticator.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.sso = null;
    }
}

