/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.CoordinatorImpl;
import com.sun.jts.CosTransactions.CoordinatorLog;
import com.sun.jts.CosTransactions.EventSemaphore;
import com.sun.jts.CosTransactions.GlobalTID;
import com.sun.jts.CosTransactions.Log;
import com.sun.jts.CosTransactions.LogFile;
import com.sun.jts.CosTransactions.LogicErrorException;
import com.sun.jts.CosTransactions.ResyncThread;
import com.sun.jts.CosTransactions.TimeoutManager;
import com.sun.jts.CosTransactions.TopCoordinator;
import com.sun.jts.jtsxa.OTSResource;
import com.sun.jts.jtsxa.OTSResourceImpl;
import com.sun.jts.utils.LogFormatter;
import com.sun.logging.LogDomains;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;

public class RecoveryManager {
    private static Enumeration xaResourceList = null;
    private static boolean initialised = false;
    private static int resyncCoords = 0;
    private static ResyncThread resyncThread = null;
    private static EventSemaphore resyncInProgress = new EventSemaphore();
    private static EventSemaphore recoveryInProgress = new EventSemaphore();
    private static EventSemaphore xaResourceListReady = new EventSemaphore();
    private static Hashtable coordsByGlobalTID = new Hashtable();
    private static Hashtable coordsByLocalTID = new Hashtable();
    private static Object lockObject = new Object();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.core.transaction");

    static void initialise() {
        if (initialised) {
            return;
        }
        initialised = true;
        if (Configuration.isRecoverable()) {
            resyncThread = new ResyncThread();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.logp(Level.FINE, "RecoveryManager", "initialise()", "Before starting ResyncThread ");
            }
            resyncThread.start();
        } else {
            String string = Configuration.getServerName();
            if (string != null && Log.checkFileExists(string)) {
                _logger.log(Level.INFO, "jts.log_file_transient_server", string);
            }
            try {
                recoveryInProgress.post();
                RecoveryManager.resyncComplete(false, false);
            }
            catch (Throwable throwable) {}
        }
    }

    static boolean addCoordinator(GlobalTID globalTID, Long l, CoordinatorImpl coordinatorImpl, int n) {
        boolean bl = true;
        coordsByGlobalTID.put(globalTID, coordinatorImpl);
        coordsByLocalTID.put(l, coordinatorImpl);
        if (n != 0) {
            TimeoutManager.setTimeout(l, 1, n);
        }
        return bl;
    }

    static boolean removeCoordinator(GlobalTID globalTID, Long l, boolean bl) {
        boolean bl2;
        block7: {
            bl2 = false;
            CoordinatorImpl coordinatorImpl = null;
            boolean bl3 = bl2 = coordsByGlobalTID.remove(globalTID) != null;
            if (bl2) {
                coordinatorImpl = (CoordinatorImpl)coordsByLocalTID.remove(l);
                boolean bl4 = bl2 = coordinatorImpl != null;
            }
            if (coordinatorImpl != null) {
                try {
                    if (coordinatorImpl.is_top_level_transaction()) {
                        CoordinatorLog.removeLog(l);
                    }
                }
                catch (SystemException systemException) {
                    bl2 = false;
                }
            }
            TimeoutManager.setTimeout(l, 0, 0);
            if (resyncCoords <= 0 || --resyncCoords != 0) break block7;
            try {
                RecoveryManager.resyncComplete(true, true);
            }
            catch (Throwable throwable) {}
        }
        return bl2;
    }

    static CoordinatorImpl getCoordinator(GlobalTID globalTID) {
        CoordinatorImpl coordinatorImpl = (CoordinatorImpl)coordsByGlobalTID.get(globalTID);
        return coordinatorImpl;
    }

    static boolean recover() {
        boolean bl;
        block6: {
            bl = false;
            boolean bl2 = false;
            Enumeration enumeration = CoordinatorLog.getLogged();
            while (enumeration.hasMoreElements()) {
                bl2 = true;
                try {
                    new TopCoordinator().reconstruct((CoordinatorLog)enumeration.nextElement());
                }
                catch (Exception exception) {
                    _logger.log(Level.SEVERE, "jts.recovery_in_doubt_exception", exception);
                    _logger.log(Level.SEVERE, "jts.recovery_in_doubt", exception.toString());
                    String string = LogFormatter.getLocalizedMessage(_logger, "jts.recovery_in_doubt", new Object[]{exception.toString()});
                    throw new INTERNAL(string);
                }
            }
            if (_logger.isLoggable(Level.FINE)) {
                _logger.logp(Level.FINE, "RecoveryManager", "recover()", "Before invoking proceedWithXARecovery()");
            }
            RecoveryManager.proceedWithXARecovery();
            recoveryInProgress.post();
            boolean bl3 = bl = coordsByGlobalTID.size() > 0;
            if (bl) break block6;
            try {
                RecoveryManager.resyncComplete(false, bl2);
            }
            catch (Throwable throwable) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resync() {
        resyncCoords = coordsByGlobalTID.size();
        Enumeration enumeration = ((Hashtable)coordsByGlobalTID.clone()).elements();
        boolean[] blArray = new boolean[1];
        while (enumeration.hasMoreElements()) {
            TopCoordinator topCoordinator = (TopCoordinator)enumeration.nextElement();
            try {
                TopCoordinator topCoordinator2 = topCoordinator;
                synchronized (topCoordinator2) {
                    Status status = topCoordinator.recover(blArray);
                    if (status == Status.StatusUnknown) {
                        TimeoutManager.setTimeout(new Long(topCoordinator.getLocalTID()), 2, 60);
                    } else if (status == Status.StatusCommitted) {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.logp(Level.FINE, "RecoveryManager", "resync()", "Before invoking commit on the reconstructed coordinatorGTID is: " + topCoordinator.superInfo.globalTID.toString());
                        }
                        try {
                            topCoordinator.commit();
                        }
                        catch (Throwable throwable) {
                            _logger.log(Level.WARNING, "jts.exception_during_resync", new Object[]{throwable.toString(), "commit"});
                        }
                        if (blArray[0]) {
                            try {
                                topCoordinator.afterCompletion(status);
                            }
                            catch (Throwable throwable) {
                                _logger.log(Level.WARNING, "jts.exception_during_resync", new Object[]{throwable.toString(), "after_completion"});
                            }
                        }
                    } else {
                        try {
                            if (_logger.isLoggable(Level.FINE)) {
                                _logger.logp(Level.FINE, "RecoveryManager", "resync()", "Before invoking rollback on thereconstructed coordinator :GTID is : " + topCoordinator.superInfo.globalTID.toString());
                            }
                            topCoordinator.rollback(true);
                        }
                        catch (Throwable throwable) {
                            _logger.log(Level.WARNING, "jts.resync_failed", new Object[]{throwable.toString(), "rollback"});
                        }
                        if (blArray[0]) {
                            try {
                                topCoordinator.afterCompletion(Status.StatusRolledBack);
                            }
                            catch (Throwable throwable) {
                                _logger.log(Level.WARNING, "jts.resync_failed", new Object[]{throwable.toString(), "after_completion"});
                            }
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void resyncComplete(boolean bl, boolean bl2) throws LogicErrorException {
        if (bl2) {
            CoordinatorLog.keypoint();
        }
        resyncInProgress.post();
        resyncInProgress = null;
    }

    static CoordinatorImpl getLocalCoordinator(Long l) {
        CoordinatorImpl coordinatorImpl = (CoordinatorImpl)coordsByLocalTID.get(l);
        return coordinatorImpl;
    }

    static boolean validLocalTID(Long l) {
        boolean bl = coordsByLocalTID.containsKey(l);
        return bl;
    }

    static void shutdown(boolean bl) {
        if (bl) {
            if (resyncThread != null) {
                resyncThread.stop();
            }
        } else if (resyncInProgress != null) {
            try {
                resyncInProgress.waitEvent();
                if (resyncThread != null) {
                    resyncThread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!bl && Configuration.isRecoverable()) {
            CoordinatorLog.keypoint();
            CoordinatorLog.finalizeAll();
        }
    }

    private static boolean checkIfUniqueXid(Map map, Xid xid) {
        int n = xid.getGlobalTransactionId().length;
        int n2 = xid.getBranchQualifier().length;
        byte[] byArray = new byte[n + 1 + n2];
        System.arraycopy(xid.getGlobalTransactionId(), 0, byArray, 0, n);
        byArray[n] = 44;
        System.arraycopy(xid.getBranchQualifier(), 0, byArray, n + 1, n2);
        String string = new String(byArray);
        if (map.get(string) == null) {
            map.put(string, string);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void recoverXAResources(Enumeration enumeration) {
        String string = Configuration.getPropertyValue("com.sun.jts.ManualRecovery");
        if (string == null || !string.equalsIgnoreCase("true")) {
            return;
        }
        Object object = lockObject;
        synchronized (object) {
            if (!xaResourceListReady.isPosted()) {
                xaResourceList = enumeration;
                xaResourceListReady.post();
                RecoveryManager.waitForResync();
                return;
            }
            RecoveryManager.waitForResync();
            xaResourceList = enumeration;
            RecoveryManager.proceedWithXARecovery();
        }
    }

    private static void proceedWithXARecovery() {
        Object object;
        Xid[] xidArray;
        Enumeration enumeration = xaResourceList;
        String string = Configuration.getPropertyValue("com.sun.jts.ManualRecovery");
        if (string == null || !string.equalsIgnoreCase("true")) {
            return;
        }
        if (Thread.currentThread().getName().equals("JTS Resync Thread") && xaResourceListReady != null) {
            try {
                xaResourceListReady.waitEvent();
                enumeration = xaResourceList;
            }
            catch (InterruptedException interruptedException) {
                _logger.log(Level.SEVERE, "jts.wait_for_resync_complete_interrupted");
                String string2 = LogFormatter.getLocalizedMessage(_logger, "jts.wait_for_resync_complete_interrupted");
                throw new INTERNAL(string2);
            }
        }
        if (enumeration == null) {
            return;
        }
        Vector<OTSResource> vector = new Vector<OTSResource>();
        Hashtable hashtable = new Hashtable();
        block6: while (enumeration.hasMoreElements()) {
            XAResource xAResource = (XAResource)enumeration.nextElement();
            xidArray = null;
            int n = 0x1000000;
            block7: while (true) {
                block19: {
                    try {
                        if (_logger.isLoggable(Level.FINE)) {
                            _logger.logp(Level.FINE, "RecoveryManager", "proceedWithXARecovery()", "Before receiving inDoubtXids from xaresource = " + xAResource);
                        }
                        xidArray = xAResource.recover(n);
                        if (!_logger.isLoggable(Level.FINE) || xidArray == null) break block19;
                        object = LogFormatter.convertXidArrayToString(xidArray);
                        _logger.logp(Level.FINE, "RecoveryManager", "proceedWithXARecovery()", "InDoubtXids returned from xaresource = " + xAResource + "are: " + (String)object);
                    }
                    catch (XAException xAException) {
                        _logger.log(Level.WARNING, "jts.xaexception_in_recovery", xAException);
                        continue block6;
                    }
                }
                n = 0;
                if (xidArray == null || xidArray.length == 0) continue block6;
                int n2 = 0;
                while (true) {
                    String string3;
                    if (n2 >= xidArray.length) continue block7;
                    String string4 = new String(xidArray[n2].getBranchQualifier());
                    if (string4.startsWith(string3 = Configuration.getServerName()) && RecoveryManager.checkIfUniqueXid(hashtable, xidArray[n2])) {
                        vector.addElement(new OTSResourceImpl(xidArray[n2], xAResource, null).getCORBAObjReference());
                    }
                    ++n2;
                }
                break;
            }
        }
        int n = 0;
        while (n < vector.size()) {
            xidArray = (Xid[])vector.elementAt(n);
            GlobalTID globalTID = new GlobalTID(xidArray.getGlobalTID());
            object = (TopCoordinator)coordsByGlobalTID.get(globalTID);
            if (object == null) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.logp(Level.FINE, "RecoveryManager", "proceedWithXARecovery()", "Could  not recognize OTSResource: " + xidArray + " with tid: " + LogFormatter.convertToString(globalTID.realTID.tid) + ";Hence rolling this resource back...");
                }
                try {
                    xidArray.rollback();
                }
                catch (Throwable throwable) {
                    _logger.log(Level.WARNING, "jts.exception_during_resync", new Object[]{throwable.toString(), "OTSResource rollback"});
                }
            } else {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.logp(Level.FINE, "RecoveryManager", "proceedWithXARecovery()", "Recognized OTSResource: " + xidArray + " with tid: " + LogFormatter.convertToString(globalTID.realTID.tid) + ";Hence registering this resource with coordinator...");
                }
                ((TopCoordinator)object).directRegisterResource((Resource)xidArray);
            }
            ++n;
        }
    }

    static CoordinatorImpl[] getCoordinators() {
        int n = coordsByGlobalTID.size();
        CoordinatorImpl[] coordinatorImplArray = new CoordinatorImpl[n];
        Enumeration enumeration = coordsByGlobalTID.elements();
        int n2 = 0;
        while (n2 < n) {
            coordinatorImplArray[n2++] = (CoordinatorImpl)enumeration.nextElement();
        }
        return coordinatorImplArray;
    }

    static Hashtable getCoordsByGlobalTID() {
        return coordsByGlobalTID;
    }

    public static byte[] getRestart() {
        byte[] byArray = null;
        LogFile logFile = Configuration.getLogFile();
        if (logFile != null) {
            byArray = logFile.readRestart();
        }
        return byArray;
    }

    public static void setRestart(byte[] byArray) {
        LogFile logFile = Configuration.getLogFile();
        if (logFile != null && !logFile.writeRestart(byArray)) {
            _logger.log(Level.WARNING, "jts.restart_write_failed");
        }
    }

    public static void waitForRecovery() {
        if (recoveryInProgress != null) {
            try {
                recoveryInProgress.waitEvent();
            }
            catch (InterruptedException interruptedException) {
                _logger.log(Level.SEVERE, "jts.wait_for_resync_complete_interrupted");
                String string = LogFormatter.getLocalizedMessage(_logger, "jts.wait_for_resync_complete_interrupted");
                throw new INTERNAL(string);
            }
        }
    }

    public static void waitForResync() {
        if (resyncInProgress != null) {
            try {
                resyncInProgress.waitEvent();
            }
            catch (InterruptedException interruptedException) {
                _logger.log(Level.SEVERE, "jts.wait_for_resync_complete_interrupted");
                String string = LogFormatter.getLocalizedMessage(_logger, "jts.wait_for_resync_complete_interrupted");
                throw new INTERNAL(string);
            }
        }
    }
}

