/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.LogException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.RandomAccessFile;

class LogFileHandle {
    static final int OPEN_RDONLY = 1;
    static final int OPEN_RDWR = 2;
    static final int OPEN_CREAT = 4;
    static final int OPEN_SYNC = 8;
    static final int SEEK_RELATIVE = 0;
    static final int SEEK_ABSOLUTE = 1;
    static final String MODE_READONLY = "r";
    static final String MODE_READWRITEOLD = "rw";
    static final String MODE_READWRITENEW = "rw";
    static final int LOG_FNAME_MAX = 252;
    static final int FILESYSTEM_BLOCKSIZE = 4096;
    private RandomAccessFile fhandle;
    private FileDescriptor fd;
    private byte[] bufferData;
    boolean buffered;
    int bufferUpdateStart;
    int bufferUpdateEnd;
    int buffPos;

    LogFileHandle() {
        this.fhandle = null;
        this.fd = null;
        this.bufferData = null;
        this.buffered = false;
        this.bufferUpdateStart = -1;
        this.bufferUpdateEnd = -1;
        this.buffPos = 0;
        this.fhandle = null;
        this.fd = null;
    }

    LogFileHandle(File file, int n) throws LogException {
        block5: {
            this.fhandle = null;
            this.fd = null;
            this.bufferData = null;
            this.buffered = false;
            this.bufferUpdateStart = -1;
            this.bufferUpdateEnd = -1;
            this.buffPos = 0;
            if ((n & 8) == 0) {
                this.buffered = true;
            }
            if ((n & 1) != 0) {
                this.fileOpen(file, MODE_READONLY);
            } else {
                try {
                    this.fileOpen(file, "rw");
                }
                catch (LogException logException) {
                    if ((n & 4) == 0) break block5;
                    this.fileOpen(file, "rw");
                }
            }
        }
    }

    public void finalize() throws LogException {
        if (this.fhandle != null) {
            this.fileClose();
        }
        this.bufferData = null;
    }

    int fileRead(byte[] byArray) throws LogException {
        int n = 0;
        if (byArray.length > 0) {
            try {
                if (this.buffered) {
                    if (this.buffPos >= this.bufferData.length) {
                        n = -1;
                    } else {
                        n = this.buffPos + byArray.length >= this.bufferData.length ? this.bufferData.length - this.buffPos : byArray.length;
                        System.arraycopy(this.bufferData, this.buffPos, byArray, 0, n);
                        this.buffPos += n;
                    }
                } else {
                    n = this.fhandle.read(byArray);
                    if (n == -1) {
                        n = 0;
                    }
                }
            }
            catch (Throwable throwable) {
                throw new LogException(null, 3, 1);
            }
        }
        return n;
    }

    int fileWrite(byte[] byArray) throws LogException {
        if (byArray.length > 0) {
            try {
                if (this.buffered) {
                    if (this.buffPos + byArray.length >= this.bufferData.length) {
                        byte[] byArray2 = new byte[this.buffPos + byArray.length];
                        if (this.bufferData.length > 0) {
                            System.arraycopy(this.bufferData, 0, byArray2, 0, this.bufferData.length);
                        }
                        this.bufferData = byArray2;
                    }
                    System.arraycopy(byArray, 0, this.bufferData, this.buffPos, byArray.length);
                    if (this.bufferUpdateStart == -1 || this.buffPos < this.bufferUpdateStart) {
                        this.bufferUpdateStart = this.buffPos;
                    }
                    this.buffPos += byArray.length;
                    if (this.buffPos > this.bufferUpdateEnd) {
                        this.bufferUpdateEnd = this.buffPos;
                    }
                } else {
                    this.fhandle.write(byArray);
                    this.fd.sync();
                }
            }
            catch (Throwable throwable) {
                int n = 7;
                throw new LogException(null, n, 1);
            }
        }
        return byArray.length;
    }

    void fileOpen(File file, String string) throws LogException {
        this.fhandle = null;
        try {
            this.fhandle = new RandomAccessFile(file, string);
            this.fd = this.fhandle.getFD();
            if (this.buffered) {
                if (this.fhandle.length() > 0L) {
                    this.bufferData = new byte[(int)this.fhandle.length()];
                    this.fhandle.readFully(this.bufferData);
                } else {
                    this.bufferData = new byte[0];
                }
            }
        }
        catch (Throwable throwable) {
            throw new LogException(null, 2, 1);
        }
    }

    void fileClose() throws LogException {
        try {
            if (this.bufferUpdateStart != -1) {
                this.fileSync();
            }
            this.fhandle.close();
        }
        catch (Throwable throwable) {
            throw new LogException(null, 8, 1);
        }
        this.fhandle = null;
        this.fd = null;
    }

    void fileSeek(long l, int n) throws LogException {
        long l2 = l;
        try {
            if (this.buffered) {
                if (n == 0) {
                    l2 = (long)this.buffPos + l;
                }
                this.buffPos = (int)l2;
            } else {
                if (n == 0) {
                    l2 = this.fhandle.getFilePointer() + l;
                }
                this.fhandle.seek(l2);
            }
        }
        catch (Throwable throwable) {
            throw new LogException(null, 3, 1);
        }
    }

    void fileSync() throws LogException {
        if (this.bufferUpdateStart != -1) {
            try {
                this.fhandle.seek(this.bufferUpdateStart);
                this.fhandle.write(this.bufferData, this.bufferUpdateStart, this.bufferUpdateEnd - this.bufferUpdateStart);
                this.fd.sync();
                this.bufferUpdateStart = -1;
                this.bufferUpdateEnd = -1;
            }
            catch (Throwable throwable) {
                throw new LogException(null, 3, 1);
            }
        }
    }

    int readVector(byte[][] byArray) throws LogException {
        int n = 0;
        int n2 = 0;
        while (n2 < byArray.length) {
            n += this.fileRead(byArray[n2]);
            ++n2;
        }
        return n;
    }

    void allocFileStorage(int n) throws LogException {
        byte[] byArray = new byte[1];
        byte[] byArray2 = new byte[1];
        if (n == 0) {
            return;
        }
        this.fileSeek(n - 1, 0);
        this.fileWrite(byArray2);
        this.fileSeek(-n, 0);
        if (this.buffered) {
            this.fileSync();
        }
    }
}

