/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import com.iplanet.ias.admin.monitor.GenericMonitorMBean;
import com.iplanet.ias.admin.monitor.MonitoredObjectType;
import com.iplanet.ias.admin.monitor.MonitoringHelper;
import com.iplanet.ias.config.ConfigContext;
import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.IiopListener;
import com.iplanet.ias.config.serverbeans.IiopService;
import com.iplanet.ias.config.serverbeans.Orb;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.ServerBeansFactory;
import com.iplanet.ias.config.serverbeans.Ssl;
import com.iplanet.ias.config.serverbeans.SslClientConfig;
import com.iplanet.ias.server.ApplicationServer;
import com.iplanet.ias.server.ServerContext;
import com.sun.corba.ee.internal.iiop.ORB;
import com.sun.enterprise.Switch;
import com.sun.enterprise.util.FileUtil;
import com.sun.logging.LogDomains;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;

public class ORBManager {
    static Logger _logger;
    private static final boolean debug = false;
    private static final String poaOrbClass = "com.sun.enterprise.iiop.POAEJBORB";
    private static final String poaOrbSingletonClass = "com.sun.corba.ee.internal.corba.ORBSingleton";
    public static final String OMG_ORB_CLASS_PROPERTY = "org.omg.CORBA.ORBClass";
    public static final String OMG_ORB_SINGLETON_CLASS_PROPERTY = "org.omg.CORBA.ORBSingletonClass";
    public static final String ORB_UTIL_CLASS_PROPERTY = "javax.rmi.CORBA.UtilClass";
    public static final String JNDI_PROVIDER_URL_PROPERTY = "java.naming.provider.url";
    public static final String JNDI_CORBA_ORB_PROPERTY = "java.naming.corba.orb";
    public static final String OMG_ORB_INIT_HOST_PROPERTY = "org.omg.CORBA.ORBInitialHost";
    public static final String OMG_ORB_INIT_PORT_PROPERTY = "org.omg.CORBA.ORBInitialPort";
    public static final String SUN_ORB_SERVER_HOST_PROPERTY = "com.sun.CORBA.ORBServerHost";
    public static final String SUN_ORB_SERVER_PORT_PROPERTY = "com.sun.CORBA.ORBServerPort";
    public static final String RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.StubClass";
    public static final String RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY = "javax.rmi.CORBA.PortableRemoteObjectClass";
    public static final String SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY = "com.sun.CORBA.connection.ORBSocketFactoryClass";
    public static final String SUN_ORB_JTS_CLASS_PROPERTY = "com.sun.corba.ee.CosTransactions.ORBJTSClass";
    public static final String SUN_MIN_WORKER_THREAD_COUNT_PROPERTY = "com.sun.CORBA.threadpool.minthreads";
    public static final String SUN_MAX_WORKER_THREAD_COUNT_PROPERTY = "com.sun.CORBA.threadpool.maxthreads";
    public static final String SUN_WORKER_THREAD_INACTIVITY_TIMEOUT_PROPERTY = "com.sun.CORBA.threadpool.timeout";
    private static final String DEFAULT_MIN_THREAD_COUNT = "10";
    private static final String DEFAULT_MAX_THREAD_COUNT = "200";
    private static final int DEFAULT_INACTIVITY_TIMEOUT_IN_SECONDS = 300;
    public static final String SUN_MAX_CONNECTIONS_PROPERTY = "com.sun.CORBA.connection.ORBHighWaterMark";
    public static final String DEFAULT_MAX_CONNECTIONS = "1024";
    private static final String J2EE_INITIALIZER = "com.sun.enterprise.iiop.J2EEInitializer";
    private static final String PI_ORB_INITIALIZER_CLASS_PREFIX = "org.omg.PortableInterceptor.ORBInitializerClass.";
    public static final String ORB_LISTEN_SOCKET_PROPERTY = "com.sun.CORBA.connection.ORBListenSocket";
    private static final String IIOP_CLEAR_TEXT_CONNECTION = "IIOP_CLEAR_TEXT";
    public static final String ORB_DISABLED_PORTS_PROPERTY = "com.sun.CORBA.connection.ORBDisabledListenPorts";
    private static final String SSL = "SSL";
    private static final String SSL_MUTUALAUTH = "SSL_MUTUALAUTH";
    private static final String ORB_SSL_CERTDB_PATH = "com.sun.CORBA.ssl.CertDB";
    private static final String ORB_SSL_CERTDB_PASSWORD = "com.sun.CORBA.ssl.CertDBPassword";
    public static final String SUN_GIOP_FRAGMENT_SIZE_PROPERTY = "com.sun.CORBA.giop.ORBFragmentSize";
    public static final String SUN_GIOP_BUFFER_SIZE_PROPERTY = "com.sun.CORBA.giop.ORBBufferSize";
    private static final String SUN_GIOP_DEFAULT_FRAGMENT_SIZE = "1024";
    private static final String SUN_GIOP_DEFAULT_BUFFER_SIZE = "1024";
    private static final String ORB_SSL_CLIENT_CERTNAME = "com.sun.CORBA.ssl.client.Certname";
    private static final String ORB_SSL_CLIENT_SSLVERSION = "com.sun.CORBA.ssl.client.SslVersion";
    private static final String ORB_SSL_CLIENT_SSL2CIPHERS = "com.sun.CORBA.ssl.client.Ssl2Ciphers";
    private static final String ORB_SSL_CLIENT_SSL3CIPHERS = "com.sun.CORBA.ssl.client.Ssl3Ciphers";
    private static final String ORB_SSL_CLIENT_TLSROLLBACK = "com.sun.CORBA.ssl.client.TlsRollback";
    private static final String DEFAULT_ORB_INIT_HOST = "localhost";
    private static final String DEFAULT_ORB_INIT_PORT = "1050";
    private static final String CONFIG_DIR = "config";
    private static final String J2EE_ORB_CONFIG_FILE_NAME = "orb.properties";
    private static final String J2EE_ORB_CONFIG_PORT_NAME = "port";
    private static final String J2EE_ORB_CONFIG_HOST_NAME = "host";
    private static final String NATIVE_LIB_DIR = "nativelib";
    private static org.omg.CORBA.ORB orb;
    private static int orbInitialPort;
    private static boolean librariesLoaded;
    private static IiopListener[] iiopListenerBeans;
    private static Orb orbBean;
    private static IiopService iiopServiceBean;
    private static final String SUN_LISTEN_ADDR_ANY_ADDRESS = "com.sun.CORBA.orb.AddrAnyAddress";
    private static final String ORB_IOR_ADDR_ANY_INITIALIZER = "com.sun.enterprise.iiop.IORAddrAnyInitializer";
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$com$sun$enterprise$util$ORBManager;

    public static synchronized void init(String[] stringArray, Properties properties) {
        if (orb != null) {
            return;
        }
        try {
            ServerContext serverContext = ApplicationServer.getServerContext();
            ConfigContext configContext = serverContext.getConfigContext();
            if (!$assertionsDisabled && configContext == null) {
                throw new AssertionError();
            }
            Server server = ServerBeansFactory.getServerBean(configContext);
            if (!$assertionsDisabled && server == null) {
                throw new AssertionError();
            }
            iiopServiceBean = server.getIiopService();
            if (!$assertionsDisabled && iiopServiceBean == null) {
                throw new AssertionError();
            }
            iiopListenerBeans = iiopServiceBean.getIiopListener();
            if (!($assertionsDisabled || iiopListenerBeans != null && iiopListenerBeans.length > 0)) {
                throw new AssertionError();
            }
            orbBean = iiopServiceBean.getOrb();
            if (!$assertionsDisabled && orbBean == null) {
                throw new AssertionError();
            }
        }
        catch (ConfigException configException) {
            _logger.log(Level.SEVERE, "enterprise_util.orbmgr_config_excep", configException);
        }
        catch (NullPointerException nullPointerException) {
            _logger.log(Level.FINE, "Server Context is NULL. Ignoring and proceeding.");
        }
        orb = ORBManager.createORB(stringArray, properties);
        if (Switch.getSwitch().getContainerType() == 2) {
            ORBManager.initializeORBMonitoring(orb, false, null);
        }
    }

    public static org.omg.CORBA.ORB getORB() {
        if (orb == null) {
            ORBManager.init(null, null);
        }
        return orb;
    }

    public static int getORBInitialPort() {
        if (orbInitialPort == -1) {
            ORBManager.checkORBInitialPort(new Properties());
        }
        return orbInitialPort;
    }

    private static synchronized org.omg.CORBA.ORB createORB(String[] stringArray, Properties properties) {
        org.omg.CORBA.ORB oRB = null;
        Properties properties2 = new Properties();
        System.setProperty(OMG_ORB_CLASS_PROPERTY, poaOrbClass);
        System.setProperty(OMG_ORB_SINGLETON_CLASS_PROPERTY, poaOrbSingletonClass);
        System.setProperty(SUN_ORB_SOCKET_FACTORY_CLASS_PROPERTY, "com.sun.enterprise.iiop.IIOPSSLSocketFactory");
        if (System.getProperty(ORB_UTIL_CLASS_PROPERTY) == null) {
            System.setProperty(ORB_UTIL_CLASS_PROPERTY, "com.sun.corba.ee.internal.POA.ShutdownUtilDelegate");
        }
        try {
            if (properties == null) {
                properties2.put(SUN_ORB_JTS_CLASS_PROPERTY, "com.sun.jts.CosTransactions.DefaultTransactionService");
            } else {
                properties2.putAll((Map<?, ?>)properties);
            }
            properties2.put("org.omg.PortableInterceptor.ORBInitializerClass.com.sun.enterprise.iiop.J2EEInitializer", "");
            properties2.put("com.sun.CORBA.ORBAllowLocalOptimization", "true");
            properties2.put(OMG_ORB_CLASS_PROPERTY, poaOrbClass);
            properties2.put(OMG_ORB_SINGLETON_CLASS_PROPERTY, poaOrbSingletonClass);
            String string = ORBManager.checkORBInitialPort(properties2);
            String string2 = ORBManager.checkORBInitialHost(properties2);
            stringArray = ORBManager.addORBInitRef(stringArray, string2, string);
            ORBManager.checkAdditionalORBListeners(properties2);
            ORBManager.checkThreadPoolSettings(properties2);
            ORBManager.checkConnectionSettings(properties2);
            ORBManager.checkMessageFragmentSize(properties2);
            ORBManager.checkServerSSLOutboundSettings(properties2);
            oRB = org.omg.CORBA.ORB.init(stringArray, properties2);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "enterprise_util.excep_in_createorb", exception);
        }
        return oRB;
    }

    private static String checkForAddrAny(Properties properties, String string) {
        if (string.equals("0.0.0.0") || string.equals("::") || string.equals("::ffff:0.0.0.0")) {
            properties.setProperty(SUN_LISTEN_ADDR_ANY_ADDRESS, string);
            properties.put("org.omg.PortableInterceptor.ORBInitializerClass.com.sun.enterprise.iiop.IORAddrAnyInitializer", "");
            try {
                String string2 = InetAddress.getLocalHost().getHostAddress();
                return string2;
            }
            catch (UnknownHostException unknownHostException) {
                _logger.log(Level.WARNING, "Unknown host exception - Setting host to localhost");
                return DEFAULT_ORB_INIT_HOST;
            }
        }
        return string;
    }

    private static String checkORBInitialHost(Properties properties) {
        String string = System.getProperty(OMG_ORB_INIT_HOST_PROPERTY);
        if (string == null) {
            string = properties.getProperty(OMG_ORB_INIT_HOST_PROPERTY);
        }
        if (string == null) {
            try {
                if (iiopListenerBeans[0].getSsl() == null) {
                    string = iiopListenerBeans[0].getAddress();
                    string = ORBManager.checkForAddrAny(properties, string);
                    properties.setProperty(SUN_ORB_SERVER_HOST_PROPERTY, string);
                }
            }
            catch (NullPointerException nullPointerException) {
                _logger.log(Level.FINE, "IIOP listener element is null. Ignoring and proceeding.");
            }
        }
        if (string == null) {
            string = DEFAULT_ORB_INIT_HOST;
        }
        System.setProperty(OMG_ORB_INIT_HOST_PROPERTY, string);
        return string;
    }

    private static String checkORBInitialPort(Properties properties) {
        String string = System.getProperty(OMG_ORB_INIT_PORT_PROPERTY);
        if (string == null) {
            string = properties.getProperty(OMG_ORB_INIT_PORT_PROPERTY);
        }
        if (string == null) {
            try {
                if (iiopListenerBeans[0].getSsl() == null) {
                    string = iiopListenerBeans[0].getPort();
                    if (!iiopListenerBeans[0].isEnabled()) {
                        properties.setProperty(ORB_DISABLED_PORTS_PROPERTY, string);
                    }
                    properties.setProperty(SUN_ORB_SERVER_PORT_PROPERTY, string);
                }
            }
            catch (NullPointerException nullPointerException) {
                _logger.log(Level.FINE, "IIOP listener element is null. Ignoring and proceeding.");
            }
        }
        if (string == null) {
            string = DEFAULT_ORB_INIT_PORT;
        }
        System.setProperty(OMG_ORB_INIT_PORT_PROPERTY, string);
        orbInitialPort = new Integer(string);
        return string;
    }

    private static void checkAdditionalORBListeners(Properties properties) {
        if (iiopListenerBeans != null && iiopListenerBeans.length > 1) {
            StringBuffer stringBuffer = new StringBuffer("");
            int n = 1;
            while (n < iiopListenerBeans.length) {
                if (iiopListenerBeans[n].isEnabled()) {
                    if (iiopListenerBeans[n].getSsl() == null) {
                        ORBManager.checkForAddrAny(properties, iiopListenerBeans[n].getAddress());
                        stringBuffer.append((stringBuffer.length() > 0 ? "," : "") + IIOP_CLEAR_TEXT_CONNECTION + ":" + iiopListenerBeans[n].getPort() + ":" + iiopListenerBeans[n].getAddress());
                    } else {
                        Ssl ssl = null;
                        ssl = iiopListenerBeans[n].getSsl();
                        if (!$assertionsDisabled && ssl == null) {
                            throw new AssertionError();
                        }
                        boolean bl = ssl.isClientAuthEnabled();
                        String string = bl ? SSL_MUTUALAUTH : SSL;
                        int n2 = 0;
                        if (ssl.isSsl2Enabled()) {
                            ++n2;
                        }
                        if (ssl.isSsl3Enabled()) {
                            n2 += 2;
                        }
                        if (ssl.isTlsEnabled()) {
                            n2 += 4;
                        }
                        String string2 = ssl.getSsl2Ciphers();
                        String string3 = string2.replace(',', '&');
                        string2 = ssl.getSsl3TlsCiphers();
                        String string4 = string2.replace(',', '&');
                        stringBuffer.append((stringBuffer.length() > 0 ? "," : "") + string + ":" + iiopListenerBeans[n].getPort() + ":" + iiopListenerBeans[n].getAddress() + ":" + ssl.getCertNickname() + ":" + n2 + ":" + string3 + ":" + string4 + ":" + ssl.isTlsEnabled());
                    }
                }
                ++n;
            }
            properties.setProperty(ORB_LISTEN_SOCKET_PROPERTY, stringBuffer.toString());
        }
    }

    private static void checkThreadPoolSettings(Properties properties) {
        if (orbBean != null) {
            int n;
            String string;
            String string2;
            try {
                string2 = orbBean.getSteadyThreadPoolSize();
                string = orbBean.getMaxThreadPoolSize();
                Integer.parseInt(string2);
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", numberFormatException);
                }
                string2 = DEFAULT_MIN_THREAD_COUNT;
                string = DEFAULT_MAX_THREAD_COUNT;
            }
            try {
                String string3 = orbBean.getIdleThreadTimeoutInSeconds();
                n = Integer.parseInt(string3);
            }
            catch (NumberFormatException numberFormatException) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", numberFormatException);
                }
                n = 300;
            }
            properties.setProperty(SUN_MIN_WORKER_THREAD_COUNT_PROPERTY, string2);
            properties.setProperty(SUN_MAX_WORKER_THREAD_COUNT_PROPERTY, string);
            properties.setProperty(SUN_WORKER_THREAD_INACTIVITY_TIMEOUT_PROPERTY, "" + n * 1000);
        }
    }

    private static void checkConnectionSettings(Properties properties) {
        if (orbBean != null) {
            String string;
            try {
                string = orbBean.getMaxConnections();
                Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (_logger.isLoggable(Level.WARNING)) {
                    _logger.log(Level.WARNING, "enterprise_util.excep_orbmgr_numfmt", numberFormatException);
                }
                string = "1024";
            }
            properties.setProperty(SUN_MAX_CONNECTIONS_PROPERTY, string);
        }
    }

    public static void initializeORBMonitoring(org.omg.CORBA.ORB oRB, boolean bl, String string) {
        if (oRB == null || !(oRB instanceof ORB)) {
            return;
        }
        try {
            GenericMonitorMBean genericMonitorMBean = new GenericMonitorMBean();
            if (!bl) {
                MonitoringHelper.registerSystemORBMonitoringMBean(genericMonitorMBean);
            } else {
                MonitoringHelper.registerUserORBMonitoringMBean(string, genericMonitorMBean);
            }
            try {
                genericMonitorMBean.addChild(MonitoredObjectType.ORB_CONNECTION.getTypeName(), MonitoredObjectType.ORB_CONNECTION, ((ORB)oRB).getConnectionMonitor());
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                _logger.log(Level.SEVERE, "enterprise_util.excep_orbmgr_init_conn_monitoring", instanceAlreadyExistsException);
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                _logger.log(Level.SEVERE, "enterprise_util.excep_orbmgr_init_conn_monitoring", mBeanRegistrationException);
            }
            try {
                genericMonitorMBean.addChild(MonitoredObjectType.ORB_THREAD_POOL.getTypeName(), MonitoredObjectType.ORB_THREAD_POOL, ((com.sun.corba.ee.internal.corba.ORB)oRB).getThreadPoolMonitor());
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                _logger.log(Level.SEVERE, "enterprise_util.excep_orbmgr_init_thrpool_monitoring", instanceAlreadyExistsException);
            }
            catch (MBeanRegistrationException mBeanRegistrationException) {
                _logger.log(Level.SEVERE, "enterprise_util.excep_orbmgr_init_conn_monitoring", mBeanRegistrationException);
            }
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
            _logger.log(Level.SEVERE, "enterprise_util.excep_orbmgr_init_orb_monitoring", instanceAlreadyExistsException);
        }
        catch (MBeanRegistrationException mBeanRegistrationException) {
            _logger.log(Level.SEVERE, "enterprise_util.excep_orbmgr_init_orb_monitoring", mBeanRegistrationException);
        }
        catch (Throwable throwable) {
            _logger.log(Level.SEVERE, "enterprise_util.excep_orbmgr_init_orb_monitoring", throwable);
        }
    }

    private static void checkMessageFragmentSize(Properties properties) {
        if (orbBean != null) {
            String string;
            String string2;
            try {
                int n = Integer.parseInt(orbBean.getMessageFragmentSize().trim()) / 8 * 8;
                if (n < 32) {
                    string2 = "32";
                    _logger.log(Level.INFO, "Setting ORB Message Fragment size to " + string2);
                } else {
                    string2 = String.valueOf(n);
                }
                string = string2;
            }
            catch (NumberFormatException numberFormatException) {
                _logger.log(Level.WARNING, "enterprise_util.excep_in_reading_fragment_size", numberFormatException);
                _logger.log(Level.INFO, "Setting ORB Message Fragment size to Default 1024");
                string2 = "1024";
                string = "1024";
            }
            properties.setProperty(SUN_GIOP_FRAGMENT_SIZE_PROPERTY, string2);
            properties.setProperty(SUN_GIOP_BUFFER_SIZE_PROPERTY, string);
        }
    }

    private static void checkServerSSLOutboundSettings(Properties properties) {
        SslClientConfig sslClientConfig;
        if (iiopServiceBean != null && (sslClientConfig = iiopServiceBean.getSslClientConfig()) != null) {
            Ssl ssl = sslClientConfig.getSsl();
            if (!$assertionsDisabled && ssl == null) {
                throw new AssertionError();
            }
            properties.setProperty(ORB_SSL_CLIENT_CERTNAME, ssl.getCertNickname());
            int n = 0;
            if (ssl.isSsl2Enabled()) {
                ++n;
            }
            if (ssl.isSsl3Enabled()) {
                n += 2;
            }
            if (ssl.isTlsEnabled()) {
                n += 4;
            }
            properties.setProperty(ORB_SSL_CLIENT_SSLVERSION, "" + n);
            properties.setProperty(ORB_SSL_CLIENT_SSL2CIPHERS, ssl.getSsl2Ciphers());
            properties.setProperty(ORB_SSL_CLIENT_SSL3CIPHERS, ssl.getSsl3TlsCiphers());
            properties.setProperty(ORB_SSL_CLIENT_TLSROLLBACK, "" + ssl.isTlsRollbackEnabled());
        }
    }

    private static String[] addORBInitRef(String[] stringArray, String string, String string2) {
        String[] stringArray2;
        int n = 0;
        if (stringArray == null) {
            stringArray2 = new String[2];
        } else {
            stringArray2 = new String[stringArray.length + 2];
            while (n < stringArray.length) {
                stringArray2[n] = stringArray[n];
                ++n;
            }
        }
        stringArray2[n++] = "-ORBInitRef";
        stringArray2[n++] = "NameService=corbaloc:iiop:1.2@" + string + ":" + string2 + "/NameService";
        return stringArray2;
    }

    public static Tie exportObject(Remote remote) throws RemoteException {
        PortableRemoteObject.exportObject((Remote)remote);
        Tie tie = Util.getTie((Remote)remote);
        tie.orb(ORBManager.getORB());
        return tie;
    }

    private static synchronized void loadSharedLibraries() {
        ORBManager.checkDelegateProps();
        String string = FileUtil.getAbsolutePath(NATIVE_LIB_DIR);
        String[] stringArray = new File(string).list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            try {
                System.load(string + File.separator + stringArray[n]);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                _logger.log(Level.SEVERE, "enterprise_util.cannot_load_library", stringArray[n]);
            }
            ++n;
        }
    }

    private static void checkDelegateProps() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty(ORBManager.ORB_UTIL_CLASS_PROPERTY);
                if (string == null || string.equals("")) {
                    System.setProperty(ORBManager.RMIIIOP_STUB_DELEGATE_CLASS_PROPERTY, "com.sun.corba.ee.internal.javax.rmi.CORBA.StubDelegateImpl");
                    System.setProperty(ORBManager.RMIIIOP_PRO_DELEGATE_CLASS_PROPERTY, "com.sun.corba.ee.internal.javax.rmi.PortableRemoteObject");
                }
                return null;
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$com$sun$enterprise$util$ORBManager == null ? (class$com$sun$enterprise$util$ORBManager = ORBManager.class$("com.sun.enterprise.util.ORBManager")) : class$com$sun$enterprise$util$ORBManager).desiredAssertionStatus();
        _logger = LogDomains.getLogger("javax.enterprise.system.util");
        orb = null;
        orbInitialPort = -1;
        librariesLoaded = false;
        iiopListenerBeans = null;
        orbBean = null;
        iiopServiceBean = null;
    }
}

