/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.WebComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.web.WebCheck;
import com.sun.enterprise.tools.verifier.tests.web.WebTest;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class FormErrorPage
extends WebTest
implements WebCheck {
    public Result check(WebBundleDescriptor webBundleDescriptor) {
        Result result = this.getInitializedResult();
        WebComponentNameConstructor webComponentNameConstructor = new WebComponentNameConstructor(webBundleDescriptor);
        if (webBundleDescriptor.getLoginConfiguration() != null) {
            boolean bl = false;
            String string = webBundleDescriptor.getLoginConfiguration().getFormErrorPage();
            if (string.length() > 0) {
                try {
                    ZipEntry zipEntry;
                    JarFile jarFile = new JarFile(Verifier.getArchiveFile(((WebBundleArchivist)webBundleDescriptor.getArchivist()).getWebJarFile().getName()));
                    if (string.startsWith("/")) {
                        string = string.substring(1);
                    }
                    bl = (zipEntry = jarFile.getEntry(string)) != null;
                    jarFile.close();
                }
                catch (Exception exception) {
                    bl = false;
                }
                if (bl) {
                    result.addGoodDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{webComponentNameConstructor.toString()}));
                    result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The form-error-page [ {0} ] value defines the location in the web application where the error page that is displayed when login is not successful can be found within web application [ {1} ]", new Object[]{string, webBundleDescriptor.getName()}));
                } else {
                    result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{webComponentNameConstructor.toString()}));
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The form-error-page [ {0} ] value does not define the location in the web application where the error page that is displayed when login is not successful can be found within web application [ {1} ]", new Object[]{string, webBundleDescriptor.getName()}));
                }
            } else {
                result.addNaDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{webComponentNameConstructor.toString()}));
                result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no form-error-page elements within this web archive [ {0} ]", new Object[]{webBundleDescriptor.getName()}));
            }
        } else {
            result.addNaDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{webComponentNameConstructor.toString()}));
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no form-error-page elements within this web archive [ {0} ]", new Object[]{webBundleDescriptor.getName()}));
        }
        return result;
    }
}

