/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.elements;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Iterator;
import java.util.Map;

public class MethodPermissionSecurityRoleExists
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor ejbDescriptor) {
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(ejbDescriptor);
        Map map = ejbDescriptor.getPermissionedMethodsByPermission();
        boolean bl = false;
        if (map.size() > 0) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                MethodPermission methodPermission = (MethodPermission)iterator.next();
                if (!methodPermission.isRoleBased()) continue;
                if (!ejbDescriptor.getEjbBundleDescriptor().getRoles().contains(methodPermission.getRole())) {
                    bl = true;
                    result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                    result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: Method permissions role [ {0} ] must be one of the roles defined in bean [ {1} ]", new Object[]{methodPermission.getRole().getName(), ejbDescriptor.getName()}));
                    continue;
                }
                result.addGoodDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Valid: Method permissions role [ {0} ] is defined as one of the roles defined in bean [ {1} ]", new Object[]{methodPermission.getRole().getName(), ejbDescriptor.getName()}));
            }
            if (bl) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.addNaDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no <method-permission> elements within this bean [ {0} ]", new Object[]{ejbDescriptor.getName()}));
        }
        return result;
    }
}

