/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector.cci;

import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.cci.ConnectionFactoryTest;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;

public class InteractionSpecJavaBeansCompliance
extends ConnectionFactoryTest
implements ConnectorCheck {
    static /* synthetic */ Class class$java$lang$Object;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result check(ConnectorDescriptor connectorDescriptor) {
        boolean bl = false;
        Result result = this.getInitializedResult();
        ComponentNameConstructor componentNameConstructor = new ComponentNameConstructor(connectorDescriptor);
        if (!this.isCCIImplemented(connectorDescriptor, result)) {
            result.addNaDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.notApplicable(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.cci.InteractionExistence.notapp", "NotApplicable : The CCI interfaces do not seem to be implemented by this resource adapter"));
            return result;
        }
        File file = Verifier.getJarFile(((ConnectorArchivist)connectorDescriptor.getArchivist()).getRarFile().getName());
        Class clazz = this.findImplementorOf(file, "javax.resource.cci.InteractionSpec");
        if (clazz == null) {
            result.addNaDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".nonexist", "Error: While the CCI interfaces are implemented, the javax.resource.cci.InteractionSpec is not"));
            return result;
        }
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz, class$java$lang$Object == null ? (class$java$lang$Object = InteractionSpecJavaBeansCompliance.class$("java.lang.Object")) : class$java$lang$Object);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            int n = 0;
            while (n < propertyDescriptorArray.length) {
                if (propertyDescriptorArray[n].getReadMethod() == null || propertyDescriptorArray[n].getWriteMethod() == null) {
                    bl = true;
                    result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The javax.resource.cci.InteractionSpec implementation [ {0} ] of the property [ {1} ] is not JavaBeans compliant", new Object[]{clazz.getName(), propertyDescriptorArray[n].getName()}));
                }
                if (!propertyDescriptorArray[n].isConstrained() && !propertyDescriptorArray[n].isBound()) {
                    bl = true;
                    result.addErrorDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed2", "Error: The property [ {0} ] of the javax.resource.cci.InteractionSpec implementation [ {1} ] is not bound or constrained", new Object[]{propertyDescriptorArray[n].getName(), clazz.getName()}));
                }
                ++n;
            }
        }
        catch (IntrospectionException introspectionException) {
            result.addNaDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: The javax.resource.cci.InteractionSpec implementation [ {0} ] is not JavaBeans compliant", new Object[]{clazz.getName()}));
            return result;
        }
        if (!bl) {
            result.addGoodDetails(VerifierTest.smh.getLocalString("tests.componentNameConstructor", "For [ {0} ]", new Object[]{componentNameConstructor.toString()}));
            result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The javax.resource.cci.InteractionSpec implementation is JavaBeans compliant"));
        }
        return result;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

