/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.gui;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.verifier.JarCheckImpl;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.gui.ControlPanel;
import com.sun.enterprise.tools.verifier.gui.MainFrame;
import com.sun.enterprise.tools.verifier.gui.ResultsPanel;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class MainPanel
extends JPanel
implements Runnable {
    ResultsPanel resultsPanel = new ResultsPanel();
    Verifier verifier;
    ControlPanel verifierControls;
    static LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    JLabel statusLabel = new JLabel(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_Idle", "Idle"));
    Enumeration components;
    Descriptor application = null;
    Thread running = null;

    public ControlPanel getVerifierControlPanel() {
        return this.verifierControls;
    }

    public MainPanel(JFrame jFrame, Verifier verifier) {
        this(jFrame, null, verifier);
    }

    public void setJarFilename(String string) {
        File file;
        if (string != null && (file = new File(string)).exists()) {
            this.getVerifierControlPanel().addJarFile(file);
        }
    }

    public MainPanel(JFrame jFrame, String string, Verifier verifier) {
        super(new BorderLayout(), true);
        this.verifier = verifier;
        this.verifier.setFrame(jFrame);
        this.verifierControls = new ControlPanel(jFrame);
        this.setJarFilename(string);
        this.add("North", this.verifierControls);
        this.add("Center", this.resultsPanel);
        this.add("South", this.statusLabel);
        this.verifierControls.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MainPanel.this.getFileList().hasMoreElements()) {
                    MainPanel.this.resultsPanel.clearOldResults();
                    MainPanel.this.clearAllResultsVectors();
                    MainPanel.this.verifier.resetApplication();
                    MainPanel.this.start();
                } else {
                    JOptionPane.showMessageDialog(MainPanel.this.verifierControls, smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.optionPane.okButtonNoFiles", "You must first select file to verify.") + "\n" + smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.optionPane.okButtonNoFiles2", "Use the Add button to select file to be verified, then click on OK button."));
                }
            }
        });
        this.verifierControls.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (MainFrame.getExitOnClose()) {
                    System.exit(0);
                } else {
                    MainPanel.this.stop();
                    MainPanel.this.enableOK();
                    MainPanel.this.enableClose();
                    MainPanel.this.reset();
                    try {
                        Class<?> clazz = Class.forName("javax.swing.JFrame");
                        JFrame jFrame = (JFrame)SwingUtilities.getAncestorOfClass(clazz, MainPanel.this.resultsPanel);
                        jFrame.setVisible(false);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.getMessage();
                    }
                }
            }
        });
    }

    private void clearAllResultsVectors() {
        JarCheckImpl.clearAllResults();
    }

    public void reset() {
        this.resultsPanel.clearOldResults();
        this.resultsPanel.clearResults();
        this.verifierControls.removeAllJarFiles();
        this.clearAllResultsVectors();
        this.verifier.resetApplication();
    }

    public void setStatus(String string) {
        this.statusLabel.setText(string);
    }

    public Enumeration getFileList() {
        return this.verifierControls.listModel.elements();
    }

    public void clearResults() {
        this.resultsPanel.clearResults();
    }

    void disableOK() {
        this.verifierControls.okButton.setEnabled(false);
    }

    void enableOK() {
        this.verifierControls.okButton.setEnabled(true);
    }

    void disableClose() {
        this.verifierControls.closeButton.setEnabled(false);
    }

    void enableClose() {
        this.verifierControls.closeButton.setEnabled(true);
    }

    public void start() {
        if (this.running == null) {
            this.components = this.getFileList();
            this.clearResults();
            this.running = new Thread(this);
            this.running.setPriority(1);
            this.running.start();
        }
    }

    public void stop() {
        if (this.running != null) {
            this.running = null;
            this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_Closed", "Closed"));
        }
    }

    public void run() {
        this.disableOK();
        JarCheckImpl jarCheckImpl = new JarCheckImpl();
        while (this.components.hasMoreElements() && this.running != null) {
            Descriptor descriptor;
            this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_LoadingFile", "Loading file..."));
            File file = (File)this.components.nextElement();
            String string = file.getAbsolutePath();
            try {
                descriptor = this.verifier.loadJar(string);
            }
            catch (Throwable throwable) {
                Descriptor.setBoundsChecking(true);
                JOptionPane.showMessageDialog(this, smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.ErrorLoading", "Error loading {0}: {1}", new Object[]{string, throwable.getMessage()}) + "\n" + smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.ErrorLoadingContactHostAdmin", "Please consult your host administrator."));
                this.resultsPanel.addDetailText(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.ErrorLoading", "Error loading {0}: {1}", new Object[]{string, throwable.getMessage()}) + "\n");
                this.verifier.cleanTMPFiles();
                this.verifier.resetApplication();
                this.running = null;
                break;
            }
            if (descriptor == null) {
                this.resultsPanel.addDetailText(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.ErrorLoading", "Error loading {0}: {1}", new Object[]{string, this.verifier.getExceptionMessage()}) + "\n");
                this.verifier.cleanTMPFiles();
                this.verifier.resetApplication();
                this.running = null;
                Descriptor.setBoundsChecking(true);
                break;
            }
            this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_Testing", "Testing {0}...", new Object[]{descriptor.getName()}));
            try {
                if (this.verifier.getCheckPass()) {
                    this.resultsPanel.addDetailText(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.AllTestsPassed", "{0}: All tests passed.", new Object[]{descriptor.getName()}) + "\n");
                } else {
                    this.resultsPanel.addDetailText(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.SomeTestsFailed", "{0}: Some tests failed.", new Object[]{descriptor.getName()}) + "\n");
                }
                Descriptor.setBoundsChecking(true);
            }
            catch (Throwable throwable) {
                Descriptor.setBoundsChecking(true);
            }
            this.verifier.cleanTMPFiles();
            this.verifier.resetApplication();
            if (this.running != null) {
                this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_WritingReport", "Writing report..."));
                if (!this.verifier.writeDetails()) {
                    this.resultsPanel.addDetailText(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.ProblemWritingReport", "There was a problem writing the report file."));
                    this.resultsPanel.addDetailText("\n" + this.verifier.getExceptionMessage() + "\n");
                }
            }
            JarCheckImpl.clearAllResults();
        }
        this.setStatus(smh.getLocalString("com.sun.enterprise.tools.verifier.gui.MainPanel.Status_Idle", "Idle"));
        this.enableOK();
        this.enableClose();
        this.running = null;
    }
}

