/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.backend;

import com.iplanet.ias.jms.IASJmsConfig;
import com.sun.ejb.codegen.GeneratorDriver;
import com.sun.enterprise.NamingManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.appverification.factory.AppVerification;
import com.sun.enterprise.deployment.AbstractArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.DeploymentContext;
import com.sun.enterprise.deployment.DirectoryArchive;
import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.log.Log;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.resource.ConnectorInfo;
import com.sun.enterprise.resource.NameNotFoundException;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.tools.deployment.backend.ApplicationRegistry;
import com.sun.enterprise.tools.deployment.backend.DeploymentSession;
import com.sun.enterprise.tools.deployment.backend.JarInstaller;
import com.sun.enterprise.tools.deployment.backend.JarManagerImpl;
import com.sun.enterprise.tools.deployment.backend.JarRepository;
import com.sun.enterprise.tools.deployment.backend.RemoteNotificationListener;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.jms.JMSException;
import javax.naming.InitialContext;
import org.xml.sax.SAXParseException;

public class JarInstallerImpl
implements JarInstaller {
    private static final boolean debug = false;
    private static boolean validateXML = true;
    private static boolean cleanTmpDir = true;
    static final String VALIDATING_PARSER = "deployment.validating.parser";
    static final String CLEAN_TMP_DIR = "deployment.tmpdir.clean";
    public static final String CODEBASE_PREFIX = "http://" + Utility.getLocalAddress() + ":";
    public static final String SERVER_CHANGED = "ServerChanged";
    public static String port = null;
    public static String jit = System.getProperty("java.compiler");
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$backend$JarInstallerImpl == null ? (class$com$sun$enterprise$tools$deployment$backend$JarInstallerImpl = JarInstallerImpl.class$("com.sun.enterprise.tools.deployment.backend.JarInstallerImpl")) : class$com$sun$enterprise$tools$deployment$backend$JarInstallerImpl);
    private static int uniqueId = (int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL);
    private static Hashtable ejbJarCache = new Hashtable();
    private Vector listeners = new Vector();
    private InitialContext ic = null;
    private ApplicationRegistry applicationRegistry = null;
    private IASJmsConfig jmsConfig_ = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$backend$JarInstallerImpl;

    public String deployApplication(byte[] byArray, String string, DeploymentSession deploymentSession) throws RemoteException {
        Object object;
        boolean bl;
        Object object2;
        Serializable serializable;
        Object object3;
        Object object4;
        File file;
        Object var5_4 = null;
        String string2 = null;
        int n = 0;
        Application application = null;
        DeploymentContext deploymentContext = null;
        File file2 = null;
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.contacted.server", "Contacted server..."), deploymentSession);
        try {
            file = this.applicationRegistry.newApplicationJarFile(string);
            this.saveAsBytes(byArray, file);
            this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.application.transferred", "Application {0} transferred", new Object[]{string}), deploymentSession);
            this.progressEvent("Application Transferred", deploymentSession);
            file2 = DeploymentContext.createApplicationTempDirectory(string);
            JarClassLoader jarClassLoader = new JarClassLoader();
            jarClassLoader.addDir(file2.toURL());
            application = ApplicationArchivist.open(file, false, null, true);
            object4 = new DirectoryArchive(file2.getAbsolutePath());
            application.getApplicationArchivist().saveInClassLoadableFormat((AbstractArchive)object4);
            deploymentContext = new DeploymentContext((AbstractArchive)object4, application);
            deploymentContext.setSession(deploymentSession);
            application.getApplicationArchivist().setClassLoader(jarClassLoader);
            object3 = application.getEjbBundleDescriptors().iterator();
            while (object3.hasNext()) {
                serializable = (EjbBundleDescriptor)object3.next();
                object2 = (EjbBundleArchivist)serializable.getArchivist();
                ((EjbBundleArchivist)object2).setClassLoader(jarClassLoader);
            }
            this.setEjbJarIds(application);
        }
        catch (SAXParseException sAXParseException) {
            Log.err.println(sAXParseException);
            deploymentSession.setException(new Exception(sAXParseException.getMessage()));
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.error.xmlvalidationfailed", "Error while validating XML deployment descriptors : {0} ", new Object[]{sAXParseException.getMessage()}));
        }
        catch (Throwable throwable) {
            Log.err.println(throwable);
            deploymentSession.setException(new Exception(throwable.getMessage()));
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.error.saving/opening.jar", "Error saving/opening JAR ", new Object[]{throwable.getMessage()}));
        }
        boolean bl2 = false;
        object4 = null;
        if (this.isInstalled(string)) {
            bl2 = true;
            object3 = JarRepository.getServerJarFilename(string);
            object4 = new File((String)object3);
            this.undeployApplication(string, bl2);
        }
        int n2 = application.getEjbDescriptors().size();
        n = application.getWebBundleDescriptors().size();
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.application.ejb/webcount", "{0} has {1}  ejbs, {2} web components to deploy", new Object[]{application.getName(), new Integer(n2), new Integer(n)}), deploymentSession);
        object3 = file;
        serializable = file;
        object3 = this.applicationRegistry.newEjbServerJarFile(application.getName());
        serializable = this.applicationRegistry.newEjbClientJarFile(application.getName());
        string2 = this.deployEjbs(deploymentContext, (File)object3, (File)serializable, (File)object4);
        if (object4 != null && !(bl = ((File)object4).delete())) {
            Log.err.println("Couldn't delete old app jar : " + object4);
        }
        if (application.getRarComponentCount() > 0) {
            object2 = Switch.getSwitch().getResourceInstaller();
            object = application.getRarDescriptors().iterator();
            while (object.hasNext()) {
                ConnectorDescriptor connectorDescriptor = (ConnectorDescriptor)object.next();
                String string3 = connectorDescriptor.getArchivist().getArchiveUri();
                ((ResourceInstaller)object2).registerConnectorDescriptor(connectorDescriptor, string, string3);
            }
        }
        if (cleanTmpDir && file2 != null) {
            object2 = file2.getAbsolutePath();
            object = new Thread(new Runnable((String)object2){
                private final /* synthetic */ String val$path;
                {
                    this.val$path = string;
                }

                public void run() {
                    DeploymentContext.deleteDirectory(new File(this.val$path));
                }
            });
            ((Thread)object).start();
        }
        if (!deploymentSession.isCancelled()) {
            JarRepository.writeToPropsFile(application.getName(), application.getApplicationArchivist().getApplicationFile(), (File)object3, (File)serializable);
            System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.application.deployed", "Application {0} deployed.\n", new Object[]{string}));
            this.changed();
            this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.deployment.complete", " Deployment of {0} is complete.", new Object[]{application.getName()}), deploymentSession);
            this.progressEvent("Done Deploying", deploymentSession);
            return string2;
        }
        return null;
    }

    private void setEjbJarIds(Application application) {
        JarManagerImpl jarManagerImpl = Switch.getSwitch().getEJBJarManager();
        Application application2 = jarManagerImpl.getApplication(application.getName());
        if (application2 == null) {
            Iterator iterator = application.getEjbBundleDescriptors().iterator();
            while (iterator.hasNext()) {
                EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
                int n = this.getUniqueId();
                ejbBundleDescriptor.setUniqueId(n);
                ejbJarCache.put(new Long(n), ejbBundleDescriptor);
            }
        } else {
            Iterator iterator = application.getEjbBundleDescriptors().iterator();
            while (iterator.hasNext()) {
                EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
                EjbBundleDescriptor ejbBundleDescriptor2 = null;
                try {
                    ejbBundleDescriptor2 = application2.getEjbBundleByUri(ejbBundleDescriptor.getArchivist().getArchiveUri());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                long l = ejbBundleDescriptor2 != null ? ejbBundleDescriptor2.getUniqueId() : (long)this.getUniqueId();
                ejbBundleDescriptor.setUniqueId(l);
                ejbJarCache.put(new Long(l), ejbBundleDescriptor);
            }
        }
    }

    public static EjbBundleDescriptor getEjbJarForId(int n) {
        return (EjbBundleDescriptor)ejbJarCache.get(new Long(n));
    }

    private synchronized int getUniqueId() {
        return ++uniqueId;
    }

    private boolean isInstalled(String string) {
        boolean bl = false;
        try {
            bl = this.getApplicationNames().contains(string);
        }
        catch (RemoteException remoteException) {}
        return bl;
    }

    public Vector getApplicationNames() throws RemoteException {
        return JarRepository.getApplicationList();
    }

    public Application getApplicationForName(String string) throws RemoteException {
        Application application = null;
        try {
            application = JarRepository.getApplicationForName(string);
        }
        catch (Throwable throwable) {
            System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.errorreturning.application", " Error returning {0}", new Object[]{string}));
            System.out.println(throwable);
        }
        return application;
    }

    public void undeployApplication(String string) throws RemoteException {
        this.undeployApplication(string, false);
    }

    private void undeployApplication(String string, boolean bl) throws RemoteException {
        if (AppVerification.doInstrument()) {
            AppVerification.getInstrumentLogger().handleChangeInDeployment();
        }
        int n = -1;
        try {
            Object object;
            Iterator iterator;
            Object object2;
            Object object3;
            this.cleanupNameSpace(string);
            String string2 = JarRepository.getServerJarFilename(string);
            Application application = null;
            JarManagerImpl jarManagerImpl = Switch.getSwitch().getEJBJarManager();
            application = jarManagerImpl.getApplication(string);
            jarManagerImpl.undeploy(string);
            if (application.getRarComponentCount() > 0) {
                object3 = Switch.getSwitch().getResourceInstaller();
                object2 = application.getRarDescriptors().iterator();
                while (object2.hasNext()) {
                    iterator = (ConnectorDescriptor)object2.next();
                    object = ((BundleDescriptor)((Object)iterator)).getArchivist().getArchiveUri();
                    ((ResourceInstaller)object3).forceResourcePoolCleanup(string, (String)object);
                    ((ResourceInstaller)object3).unregisterConnectorDescriptor(string, (String)object);
                }
            }
            JarRepository.getApplicationJarFilenamesFor(string);
            object3 = JarRepository.getServerJarFilename(string);
            object2 = JarRepository.getApplicationJarFilenamesFor(string).elements();
            while (object2.hasMoreElements()) {
                iterator = (String)object2.nextElement();
                if (bl && ((String)((Object)iterator)).equals(object3)) continue;
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.delete.nextserverjar", " delete {0}", new Object[]{iterator}));
                boolean bl2 = new File((String)((Object)iterator)).delete();
                if (bl2) continue;
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.errorjarnotdeleted", " Warning: {0} could not be deleted", new Object[]{iterator}));
            }
            JarRepository.removeFromPropsFile(string);
            if (!bl) {
                iterator = application.getEjbBundleDescriptors().iterator();
                while (iterator.hasNext()) {
                    object = (EjbBundleDescriptor)iterator.next();
                    long l = ((EjbBundleDescriptor)object).getUniqueId();
                    ejbJarCache.remove(new Long(l));
                }
            }
            Switch.getSwitch().getPoolManager().resizeAllPools(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionapplicationnotundeployed.reasonnotknown", " Application {0} could not be undeployed - reason unknown", new Object[]{string}));
        }
        System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.applicationundeployed", " Application {0} has been undeployed", new Object[]{string}));
        this.changed();
    }

    private void removeDirectory(File file) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                File file2 = fileArray[n];
                if (file2.isDirectory()) {
                    this.removeDirectory(file2);
                }
                file2.delete();
                ++n;
            }
        }
        file.delete();
    }

    public void deployConnector(byte[] byArray, String string) throws RemoteException, PoolingException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        resourceInstaller.installResourceAdapter(byArray, string);
    }

    public Set getConnectionFactoryPropertyTemplate(String string, String string2) throws RemoteException, PoolingException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        ConnectorDescriptor connectorDescriptor = resourceInstaller.getDescriptorByConnectorName(string, string2);
        if (connectorDescriptor == null) {
            throw new NameNotFoundException(string + ":" + string2);
        }
        Set set = connectorDescriptor.getConfigProperties();
        return set;
    }

    public void addConnectionFactory(String string, String string2, String string3, String string4, String string5, Properties properties) throws RemoteException, PoolingException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        resourceInstaller.addConnectionFactory(string, string2, string3, string4, string5, properties);
    }

    public void removeConnectionFactory(String string) throws RemoteException, PoolingException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        resourceInstaller.removeConnectionFactory(string);
    }

    public void undeployConnector(String string) throws RemoteException, PoolingException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        resourceInstaller.uninstallResourceAdapter(string);
    }

    public ConnectorInfo listConnectors() throws RemoteException, PoolingException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        return resourceInstaller.listResourceAdapters();
    }

    public Set listConnectorResources() throws RemoteException {
        ResourceInstaller resourceInstaller = Switch.getSwitch().getResourceInstaller();
        return resourceInstaller.listConnectorResources();
    }

    public void createDestination(JmsDestinationResource jmsDestinationResource) throws RemoteException, JMSException {
        try {
            IASJmsConfig iASJmsConfig = this.getJmsConfig();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Iterator iterator = jmsDestinationResource.getProperties().iterator();
            while (iterator.hasNext()) {
                ResourceProperty resourceProperty = (ResourceProperty)iterator.next();
                hashMap.put(resourceProperty.getName(), resourceProperty.getValue());
            }
            iASJmsConfig.createDestination(jmsDestinationResource.getName(), jmsDestinationResource.getIsQueue(), hashMap);
        }
        catch (Exception exception) {
            Log.err.println(exception);
            throw new JMSException(exception.getMessage());
        }
    }

    public void deleteDestination(JmsDestinationResource jmsDestinationResource) throws RemoteException, JMSException {
        try {
            IASJmsConfig iASJmsConfig = this.getJmsConfig();
            iASJmsConfig.deleteDestination(jmsDestinationResource.getName());
        }
        catch (Exception exception) {
            Log.err.println(exception);
            throw new JMSException(exception.getMessage());
        }
    }

    public void createJmsConnectionFactory(JmsCnxFactoryResource jmsCnxFactoryResource) throws RemoteException, JMSException {
        try {
            IASJmsConfig iASJmsConfig = this.getJmsConfig();
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Iterator iterator = jmsCnxFactoryResource.getProperties().iterator();
            while (iterator.hasNext()) {
                ResourceProperty resourceProperty = (ResourceProperty)iterator.next();
                hashMap.put(resourceProperty.getName(), resourceProperty.getValue());
            }
            iASJmsConfig.createConnectionFactory(jmsCnxFactoryResource.getName(), jmsCnxFactoryResource.getIsQueue(), hashMap);
        }
        catch (Exception exception) {
            Log.err.println(exception);
            throw new JMSException(exception.getMessage());
        }
    }

    public void deleteJmsConnectionFactory(JmsCnxFactoryResource jmsCnxFactoryResource) throws RemoteException, JMSException {
        try {
            IASJmsConfig iASJmsConfig = this.getJmsConfig();
            iASJmsConfig.deleteConnectionFactory(jmsCnxFactoryResource.getName());
        }
        catch (Exception exception) {
            Log.err.println(exception);
            throw new JMSException(exception.getMessage());
        }
    }

    private String deployEjbs(DeploymentContext deploymentContext, File file, File file2, File file3) throws RemoteException {
        String string = "";
        int n = -1;
        Application application = deploymentContext.getApplication();
        DeploymentSession deploymentSession = deploymentContext.getSession();
        String string2 = CODEBASE_PREFIX + port + "/" + URLEncoder.encode(application.getName()) + "Client.jar";
        this.progress(localStrings.getLocalString("enterprise.tools.deployment.backend.deployingEjbs", "Deploying Ejbs..."), deploymentSession);
        try {
            string = GeneratorDriver.preDeploy(deploymentContext, file, file2, file3);
            if (deploymentSession.isCancelled()) {
                return null;
            }
        }
        catch (Exception exception) {
            Log.err.println(exception);
            deploymentSession.setException(exception);
            throw new RemoteException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptionprocessingejbjar", " Error processing ejb jar: {0} ", new Object[]{exception.getMessage()}));
        }
        JarManagerImpl jarManagerImpl = Switch.getSwitch().getEJBJarManager();
        jarManagerImpl.loadJar(file.toString());
        return string2;
    }

    private void saveAsBytes(byte[] byArray, File file) throws IOException {
        if (byArray == null) {
            throw new IOException(localStrings.getLocalString("enterprise.tools.deployment.backend.nulldata", "null data"));
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray, 0, byArray.length);
        fileOutputStream.close();
    }

    private byte[] getFileAsBytes(File file) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[fileInputStream.available()];
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }

    private void progress(String string, DeploymentSession deploymentSession) {
        block2: {
            if (deploymentSession == null) break block2;
            try {
                deploymentSession.setStatusMessage(string);
            }
            catch (Throwable throwable) {
                Log.err.println(throwable);
            }
        }
    }

    private void progressEvent(String string, DeploymentSession deploymentSession) {
        block2: {
            if (deploymentSession == null) break block2;
            try {
                deploymentSession.notification(new NotificationEvent("", string, ""));
            }
            catch (Throwable throwable) {
                Log.err.println(throwable);
            }
        }
    }

    public void addRemoteNotificationListener(RemoteNotificationListener remoteNotificationListener) throws RemoteException {
        this.listeners.addElement(remoteNotificationListener);
    }

    public void removeRemoteNotificationListener(RemoteNotificationListener remoteNotificationListener) throws RemoteException {
        this.listeners.removeElement(remoteNotificationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed() throws RemoteException {
        Vector vector = null;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            final RemoteNotificationListener remoteNotificationListener = (RemoteNotificationListener)enumeration.nextElement();
            final NotificationEvent notificationEvent = new NotificationEvent("", SERVER_CHANGED, SERVER_CHANGED, "");
            Thread thread = new Thread(){

                public void run() {
                    try {
                        remoteNotificationListener.notification(notificationEvent);
                    }
                    catch (Throwable throwable) {
                        JarInstallerImpl.this.listeners.removeElement(remoteNotificationListener);
                    }
                }
            };
            thread.start();
        }
    }

    private void cleanupNameSpace(String string) {
        try {
            Object object;
            Object object2;
            NamingManager namingManager = Switch.getSwitch().getNamingManager();
            JarManagerImpl jarManagerImpl = Switch.getSwitch().getEJBJarManager();
            Application application = jarManagerImpl.getApplication(string);
            if (application == null) {
                application = JarRepository.getApplicationForName(string);
            }
            if (application == null) {
                throw new RuntimeException(localStrings.getLocalString("enterprise.tools.deployment.backend.exceptioncouldnotopenapplication", "Couldn't open :  {0} ", new Object[]{string}));
            }
            Vector vector = application.getEjbDescriptors();
            int n = 0;
            while (n < vector.size()) {
                object2 = (EjbDescriptor)vector.elementAt(n);
                object = ((EjbAbstractDescriptor)object2).getJndiName();
                System.out.println(localStrings.getLocalString("enterprise.tools.deployment.backend.unbindingJNDIname", "Unbinding JNDI name: {0} ", new Object[]{object}));
                if (!((EjbDescriptor)object2).getType().equals("Message-driven") && ((EjbAbstractDescriptor)object2).isRemoteInterfacesSupported()) {
                    namingManager.unpublishObject((String)object);
                }
                namingManager.unbindObjects((JndiNameEnvironment)object2);
                ++n;
            }
            object2 = application.getWebBundleDescriptors();
            object = object2.iterator();
            while (object.hasNext()) {
                WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)object.next();
                namingManager.unbindObjects(webBundleDescriptor);
            }
        }
        catch (Exception exception) {
            Log.err.println(exception);
        }
    }

    private IASJmsConfig getJmsConfig() throws Exception {
        if (this.jmsConfig_ == null) {
            this.jmsConfig_ = new IASJmsConfig(1);
        }
        return this.jmsConfig_;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

