/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.application;

import com.iplanet.ias.security.Audit;
import com.sun.ejb.Invocation;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationException;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.security.LoginException;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.acl.AccessControlEntryImpl;
import com.sun.enterprise.security.acl.AccessControlList;
import com.sun.enterprise.security.acl.AccessControlListImpl;
import com.sun.enterprise.security.acl.EJBResource;
import com.sun.enterprise.security.acl.ResourceAccessManager;
import com.sun.enterprise.security.acl.ResourceGuard;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.security.application.Authorizer;
import com.sun.enterprise.security.application.AuthorizerImpl;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class EJBSecurityManager
implements SecurityManager {
    private static Logger _logger = null;
    private static final boolean debug = false;
    private ResourceAccessManager ram = null;
    private EjbDescriptor deploymentDescriptor = null;
    private ClassLoader loader = null;
    private Authorizer authorizer = null;
    private static LocalStringManagerImpl localStrings;
    private Switch theSwitch;
    private RunAsIdentityDescriptor runAs = null;
    private Set unchecked;
    private Set excluded;
    static /* synthetic */ Class class$com$sun$enterprise$security$application$EJBSecurityManager;

    public EJBSecurityManager(ClassLoader classLoader, EjbDescriptor ejbDescriptor) {
        boolean bl;
        this.loader = classLoader;
        this.deploymentDescriptor = ejbDescriptor;
        if (this.deploymentDescriptor == null) {
            throw new IllegalArgumentException("Illegal Deployment Descriptor Information.");
        }
        boolean bl2 = bl = !this.deploymentDescriptor.getUsesCallerIdentity();
        if (bl) {
            this.runAs = this.deploymentDescriptor.getRunAsIdentity();
            if (this.runAs != null) {
                _logger.log(Level.FINE, ejbDescriptor.getEjbClassName() + " will run-as: " + this.runAs.getPrincipal() + " (" + this.runAs.getRoleName() + ")");
            }
        }
        this.ram = new ResourceAccessManager();
        this.authorizer = new AuthorizerImpl(this.ram);
        this.theSwitch = Switch.getSwitch();
        this.initialize();
    }

    private String getAppName() {
        String string = "default";
        Application application = this.deploymentDescriptor.getApplication();
        if (application != null) {
            string = application.getName();
        }
        return string;
    }

    private void initialize() {
        String string = this.getAppName();
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Application = " + string);
            _logger.log(Level.FINEST, "RoleMapper = " + this.deploymentDescriptor.getApplication().getRoleMapper());
        }
        EjbDescriptor ejbDescriptor = this.deploymentDescriptor;
        RoleMapper.setRoleMapper(string, ejbDescriptor.getApplication().getRoleMapper());
        Enumeration enumeration = ejbDescriptor.getMethods(this.loader).elements();
        while (enumeration.hasMoreElements()) {
            Method method = (Method)enumeration.nextElement();
            EJBResource eJBResource = new EJBResource(string, method);
            AccessControlList accessControlList = this.getAccessControlList(ejbDescriptor, method);
            if (accessControlList == null) continue;
            ResourceGuard resourceGuard = new ResourceGuard(accessControlList);
            this.ram.protect(eJBResource, resourceGuard);
        }
        this.copyUncheckedAndExcludedSets();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyUncheckedAndExcludedSets() {
        Object object;
        Object object2;
        Object object3;
        Set set;
        this.excluded = Collections.synchronizedSet(new HashSet());
        this.unchecked = Collections.synchronizedSet(new HashSet());
        EjbDescriptor ejbDescriptor = this.deploymentDescriptor;
        Set set2 = ejbDescriptor.getUncheckedMethodDescriptors();
        if (set2 != null) {
            set = set2;
            synchronized (set) {
                object3 = set2.iterator();
                while (object3.hasNext()) {
                    object2 = (MethodDescriptor)object3.next();
                    object = ((MethodDescriptor)object2).getMethod(ejbDescriptor);
                    this.unchecked.add(object);
                }
            }
        }
        if ((set = ejbDescriptor.getExcludedMethodDescriptors()) != null) {
            object3 = set;
            synchronized (object3) {
                object2 = set.iterator();
                while (object2.hasNext()) {
                    object = (MethodDescriptor)object2.next();
                    Method method = ((MethodDescriptor)object).getMethod(ejbDescriptor);
                    this.excluded.add(method);
                }
            }
        }
    }

    private AccessControlList getAccessControlList(EjbDescriptor ejbDescriptor, Method method) {
        AccessControlListImpl accessControlListImpl = null;
        Iterator iterator = ejbDescriptor.getMethodPermissionsFor(method).iterator();
        if (iterator.hasNext()) {
            accessControlListImpl = new AccessControlListImpl();
        } else {
            accessControlListImpl = new AccessControlListImpl();
            accessControlListImpl.addEntry(new AccessControlEntryImpl(RoleMapper.getDefaultRole()));
        }
        while (iterator.hasNext()) {
            MethodPermission methodPermission = (MethodPermission)iterator.next();
            if (!methodPermission.isRoleBased()) continue;
            AccessControlEntryImpl accessControlEntryImpl = new AccessControlEntryImpl(methodPermission.getRole());
            accessControlListImpl.addEntry(accessControlEntryImpl);
        }
        return accessControlListImpl;
    }

    private SecurityContext getSecurityContext() {
        return SecurityContext.getCurrent();
    }

    public boolean authorize(Invocation invocation) {
        boolean bl;
        try {
            if (invocation.securityPermissions == 2) {
                bl = false;
            } else if (invocation.securityPermissions == 1) {
                bl = true;
            } else if (this.isExcluded(invocation.method)) {
                bl = false;
            } else if (this.isUnchecked(invocation.method)) {
                bl = true;
            } else if (this.areMethodPermissionsSet()) {
                boolean bl2 = false;
                SecurityContext securityContext = SecurityContext.getCurrent();
                if (securityContext == null) {
                    SecurityContext.init();
                    bl2 = true;
                }
                bl = this.authorizer.authorize(this.getAppName(), invocation);
                if (bl2) {
                    this.setSecurityContext(securityContext);
                }
            } else {
                bl = true;
            }
        }
        catch (LoginException loginException) {
            bl = false;
        }
        if (Audit.isActive()) {
            SecurityContext securityContext = SecurityContext.getCurrent();
            Audit.ejbMethodInvocation(securityContext, invocation.ejbObject, invocation.method, bl);
        }
        return bl;
    }

    public boolean isUnchecked(Method method) {
        if (this.unchecked == null) {
            return false;
        }
        return this.unchecked.contains(method);
    }

    public boolean isExcluded(Method method) {
        if (this.excluded == null) {
            return false;
        }
        return this.excluded.contains(method);
    }

    private boolean areMethodPermissionsSet() {
        EjbDescriptor ejbDescriptor = this.deploymentDescriptor;
        boolean bl = ejbDescriptor.getPermissionedMethodsByPermission().isEmpty();
        return !bl;
    }

    private void setSecurityContext(SecurityContext securityContext) {
        SecurityContext.setCurrent(securityContext);
    }

    public void preInvoke(ComponentInvocation componentInvocation) {
        SecurityContext securityContext = null;
        if (this.runAs != null) {
            securityContext = SecurityContext.init();
            componentInvocation.setOldSecurityContext(securityContext);
            this.loginForRunAs();
        }
    }

    public void postInvoke(ComponentInvocation componentInvocation) {
        if (this.runAs != null) {
            SecurityContext securityContext = componentInvocation.getOldSecurityContext();
            this.setSecurityContext(securityContext);
        }
    }

    private void loginForRunAs() {
        LoginContextDriver.loginPrincipal(this.runAs.getPrincipal());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCallerInRole(String string) {
        SecurityContext securityContext = null;
        SecurityContext securityContext2 = null;
        boolean bl = false;
        if (this.runAs != null) {
            try {
                InvocationManager invocationManager = this.theSwitch.getInvocationManager();
                ComponentInvocation componentInvocation = invocationManager.getCurrentInvocation();
                if (componentInvocation == null) {
                    throw new InvocationException();
                }
                securityContext2 = componentInvocation.getOldSecurityContext();
                securityContext = this.getSecurityContext();
                this.setSecurityContext(securityContext2);
                bl = this.authorizer.isCallerInRole(this.getAppName(), string);
                Object var8_8 = null;
                this.setSecurityContext(securityContext);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                this.setSecurityContext(securityContext);
                throw throwable;
            }
        } else {
            boolean bl2 = false;
            securityContext2 = SecurityContext.getCurrent();
            if (securityContext2 == null) {
                SecurityContext.init();
                bl2 = true;
            }
            bl = this.authorizer.isCallerInRole(this.getAppName(), string);
            if (bl2) {
                this.setSecurityContext(securityContext2);
            }
        }
        return bl;
    }

    public Principal getCallerPrincipal() {
        Object object;
        SecurityContext securityContext = null;
        boolean bl = false;
        if (this.runAs != null) {
            object = this.theSwitch.getInvocationManager();
            ComponentInvocation componentInvocation = object.getCurrentInvocation();
            if (componentInvocation == null) {
                throw new InvocationException();
            }
            securityContext = componentInvocation.getOldSecurityContext();
        } else {
            securityContext = this.getSecurityContext();
            if (securityContext == null) {
                securityContext = SecurityContext.init();
                bl = true;
            }
        }
        if (securityContext != null) {
            object = securityContext.getCallerPrincipal();
            if (bl) {
                this.setSecurityContext(null);
            }
            return object;
        }
        throw new IllegalStateException("Bad or improper security context.");
    }

    public void destroy() {
        String string = this.getAppName();
        RoleMapper.removeRoleMapper(string);
        Enumeration enumeration = this.deploymentDescriptor.getMethods(this.loader).elements();
        while (enumeration.hasMoreElements()) {
            Method method = (Method)enumeration.nextElement();
            EJBResource eJBResource = new EJBResource(string, method);
            this.ram.unprotect(eJBResource);
        }
        this.deploymentDescriptor = null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$application$EJBSecurityManager == null ? (class$com$sun$enterprise$security$application$EJBSecurityManager = EJBSecurityManager.class$("com.sun.enterprise.security.application.EJBSecurityManager")) : class$com$sun$enterprise$security$application$EJBSecurityManager);
    }
}

