/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.security.acl.Resource;

public class WebResource
extends Resource {
    private transient boolean wildcard;
    private transient String path;

    public WebResource(String string, String string2, String string3) {
        super(string, string2, string3);
        this.init(string2);
    }

    private void init(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name can't be null");
        }
        if (string.endsWith("/*") || string.equals("*")) {
            this.wildcard = true;
            this.path = string.length() == 1 ? "" : string.substring(0, string.length() - 1);
        } else {
            this.path = string;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        Resource resource = (Resource)object;
        return this.getApplication().equals(resource.getApplication()) && this.getMethod().equals(resource.getMethod()) && this.getName().equals(resource.getName());
    }

    public boolean implies(Resource resource) {
        if (resource == null || resource.getClass() != this.getClass()) {
            return false;
        }
        WebResource webResource = (WebResource)resource;
        if (!this.getMethod().equals(webResource.getMethod())) {
            return false;
        }
        if (this.wildcard) {
            if (webResource.wildcard) {
                return webResource.path.startsWith(this.path);
            }
            return webResource.path.length() > this.path.length() && webResource.path.startsWith(this.path);
        }
        if (webResource.wildcard) {
            return false;
        }
        return this.path.equals(webResource.path);
    }
}

