/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.security.acl;

import com.sun.enterprise.security.acl.AccessControlList;
import com.sun.enterprise.security.acl.Resource;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.security.AccessControlException;
import java.security.Guard;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ResourceGuard
implements Guard {
    private static Logger _logger = null;
    private static boolean debug;
    private static LocalStringManagerImpl localStrings;
    private AccessControlList acl;
    static /* synthetic */ Class class$com$sun$enterprise$security$acl$ResourceGuard;

    public ResourceGuard(AccessControlList accessControlList) {
        this.acl = accessControlList;
        if (debug) {
            _logger.log(Level.FINEST, "Created a Resource Guard with: " + accessControlList);
        }
    }

    public void checkGuard(Object object) throws SecurityException {
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Checking Access to the Object " + object);
            _logger.log(Level.FINEST, "ACL protecting this resource " + this.acl);
        }
        if (this.acl.checkAccess(RoleMapper.getDefaultRole())) {
            return;
        }
        if (object instanceof Resource) {
            Resource resource = (Resource)object;
            RoleMapper roleMapper = RoleMapper.getRoleMapper(resource.getApplication());
            Enumeration enumeration = roleMapper.getCurrentRoles();
            while (enumeration.hasMoreElements()) {
                Role role = (Role)enumeration.nextElement();
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Checking for the role: " + role);
                }
                if (!this.acl.checkAccess(role)) continue;
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, "Access to the Resource: " + resource + " was allowed for a user with role " + role);
                }
                return;
            }
            throw new AccessControlException(localStrings.getLocalString("resourceguard.access_denied", "Access to the Resource is Denied"));
        }
        throw new SecurityException(localStrings.getLocalString("resourceguard.invalid_resource", "Invalid Resource."));
    }

    public String toString() {
        return "Guard(" + this.acl.toString() + ")";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.core.security");
        debug = false;
        localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$security$acl$ResourceGuard == null ? (class$com$sun$enterprise$security$acl$ResourceGuard = ResourceGuard.class$("com.sun.enterprise.security.acl.ResourceGuard")) : class$com$sun$enterprise$security$acl$ResourceGuard);
    }
}

