/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.resource.ClientSecurityInfo;
import com.sun.enterprise.resource.ConnectorXAResource;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.logging.LogDomains;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;

public class LocalTxConnectorAllocator
implements ResourceAllocator {
    private PoolManager poolMgr;
    private ResourceSpec spec;
    private ConnectionRequestInfo reqInfo;
    private Subject subject;
    private ManagedConnectionFactory mcf;
    private ConnectorDescriptor desc;
    private ClientSecurityInfo info;
    private static Hashtable conHandles = new Hashtable();
    static Logger _logger = LogDomains.getLogger("javax.enterprise.resource.resourceadapter");

    public LocalTxConnectorAllocator(PoolManager poolManager, ManagedConnectionFactory managedConnectionFactory, ResourceSpec resourceSpec, Subject subject, ConnectionRequestInfo connectionRequestInfo, ClientSecurityInfo clientSecurityInfo, ConnectorDescriptor connectorDescriptor) {
        this.poolMgr = poolManager;
        this.mcf = managedConnectionFactory;
        this.spec = resourceSpec;
        this.subject = subject;
        this.reqInfo = connectionRequestInfo;
        this.info = clientSecurityInfo;
        this.desc = connectorDescriptor;
    }

    public ResourceHandle createResource() throws PoolingException {
        try {
            ManagedConnection managedConnection = this.mcf.createManagedConnection(this.subject, this.reqInfo);
            ResourceHandle resourceHandle = new ResourceHandle(managedConnection, this.spec, this, this.info);
            ConnectionListenerImpl connectionListenerImpl = new ConnectionListenerImpl(resourceHandle);
            managedConnection.addConnectionEventListener((ConnectionEventListener)connectionListenerImpl);
            return resourceHandle;
        }
        catch (ResourceException resourceException) {
            _logger.log(Level.SEVERE, "poolmgr.create_resource_error", resourceException);
            if (resourceException.getLinkedException() != null) {
                _logger.log(Level.SEVERE, "poolmgr.create_resource_error", resourceException.getLinkedException());
            }
            throw new PoolingException((Exception)((Object)resourceException));
        }
    }

    public void fillInResourceObjects(ResourceHandle resourceHandle) throws PoolingException {
        try {
            ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
            Object object = managedConnection.getConnection(this.subject, this.reqInfo);
            ConnectorXAResource connectorXAResource = new ConnectorXAResource(managedConnection, object, this.spec, this, this.info);
            resourceHandle.fillInResourceObjects(object, connectorXAResource);
            this.addResourceHandle(object, resourceHandle);
        }
        catch (ResourceException resourceException) {
            throw new PoolingException((Exception)((Object)resourceException));
        }
    }

    public void closeUserConnection(ResourceHandle resourceHandle) throws PoolingException {
        try {
            ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
            managedConnection.cleanup();
        }
        catch (ResourceException resourceException) {
            throw new PoolingException((Exception)((Object)resourceException));
        }
    }

    public void destroyResource(ResourceHandle resourceHandle) throws PoolingException {
        try {
            this.removeResourceHandle(resourceHandle.getUserConnection());
            ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
            managedConnection.destroy();
        }
        catch (ResourceException resourceException) {
            throw new PoolingException((Exception)((Object)resourceException));
        }
    }

    public boolean matchConnection(ResourceHandle resourceHandle) {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(resourceHandle.getResource());
        try {
            ManagedConnection managedConnection = this.mcf.matchManagedConnections(hashSet, this.subject, this.reqInfo);
            return managedConnection != null;
        }
        catch (ResourceException resourceException) {
            return false;
        }
    }

    public boolean supportsReauthentication() {
        return this.desc.supportsReauthentication();
    }

    public void cleanup(ResourceHandle resourceHandle) throws PoolingException {
        try {
            ManagedConnection managedConnection = (ManagedConnection)resourceHandle.getResource();
            managedConnection.cleanup();
        }
        catch (ResourceException resourceException) {
            throw new PoolingException(resourceException.toString(), (Exception)((Object)resourceException));
        }
    }

    private ResourceHandle getResourceHandle(Object object) {
        return (ResourceHandle)conHandles.get(new Key(object));
    }

    private void removeResourceHandle(Object object) {
        conHandles.remove(new Key(object));
    }

    private void addResourceHandle(Object object, ResourceHandle resourceHandle) {
        conHandles.put(new Key(object), resourceHandle);
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean shareableWithinComponent() {
        return false;
    }

    public Object getSharedConnection(ResourceHandle resourceHandle) throws PoolingException {
        throw new IllegalStateException("getSharedConnection not supported");
    }

    class ConnectionListenerImpl
    implements ConnectionEventListener {
        private ResourceHandle resource;

        public ConnectionListenerImpl(ResourceHandle resourceHandle) {
            this.resource = resourceHandle;
        }

        public void connectionClosed(ConnectionEvent connectionEvent) {
            Object object = connectionEvent.getConnectionHandle();
            ResourceHandle resourceHandle = LocalTxConnectorAllocator.this.getResourceHandle(object);
            ConnectorXAResource connectorXAResource = (ConnectorXAResource)resourceHandle.getXAResource();
            LocalTxConnectorAllocator.this.poolMgr.unregisterResource(resourceHandle, 0x4000000);
            LocalTxConnectorAllocator.this.poolMgr.putbackResourceToPool(resourceHandle, false);
        }

        public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
            ManagedConnection managedConnection = (ManagedConnection)connectionEvent.getSource();
            managedConnection.removeConnectionEventListener((ConnectionEventListener)this);
            LocalTxConnectorAllocator.this.poolMgr.putbackResourceToPool(this.resource, true);
            try {
                managedConnection.destroy();
            }
            catch (ResourceException resourceException) {}
        }

        public void localTransactionStarted(ConnectionEvent connectionEvent) {
        }

        public void localTransactionCommitted(ConnectionEvent connectionEvent) {
        }

        public void localTransactionRolledback(ConnectionEvent connectionEvent) {
        }
    }

    class Key {
        private Object obj;

        Key(Object object) {
            this.obj = object;
        }

        public int hashCode() {
            return this.obj.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                return this.obj == ((Key)object).obj;
            }
            return false;
        }
    }
}

