/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.resource;

import com.iplanet.ias.connectors.deployment.IASDeploymentException;
import com.iplanet.ias.connectors.deployment.IASMCFFactory;
import com.iplanet.ias.connectors.tools.security.PrincipalsTable;
import com.iplanet.ias.connectors.tools.security.SecurityException;
import com.iplanet.ias.connectors.util.xml.ConnectorDeploymentObject;
import com.sun.enterprise.ComponentInvocation;
import com.sun.enterprise.InvocationManager;
import com.sun.enterprise.J2EETransactionManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.resource.IASConnectorAllocator;
import com.sun.enterprise.resource.IASPoolHelper;
import com.sun.enterprise.resource.IASPoolHelperImp;
import com.sun.enterprise.resource.IASPoolManagerConstants;
import com.sun.enterprise.resource.IASPoolManagerException;
import com.sun.enterprise.resource.IASPoolObject;
import com.sun.enterprise.resource.IASPrincipalsMapping;
import com.sun.enterprise.resource.PortabilityUtils;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourcePoolManagerImpl;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.SecurityContext;
import com.sun.enterprise.security.auth.login.PasswordCredential;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

public class IASConnectionManagerImpl
implements ConnectionManager {
    private HashMap MCFTable = new HashMap(11);
    static Logger _logger = PortabilityUtils.GetPoolManagerLogger();
    private HashMap securityTable = null;

    private IASConnectionManagerImpl() throws IASDeploymentException, SecurityException {
        this.initializeSecurityTable();
        _logger.log(Level.FINE, "In end of IASConnectionManagerImpl constructor.");
    }

    public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        Object object;
        _logger.log(Level.FINE, "In start of IASConnectionManagerImpl.allocateConnection(...)");
        IASPoolObject iASPoolObject = null;
        Transaction transaction = null;
        Object object2 = null;
        String string = null;
        IASPoolHelperImp iASPoolHelperImp = this.getIASPoolHelper(managedConnectionFactory);
        _logger.log(Level.FINE, "after get PoolHelper");
        string = iASPoolHelperImp.toString();
        _logger.log(Level.FINE, "before get transaction level");
        int n = -1;
        try {
            n = this.getTransactionLevel(string);
        }
        catch (IASDeploymentException iASDeploymentException) {
            throw new ResourceException(iASDeploymentException.getMessage());
        }
        _logger.log(Level.FINE, "after get transaction level ");
        boolean bl = this.getSharingScope(string);
        _logger.log(Level.FINE, "after get SharingScope");
        if (this.isTransactional(n)) {
            transaction = this.getTransaction();
        }
        _logger.log(Level.FINE, "after get transaction");
        String string2 = ResourceReferenceDescriptor.APPLICATION_AUTHORIZATION;
        ResourceReferenceDescriptor resourceReferenceDescriptor = this.getResourceReferenceDescriptor(string);
        _logger.log(Level.FINE, "after get ResourceReferenceDescriptor");
        PrincipalImpl principalImpl = null;
        Subject subject = null;
        if (resourceReferenceDescriptor != null) {
            string2 = resourceReferenceDescriptor.getAuthorization();
            if (resourceReferenceDescriptor.isContainerAuthorization()) {
                _logger.log(Level.FINE, "Authorization is: Container !!!");
                object = SecurityContext.getCurrent();
                if (object == null) {
                    _logger.log(Level.FINE, "Before SecurityContext.init().");
                    SecurityContext.init();
                    object = SecurityContext.getCurrent();
                }
                if (!((SecurityContext)object).didServerGenerateCredentials()) {
                    _logger.log(Level.FINE, "After getting SecurityContext.");
                    principalImpl = (PrincipalImpl)((SecurityContext)object).getCallerPrincipal();
                    if (principalImpl == null) {
                        _logger.log(Level.FINE, "After getting SecurityContext principal is null.");
                        Object[] objectArray = new Object[]{principalImpl.getName(), string};
                        String string3 = MessageFormat.format(IASPoolManagerConstants.PRINCIPAL_IS_NULL, objectArray);
                        throw new ResourceException(string3, "3");
                    }
                    _logger.log(Level.FINE, "Before getSubject.");
                    subject = this.getSubject((SecurityContext)object, string, principalImpl, managedConnectionFactory);
                    _logger.log(Level.FINE, "After getSubject.");
                } else if (((SecurityContext)object).didServerGenerateCredentials()) {
                    subject = this.createServerSubject((SecurityContext)object, managedConnectionFactory);
                } else {
                    Object[] objectArray = new Object[]{string};
                    String string4 = MessageFormat.format(IASPoolManagerConstants.SECURITYCONTEXT_IS_NULL, objectArray);
                    throw new ResourceException(string4, "4");
                }
            }
        }
        try {
            _logger.log(Level.FINE, "Before getPooledConnection.");
            iASPoolObject = Switch.getSwitch().getResourcePoolManager().getPooledConnection(iASPoolHelperImp, connectionRequestInfo, subject, transaction, bl);
            _logger.log(Level.FINE, "After getPooledConnection.");
            object2 = iASPoolObject.getUnderlyingObject(subject, connectionRequestInfo);
        }
        catch (IASPoolManagerException iASPoolManagerException) {
            throw new ResourceException(iASPoolManagerException.getMessage(), iASPoolManagerException.getErrorCode());
        }
        _logger.log(Level.FINE, "Before Transaction code.");
        if (this.isTransactional(n) && iASPoolObject.getShareCount() == 0) {
            iASPoolObject.setTransactionLevel(n);
            object = this.createResourceHandle(iASPoolObject, n);
            try {
                ((ResourceHandle)object).fillInResourceObjects(object2, iASPoolObject.getXAResource(n, object2, iASPoolHelperImp, subject, transaction));
            }
            catch (IASPoolManagerException iASPoolManagerException) {
                throw new ResourceException(iASPoolManagerException.getMessage(), iASPoolManagerException.getErrorCode());
            }
            ((ResourceHandle)object).setPoolObject(iASPoolObject);
            ((ResourceHandle)object).setPoolHelper(iASPoolHelperImp);
            ((ResourceHandle)object).setSubject(subject);
            try {
                this.registerResource((ResourceHandle)object, transaction);
            }
            catch (IASPoolManagerException iASPoolManagerException) {
                throw new ResourceException(iASPoolManagerException.getMessage(), iASPoolManagerException.getErrorCode());
            }
        }
        _logger.log(Level.FINE, "After Transaction code.");
        return object2;
    }

    private Subject createServerSubject(SecurityContext securityContext, ManagedConnectionFactory managedConnectionFactory) {
        _logger.log(Level.FINE, "In start of IASConnectionManagerImpl.createServerSubject(...)");
        final PrincipalImpl principalImpl = (PrincipalImpl)securityContext.getCallerPrincipal();
        String string = "";
        final javax.resource.spi.security.PasswordCredential passwordCredential = new javax.resource.spi.security.PasswordCredential(principalImpl.getName(), string.toCharArray());
        passwordCredential.setManagedConnectionFactory(managedConnectionFactory);
        final Subject subject = new Subject();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                subject.getPrincipals().add(principalImpl);
                subject.getPrivateCredentials().add(passwordCredential);
                return null;
            }
        });
        _logger.log(Level.FINE, "In end of IASConnectionManagerImpl.createServerSubject(...)");
        return subject;
    }

    public static IASConnectionManagerImpl getConnectionManager() throws IASDeploymentException, SecurityException {
        IASConnectionManagerImpl iASConnectionManagerImpl = null;
        iASConnectionManagerImpl = (IASConnectionManagerImpl)Switch.getSwitch().getConnectionManager();
        if (iASConnectionManagerImpl == null) {
            iASConnectionManagerImpl = new IASConnectionManagerImpl();
        }
        return iASConnectionManagerImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IASPoolHelperImp getIASPoolHelper(ManagedConnectionFactory managedConnectionFactory) throws ResourceException {
        _logger.log(Level.FINE, "In start of IASConnectionManagerImpl.getIASPoolHelper(...)");
        IASPoolHelperImp iASPoolHelperImp = null;
        HashMap hashMap = this.MCFTable;
        synchronized (hashMap) {
            if (!this.MCFTable.isEmpty() && this.MCFTable.containsKey(managedConnectionFactory)) {
                iASPoolHelperImp = (IASPoolHelperImp)this.MCFTable.get(managedConnectionFactory);
            } else {
                iASPoolHelperImp = new IASPoolHelperImp(managedConnectionFactory);
                this.MCFTable.put(managedConnectionFactory, iASPoolHelperImp);
            }
        }
        _logger.log(Level.FINE, "In end of IASConnectionManagerImpl.getIASPoolHelper(...)");
        return iASPoolHelperImp;
    }

    private Subject getSubject(SecurityContext securityContext, String string, PrincipalImpl principalImpl, ManagedConnectionFactory managedConnectionFactory) throws ResourceException {
        _logger.log(Level.FINE, "In start of IASConnectionManagerImpl.getSubject(...)");
        IASPrincipalsMapping iASPrincipalsMapping = (IASPrincipalsMapping)this.securityTable.get(string);
        _logger.log(Level.FINE, "jndiName: " + string);
        if (iASPrincipalsMapping == null) {
            Object[] objectArray = new Object[]{principalImpl.getName(), string};
            String string2 = MessageFormat.format(IASPoolManagerConstants.SUBJECT_IS_NULL, objectArray);
            throw new ResourceException(string2, "2");
        }
        Subject subject = null;
        subject = iASPrincipalsMapping.getSubjectByPrincipal(principalImpl);
        if (subject == null) {
            subject = iASPrincipalsMapping.getDefaultSubject();
        }
        if (subject == null && (subject = securityContext.getSubject()) != null) {
            subject = this.createNewSubject(subject, managedConnectionFactory);
        }
        if (subject == null) {
            _logger.log(Level.FINE, "Subject is null!!!");
            Object[] objectArray = new Object[]{principalImpl.getName(), string};
            String string3 = MessageFormat.format(IASPoolManagerConstants.SUBJECT_IS_NULL, objectArray);
            throw new ResourceException(string3, "2");
        }
        _logger.log(Level.FINE, "In end of IASConnectionManagerImpl.getSubject(...)");
        return subject;
    }

    public Subject createNewSubject(final Subject subject, ManagedConnectionFactory managedConnectionFactory) {
        _logger.log(Level.FINE, "In start of IASConnectionManagerImpl.createNewSubject(...)");
        PasswordCredential passwordCredential = null;
        passwordCredential = (PasswordCredential)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Set<Object> set = subject.getPrivateCredentials();
                if (set.isEmpty()) {
                    return null;
                }
                Iterator<Object> iterator = set.iterator();
                PasswordCredential passwordCredential = null;
                if (iterator.hasNext()) {
                    passwordCredential = (PasswordCredential)iterator.next();
                }
                return passwordCredential;
            }
        });
        if (passwordCredential == null) {
            return null;
        }
        String string = passwordCredential.getUser();
        final PrincipalImpl principalImpl = new PrincipalImpl(string);
        String string2 = passwordCredential.getPassword();
        final javax.resource.spi.security.PasswordCredential passwordCredential2 = new javax.resource.spi.security.PasswordCredential(string, string2.toCharArray());
        passwordCredential2.setManagedConnectionFactory(managedConnectionFactory);
        final Subject subject2 = new Subject();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                subject2.getPrincipals().add(principalImpl);
                subject2.getPrivateCredentials().add(passwordCredential2);
                return null;
            }
        });
        _logger.log(Level.FINE, "In end of IASConnectionManagerImpl.createNewSubject(...)");
        return subject2;
    }

    private void initializeSecurityTable() throws IASDeploymentException, SecurityException {
        _logger.log(Level.FINE, "In start of IASConnectionManagerImpl.initializeSecurityTable(...)");
        IASMCFFactory iASMCFFactory = IASMCFFactory.getMCFFactory();
        _logger.log(Level.FINE, "After getting IASMCFFactory.");
        Set set = iASMCFFactory.getJNDINameList();
        _logger.log(Level.FINE, "After getting listOfJNDIName.");
        Iterator iterator = set.iterator();
        this.securityTable = new HashMap(11);
        _logger.log(Level.FINE, "After creating securityTable.");
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            _logger.log(Level.FINE, "JNDIName: " + string);
            this.addPrincipalsMapping(iASMCFFactory, string);
        }
        _logger.log(Level.FINE, "In end of IASConnectionManagerImpl.initializeSecurityTable(...)");
    }

    public void addPrincipalsMapping(IASMCFFactory iASMCFFactory, String string) {
        _logger.log(Level.FINE, "In start of IASConnectionManagerImpl.addPrincipalsMapping(...)");
        IASPrincipalsMapping iASPrincipalsMapping = this.createIASPrincipalsMapping(iASMCFFactory, string);
        this.securityTable.put(string, iASPrincipalsMapping);
        _logger.log(Level.FINE, "In end of IASConnectionManagerImpl.addPrincipalsMapping(...)");
    }

    public void removePrincipalsMapping(String string) {
        _logger.log(Level.FINE, "In start of IASConnectionManagerImpl.removePrincipalsMapping(...)");
        this.securityTable.remove(string);
        _logger.log(Level.FINE, "In end of IASConnectionManagerImpl.removePrincipalsMapping(...)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePools(ManagedConnectionFactory managedConnectionFactory) {
        _logger.log(Level.FINE, "In start of IASConnectionManagerImpl.removePools(...)");
        HashMap hashMap = this.MCFTable;
        synchronized (hashMap) {
            IASPoolHelper iASPoolHelper = (IASPoolHelper)this.MCFTable.get(managedConnectionFactory);
            if (iASPoolHelper != null) {
                ResourcePoolManagerImpl resourcePoolManagerImpl = (ResourcePoolManagerImpl)Switch.getSwitch().getResourcePoolManager();
                resourcePoolManagerImpl.removePools(iASPoolHelper);
            }
            this.MCFTable.remove(managedConnectionFactory);
        }
        _logger.log(Level.FINE, "In end of IASConnectionManagerImpl.removePools(...)");
    }

    private IASPrincipalsMapping createIASPrincipalsMapping(IASMCFFactory iASMCFFactory, String string) {
        _logger.log(Level.FINE, "In start of IASConnectionManagerImpl.createIASPrincipalsMapping(...)");
        ManagedConnectionFactory managedConnectionFactory = null;
        String string2 = null;
        String string3 = null;
        PrincipalsTable principalsTable = null;
        try {
            managedConnectionFactory = iASMCFFactory.getManagedConnectionFactory(string);
            _logger.log(Level.FINE, "After getting MCF.");
        }
        catch (IASDeploymentException iASDeploymentException) {
            // empty catch block
        }
        if (managedConnectionFactory != null) {
            string2 = iASMCFFactory.getUserByMCF(managedConnectionFactory);
            _logger.log(Level.FINE, "After getting defaultUser.");
            string3 = iASMCFFactory.getPasswordByMCF(managedConnectionFactory);
            _logger.log(Level.FINE, "After getting defaultPassword.");
        }
        try {
            principalsTable = iASMCFFactory.getSecurityTableByJndiName(string);
            _logger.log(Level.FINE, "After getting securityInfoTable for connector: " + string);
        }
        catch (IASDeploymentException iASDeploymentException) {
            _logger.log(Level.FINE, iASDeploymentException.getMessage());
        }
        if (managedConnectionFactory == null && string2 == null && string3 == null && principalsTable == null) {
            _logger.log(Level.FINE, "IASPrincipalsMapping is null.");
            return null;
        }
        IASPrincipalsMapping iASPrincipalsMapping = new IASPrincipalsMapping();
        iASPrincipalsMapping.setMCF(managedConnectionFactory);
        iASPrincipalsMapping.setDefaultUser(string2);
        iASPrincipalsMapping.setDefaultPassword(string3);
        iASPrincipalsMapping.setSecurityInfoTable(principalsTable);
        _logger.log(Level.FINE, "return IASPrincipalsMapping instance.");
        return iASPrincipalsMapping;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        _logger.log(Level.FINE, "In end of IASConnectionManagerImpl.readObject(...).");
    }

    private Object readResolve() throws ObjectStreamException {
        return Switch.getSwitch().getConnectionManager();
    }

    private int getTransactionLevel(String string) throws IASDeploymentException {
        _logger.log(Level.FINE, "In start of IASConnectionManagerImpl.getTransactionLevel(...)");
        ConnectorDeploymentObject connectorDeploymentObject = null;
        IASMCFFactory iASMCFFactory = IASMCFFactory.getMCFFactory();
        connectorDeploymentObject = iASMCFFactory.getDescriptorByJndiName(string);
        int n = connectorDeploymentObject.getTransactionSupport();
        _logger.log(Level.FINE, "tranLevel=" + n);
        _logger.log(Level.FINE, "In end of IASConnectionManagerImpl.getTransactionLevel(...)");
        return n;
    }

    private boolean getSharingScope(String string) throws ResourceException {
        ResourceReferenceDescriptor resourceReferenceDescriptor = this.getResourceReferenceDescriptor(string);
        if (resourceReferenceDescriptor != null) {
            String string2 = resourceReferenceDescriptor.getSharingScope();
            if (string2.equals(ResourceReferenceDescriptor.RESOURCE_UNSHAREABLE)) {
                return false;
            }
            if (string2.equals(ResourceReferenceDescriptor.RESOURCE_SHAREABLE)) {
                return true;
            }
        }
        return false;
    }

    private Transaction getTransaction() throws ResourceException {
        Transaction transaction = null;
        InvocationManager invocationManager = Switch.getSwitch().getInvocationManager();
        ComponentInvocation componentInvocation = invocationManager.getCurrentInvocation();
        if (componentInvocation == null) {
            throw new ResourceException(IASPoolManagerConstants.FAIL_TO_GET_CURRENT_INVOCATION);
        }
        transaction = componentInvocation.getTransaction();
        return transaction;
    }

    private void registerResource(ResourceHandle resourceHandle, Transaction transaction) throws IASPoolManagerException {
        try {
            J2EETransactionManager j2EETransactionManager = Switch.getSwitch().getTransactionManager();
            if (transaction != null) {
                j2EETransactionManager.enlistResource(transaction, resourceHandle);
                j2EETransactionManager.registerComponentResource(resourceHandle);
            }
        }
        catch (RollbackException rollbackException) {
            throw new IASPoolManagerException(rollbackException.getMessage());
        }
        catch (IllegalStateException illegalStateException) {
            throw new IASPoolManagerException(illegalStateException.getMessage());
        }
        catch (SystemException systemException) {
            throw new IASPoolManagerException(systemException.getMessage());
        }
    }

    private ResourceHandle createResourceHandle(IASPoolObject iASPoolObject, int n) {
        boolean bl = n == 2;
        IASConnectorAllocator iASConnectorAllocator = new IASConnectorAllocator();
        ResourceHandle resourceHandle = new ResourceHandle(iASPoolObject.getPoolObject(), null, iASConnectorAllocator, null, bl);
        return resourceHandle;
    }

    private boolean isTransactional(int n) {
        return n == 2 || n == 1;
    }

    private ResourceReferenceDescriptor getResourceReferenceDescriptor(String string) throws ResourceException {
        _logger.log(Level.FINE, "In start of IASConnectionManagerImpl.getResourceReferenceDescriptor(...)");
        InvocationManager invocationManager = Switch.getSwitch().getInvocationManager();
        if (invocationManager == null) {
            return null;
        }
        ComponentInvocation componentInvocation = null;
        componentInvocation = invocationManager.getCurrentInvocation();
        if (componentInvocation == null) {
            throw new ResourceException(IASPoolManagerConstants.FAIL_TO_GET_CURRENT_INVOCATION);
        }
        Set set = null;
        Object object = componentInvocation.getContainerContext();
        JndiNameEnvironment jndiNameEnvironment = (JndiNameEnvironment)Switch.getSwitch().getDescriptorFor(object);
        if (jndiNameEnvironment == null) {
            return null;
        }
        set = jndiNameEnvironment.getResourceReferenceDescriptors();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ResourceReferenceDescriptor resourceReferenceDescriptor = (ResourceReferenceDescriptor)iterator.next();
            String string2 = resourceReferenceDescriptor.getJndiName();
            if (!string.equals(string2)) continue;
            _logger.log(Level.FINE, "In getResourceReferenceDescriptor-->found Descriptor!!!");
            return resourceReferenceDescriptor;
        }
        _logger.log(Level.FINE, "In getResourceReferenceDescriptor-->NOT found Descriptor!!!");
        return null;
    }
}

