/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.repository;

import com.sun.enterprise.repository.J2EEResource;
import com.sun.enterprise.repository.J2EEResourceBase;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.util.Utility;
import java.io.Serializable;
import java.util.Iterator;

public class JdbcConnectionPool
extends J2EEResourceBase
implements Serializable {
    private String userName_;
    private String password_;
    private String datasourceClassname_;
    private String steadyPoolSize_;
    private String maxPoolSize_;
    private String maxWaitTimeInMillis_;
    private String poolResizeQuantity_;
    private String idleTimeoutInSeconds_;
    private boolean isConnectionValidationRequired_;
    private String connectionValidationMethod_;
    private String validationTableName_;
    private boolean failAllConnections_;
    private boolean perfMonitor = false;
    private String resType_;
    private String transactionIsolationLevel_;
    private boolean isIsolationLevelGuaranteed_;
    private transient Object cachedVendorDataSource = null;
    private boolean noNonTxOps = false;
    static /* synthetic */ Class class$javax$sql$XADataSource;

    public JdbcConnectionPool(String string) {
        super(string);
    }

    protected J2EEResource doClone(String string) {
        JdbcConnectionPool jdbcConnectionPool = new JdbcConnectionPool(string);
        jdbcConnectionPool.setUserName(this.getUserName());
        jdbcConnectionPool.setPassword(this.getPassword());
        jdbcConnectionPool.setDatasourceClassname(this.getDatasourceClassname());
        jdbcConnectionPool.setMaxPoolSize(this.getMaxPoolSize());
        jdbcConnectionPool.setMaxWaitTimeInMillis(this.getMaxWaitTimeInMillis());
        jdbcConnectionPool.setPoolResizeQuantity(this.getPoolResizeQuantity());
        jdbcConnectionPool.setIdleTimeoutInSeconds(this.getIdleTimeoutInSeconds());
        jdbcConnectionPool.setIsConnectionValidationRequired(this.isIsConnectionValidationRequired());
        jdbcConnectionPool.setConnectionValidationMethod(this.getConnectionValidationMethod());
        jdbcConnectionPool.setValidationTableName(this.getValidationTableName());
        jdbcConnectionPool.setFailAllConnections(this.isFailAllConnections());
        jdbcConnectionPool.setResType(this.getResType());
        jdbcConnectionPool.setTransactionIsolationLevel(this.getTransactionIsolationLevel());
        jdbcConnectionPool.setIsIsolationLevelGuaranteed(this.isIsolationLevelGuaranteed());
        return jdbcConnectionPool;
    }

    public int getType() {
        return 8;
    }

    public String getUserName() {
        return this.userName_;
    }

    public void setUserName(String string) {
        this.userName_ = string;
    }

    public String getPassword() {
        return this.password_;
    }

    public void setPassword(String string) {
        this.password_ = string;
    }

    public String getDatasourceClassname() {
        return this.datasourceClassname_;
    }

    public void setDatasourceClassname(String string) {
        this.datasourceClassname_ = string;
    }

    public String getSteadyPoolSize() {
        return this.steadyPoolSize_;
    }

    public void setSteadyPoolSize(String string) {
        this.steadyPoolSize_ = string;
    }

    public String getMaxPoolSize() {
        return this.maxPoolSize_;
    }

    public void setMaxPoolSize(String string) {
        this.maxPoolSize_ = string;
    }

    public String getMaxWaitTimeInMillis() {
        return this.maxWaitTimeInMillis_;
    }

    public void setMaxWaitTimeInMillis(String string) {
        this.maxWaitTimeInMillis_ = string;
    }

    public String getPoolResizeQuantity() {
        return this.poolResizeQuantity_;
    }

    public void setPoolResizeQuantity(String string) {
        this.poolResizeQuantity_ = string;
    }

    public String getIdleTimeoutInSeconds() {
        return this.idleTimeoutInSeconds_;
    }

    public void setIdleTimeoutInSeconds(String string) {
        this.idleTimeoutInSeconds_ = string;
    }

    public boolean isIsConnectionValidationRequired() {
        return this.isConnectionValidationRequired_;
    }

    public void setIsConnectionValidationRequired(boolean bl) {
        this.isConnectionValidationRequired_ = bl;
    }

    public String getConnectionValidationMethod() {
        return this.connectionValidationMethod_;
    }

    public void setConnectionValidationMethod(String string) {
        this.connectionValidationMethod_ = string;
    }

    public String getValidationTableName() {
        return this.validationTableName_;
    }

    public void setValidationTableName(String string) {
        this.validationTableName_ = string;
    }

    public boolean isFailAllConnections() {
        return this.failAllConnections_;
    }

    public void setFailAllConnections(boolean bl) {
        this.failAllConnections_ = bl;
    }

    public String getResType() {
        return this.resType_;
    }

    public void setResType(String string) {
        this.resType_ = string;
    }

    public String getTransactionIsolationLevel() {
        return this.transactionIsolationLevel_;
    }

    public void setTransactionIsolationLevel(String string) {
        this.transactionIsolationLevel_ = string;
    }

    public boolean isIsolationLevelGuaranteed() {
        return this.isIsolationLevelGuaranteed_;
    }

    public void setIsIsolationLevelGuaranteed(boolean bl) {
        this.isIsolationLevelGuaranteed_ = bl;
    }

    public String toString() {
        return "< JDBC Connection Pool : " + this.getName() + "... >";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object createDataSource() throws J2EEResourceException {
        JdbcConnectionPool jdbcConnectionPool = this;
        synchronized (jdbcConnectionPool) {
            if (this.cachedVendorDataSource == null) {
                try {
                    Class clazz = Utility.loadClass(this.getDatasourceClassname());
                    this.cachedVendorDataSource = clazz.newInstance();
                    Iterator iterator = this.getProperties().iterator();
                    while (iterator.hasNext()) {
                        ResourceProperty resourceProperty = (ResourceProperty)iterator.next();
                        Utility.invokeSetMethodCaseInsensitive(this.cachedVendorDataSource, resourceProperty.getName(), resourceProperty.getValue().toString());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new J2EEResourceException(exception);
                }
            }
        }
        return this.cachedVendorDataSource;
    }

    public boolean isXA() {
        boolean bl;
        block4: {
            bl = false;
            if (this.resType_ == null) {
                return false;
            }
            if (!this.resType_.equals("javax.sql.XADataSource") || this.datasourceClassname_ == null) break block4;
            try {
                Class clazz = Utility.loadClass(this.getDatasourceClassname());
                if ((class$javax$sql$XADataSource == null ? (class$javax$sql$XADataSource = JdbcConnectionPool.class$("javax.sql.XADataSource")) : class$javax$sql$XADataSource).isAssignableFrom(clazz)) {
                    bl = true;
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return bl;
    }

    public void addProperty(ResourceProperty resourceProperty) {
        String string = resourceProperty.getName();
        if (string.equalsIgnoreCase("user")) {
            this.setUserName((String)resourceProperty.getValue());
        } else if (string.equalsIgnoreCase("password")) {
            this.setPassword((String)resourceProperty.getValue());
        }
        if (string.equalsIgnoreCase("xa-driver-does-not-support-non-tx-operations")) {
            if (((String)resourceProperty.getValue()).equalsIgnoreCase("true")) {
                this.noNonTxOps = true;
            }
            return;
        }
        if (string.equalsIgnoreCase("perf-monitor")) {
            if (((String)resourceProperty.getValue()).equalsIgnoreCase("true")) {
                this.perfMonitor = true;
            }
            return;
        }
        super.addProperty(resourceProperty);
    }

    public boolean isPerfMonitor() {
        return this.perfMonitor;
    }

    public boolean getNoNonTxOps() {
        return this.noNonTxOps;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

