/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.enterprise.PoolManager;
import com.sun.enterprise.Switch;
import com.sun.enterprise.jms.SessionWrapper;
import com.sun.enterprise.resource.PoolingException;
import com.sun.enterprise.resource.ResourceAllocator;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.resource.ResourceSpec;
import com.sun.jms.spi.xa.JMSXASession;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import javax.transaction.xa.XAResource;

public class SimpleAllocator
implements ResourceAllocator {
    private static final boolean debug = false;
    private static final String QUEUE_RESOURCE_TYPE = "javax.jms.QueueSession";
    private static final String TOPIC_RESOURCE_TYPE = "javax.jms.TopicSession";
    private static final String JMS_RESOURCE_FACTORY = "JMS";
    private String resourceType_;
    static Logger _logger = null;

    public SimpleAllocator(boolean bl) {
        this.resourceType_ = bl ? QUEUE_RESOURCE_TYPE : TOPIC_RESOURCE_TYPE;
    }

    public ResourceHandle createResource() throws PoolingException {
        throw new PoolingException("Not supported");
    }

    public ResourceHandle createResource(SessionWrapper sessionWrapper) throws PoolingException {
        ResourceHandle resourceHandle;
        try {
            Switch switch_ = Switch.getSwitch();
            PoolManager poolManager = switch_.getPoolManager();
            ResourceSpec resourceSpec = new ResourceSpec(JMS_RESOURCE_FACTORY, 2);
            JMSXASession jMSXASession = sessionWrapper.getDelegateXA();
            resourceHandle = new ResourceHandle(jMSXASession, resourceSpec, this, null);
            XAResource xAResource = jMSXASession.getXAResource();
            resourceHandle.fillInResourceObjects(sessionWrapper, xAResource);
        }
        catch (Exception exception) {
            _logger.log(Level.SEVERE, "jms.create_resource_failed", exception);
            throw new PoolingException(exception);
        }
        return resourceHandle;
    }

    public void fillInResourceObjects(ResourceHandle resourceHandle) throws PoolingException {
        throw new PoolingException("Not supported");
    }

    public void closeUserConnection(ResourceHandle resourceHandle) throws PoolingException {
        this.cleanup(resourceHandle);
    }

    public void destroyResource(ResourceHandle resourceHandle) throws PoolingException {
        this.cleanup(resourceHandle);
    }

    public boolean matchConnection(ResourceHandle resourceHandle) {
        return false;
    }

    public boolean supportsReauthentication() {
        return false;
    }

    public void cleanup(ResourceHandle resourceHandle) throws PoolingException {
        try {
            SessionWrapper sessionWrapper = (SessionWrapper)resourceHandle.getUserConnection();
            if (sessionWrapper == null) {
                throw new PoolingException("Invalid resource handle " + resourceHandle);
            }
            sessionWrapper.close();
        }
        catch (JMSException jMSException) {
            throw new PoolingException((Exception)((Object)jMSException));
        }
    }

    public boolean isTransactional() {
        return true;
    }

    public boolean shareableWithinComponent() {
        return false;
    }

    public Object getSharedConnection(ResourceHandle resourceHandle) throws PoolingException {
        throw new IllegalStateException("getSharedConnection not supported");
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.jms");
    }
}

