/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jms;

import com.sun.enterprise.Switch;
import com.sun.enterprise.jms.ConnectionWrapper;
import com.sun.enterprise.jms.JmsWrapperFactory;
import com.sun.enterprise.jms.SessionWrapper;
import com.sun.enterprise.resource.ResourceHandle;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.jms.spi.xa.JMSXAQueueSession;
import com.sun.jms.spi.xa.JMSXASession;
import com.sun.jms.spi.xa.JMSXATopicSession;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class SessionWrapperBase
implements SessionWrapper {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$jms$SessionWrapperBase == null ? (class$com$sun$enterprise$jms$SessionWrapperBase = SessionWrapperBase.class$("com.sun.enterprise.jms.SessionWrapperBase")) : class$com$sun$enterprise$jms$SessionWrapperBase);
    private static final boolean debug = false;
    private JMSXASession delegateXA_;
    private JmsWrapperFactory wrapperFactory_;
    private ConnectionWrapper parent_;
    private ResourceHandle resourceHandle_;
    private boolean closed_;
    static Logger _logger = null;
    static /* synthetic */ Class class$com$sun$enterprise$jms$SessionWrapperBase;

    public SessionWrapperBase(JMSXASession jMSXASession, JmsWrapperFactory jmsWrapperFactory, ConnectionWrapper connectionWrapper) {
        this.delegateXA_ = jMSXASession;
        this.wrapperFactory_ = jmsWrapperFactory;
        this.parent_ = connectionWrapper;
        this.resourceHandle_ = null;
        this.closed_ = false;
    }

    public BytesMessage createBytesMessage() throws JMSException {
        return this.getDelegate().createBytesMessage();
    }

    public MapMessage createMapMessage() throws JMSException {
        return this.getDelegate().createMapMessage();
    }

    public Message createMessage() throws JMSException {
        return this.getDelegate().createMessage();
    }

    public ObjectMessage createObjectMessage() throws JMSException {
        return this.getDelegate().createObjectMessage();
    }

    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        return this.getDelegate().createObjectMessage(serializable);
    }

    public StreamMessage createStreamMessage() throws JMSException {
        return this.getDelegate().createStreamMessage();
    }

    public TextMessage createTextMessage() throws JMSException {
        return this.getDelegate().createTextMessage();
    }

    public TextMessage createTextMessage(String string) throws JMSException {
        return this.getDelegate().createTextMessage(string);
    }

    public boolean getTransacted() throws JMSException {
        return this.getDelegate().getTransacted();
    }

    public void commit() throws JMSException {
        this.getDelegate().commit();
    }

    public void rollback() throws JMSException {
        this.getDelegate().rollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        Object object;
        SessionWrapperBase sessionWrapperBase = this;
        synchronized (sessionWrapperBase) {
            if (this.closed_) {
                return;
            }
            this.closed_ = true;
        }
        Switch switch_ = Switch.getSwitch();
        if (this.resourceHandle_ != null) {
            object = switch_.getPoolManager();
            object.unregisterResource(this.resourceHandle_, 0x4000000);
            this.resourceHandle_ = null;
        }
        object = null;
        try {
            this.getDelegateXA().close();
        }
        catch (JMSException jMSException) {
            object = jMSException;
        }
        this.parent_.sessionClosed(this);
        if (object != null) {
            throw object;
        }
    }

    public void recover() throws JMSException {
        this.getDelegate().recover();
    }

    public MessageListener getMessageListener() throws JMSException {
        return this.getDelegate().getMessageListener();
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        this.getDelegate().setMessageListener(messageListener);
    }

    public void run() {
        try {
            this.getDelegate().run();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    public Queue createQueue(String string) throws JMSException {
        return this.getQueueDelegate().createQueue(string);
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        QueueReceiver queueReceiver = this.getQueueDelegate().createReceiver(queue);
        return this.wrapperFactory_.createQueueReceiverWrapper(queueReceiver);
    }

    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        QueueReceiver queueReceiver = this.getQueueDelegate().createReceiver(queue, string);
        return this.wrapperFactory_.createQueueReceiverWrapper(queueReceiver);
    }

    public QueueSender createSender(Queue queue) throws JMSException {
        return this.getQueueDelegate().createSender(queue);
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.getQueueDelegate().createBrowser(queue);
    }

    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        return this.getQueueDelegate().createBrowser(queue, string);
    }

    public TemporaryQueue createTemporaryQueue() throws JMSException {
        return this.getQueueDelegate().createTemporaryQueue();
    }

    public Topic createTopic(String string) throws JMSException {
        return this.getTopicDelegate().createTopic(string);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        TopicSubscriber topicSubscriber = this.getTopicDelegate().createSubscriber(topic);
        return this.wrapperFactory_.createTopicSubscriberWrapper(topicSubscriber);
    }

    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        TopicSubscriber topicSubscriber = this.getTopicDelegate().createSubscriber(topic, string, bl);
        return this.wrapperFactory_.createTopicSubscriberWrapper(topicSubscriber);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        TopicSubscriber topicSubscriber = this.getTopicDelegate().createDurableSubscriber(topic, string);
        return this.wrapperFactory_.createTopicSubscriberWrapper(topicSubscriber);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        TopicSubscriber topicSubscriber = this.getTopicDelegate().createDurableSubscriber(topic, string, string2, bl);
        return this.wrapperFactory_.createTopicSubscriberWrapper(topicSubscriber);
    }

    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        return this.getTopicDelegate().createPublisher(topic);
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        return this.getTopicDelegate().createTemporaryTopic();
    }

    public void unsubscribe(String string) throws JMSException {
        this.getTopicDelegate().unsubscribe(string);
    }

    public void setResourceHandle(ResourceHandle resourceHandle) {
        this.resourceHandle_ = resourceHandle;
    }

    public ResourceHandle getResourceHandle() {
        return this.resourceHandle_;
    }

    public Session getDelegate() throws JMSException {
        JMSXASession jMSXASession = this.getDelegateXA();
        return jMSXASession instanceof JMSXAQueueSession ? this.getQueueDelegate() : this.getTopicDelegate();
    }

    public JMSXASession getDelegateXA() {
        return this.delegateXA_;
    }

    public JMSXAQueueSession getQueueDelegateXA() {
        return (JMSXAQueueSession)this.getDelegateXA();
    }

    public JMSXATopicSession getTopicDelegateXA() {
        return (JMSXATopicSession)this.getDelegateXA();
    }

    public QueueSession getQueueDelegate() throws JMSException {
        return this.getQueueDelegateXA().getQueueSession();
    }

    public TopicSession getTopicDelegate() throws JMSException {
        return this.getTopicDelegateXA().getTopicSession();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.resource.jms");
    }
}

