/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.iplanet.ias.deployment.EjbBundleXmlReader;
import com.iplanet.ias.deployment.Utils;
import com.iplanet.ias.tools.common.dd.ejb.SunEjbJar;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class EjbBundleArchivist
extends Archivist {
    public static String DEPLOYMENT_DESCRIPTOR_ENTRY = "META-INF/ejb-jar.xml";
    public static String IAS_DEPLOYMENT_DESCRIPTOR_ENTRY = "META-INF/sun-ejb-jar.xml";
    private EjbBundleDescriptor ejbBundleDescriptor;
    private ClassLoader classLoader = null;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$EjbBundleArchivist == null ? (class$com$sun$enterprise$deployment$EjbBundleArchivist = EjbBundleArchivist.class$("com.sun.enterprise.deployment.EjbBundleArchivist")) : class$com$sun$enterprise$deployment$EjbBundleArchivist);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbBundleArchivist;

    public EjbBundleArchivist(String string, EjbBundleDescriptor ejbBundleDescriptor) {
        this(true, string, ejbBundleDescriptor, new HashSet());
    }

    public EjbBundleArchivist(String string, EjbBundleDescriptor ejbBundleDescriptor, Set set) {
        this(true, string, ejbBundleDescriptor, set);
    }

    public EjbBundleArchivist(boolean bl, String string, EjbBundleDescriptor ejbBundleDescriptor, Set set) {
        super(string, bl);
        this.manifestClasspath = set;
        this.ejbBundleDescriptor = ejbBundleDescriptor;
        this.ejbBundleDescriptor.setArchivist(this);
    }

    public ClassLoader getClassLoader() {
        block3: {
            if (this.classLoader != null) break block3;
            if (this.ejbBundleDescriptor.getApplication() != null) {
                return this.ejbBundleDescriptor.getApplication().getApplicationArchivist().getClassLoader();
            }
            try {
                JarClassLoader jarClassLoader = new JarClassLoader();
                jarClassLoader.addJar(new File(this.getArchiveUri()).getAbsolutePath());
                this.classLoader = jarClassLoader;
            }
            catch (IOException iOException) {
                _logger.log(Level.WARNING, "enterprise.deployment_ioexcp", iOException);
            }
        }
        return this.classLoader;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Descriptor getDescriptor() {
        return this.ejbBundleDescriptor;
    }

    protected File getArchiveFile() throws IOException {
        if (!this.hasArchive()) {
            throw new IOException("No archive file for " + this);
        }
        File file = null;
        Application application = this.ejbBundleDescriptor.getApplication();
        if (application != null) {
            ApplicationArchivist applicationArchivist = application.getApplicationArchivist();
            File file2 = applicationArchivist.getApplicationFile();
            file = Archivist.getEjbTemp(Archivist.getDirectory(file2));
            applicationArchivist.extractBundleToFile(this.ejbBundleDescriptor, file);
            file.deleteOnExit();
        } else {
            file = this.getEjbJarFile();
        }
        return file;
    }

    public File getArchiveFile_() throws IOException {
        return this.getArchiveFile();
    }

    public static boolean isEjbBundle(File file) throws IOException {
        Archivist.checkExists(file);
        JarFile jarFile = new JarFile(file);
        ZipEntry zipEntry = jarFile.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        boolean bl = zipEntry != null;
        jarFile.close();
        return bl;
    }

    public Hashtable createEntryNameMap(FileContentsDescriptor fileContentsDescriptor) throws IOException {
        Hashtable hashtable = super.createEntryNameMap(fileContentsDescriptor);
        hashtable.remove(DEPLOYMENT_DESCRIPTOR_ENTRY);
        return hashtable;
    }

    private boolean isStructuralEjbClass(EjbDescriptor ejbDescriptor, String string) {
        return ejbDescriptor.getHomeClassName().equals(string) || ejbDescriptor.getRemoteClassName().equals(string) || ejbDescriptor.getLocalHomeClassName().equals(string) || ejbDescriptor.getLocalClassName().equals(string) || ejbDescriptor.getEjbClassName().equals(string);
    }

    private boolean isStructuralEjbBundleClass(EjbBundleDescriptor ejbBundleDescriptor, String string) {
        boolean bl = false;
        Set set = ejbBundleDescriptor.getEjbs();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator.next();
            if (!this.isStructuralEjbClass(ejbDescriptor, string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean isDeletable(String string) {
        boolean bl = true;
        if (string.equals("META-INF/MANIFEST.MF") || string.equals(DEPLOYMENT_DESCRIPTOR_ENTRY)) {
            bl = false;
        }
        return bl;
    }

    public static void createPackage(FileContentsDescriptor fileContentsDescriptor, File file, File file2) throws IOException, ArchiveException {
        if (!file.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptioncannotpackageejbs", "Cannot package Ejbs: {0} does not exist.", new Object[]{file}));
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        EjbBundleDescriptor ejbBundleDescriptor = null;
        Vector vector = EjbBundleNode.readEjbBundleNodes(fileInputStream, false);
        fileInputStream.close();
        if (vector.size() > 0) {
            Object object;
            EjbBundleNode ejbBundleNode = (EjbBundleNode)((Object)vector.elementAt(0));
            ejbBundleDescriptor = ejbBundleNode.getDescriptor();
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            EjbBundleArchivist ejbBundleArchivist = new EjbBundleArchivist(file2.toString(), ejbBundleDescriptor);
            ejbBundleArchivist.setClassLoader(fileContentsDescriptor.getClassLoader());
            ejbBundleNode.completeLoadingDescriptor(ejbBundleDescriptor);
            Enumeration enumeration = fileContentsDescriptor.getFiles();
            while (enumeration.hasMoreElements()) {
                object = (File)enumeration.nextElement();
                File file3 = fileContentsDescriptor.getFullFileFor((File)object);
                String string = ((File)object).toString();
                string = string.replace(File.separatorChar, '/');
                ZipEntry zipEntry = new ZipEntry(string);
                zipEntry.setTime(System.currentTimeMillis());
                fileInputStream = new FileInputStream(file3);
                zipOutputStream.putNextEntry(zipEntry);
                ApplicationArchivist.copy(fileInputStream, zipOutputStream);
                fileInputStream.close();
                zipOutputStream.closeEntry();
            }
            ejbBundleArchivist.writeDeploymentInfo(zipOutputStream);
            object = ejbBundleArchivist.createManifest();
            EjbBundleArchivist.writeManifest((Manifest)object, zipOutputStream);
            zipOutputStream.close();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.createdejbjar", "Created EJB JAR {0}", new Object[]{file2}));
            }
        } else if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.nodeployinfoindescriptorfile", "There was no deployment information in {0}", new Object[]{file}));
        }
    }

    public void writeDeploymentInfo(ZipOutputStream zipOutputStream) throws IOException {
        this.writeDeploymentInfo(zipOutputStream, DEPLOYMENT_DESCRIPTOR_ENTRY);
    }

    private void writeDeploymentInfo(ZipOutputStream zipOutputStream, String string) throws IOException {
        Archivist.writeDocumentToJar((Document)EjbBundleNode.getDocument(this.ejbBundleDescriptor), string, zipOutputStream);
    }

    public static EjbBundleDescriptor open(File file, String string, JarFile jarFile, ApplicationArchivist applicationArchivist) throws IOException, ArchiveException {
        try {
            return EjbBundleArchivist.open(file, string, jarFile, applicationArchivist, false);
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
    }

    public static EjbBundleDescriptor open(File file, String string, JarFile jarFile, ApplicationArchivist applicationArchivist, boolean bl) throws IOException, ArchiveException, SAXParseException {
        if (!file.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionejbjarafiledoesnotexist", "{0} does not exist", new Object[]{file}));
        }
        ZipEntry zipEntry = jarFile.getEntry(string);
        if (zipEntry != null) {
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            if (bl) {
                Archivist.validate(jarFile.getInputStream(zipEntry));
            }
            EjbBundleNode ejbBundleNode = EjbBundleNode.read(inputStream, bl);
            inputStream.close();
            EjbBundleDescriptor ejbBundleDescriptor = ejbBundleNode.getDescriptor();
            EjbBundleArchivist ejbBundleArchivist = new EjbBundleArchivist(file.toString(), ejbBundleDescriptor);
            ejbBundleArchivist.setManifestClasspaths(jarFile.getManifest());
            if (applicationArchivist != null) {
                ejbBundleArchivist.setClassLoader(applicationArchivist.getClassLoader());
            }
            ejbBundleNode.completeLoadingDescriptor(ejbBundleDescriptor);
            return ejbBundleDescriptor;
        }
        throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionnodeoployinfofoundatinjarcontainerdescriptor", "No deployment info found at: {0} in {1}", new Object[]{string, jarFile.getName()}));
    }

    static EjbBundleDescriptor open(File file) throws IOException, ArchiveException {
        return EjbBundleArchivist.open(file, null);
    }

    static EjbBundleDescriptor open(File file, ApplicationArchivist applicationArchivist) throws IOException, ArchiveException {
        try {
            return EjbBundleArchivist.open(file, applicationArchivist, false);
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
    }

    public static EjbBundleDescriptor open(File file, ApplicationArchivist applicationArchivist, boolean bl) throws IOException, ArchiveException, SAXParseException {
        if (!file.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionejabjardoesnotexist", "{0} does not exist", new Object[]{file}));
        }
        JarFile jarFile = new JarFile(file);
        EjbBundleDescriptor ejbBundleDescriptor = EjbBundleArchivist.open(file, DEPLOYMENT_DESCRIPTOR_ENTRY, jarFile, applicationArchivist, bl);
        jarFile.close();
        return ejbBundleDescriptor;
    }

    public File getEjbJarFile() {
        return new File(this.getArchiveUri());
    }

    void save(File file, String string, ZipOutputStream zipOutputStream) throws IOException {
        File file2 = Archivist.getEjbTemp(Archivist.getDirectory(file));
        ZipOutputStream zipOutputStream2 = new ZipOutputStream(new FileOutputStream(file2));
        if (zipOutputStream == null) {
            this.writeDeploymentInfo(zipOutputStream2, string);
        } else {
            this.writeDeploymentInfo(zipOutputStream, string);
        }
        Manifest manifest = super.createManifest();
        EjbBundleArchivist.writeManifest(manifest, zipOutputStream2);
        Vector<String> vector = new Vector<String>();
        if (zipOutputStream == null) {
            vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        }
        vector.addElement("META-INF/MANIFEST.MF");
        this.writeEntriesToOutput(zipOutputStream2, vector);
        zipOutputStream2.close();
        file.delete();
        boolean bl = file2.renameTo(file);
        if (!bl) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrorsavingjar", "Error saving JAR"));
        }
        this.setHasArchive(true, file.toString());
    }

    public void save(File file) throws IOException {
        this.save(file, DEPLOYMENT_DESCRIPTOR_ENTRY, null);
    }

    public void addEjbJar(File file) throws IOException, ArchiveException {
        EjbBundleDescriptor ejbBundleDescriptor = EjbBundleArchivist.open(file);
        this.ejbBundleDescriptor.addEjbBundleDescriptor(ejbBundleDescriptor);
        File file2 = Archivist.createTempFile(Archivist.getDirectory(this.getEjbJarFile()));
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        Vector<String> vector = new Vector<String>();
        vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        vector.addElement("META-INF/MANIFEST.MF");
        JarFile jarFile = new JarFile(this.getEjbJarFile());
        JarFile jarFile2 = new JarFile(file);
        Archivist.addJarToOutput(zipOutputStream, jarFile, vector);
        Archivist.addJarToOutput(zipOutputStream, jarFile2, vector);
        this.writeDeploymentInfo(zipOutputStream);
        Manifest manifest = super.createManifest();
        EjbBundleArchivist.writeManifest(manifest, zipOutputStream);
        zipOutputStream.close();
        fileOutputStream.close();
        this.setClassLoader(null);
        if (!file2.renameTo(this.getEjbJarFile()) && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.errorrenamingjar", "Error renaming JAR"));
        }
    }

    private boolean hasClassFiles(Hashtable hashtable) {
        boolean bl = false;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.endsWith(".class")) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void removeEntries(Vector vector) throws IOException {
        super.removeEntries(vector);
        this.ejbBundleDescriptor.changed();
    }

    public void updateFiles(Hashtable hashtable) throws IOException {
        super.updateFiles(hashtable);
        if (this.hasClassFiles(hashtable)) {
            this.setClassLoader(null);
            Application application = this.ejbBundleDescriptor.getApplication();
            if (application == null) {
                throw new IOException("Couldn't get application archivist");
            }
            ApplicationArchivist applicationArchivist = application.getApplicationArchivist();
            applicationArchivist.setClassLoader(null);
            this.ejbBundleDescriptor.classesChanged();
        }
        this.ejbBundleDescriptor.changed();
    }

    public String toString() {
        return "EjbBundleArchivist " + this.getArchiveUri();
    }

    protected Vector getListOfExemptForClassLoadableFormat() {
        Vector vector = super.getListOfExemptForClassLoadableFormat();
        vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        return vector;
    }

    protected Vector getLibraryJars(Archivist archivist) throws IOException {
        Vector vector = super.getLibraryJars(archivist);
        String string = this.ejbBundleDescriptor.getEjbClientJarUri();
        if (!"".equals(string)) {
            JarFile jarFile = new JarFile(archivist.getArchiveFile());
            ZipEntry zipEntry = jarFile.getEntry(string);
            jarFile.close();
            if (zipEntry != null) {
                vector.add(string);
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.noclientjarentry", "Warning: {0} not found as a client jar entry.", new Object[]{string}));
            }
        }
        return vector;
    }

    static EjbBundleDescriptor open(File file, String string, JarFile jarFile, ApplicationArchivist applicationArchivist, boolean bl, boolean bl2) throws IOException, ArchiveException, SAXParseException {
        EjbBundleDescriptor ejbBundleDescriptor = EjbBundleArchivist.open(file, string, jarFile, applicationArchivist, bl);
        if (bl2 && ejbBundleDescriptor != null) {
            String string2 = Utils.getSunDescriptorName(string);
            SunEjbJar sunEjbJar = EjbBundleArchivist.createSunEjbJar(jarFile, string2, false);
            ejbBundleDescriptor.setSunDescriptor(sunEjbJar);
        }
        return ejbBundleDescriptor;
    }

    static EjbBundleDescriptor open(File file, ApplicationArchivist applicationArchivist, boolean bl, boolean bl2) throws IOException, ArchiveException, SAXParseException {
        EjbBundleDescriptor ejbBundleDescriptor = EjbBundleArchivist.open(file, applicationArchivist, bl);
        if (bl2 && ejbBundleDescriptor != null) {
            JarFile jarFile = new JarFile(file);
            SunEjbJar sunEjbJar = EjbBundleArchivist.createSunEjbJar(jarFile, IAS_DEPLOYMENT_DESCRIPTOR_ENTRY, false);
            ejbBundleDescriptor.setSunDescriptor(sunEjbJar);
            jarFile.close();
        }
        return ejbBundleDescriptor;
    }

    public void save(File file, boolean bl) throws IOException {
        this.save(file, DEPLOYMENT_DESCRIPTOR_ENTRY, null, bl);
    }

    void save(File file, String string, ZipOutputStream zipOutputStream, boolean bl) throws IOException {
        File file2 = Archivist.getEjbTemp(Archivist.getDirectory(file));
        ZipOutputStream zipOutputStream2 = new ZipOutputStream(new FileOutputStream(file2));
        String string2 = Utils.getSunDescriptorName(string);
        if (zipOutputStream == null) {
            this.writeDeploymentInfo(zipOutputStream2, string);
            if (bl) {
                this.writeSunDeploymentInfo(zipOutputStream2, string2);
            }
        } else {
            this.writeDeploymentInfo(zipOutputStream, string);
            if (bl) {
                this.writeSunDeploymentInfo(zipOutputStream, string2);
            }
        }
        Manifest manifest = super.createManifest();
        EjbBundleArchivist.writeManifest(manifest, zipOutputStream2);
        Vector<String> vector = new Vector<String>();
        if (zipOutputStream == null) {
            vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
            if (bl) {
                vector.addElement("META-INF/sun-ejb-jar.xml");
            }
        }
        vector.addElement("META-INF/MANIFEST.MF");
        this.writeEntriesToOutput(zipOutputStream2, vector);
        zipOutputStream2.close();
        file.delete();
        boolean bl2 = file2.renameTo(file);
        if (!bl2) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrorsavingjar", "Error saving JAR"));
        }
        this.setHasArchive(true, file.toString());
    }

    private void writeSunDeploymentInfo(ZipOutputStream zipOutputStream, String string) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(System.currentTimeMillis());
        zipOutputStream.putNextEntry(zipEntry);
        SunEjbJar sunEjbJar = this.ejbBundleDescriptor.getSunDescriptor();
        sunEjbJar.write(zipOutputStream);
        zipOutputStream.closeEntry();
    }

    public static SunEjbJar createSunEjbJar(JarFile jarFile, String string, boolean bl) throws IOException, ArchiveException {
        SunEjbJar sunEjbJar = null;
        ZipEntry zipEntry = jarFile.getEntry(string);
        if (zipEntry != null) {
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            try {
                sunEjbJar = EjbBundleXmlReader.createSunEjbDescriptorObj(inputStream, bl);
                inputStream.close();
            }
            catch (Exception exception) {
                throw new ArchiveException(exception.getMessage());
            }
        }
        return sunEjbJar;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

