/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.AbstractArchive;
import com.sun.enterprise.deployment.Archivist;
import com.sun.logging.LogDomains;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;

public class DirectoryArchive
implements AbstractArchive {
    private File root;
    private TreeSet entries;
    private List directories;
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");

    public DirectoryArchive(String string) {
        this.root = new File(string);
        if (!this.root.exists()) {
            this.root.mkdirs();
        }
        this.entries = new TreeSet();
        this.directories = new LinkedList();
    }

    public AbstractArchive copy() {
        DirectoryArchive directoryArchive = new DirectoryArchive(this.root.toString());
        directoryArchive.entries.addAll(this.entries);
        return directoryArchive;
    }

    public void addEntry(String string, InputStream inputStream) throws IOException {
        String string2 = string.replace('/', File.separatorChar);
        File file = new File(this.root, string2);
        File file2 = new File(file.getParent());
        if (!file2.exists()) {
            file2.mkdirs();
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        Archivist.copyWithoutClose(inputStream, bufferedOutputStream);
        bufferedOutputStream.close();
        this.entries.add(string);
    }

    public void addEntry(File file) throws IOException {
        String string = file.getAbsolutePath();
        if (string.startsWith(this.root.getAbsolutePath())) {
            String string2 = file.getParent();
            this.entries.add(this.getRelativePath(string));
        } else {
            File file2 = new File(this.root, file.toString());
            if (file2.exists()) {
                this.entries.add(file.toString());
            } else if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "WARNING , implement file copy for " + string + " in DIRECTORY ARCHIVE");
            }
        }
    }

    public Set getListOfEntries() {
        return this.entries;
    }

    public File getWriteableDirectory() {
        return this.root;
    }

    public File getSourceDirectory() {
        return this.root;
    }

    public void makeJar(File file) throws IOException {
        ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        zipOutputStream.setLevel(0);
        Iterator iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            File file2 = new File(this.root, string);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file2));
            try {
                zipOutputStream.putNextEntry(new ZipEntry(string.replace(File.separatorChar, '/')));
                Archivist.copy(bufferedInputStream, zipOutputStream);
                zipOutputStream.closeEntry();
            }
            catch (ZipException zipException) {
                // empty catch block
            }
        }
        zipOutputStream.close();
    }

    private String getRelativePath(String string) {
        return string.substring(this.root.getAbsolutePath().length() + File.separator.length());
    }

    public Iterator iterator() {
        return this.entries.iterator();
    }
}

