/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.AbstractArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.OrderedSet;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.resource.ResourceInstaller;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class ConnectorArchivist
extends Archivist {
    public static final String DESTINATION_CLASSES = "RA-INF" + File.separator + "classes";
    public static String DEPLOYMENT_DESCRIPTOR_ENTRY = "META-INF/ra.xml";
    public static final String RI_SPECIFIC_DESCRIPTOR_ENTRY = "META-INF/sun-j2ee-ri.xml";
    private ConnectorDescriptor connectorDescriptor;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$ConnectorArchivist == null ? (class$com$sun$enterprise$deployment$ConnectorArchivist = ConnectorArchivist.class$("com.sun.enterprise.deployment.ConnectorArchivist")) : class$com$sun$enterprise$deployment$ConnectorArchivist);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    Set rarContents = new OrderedSet();
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ConnectorArchivist;

    public ConnectorArchivist(String string, ConnectorDescriptor connectorDescriptor) {
        this(true, string, connectorDescriptor);
    }

    public ConnectorArchivist(boolean bl, String string, ConnectorDescriptor connectorDescriptor, Set set) {
        super(string, bl);
        this.manifestClasspath = new HashSet(set);
        this.connectorDescriptor = connectorDescriptor;
        this.connectorDescriptor.setArchivist(this);
    }

    public ConnectorArchivist(boolean bl, String string, ConnectorDescriptor connectorDescriptor) {
        super(string, bl);
        this.connectorDescriptor = connectorDescriptor;
        this.connectorDescriptor.setArchivist(this);
    }

    public static String getConnectorDirectory() {
        String string = FileUtil.getAbsolutePath(ResourceInstaller.CONNECTOR_ADAPTER_DIR);
        return string;
    }

    public Descriptor getDescriptor() {
        return this.connectorDescriptor;
    }

    public static boolean isConnector(File file) throws IOException {
        Archivist.checkExists(file);
        JarFile jarFile = new JarFile(file);
        ZipEntry zipEntry = jarFile.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        boolean bl = zipEntry != null;
        jarFile.close();
        return bl;
    }

    protected File getArchiveFile() throws IOException {
        File file = new File(this.getArchiveUri());
        Application application = this.connectorDescriptor.getApplication();
        if (application != null) {
            ApplicationArchivist applicationArchivist = application.getApplicationArchivist();
            File file2 = applicationArchivist.getApplicationFile();
            file = Archivist.getConnectorTemp(Archivist.getDirectory(file2));
            applicationArchivist.extractBundleToFile(this.connectorDescriptor, file);
            file.deleteOnExit();
        }
        return file;
    }

    private static void writeEntry(String string, FileInputStream fileInputStream, ZipOutputStream zipOutputStream, File file) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        zipEntry.setTime(System.currentTimeMillis());
        fileInputStream = new FileInputStream(file);
        zipOutputStream.putNextEntry(zipEntry);
        ApplicationArchivist.copy(fileInputStream, zipOutputStream);
        fileInputStream.close();
        zipOutputStream.closeEntry();
    }

    public static ConnectorDescriptor open(File file) throws IOException, ArchiveException {
        try {
            return ConnectorArchivist.open(file, false);
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
    }

    public static ConnectorDescriptor open(File file, boolean bl) throws IOException, ArchiveException, SAXParseException {
        if (!file.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionrarinfodoesn'texist", "{0} does not exist", new Object[]{file}));
        }
        JarFile jarFile = new JarFile(file);
        ConnectorDescriptor connectorDescriptor = ConnectorArchivist.open(file, DEPLOYMENT_DESCRIPTOR_ENTRY, jarFile, bl);
        jarFile.close();
        return connectorDescriptor;
    }

    static ConnectorDescriptor open(File file, String string, JarFile jarFile) throws IOException, ArchiveException {
        try {
            return ConnectorArchivist.open(file, string, jarFile, false);
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
    }

    static ConnectorDescriptor open(File file, String string, JarFile jarFile, boolean bl) throws IOException, ArchiveException, SAXParseException {
        if (!file.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionappclientjarinfodoesn'texist", "{0} does not exist", new Object[]{file}));
        }
        ZipEntry zipEntry = jarFile.getEntry(string);
        if (zipEntry != null) {
            if (bl) {
                Archivist.validate(jarFile.getInputStream(zipEntry));
            }
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            ConnectorNode connectorNode = ConnectorNode.read(inputStream, bl);
            inputStream.close();
            ConnectorDescriptor connectorDescriptor = connectorNode.getDescriptor();
            ConnectorArchivist connectorArchivist = new ConnectorArchivist(file.toString(), connectorDescriptor);
            connectorArchivist.setManifestClasspaths(jarFile.getManifest());
            connectorDescriptor.setArchivist(connectorArchivist);
            connectorDescriptor.doneOpening();
            return connectorDescriptor;
        }
        throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionnodeployinfofoundatin", "No deployment info found at: {0} in {1}", new Object[]{string, jarFile.getName()}));
    }

    public File getRarFile() {
        return new File(this.getArchiveUri());
    }

    public void save(File file) throws IOException {
        this.save(file, DEPLOYMENT_DESCRIPTOR_ENTRY, null);
    }

    void save(File file, String string, ZipOutputStream zipOutputStream) throws IOException {
        File file2 = Archivist.getRarTemp(Archivist.getDirectory(file));
        ZipOutputStream zipOutputStream2 = new ZipOutputStream(new FileOutputStream(file2));
        if (zipOutputStream == null) {
            this.writeDeploymentInfo(zipOutputStream2, string, false);
        } else {
            this.writeDeploymentInfo(zipOutputStream, string, true);
        }
        Manifest manifest = this.createManifest();
        Archivist.writeManifest(manifest, zipOutputStream2);
        Vector<String> vector = new Vector<String>();
        if (zipOutputStream == null) {
            vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
            vector.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        }
        vector.addElement("META-INF/MANIFEST.MF");
        this.writeEntriesToOutput(zipOutputStream2, vector);
        zipOutputStream2.close();
        file.delete();
        boolean bl = file2.renameTo(file);
        if (!bl) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrorsavingrar", "Error saving RAR"));
        }
        this.setHasArchive(true, file.toString());
        this.connectorDescriptor.doneSaving();
    }

    private static String getRuntimeEntryNameFrom(String string) {
        return RI_SPECIFIC_DESCRIPTOR_ENTRY + string;
    }

    public void writeDeploymentInfo(ZipOutputStream zipOutputStream, String string, boolean bl) throws IOException {
        Archivist.writeDocumentToJar((Document)ConnectorNode.getDocument(this.connectorDescriptor), string, zipOutputStream);
    }

    public Set getAllJarFiles(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                this.rarContents.add(jarEntry.getName());
            }
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "enterprise.deployment_ioexcp", iOException);
        }
        return this.rarContents;
    }

    public boolean isDeletable(String string) {
        boolean bl = true;
        if (string.equals("META-INF/MANIFEST.MF") || string.equals(DEPLOYMENT_DESCRIPTOR_ENTRY) || string.equals(RI_SPECIFIC_DESCRIPTOR_ENTRY)) {
            bl = false;
        }
        return bl;
    }

    public void updateFiles(Hashtable hashtable) throws IOException {
        super.updateFiles(hashtable);
        this.connectorDescriptor.changed();
    }

    public void removeEntries(Vector vector) throws IOException {
        super.removeEntries(vector);
        this.connectorDescriptor.changed();
    }

    public static void createPackage(FileContentsDescriptor fileContentsDescriptor, File file, File file2) throws IOException, ArchiveException {
        if (!file.exists()) {
            throw new IOException("Cannot package web application: " + file + "  does not exist.");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        _logger.log(Level.FINE, "Reading connector nodes");
        ConnectorNode connectorNode = ConnectorNode.read(fileInputStream, false);
        _logger.log(Level.FINE, "Done reading connector nodes");
        ConnectorDescriptor connectorDescriptor = null;
        try {
            connectorDescriptor = connectorNode.getDescriptor();
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "enterprise.deployment_read_connector", throwable);
            fileInputStream.close();
            throw new IOException("Error reading connector xml: " + throwable.getMessage());
        }
        if (connectorDescriptor != null) {
            Object object;
            ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            ConnectorArchivist connectorArchivist = new ConnectorArchivist(file2.toString(), connectorDescriptor);
            fileInputStream.close();
            Enumeration enumeration = fileContentsDescriptor.getFiles();
            while (enumeration.hasMoreElements()) {
                object = (File)enumeration.nextElement();
                File file3 = fileContentsDescriptor.getFullFileFor((File)object);
                String string = ((File)object).toString().replace(File.separatorChar, '/');
                if (DEPLOYMENT_DESCRIPTOR_ENTRY.equals(string)) continue;
                ConnectorArchivist.writeEntry(string, fileInputStream, zipOutputStream, file3);
            }
            ConnectorArchivist.writeEntry(DEPLOYMENT_DESCRIPTOR_ENTRY, fileInputStream, zipOutputStream, file);
            object = new Manifest();
            ConnectorArchivist.writeManifest((Manifest)object, zipOutputStream);
            zipOutputStream.close();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "Created Resource Adapter Archive: " + file2);
            }
        }
    }

    public static Set getClassList(FileContentsDescriptor fileContentsDescriptor) {
        OrderedSet orderedSet = new OrderedSet();
        Enumeration enumeration = fileContentsDescriptor.getFiles();
        while (enumeration.hasMoreElements()) {
            File file = (File)enumeration.nextElement();
            if (file.toString().endsWith(".class") || !file.toString().endsWith(".jar")) continue;
            try {
                JarFile jarFile = new JarFile(fileContentsDescriptor.getFullFileFor(file).toString());
                Enumeration<JarEntry> enumeration2 = jarFile.entries();
                while (enumeration2.hasMoreElements()) {
                    JarEntry jarEntry = enumeration2.nextElement();
                    if (!jarEntry.getName().endsWith(".class")) continue;
                    orderedSet.add(FileUtil.classNameFromEntryName(jarEntry.getName()));
                }
            }
            catch (IOException iOException) {
                _logger.log(Level.FINE, "ConnectorArchivist.getClassList: " + iOException.toString());
            }
        }
        return orderedSet;
    }

    public static Set getClassList(Set set) throws IOException {
        OrderedSet orderedSet = new OrderedSet();
        OrderedSet orderedSet2 = new OrderedSet();
        try {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!string.toString().endsWith(".jar")) continue;
                JarFile jarFile = new JarFile(string);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    if (!jarEntry.getName().endsWith(".class")) continue;
                    String string2 = FileUtil.classNameFromEntryName(jarEntry.getName());
                    orderedSet2.add(string2);
                }
                if (orderedSet2 == null) continue;
                orderedSet.addAll(orderedSet2);
                orderedSet2.clear();
            }
        }
        catch (IOException iOException) {
            _logger.log(Level.WARNING, "enterprise.deployment_ioexcp", iOException);
        }
        return orderedSet;
    }

    protected void makeArchiveClassLoadable(JarInputStream jarInputStream, AbstractArchive abstractArchive) throws IOException {
        ZipEntry zipEntry;
        while ((zipEntry = jarInputStream.getNextEntry()) != null) {
            ZipEntry zipEntry2;
            if (!zipEntry.getName().endsWith(".jar")) continue;
            JarInputStream jarInputStream2 = new JarInputStream(jarInputStream);
            while ((zipEntry2 = jarInputStream2.getNextEntry()) != null) {
                abstractArchive.addEntry(zipEntry2.getName(), jarInputStream2);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

