/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.iplanet.ias.deployment.ApplicationXmlReader;
import com.iplanet.ias.deployment.Utils;
import com.iplanet.ias.tools.common.dd.application.SunApplication;
import com.sun.enterprise.deployment.AbstractArchive;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ArchiveException;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorArchivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.DirectoryArchive;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.deployment.WebDescriptorFactoryImpl;
import com.sun.enterprise.deployment.web.WebApplicationReader;
import com.sun.enterprise.deployment.web.WebComponentDescriptor;
import com.sun.enterprise.deployment.web.WebDescriptorFactory;
import com.sun.enterprise.deployment.xml.ApplicationClientNode;
import com.sun.enterprise.deployment.xml.ApplicationNode;
import com.sun.enterprise.deployment.xml.ConnectorNode;
import com.sun.enterprise.deployment.xml.EjbBundleNode;
import com.sun.enterprise.deployment.xml.ParseException;
import com.sun.enterprise.deployment.xml.RuntimeDescriptorNode;
import com.sun.enterprise.deployment.xml.XMLUtils;
import com.sun.enterprise.deployment.xml.XMLValidationHandler;
import com.sun.enterprise.util.FileClassLoader;
import com.sun.enterprise.util.FileUtil;
import com.sun.enterprise.util.JarClassLoader;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;

public class ApplicationArchivist
extends Archivist {
    public static final boolean debug = false;
    public static final String DEPLOYMENT_DESCRIPTOR_ENTRY = "META-INF/application.xml";
    public static final String RI_SPECIFIC_DESCRIPTOR_ENTRY = "META-INF/sun-application.xml";
    private static final String LIBRARY_JAR_URI_ROOT = "library/";
    private File applicationFile = null;
    private ClassLoader classLoader;
    private Application application;
    private boolean isClassLoadable = false;
    private static boolean saveApplicationClientRuntime = true;
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$ApplicationArchivist == null ? (class$com$sun$enterprise$deployment$ApplicationArchivist = ApplicationArchivist.class$("com.sun.enterprise.deployment.ApplicationArchivist")) : class$com$sun$enterprise$deployment$ApplicationArchivist);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ApplicationArchivist;

    ApplicationArchivist(File file, Application application) {
        this(file, application, false);
    }

    ApplicationArchivist(File file, Application application, boolean bl) {
        super(file.toString(), true);
        this.applicationFile = file;
        this.application = application;
        this.isClassLoadable = bl;
    }

    public void setClassLoadable(boolean bl) {
        this.isClassLoadable = bl;
    }

    public boolean getClassLoadable() {
        return this.isClassLoadable;
    }

    public File getArchiveFile() throws IOException {
        return this.applicationFile;
    }

    public void updateFiles(Hashtable hashtable) throws IOException {
        super.updateFiles(hashtable);
        this.application.changed(true);
    }

    public Set getLibraryJarUris() throws IOException {
        String string;
        Serializable serializable;
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        Set set = this.application.getArchivableDescriptors();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            serializable = (BundleDescriptor)iterator.next();
            Archivist archivist = ((BundleDescriptor)serializable).getArchivist();
            string = archivist.getArchiveUri();
            if (!string.endsWith(".jar")) continue;
            hashSet2.add(string);
        }
        serializable = this.getEntryNames();
        int n = 0;
        while (n < ((Vector)serializable).size()) {
            string = (String)((Vector)serializable).elementAt(n);
            if (string.endsWith(".jar") && !hashSet2.contains(string)) {
                hashSet.add(string);
            }
            ++n;
        }
        return hashSet;
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            try {
                if (this.isClassLoadable) {
                    JarClassLoader jarClassLoader = new JarClassLoader();
                    jarClassLoader.addJar(this.getApplicationFile().toString());
                    this.classLoader = jarClassLoader;
                } else {
                    File file = new File(FileUtil.getTempDirectory(), this.application.getName());
                    String string = this.extractClassloadableSubJarsTo(file, "ejbJars");
                    this.classLoader = new FileClassLoader(string);
                }
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "enterprise.deployment_exception_classloadercouldnotbemade", exception);
                throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionclassloadercouldnotbemade", "Class loader could not be made"));
            }
        }
        return this.classLoader;
    }

    private String extractClassloadableSubJarsTo(File file, String string) throws IOException {
        File file2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        JarFile jarFile = new JarFile(this.getApplicationFile());
        File file3 = new File(file, string);
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet hashSet2 = new HashSet();
        Hashtable hashtable = new Hashtable();
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            object5 = enumeration.nextElement();
            object4 = ((ZipEntry)object5).getName();
            if (!((String)object4).endsWith(".jar") && !((String)object4).endsWith(".war")) continue;
            hashSet.add(object4);
        }
        object5 = this.application.getEjbBundleDescriptors().iterator();
        while (object5.hasNext()) {
            object4 = (EjbBundleDescriptor)object5.next();
            object3 = ((BundleDescriptor)object4).getArchivist();
            hashSet2.addAll(((Archivist)object3).getFilesToBeRemoved());
            hashtable.putAll(((Archivist)object3).getFilesToBeAdded());
        }
        object5 = this.application.getWebBundleDescriptors().iterator();
        while (object5.hasNext()) {
            object4 = (WebBundleDescriptor)object5.next();
            object3 = ((BundleDescriptor)object4).getArchivist();
            hashSet2.addAll(((Archivist)object3).getFilesToBeRemoved());
            hashtable.putAll(((Archivist)object3).getFilesToBeAdded());
        }
        object4 = this.getFilesToBeAdded();
        object3 = ((Hashtable)object4).keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            if (hashSet.contains(object2) || !((String)object2).endsWith(".jar") && !((String)object2).endsWith(".war")) continue;
            object = (File)((Hashtable)object4).get(object2);
            Archivist.extractJarFile((File)object, file3);
        }
        object5 = hashSet.iterator();
        while (object5.hasNext()) {
            object2 = (String)object5.next();
            object = ((String)object2).replace('/', File.separatorChar);
            file2 = new File(file, (String)object);
            file2.deleteOnExit();
            ApplicationArchivist.extractJar((String)object2, jarFile, file2);
            Archivist.extractJarFile(file2, file3);
        }
        object5 = hashSet2.iterator();
        while (object5.hasNext()) {
            object2 = (String)object5.next();
            object = ((String)object2).replace('/', File.separatorChar);
            file2 = new File(file3, (String)object);
            boolean bl = file2.delete();
        }
        object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            boolean bl;
            object = (String)object2.nextElement();
            file2 = (File)hashtable.get(object);
            if (!file2.exists()) {
                if (!_logger.isLoggable(Level.FINE)) continue;
                _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.exceptionfiledoesnotexist", "{0} does not exist", new Object[]{file2.toString()}));
                continue;
            }
            String string2 = ((String)object).replace('/', File.separatorChar);
            File file4 = new File(file3, string2);
            if (!file4.getParentFile().exists() && !(bl = file4.getParentFile().mkdirs())) {
                throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionunpackingarchivefailed", "Unpacking archive failed: could not make parent file for {0}", new Object[]{file4}));
            }
            FileInputStream fileInputStream = new FileInputStream(file2);
            FileOutputStream fileOutputStream = new FileOutputStream(file4);
            Archivist.copy(fileInputStream, fileOutputStream);
            fileInputStream.close();
            fileOutputStream.close();
        }
        jarFile.close();
        return file3.getAbsolutePath();
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public File getApplicationFile() {
        return this.applicationFile;
    }

    public Descriptor getDescriptor() {
        return this.application;
    }

    public void setApplicationFile(File file) {
        this.setArchiveUri(file.toString());
        this.applicationFile = file;
        this.setClassLoader(null);
    }

    public static Application open(File file) throws IOException, ArchiveException {
        try {
            return ApplicationArchivist.open(file, false, null, false);
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
    }

    public static Application open(File file, ClassLoader classLoader) throws IOException, ArchiveException {
        try {
            return ApplicationArchivist.open(file, false, classLoader, false);
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
    }

    public static Application open(File file, boolean bl) throws IOException, ArchiveException {
        try {
            return ApplicationArchivist.open(file, bl, null, false);
        }
        catch (SAXParseException sAXParseException) {
            return null;
        }
    }

    public static Application open(File file, boolean bl, boolean bl2) throws IOException, ArchiveException, SAXParseException {
        return ApplicationArchivist.open(file, bl, null, bl2);
    }

    public static Application open(File file, boolean bl, ClassLoader classLoader, boolean bl2) throws IOException, ArchiveException, SAXParseException {
        if (!file.exists()) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionjarfiledoesn'texist", "{0} does not exist", new Object[]{file}));
        }
        JarFile jarFile = new JarFile(file);
        ZipEntry zipEntry = jarFile.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        if (zipEntry != null) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            if (bl2) {
                Archivist.validate(jarFile.getInputStream(zipEntry));
            }
            ApplicationNode applicationNode = ApplicationNode.read(inputStream, bl2);
            inputStream.close();
            Application application = applicationNode.getApplication(null, null);
            ApplicationArchivist applicationArchivist = new ApplicationArchivist(file, application, bl);
            if (classLoader != null) {
                applicationArchivist.setClassLoader(classLoader);
            }
            application.setApplicationArchivist(applicationArchivist);
            Enumeration enumeration = applicationNode.getEjbBundleArchiveMap().keys();
            while (enumeration.hasMoreElements()) {
                object6 = (String)enumeration.nextElement();
                object5 = (String)applicationNode.getEjbBundleArchiveMap().get(object6);
                object4 = Archivist.getEjbTemp(Archivist.getDirectory(file));
                ApplicationArchivist.extractJar((String)object6, jarFile, (File)object4);
                object3 = null;
                if ("".equals(object5)) {
                    object3 = EjbBundleArchivist.open((File)object4, applicationArchivist, bl2, true);
                } else {
                    object3 = EjbBundleArchivist.open((File)object4, (String)object5, jarFile, applicationArchivist, bl2, true);
                    ((BundleDescriptor)object3).getArchivist().setExternalDescriptorArchiveUri((String)object5);
                }
                ((File)object4).delete();
                ((BundleDescriptor)object3).getArchivist().setArchiveUri((String)object6);
                application.addEjbBundleDescriptor((EjbBundleDescriptor)object3);
            }
            object6 = applicationNode.getWebBundleArchiveMap().keys();
            while (object6.hasMoreElements()) {
                object5 = (String)object6.nextElement();
                object4 = (String)applicationNode.getWebBundleArchiveMap().get(object5);
                object3 = Archivist.getWebTemp(Archivist.getDirectory(file));
                ApplicationArchivist.extractJar((String)object5, jarFile, (File)object3);
                object2 = null;
                if ("".equals(object4)) {
                    object2 = WebBundleArchivist.open((File)object3, bl2, true);
                } else {
                    object2 = WebBundleArchivist.open((File)object3, (String)object4, jarFile, bl2, true);
                    ((BundleDescriptor)object2).getArchivist().setExternalDescriptorArchiveUri((String)object4);
                }
                ((File)object3).delete();
                ((BundleDescriptor)object2).getArchivist().setArchiveUri((String)object5);
                object = applicationNode.getContextRootFor((String)object5);
                ((WebBundleDescriptor)object2).setContextRoot((String)object);
                application.addWebBundleDescriptor((WebBundleDescriptor)object2);
            }
            object5 = applicationNode.getApplicationClientDescriptorArchiveMap().keys();
            while (object5.hasMoreElements()) {
                object4 = (String)object5.nextElement();
                object3 = (String)applicationNode.getApplicationClientDescriptorArchiveMap().get(object4);
                object2 = Archivist.getApplicationClientTemp(Archivist.getDirectory(file));
                ApplicationArchivist.extractJar((String)object4, jarFile, (File)object2);
                object = null;
                if ("".equals(object3)) {
                    object = ApplicationClientArchivist.open((File)object2, bl2, true);
                } else {
                    object = ApplicationClientArchivist.open((File)object2, (String)object3, jarFile, bl2, true);
                    ((BundleDescriptor)object).getArchivist().setExternalDescriptorArchiveUri((String)object3);
                }
                ((File)object2).delete();
                ((BundleDescriptor)object).getArchivist().setArchiveUri((String)object4);
                application.addApplicationClientDescriptor((ApplicationClientDescriptor)object);
            }
            object4 = applicationNode.getRarDescriptorArchiveMap().keys();
            while (object4.hasMoreElements()) {
                object3 = (String)object4.nextElement();
                object2 = (String)applicationNode.getRarDescriptorArchiveMap().get(object3);
                object = Archivist.getRarTemp(Archivist.getDirectory(file));
                ApplicationArchivist.extractJar((String)object3, jarFile, (File)object);
                ConnectorDescriptor connectorDescriptor = null;
                if ("".equals(object2)) {
                    connectorDescriptor = ConnectorArchivist.open((File)object, bl2);
                } else {
                    connectorDescriptor = ConnectorArchivist.open((File)object, (String)object2, jarFile, bl2);
                    connectorDescriptor.getArchivist().setExternalDescriptorArchiveUri((String)object2);
                }
                ((File)object).delete();
                connectorDescriptor.getArchivist().setArchiveUri((String)object3);
                application.addRarDescriptor(connectorDescriptor);
            }
            object3 = jarFile.getEntry(RI_SPECIFIC_DESCRIPTOR_ENTRY);
            if (object3 != null) {
                inputStream = jarFile.getInputStream((ZipEntry)object3);
                try {
                    object2 = ApplicationXmlReader.createSunApplicationDescriptorObj(inputStream, false);
                    application.setSunDescriptor((SunApplication)((Object)object2));
                    inputStream.close();
                }
                catch (Exception exception) {
                    throw new ArchiveException(exception.getMessage());
                }
            }
            ApplicationNode.resolveInterJarEjbReferences(application);
            jarFile.close();
            return application;
        }
        jarFile.close();
        throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionnodeploymentinfofound", "No deployment info found - invalid format"));
    }

    public void save(boolean bl) throws IOException {
        this.save(this.getApplicationFile(), bl);
    }

    public void save(File file, boolean bl) throws IOException {
        Object object;
        File file2 = Archivist.createTempFile(Archivist.getDirectory(file));
        ZipOutputStream zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
        Vector<Object> vector = new Vector<Object>();
        HashSet<Object> hashSet = new HashSet<Object>();
        JarFile jarFile = null;
        if (this.getApplicationFile().exists()) {
            Object object2;
            Object object3;
            Vector<String> vector2;
            Object object4;
            Serializable serializable;
            Iterator iterator;
            Iterator iterator2;
            Object object5;
            jarFile = new JarFile(this.getApplicationFile());
            object = this.application.getEjbBundleDescriptors().iterator();
            while (object.hasNext()) {
                object5 = (EjbBundleDescriptor)object.next();
                iterator2 = (EjbBundleArchivist)((BundleDescriptor)object5).getArchivist();
                iterator = File.createTempFile("ejb-jar", ".jar");
                serializable = ((Archivist)((Object)iterator2)).getArchiveUri();
                if (((Archivist)((Object)iterator2)).hasArchive()) {
                    ApplicationArchivist.extractJar((String)((Object)serializable), jarFile, (File)((Object)iterator));
                    ((Archivist)((Object)iterator2)).setArchiveUri(((File)((Object)iterator)).toString());
                }
                ((BundleDescriptor)object5).setApplication(null);
                if (((Archivist)((Object)iterator2)).hasExternalDescriptor()) {
                    ((EjbBundleArchivist)((Object)iterator2)).save((File)((Object)iterator), ((Archivist)((Object)iterator2)).getExternalDescriptorArchiveUri(), zipOutputStream, true);
                    object4 = Utils.getSunDescriptorName(((Archivist)((Object)iterator2)).getExternalDescriptorArchiveUri(), jarFile);
                    vector.add(object4);
                    vector.add(((Archivist)((Object)iterator2)).getExternalDescriptorArchiveUri());
                } else {
                    ((EjbBundleArchivist)((Object)iterator2)).save((File)((Object)iterator), true);
                }
                ((BundleDescriptor)object5).setApplication(this.application);
                ((Archivist)((Object)iterator2)).setHasArchive(true, (String)((Object)serializable));
                object4 = new FileInputStream((File)((Object)iterator));
                zipOutputStream.putNextEntry(new ZipEntry((String)((Object)serializable)));
                Archivist.copy((InputStream)object4, zipOutputStream);
                zipOutputStream.closeEntry();
                ((InputStream)object4).close();
                vector.add(serializable);
                if (this.isClassLoadable) {
                    vector2 = new Vector<String>();
                    vector2.addElement("META-INF/MANIFEST.MF");
                    vector2.addElement(EjbBundleArchivist.DEPLOYMENT_DESCRIPTOR_ENTRY);
                    vector2.addElement("META-INF/sun-ejb-jar.xml");
                    Archivist.addJarToOutput(zipOutputStream, new JarFile((File)((Object)iterator)), vector2);
                    object3 = ((EjbBundleDescriptor)object5).getEjbClientJarUri();
                    if (!"".equals(object3)) {
                        object2 = new JarFile(this.getApplicationFile());
                        ZipEntry zipEntry = ((JarFile)object2).getEntry((String)object3);
                        ((ZipFile)object2).close();
                        if (zipEntry != null) {
                            hashSet.add(object3);
                        } else if (_logger.isLoggable(Level.FINE)) {
                            _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.noclientjarentry", "Warning: {0} not found as a client jar entry.", new Object[]{object3}));
                        }
                    }
                }
                ((File)((Object)iterator)).delete();
            }
            object5 = this.application.getWebBundleDescriptors().iterator();
            while (object5.hasNext()) {
                iterator2 = (WebBundleDescriptor)object5.next();
                iterator = (WebBundleArchivist)((BundleDescriptor)((Object)iterator2)).getArchivist();
                serializable = File.createTempFile("war", ".war");
                object4 = ((Archivist)((Object)iterator)).getArchiveUri();
                if (((Archivist)((Object)iterator)).hasArchive()) {
                    ApplicationArchivist.extractJar((String)object4, jarFile, serializable);
                    ((Archivist)((Object)iterator)).setArchiveUri(((File)serializable).toString());
                }
                ((BundleDescriptor)((Object)iterator2)).setApplication(null);
                if (((Archivist)((Object)iterator)).hasExternalDescriptor()) {
                    ((WebBundleArchivist)((Object)iterator)).save((File)serializable, ((Archivist)((Object)iterator)).getExternalDescriptorArchiveUri(), zipOutputStream, true);
                    vector2 = Utils.getSunDescriptorName(((Archivist)((Object)iterator)).getExternalDescriptorArchiveUri(), jarFile);
                    vector.add(vector2);
                    vector.add(((Archivist)((Object)iterator)).getExternalDescriptorArchiveUri());
                } else {
                    ((WebBundleArchivist)((Object)iterator)).save((File)serializable, true);
                }
                ((BundleDescriptor)((Object)iterator2)).setApplication(this.application);
                ((Archivist)((Object)iterator)).setHasArchive(true, (String)object4);
                vector2 = new FileInputStream((File)serializable);
                zipOutputStream.putNextEntry(new ZipEntry((String)object4));
                Archivist.copy((InputStream)((Object)vector2), zipOutputStream);
                zipOutputStream.closeEntry();
                ((InputStream)((Object)vector2)).close();
                ((File)serializable).delete();
                vector.add(object4);
            }
            iterator2 = this.application.getApplicationClientDescriptors().iterator();
            while (iterator2.hasNext()) {
                iterator = (ApplicationClientDescriptor)iterator2.next();
                serializable = (ApplicationClientArchivist)((BundleDescriptor)((Object)iterator)).getArchivist();
                object4 = File.createTempFile("application-client", ".jar");
                vector2 = ((Archivist)((Object)serializable)).getArchiveUri();
                if (((Archivist)((Object)serializable)).hasArchive()) {
                    ApplicationArchivist.extractJar((String)((Object)vector2), jarFile, (File)object4);
                    ((Archivist)((Object)serializable)).setArchiveUri(((File)object4).toString());
                }
                ((BundleDescriptor)((Object)iterator)).setApplication(null);
                if (((Archivist)((Object)serializable)).hasExternalDescriptor()) {
                    ((ApplicationClientArchivist)((Object)serializable)).save((File)object4, saveApplicationClientRuntime, ((Archivist)((Object)serializable)).getExternalDescriptorArchiveUri(), zipOutputStream, true);
                    object3 = Utils.getSunDescriptorName(((Archivist)((Object)serializable)).getExternalDescriptorArchiveUri(), jarFile);
                    vector.add(object3);
                    vector.add(((Archivist)((Object)serializable)).getExternalDescriptorArchiveUri());
                } else {
                    ((ApplicationClientArchivist)((Object)serializable)).save((File)object4, saveApplicationClientRuntime, true);
                }
                ((BundleDescriptor)((Object)iterator)).setApplication(this.application);
                ((Archivist)((Object)serializable)).setHasArchive(true, (String)((Object)vector2));
                object3 = new FileInputStream((File)object4);
                zipOutputStream.putNextEntry(new ZipEntry((String)((Object)vector2)));
                Archivist.copy((InputStream)object3, zipOutputStream);
                zipOutputStream.closeEntry();
                ((InputStream)object3).close();
                vector.add(vector2);
                if (this.isClassLoadable) {
                    object2 = new Vector<String>();
                    ((Vector)object2).addElement("META-INF/MANIFEST.MF");
                    ((Vector)object2).addElement("META-INF/application-client.xml");
                    ((Vector)object2).addElement("META-INF/sun-application-client.xml");
                    Archivist.addJarToOutput(zipOutputStream, new JarFile((File)object4), (Vector)object2);
                }
                ((File)object4).delete();
            }
            iterator = this.application.getRarDescriptors().iterator();
            while (iterator.hasNext()) {
                serializable = (ConnectorDescriptor)iterator.next();
                object4 = (ConnectorArchivist)((BundleDescriptor)serializable).getArchivist();
                vector2 = File.createTempFile("connector", ".rar");
                object3 = ((Archivist)object4).getArchiveUri();
                if (((Archivist)object4).hasArchive()) {
                    ApplicationArchivist.extractJar((String)object3, jarFile, (File)((Object)vector2));
                    ((Archivist)object4).setArchiveUri(((File)((Object)vector2)).toString());
                }
                ((BundleDescriptor)serializable).setApplication(null);
                ((ConnectorArchivist)object4).save((File)((Object)vector2));
                ((BundleDescriptor)serializable).setApplication(this.application);
                ((Archivist)object4).setHasArchive(true, (String)object3);
                object2 = new FileInputStream((File)((Object)vector2));
                zipOutputStream.putNextEntry(new ZipEntry((String)object3));
                Archivist.copy((InputStream)object2, zipOutputStream);
                zipOutputStream.closeEntry();
                ((InputStream)object2).close();
                vector.add(object3);
                if (this.isClassLoadable) {
                    ApplicationArchivist.expandRarFile(new JarFile((File)((Object)vector2)), zipOutputStream);
                }
                ((File)((Object)vector2)).delete();
            }
            serializable = new Vector();
            if (this.isClassLoadable) {
                object4 = this.getFilesToBeAdded();
                hashSet.addAll(this.getLibraryJarUris());
                vector2 = hashSet.iterator();
                while (vector2.hasNext()) {
                    object3 = (String)vector2.next();
                    if (((Hashtable)object4).contains(object3)) {
                        object2 = (File)((Hashtable)object4).get(object3);
                        ((Vector)serializable).add(object2);
                        continue;
                    }
                    object2 = Archivist.getLibraryTemp(this.getApplicationDirectory());
                    ((File)object2).deleteOnExit();
                    ApplicationArchivist.extractJar((String)object3, jarFile, (File)object2);
                    ((Vector)serializable).add(object2);
                }
            }
            vector.add(DEPLOYMENT_DESCRIPTOR_ENTRY);
            vector.add(RI_SPECIFIC_DESCRIPTOR_ENTRY);
            vector.add("META-INF/MANIFEST.MF");
            this.writeEntriesToOutput(zipOutputStream, vector, (Vector)serializable);
        }
        object = this.createApplicationManifest();
        ApplicationArchivist.writeManifest((Manifest)object, zipOutputStream);
        this.writeApplicationDeploymentInfo(zipOutputStream, bl);
        zipOutputStream.close();
        if (jarFile != null) {
            jarFile.close();
        }
        file.delete();
        boolean bl2 = file2.renameTo(file);
        if (!bl2) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionerrorsavingjar", "Error saving JAR"));
        }
        this.setApplicationFile(file);
        this.setClassLoader(null);
        if (this.isClassLoadable) {
            // empty if block
        }
        this.application.doneSaving();
    }

    public void addLibraryJar(File file) throws IOException {
        Hashtable<String, File> hashtable = new Hashtable<String, File>();
        String string = LIBRARY_JAR_URI_ROOT + file.getName();
        hashtable.put(string, file);
        this.addFiles(hashtable);
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.application.getEjbBundleDescriptors());
        hashSet.addAll(this.application.getApplicationClientDescriptors());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            BundleDescriptor bundleDescriptor = (BundleDescriptor)iterator.next();
            bundleDescriptor.getArchivist().addManfiestClasspath(string);
        }
    }

    public void removeLibraryJar(String string) throws IOException {
        this.removeEntry(string);
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.application.getEjbBundleDescriptors());
        hashSet.addAll(this.application.getApplicationClientDescriptors());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            BundleDescriptor bundleDescriptor = (BundleDescriptor)iterator.next();
            bundleDescriptor.getArchivist().removeManifestClasspath(string);
        }
    }

    public String createUniqueURI(String string, String string2) throws IOException {
        int n;
        Object object;
        Vector vector = this.getEntryNames();
        Vector<String> vector2 = new Vector<String>();
        String string3 = string;
        int n2 = 0;
        while (n2 < vector.size()) {
            object = (String)vector.elementAt(n2);
            if (((String)object).startsWith(string) && ((String)object).endsWith(string2)) {
                n = ((String)object).lastIndexOf(string2);
                vector2.add(((String)object).substring(0, n));
            }
            ++n2;
        }
        if (vector2.size() > 0) {
            Object object2;
            object = "";
            n = 0;
            while (n < vector2.size()) {
                object2 = (String)vector2.elementAt(n);
                if (((String)object2).length() > ((String)object).length()) {
                    object = object2;
                }
                ++n;
            }
            object2 = new Random();
            string3 = (String)object + ((Random)object2).nextInt(10);
        }
        return string3 + string2;
    }

    public String createUniqueAppClientURI() throws IOException {
        return this.createUniqueURI("app-client-ic", ".jar");
    }

    public String createUniqueRarURI() throws IOException {
        return this.createUniqueURI("connector-ic", ".rar");
    }

    public String createUniqueWarURI() throws IOException {
        return this.createUniqueURI("war-ic", ".war");
    }

    public String createUniqueEjbURI() throws IOException {
        return this.createUniqueURI("ejb-jar-ic", ".jar");
    }

    public static Application readApplicationFromXmlFiles(String string) throws IOException, ArchiveException {
        FileInputStream fileInputStream = new FileInputStream(new File(string));
        ApplicationNode applicationNode = ApplicationNode.read(fileInputStream, false);
        Application application = applicationNode.getApplication(null, null);
        fileInputStream.close();
        Enumeration enumeration = applicationNode.getEjbBundleArchiveMap().keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            fileInputStream = new FileInputStream(new File(string2));
            EjbBundleNode ejbBundleNode = EjbBundleNode.read(fileInputStream, false);
            EjbBundleDescriptor ejbBundleDescriptor = ejbBundleNode.getDescriptor();
            application.addEjbBundleDescriptor(ejbBundleDescriptor);
            fileInputStream.close();
        }
        return application;
    }

    public void writeApplicationDeploymentInfo(ZipOutputStream zipOutputStream, boolean bl) throws IOException {
        Archivist.writeDocumentToJar((Document)ApplicationNode.getDocument(this.application), DEPLOYMENT_DESCRIPTOR_ENTRY, zipOutputStream);
        if (bl && this.application.hasRuntimeInformation()) {
            ZipEntry zipEntry = new ZipEntry(RI_SPECIFIC_DESCRIPTOR_ENTRY);
            zipEntry.setTime(System.currentTimeMillis());
            zipOutputStream.putNextEntry(zipEntry);
            SunApplication sunApplication = this.application.getSunDescriptor();
            sunApplication.write(zipOutputStream);
            zipOutputStream.closeEntry();
        }
    }

    public void writeRuntimeInfo(File file) throws IOException {
        XMLUtils.writeDocumentToFile((Document)RuntimeDescriptorNode.getDocument(this.application), file);
    }

    public Manifest createApplicationManifest() {
        Manifest manifest = new Manifest();
        return manifest;
    }

    public void add16Icon(File file) throws IOException {
        this.addIcon(file, true);
    }

    private void addIcon(File file, boolean bl) throws IOException {
        ApplicationArchivist.addIcon(this.application, this, file, bl);
    }

    private static void addIcon(Descriptor descriptor, Archivist archivist, File file, boolean bl) throws IOException {
        Vector vector = archivist.getEntryNames();
        Hashtable<String, File> hashtable = new Hashtable<String, File>();
        String string = Descriptor.createUniqueNameAmongst(file.getName(), vector);
        hashtable.put(string, file);
        String string2 = null;
        string2 = bl ? descriptor.getSmallIconUri() : descriptor.getLargeIconUri();
        if (!"".equals(string2)) {
            Vector<String> vector2 = new Vector<String>();
            vector2.add(string2);
            archivist.removeEntries(vector2);
        }
        archivist.addFiles(hashtable);
        if (bl) {
            descriptor.setSmallIconUri(string);
        } else {
            descriptor.setLargeIconUri(string);
        }
    }

    public void add16Icon(BundleDescriptor bundleDescriptor, Descriptor descriptor, File file) throws IOException {
        this.addIcon(bundleDescriptor, descriptor, file, true);
    }

    public void add32Icon(BundleDescriptor bundleDescriptor, Descriptor descriptor, File file) throws IOException {
        this.addIcon(bundleDescriptor, descriptor, file, false);
    }

    private void addIcon(BundleDescriptor bundleDescriptor, Descriptor descriptor, File file, boolean bl) throws IOException {
        try {
            ApplicationArchivist.addIcon(descriptor, bundleDescriptor.getArchivist(), file, bl);
        }
        catch (Throwable throwable) {}
    }

    public void add32Icon(File file) throws IOException {
        this.addIcon(file, false);
    }

    public void addApplicationJar(File file) throws IOException, ArchiveException {
        Application application = ApplicationArchivist.open(file);
        File file2 = Archivist.createTempFile(this.getApplicationDirectory());
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        Vector<String> vector = new Vector<String>();
        vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        vector.addElement("META-INF/MANIFEST.MF");
        vector.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        JarFile jarFile = new JarFile(this.getApplicationFile());
        Archivist.addJarToOutput(zipOutputStream, jarFile, vector);
        jarFile.close();
        JarFile jarFile2 = new JarFile(file);
        Archivist.addJarToOutput(zipOutputStream, jarFile2, vector);
        jarFile2.close();
        this.application.addApplication(application);
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, zipOutputStream);
        this.writeApplicationDeploymentInfo(zipOutputStream, true);
        zipOutputStream.close();
        fileOutputStream.close();
        this.getApplicationFile().delete();
        if (!file2.renameTo(this.getApplicationFile()) && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.errorrenamingjarfiletoappfile", "Error renaming JAR {0} to {1}", new Object[]{file2, this.getApplicationFile()}));
        }
        this.setClassLoader(null);
        this.application.changed();
    }

    private Hashtable createLibraryJarHashtable(Set set) {
        Hashtable<String, File> hashtable = new Hashtable<String, File>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            hashtable.put(LIBRARY_JAR_URI_ROOT + file.getName(), file);
        }
        return hashtable;
    }

    public EjbBundleDescriptor addEjbJar(File file, String string) throws IOException, ArchiveException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        this.save(this.getApplicationFile(), true);
        EjbBundleDescriptor ejbBundleDescriptor = null;
        EjbBundleArchivist ejbBundleArchivist = null;
        String string2 = super.getUniqueEntryFilenameFor(this.getApplicationFile(), file.getName());
        if (string != null && !"".equals(string) && ((File)(object4 = new File(string))).exists()) {
            object3 = new FileInputStream((File)object4);
            try {
                object2 = EjbBundleNode.read((InputStream)object3, false);
                ejbBundleDescriptor = ((EjbBundleNode)((Object)object2)).getDescriptor();
                ejbBundleArchivist = new EjbBundleArchivist(string2, ejbBundleDescriptor);
            }
            catch (ParseException parseException) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.errorwithexternaldescriptors", "Supplied External Descriptors {0} are incorect", new Object[]{string}));
                }
                _logger.log(Level.WARNING, "enterprise.deployment_incorrect_descriptor", parseException);
            }
        }
        if (ejbBundleDescriptor == null) {
            ejbBundleDescriptor = EjbBundleArchivist.open(file);
            ejbBundleArchivist = (EjbBundleArchivist)ejbBundleDescriptor.getArchivist();
            ejbBundleArchivist.setArchiveUri(string2);
        }
        if (!((String)(object4 = ejbBundleDescriptor.getEjbClientJarUri())).equals("")) {
            object3 = ((String)object4).replace('/', File.separatorChar);
            object2 = new File(file.getParentFile(), (String)object3);
            if (((File)object2).exists()) {
                object = new Hashtable();
                ((Hashtable)object).put(object4, object2);
                super.addFiles((Hashtable)object, this.getApplicationFile());
                ejbBundleArchivist.addManfiestClasspath((String)object4);
            } else {
                throw new FileNotFoundException(localStrings.getLocalString("enterprise.deployment.noclientjarentry", "Warning: {0} not found as a client jar entry.", new Object[]{((File)object2).toString()}));
            }
        }
        if (string != null && !"".equals(string)) {
            ejbBundleArchivist.setExternalDescriptorArchiveUri(string);
        }
        object3 = Archivist.createTempFile(this.getApplicationDirectory());
        object2 = new JarFile(this.getApplicationFile());
        object = new FileOutputStream((File)object3);
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)object);
        Vector<String> vector = new Vector<String>();
        vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        vector.addElement("META-INF/MANIFEST.MF");
        vector.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        Archivist.addJarToOutput(zipOutputStream, (JarFile)object2, vector);
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(string2);
        zipOutputStream.putNextEntry(zipEntry);
        Archivist.copy(fileInputStream, zipOutputStream);
        fileInputStream.close();
        ((ZipFile)object2).close();
        this.getApplicationFile().delete();
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, zipOutputStream);
        this.application.addEjbBundleDescriptor(ejbBundleDescriptor);
        this.writeApplicationDeploymentInfo(zipOutputStream, true);
        zipOutputStream.close();
        ((FileOutputStream)object).close();
        this.getApplicationFile().delete();
        if (!((File)object3).renameTo(this.getApplicationFile()) && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.errorrenamingjar", "Error renaming JAR"));
        }
        this.setApplicationFile(this.getApplicationFile());
        this.application.changed();
        return ejbBundleDescriptor;
    }

    public EjbBundleDescriptor addEjbJar(File file) throws IOException, ArchiveException {
        return this.addEjbJar(file, null);
    }

    public void addEjbJar(EjbBundleDescriptor ejbBundleDescriptor, FileContentsDescriptor fileContentsDescriptor, Set set, Descriptor descriptor) throws IOException {
        Object object;
        Application application;
        Archivist archivist = null;
        if (descriptor instanceof Application) {
            application = (Application)descriptor;
            object = application.getApplicationArchivist().createUniqueEjbURI();
            archivist = new EjbBundleArchivist(false, (String)object, ejbBundleDescriptor, new HashSet());
            application.addEjbBundleDescriptor(ejbBundleDescriptor);
        } else {
            object = (EjbBundleDescriptor)descriptor;
            application = ((BundleDescriptor)object).getApplication();
            archivist = ((BundleDescriptor)object).getArchivist();
            ((EjbBundleDescriptor)object).addEjbBundleDescriptor(ejbBundleDescriptor);
        }
        object = archivist.createEntryNameMap(fileContentsDescriptor);
        archivist.addFiles((Hashtable)object);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            archivist.addManfiestClasspath((String)iterator.next());
        }
        application.getApplicationArchivist().save(true);
    }

    public void removeDescriptor(Descriptor descriptor) throws IOException {
        if (descriptor instanceof EjbDescriptor) {
            EjbDescriptor ejbDescriptor = (EjbDescriptor)descriptor;
            EjbBundleDescriptor ejbBundleDescriptor = ejbDescriptor.getEjbBundleDescriptor();
            ejbBundleDescriptor.removeEjb(ejbDescriptor);
        } else if (descriptor instanceof WebComponentDescriptor) {
            WebComponentDescriptorImpl webComponentDescriptorImpl = (WebComponentDescriptorImpl)descriptor;
            WebBundleDescriptor webBundleDescriptor = webComponentDescriptorImpl.getWebBundleDescriptor();
            webBundleDescriptor.removeWebComponentDescriptor(webComponentDescriptorImpl);
        } else {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionbundledescriptorunknowntype", "{0} is an unknown type for removing", new Object[]{descriptor}));
        }
        this.save(true);
    }

    public void removeBundleDescriptor(BundleDescriptor bundleDescriptor) throws IOException {
        if (bundleDescriptor instanceof EjbBundleDescriptor) {
            this.application.removeEjbBundleDescriptor((EjbBundleDescriptor)bundleDescriptor);
        } else if (bundleDescriptor instanceof WebBundleDescriptor) {
            this.application.removeWebBundleDescriptor((WebBundleDescriptor)bundleDescriptor);
        } else if (bundleDescriptor instanceof ApplicationClientDescriptor) {
            this.application.removeApplicationClientDescriptor((ApplicationClientDescriptor)bundleDescriptor);
        } else if (bundleDescriptor instanceof ConnectorDescriptor) {
            this.application.removeRarDescriptor((ConnectorDescriptor)bundleDescriptor);
        } else {
            throw new RuntimeException(localStrings.getLocalString("enterprise.deployment.exceptionbundledescriptorunknowntype", "{0} is an unknown type for removing", new Object[]{bundleDescriptor}));
        }
        super.removeEntry(bundleDescriptor.getArchivist().getArchiveUri());
        this.save(true);
    }

    public void addWebComponent(WebBundleDescriptor webBundleDescriptor, FileContentsDescriptor fileContentsDescriptor, FileContentsDescriptor fileContentsDescriptor2, Descriptor descriptor) throws IOException {
        Object object;
        Application application;
        Archivist archivist = null;
        WebBundleDescriptor webBundleDescriptor2 = null;
        if (descriptor instanceof Application) {
            application = (Application)descriptor;
            object = application.getApplicationArchivist().createUniqueWarURI();
            archivist = new WebBundleArchivist(false, (String)object, webBundleDescriptor);
            application.addWebBundleDescriptor(webBundleDescriptor);
        } else {
            webBundleDescriptor2 = (WebBundleDescriptor)descriptor;
            application = webBundleDescriptor2.getApplication();
            archivist = webBundleDescriptor2.getArchivist();
            webBundleDescriptor2.addWebBundleDescriptor(webBundleDescriptor);
        }
        object = ((WebBundleArchivist)archivist).createEntryNameMap(fileContentsDescriptor, fileContentsDescriptor2);
        archivist.addFiles((Hashtable)object);
        application.getApplicationArchivist().save(true);
    }

    public void addWebJar(File file, String string) throws IOException, ArchiveException {
        Object object;
        Object object2;
        Closeable closeable;
        File file2;
        this.save(this.getApplicationFile(), true);
        String string2 = super.getUniqueEntryFilenameFor(this.getApplicationFile(), file.getName());
        WebBundleDescriptor webBundleDescriptor = null;
        Archivist archivist = null;
        if (string != null && !"".equals(string) && (file2 = new File(string)).exists()) {
            closeable = new FileInputStream(file2);
            try {
                object2 = new WebDescriptorFactoryImpl();
                object = new WebApplicationReader();
                webBundleDescriptor = (WebBundleDescriptor)((WebApplicationReader)object).getDescriptor((InputStream)closeable, (WebDescriptorFactory)object2);
                archivist = new WebBundleArchivist(string2, webBundleDescriptor);
            }
            catch (Exception exception) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.errorwithexternaldescriptors", "Supplied External Descriptors {0} are incorect", new Object[]{string}));
                }
                _logger.log(Level.WARNING, "enterprise.deployment_incorrect_descriptor", exception);
            }
        }
        if (webBundleDescriptor == null) {
            webBundleDescriptor = WebBundleArchivist.open(file);
            archivist = webBundleDescriptor.getArchivist();
            archivist.setArchiveUri(string2);
        }
        if (string != null && !"".equals(string)) {
            archivist.setExternalDescriptorArchiveUri(string);
        }
        file2 = Archivist.createTempFile(this.getApplicationDirectory());
        closeable = new JarFile(this.getApplicationFile());
        object2 = new FileOutputStream(file2);
        object = new ZipOutputStream((OutputStream)object2);
        Vector<String> vector = new Vector<String>();
        vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        vector.addElement("META-INF/MANIFEST.MF");
        vector.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        Archivist.addJarToOutput((ZipOutputStream)object, (JarFile)closeable, vector);
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(string2);
        ((ZipOutputStream)object).putNextEntry(zipEntry);
        Archivist.copy(fileInputStream, (OutputStream)object);
        fileInputStream.close();
        ((ZipFile)closeable).close();
        this.getApplicationFile().delete();
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, (ZipOutputStream)object);
        this.application.addWebBundleDescriptor(webBundleDescriptor);
        this.writeApplicationDeploymentInfo((ZipOutputStream)object, true);
        ((ZipOutputStream)object).close();
        ((FileOutputStream)object2).close();
        this.getApplicationFile().delete();
        if (!file2.renameTo(this.getApplicationFile()) && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.errorrenamingjar", "Error renaming JAR"));
        }
        this.setApplicationFile(this.getApplicationFile());
        this.application.changed();
    }

    public void addWebJar(File file) throws IOException, ArchiveException {
        this.addWebJar(file, null);
    }

    public void addApplicationClient(ApplicationClientDescriptor applicationClientDescriptor, FileContentsDescriptor fileContentsDescriptor, Set set, Application application) throws IOException {
        String string = application.getApplicationArchivist().createUniqueAppClientURI();
        ApplicationClientArchivist applicationClientArchivist = new ApplicationClientArchivist(false, string, applicationClientDescriptor, set);
        application.addApplicationClientDescriptor(applicationClientDescriptor);
        Hashtable hashtable = ((Archivist)applicationClientArchivist).createEntryNameMap(fileContentsDescriptor);
        applicationClientArchivist.addFiles(hashtable);
        application.getApplicationArchivist().save(true);
    }

    public ApplicationClientDescriptor addApplicationClientJar(File file, Set set) throws IOException, ArchiveException {
        return this.addApplicationClientJar(file, set, null);
    }

    public ApplicationClientDescriptor addApplicationClientJar(File file, Set set, String string) throws IOException, ArchiveException {
        Object object;
        Cloneable cloneable;
        Closeable closeable;
        Object object2;
        Object object3;
        Serializable serializable;
        this.save(this.getApplicationFile(), true);
        String string2 = super.getUniqueEntryFilenameFor(this.getApplicationFile(), file.getName());
        ApplicationClientDescriptor applicationClientDescriptor = null;
        ApplicationClientArchivist applicationClientArchivist = null;
        if (string != null && !"".equals(string) && ((File)(serializable = new File(string))).exists()) {
            object3 = new FileInputStream((File)serializable);
            try {
                object2 = ApplicationClientNode.read((InputStream)object3, false);
                applicationClientDescriptor = ((ApplicationClientNode)((Object)object2)).getDescriptor();
                applicationClientArchivist = new ApplicationClientArchivist(string2, applicationClientDescriptor);
                closeable = new JarFile(file);
                cloneable = ((JarFile)closeable).getManifest();
                if (cloneable != null && (object = ((Manifest)cloneable).getMainAttributes().getValue(Attributes.Name.MAIN_CLASS)) != null) {
                    applicationClientDescriptor.setMainClassName((String)object);
                }
                ((ZipFile)closeable).close();
            }
            catch (ParseException parseException) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.errorwithexternaldescriptors", "Supplied External Descriptors {0} are incorect", new Object[]{string}));
                }
                _logger.log(Level.WARNING, "enterprise.deployment_incorrect_descriptor", parseException);
            }
        }
        if (applicationClientDescriptor == null) {
            applicationClientDescriptor = ApplicationClientArchivist.open(file);
            applicationClientArchivist = (ApplicationClientArchivist)applicationClientDescriptor.getArchivist();
            applicationClientArchivist.setArchiveUri(string2);
        }
        if (string != null && !"".equals(string)) {
            applicationClientArchivist.setExternalDescriptorArchiveUri(string);
        }
        if (!set.isEmpty()) {
            serializable = this.createLibraryJarHashtable(set);
            serializable = super.addFiles((Hashtable)serializable, this.getApplicationFile());
            object3 = ((Hashtable)serializable).keys();
            while (object3.hasMoreElements()) {
                object2 = (String)object3.nextElement();
                applicationClientArchivist.addManfiestClasspath((String)object2);
            }
            applicationClientArchivist.save(applicationClientArchivist.getApplicationClientJarFile(), true);
        }
        serializable = Archivist.createTempFile(this.getApplicationDirectory());
        object3 = new JarFile(this.getApplicationFile());
        object2 = new FileOutputStream((File)serializable);
        closeable = new ZipOutputStream((OutputStream)object2);
        cloneable = new Vector<String>();
        ((Vector)cloneable).addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        ((Vector)cloneable).addElement("META-INF/MANIFEST.MF");
        ((Vector)cloneable).addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        Archivist.addJarToOutput((ZipOutputStream)closeable, (JarFile)object3, (Vector)cloneable);
        object = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(string2);
        ((ZipOutputStream)closeable).putNextEntry(zipEntry);
        Archivist.copy((InputStream)object, (OutputStream)closeable);
        ((FileInputStream)object).close();
        ((ZipFile)object3).close();
        this.getApplicationFile().delete();
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, (ZipOutputStream)closeable);
        this.application.addApplicationClientDescriptor(applicationClientDescriptor);
        this.writeApplicationDeploymentInfo((ZipOutputStream)closeable, true);
        ((ZipOutputStream)closeable).close();
        ((FileOutputStream)object2).close();
        if (!((File)serializable).renameTo(this.getApplicationFile()) && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.errorrenamingjar", "Error renaming JAR"));
        }
        this.setApplicationFile(this.getApplicationFile());
        this.application.changed();
        return applicationClientDescriptor;
    }

    public ConnectorDescriptor addRar(File file, Set set) throws IOException, ArchiveException {
        return this.addRar(file, set, null);
    }

    public ConnectorDescriptor addRar(File file, Set set, String string) throws IOException, ArchiveException {
        Object object;
        Object object2;
        Serializable serializable;
        this.save(this.getApplicationFile(), true);
        ConnectorDescriptor connectorDescriptor = null;
        ConnectorArchivist connectorArchivist = null;
        String string2 = super.getUniqueEntryFilenameFor(this.getApplicationFile(), file.getName());
        if (string != null && !"".equals(string) && ((File)(serializable = new File(string))).exists()) {
            object2 = new FileInputStream((File)serializable);
            try {
                object = ConnectorNode.read((InputStream)object2, false);
                connectorDescriptor = ((ConnectorNode)object).getDescriptor();
                connectorArchivist = new ConnectorArchivist(string2, connectorDescriptor);
            }
            catch (ParseException parseException) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.errorwithexternaldescriptors", "Supplied External Descriptors {0} are incorect", new Object[]{string}));
                }
                _logger.log(Level.WARNING, "enterprise.deployment_incorrect_descriptor", parseException);
            }
        }
        if (connectorDescriptor == null) {
            connectorDescriptor = ConnectorArchivist.open(file);
            connectorArchivist = (ConnectorArchivist)connectorDescriptor.getArchivist();
            connectorArchivist.setArchiveUri(string2);
        }
        if (string != null && !"".equals(string)) {
            connectorArchivist.setExternalDescriptorArchiveUri(string);
        }
        if (!set.isEmpty()) {
            serializable = this.createLibraryJarHashtable(set);
            serializable = super.addFiles((Hashtable)serializable, this.getApplicationFile());
            object2 = ((Hashtable)serializable).keys();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                connectorArchivist.addManfiestClasspath((String)object);
            }
            connectorArchivist.save(connectorArchivist.getRarFile());
        }
        serializable = Archivist.createTempFile(this.getApplicationDirectory());
        object2 = new JarFile(this.getApplicationFile());
        object = new FileOutputStream((File)serializable);
        ZipOutputStream zipOutputStream = new ZipOutputStream((OutputStream)object);
        Vector<String> vector = new Vector<String>();
        vector.addElement(DEPLOYMENT_DESCRIPTOR_ENTRY);
        vector.addElement("META-INF/MANIFEST.MF");
        vector.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        Archivist.addJarToOutput(zipOutputStream, (JarFile)object2, vector);
        FileInputStream fileInputStream = new FileInputStream(file);
        ZipEntry zipEntry = new ZipEntry(string2);
        zipOutputStream.putNextEntry(zipEntry);
        Archivist.copy(fileInputStream, zipOutputStream);
        fileInputStream.close();
        ((ZipFile)object2).close();
        this.getApplicationFile().delete();
        Manifest manifest = new Manifest();
        ApplicationArchivist.writeManifest(manifest, zipOutputStream);
        this.application.addRarDescriptor(connectorDescriptor);
        this.writeApplicationDeploymentInfo(zipOutputStream, false);
        zipOutputStream.close();
        ((FileOutputStream)object).close();
        if (!((File)serializable).renameTo(this.getApplicationFile()) && _logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, localStrings.getLocalString("enterprise.deployment.errorrenamingrar", "Error renaming RAR"));
        }
        this.setApplicationFile(this.getApplicationFile());
        this.application.changed();
        return connectorDescriptor;
    }

    public void addRar(ConnectorDescriptor connectorDescriptor, FileContentsDescriptor fileContentsDescriptor, Set set, Application application) throws IOException {
        String string = application.getApplicationArchivist().createUniqueRarURI();
        ConnectorArchivist connectorArchivist = new ConnectorArchivist(false, string, connectorDescriptor, set);
        application.addRarDescriptor(connectorDescriptor);
        Hashtable hashtable = connectorArchivist.createEntryNameMap(fileContentsDescriptor);
        connectorArchivist.addFiles(hashtable);
        application.getApplicationArchivist().save(true);
    }

    private void extractEjbJar(EjbBundleDescriptor ejbBundleDescriptor, File file) throws IOException {
        this.extractBundleToFile(ejbBundleDescriptor, file);
    }

    private static void extractJar(String string, JarFile jarFile, File file) throws IOException {
        String string2 = file.getAbsolutePath();
        String string3 = new File(string2).getParent();
        new File(string3).mkdirs();
        ZipEntry zipEntry = jarFile.getEntry(string);
        if (zipEntry == null) {
            throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionarchiveurinotfoundinappjar", "{0} not found in {1}", new Object[]{string, jarFile.getName()}));
        }
        InputStream inputStream = jarFile.getInputStream(zipEntry);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        Archivist.copy(inputStream, fileOutputStream);
        inputStream.close();
        fileOutputStream.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extractBundleToFile(BundleDescriptor bundleDescriptor, File file) throws IOException {
        Archivist archivist = bundleDescriptor.getArchivist();
        JarFile jarFile = new JarFile(this.getApplicationFile());
        try {
            ApplicationArchivist.extractJar(archivist.getArchiveUri(), jarFile, file);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            jarFile.close();
            throw throwable;
        }
        jarFile.close();
    }

    private void extractWebJar(WebBundleDescriptor webBundleDescriptor, File file) throws IOException {
        this.extractBundleToFile(webBundleDescriptor, file);
    }

    private void extractApplicationClientJar(ApplicationClientDescriptor applicationClientDescriptor, File file) throws IOException {
        this.extractBundleToFile(applicationClientDescriptor, file);
    }

    private void extractRar(ConnectorDescriptor connectorDescriptor, File file) throws IOException {
        this.extractBundleToFile(connectorDescriptor, file);
    }

    public static boolean isApplication(File file) throws IOException {
        Archivist.checkExists(file);
        JarFile jarFile = new JarFile(file);
        ZipEntry zipEntry = jarFile.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
        boolean bl = zipEntry != null;
        jarFile.close();
        return bl;
    }

    public static void writeManifest(Manifest manifest, ZipOutputStream zipOutputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry("META-INF/MANIFEST.MF");
        zipEntry.setTime(System.currentTimeMillis());
        zipOutputStream.putNextEntry(zipEntry);
        manifest.write(zipOutputStream);
        zipOutputStream.closeEntry();
    }

    private File getApplicationDirectory() {
        return Archivist.getDirectory(this.getApplicationFile());
    }

    public String toString() {
        return "ApplicationArchivist " + this.applicationFile;
    }

    public static void expandRarFile(JarFile jarFile, ZipOutputStream zipOutputStream) throws IOException {
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry;
            ZipEntry zipEntry2 = enumeration.nextElement();
            if (!zipEntry2.getName().endsWith(".jar")) continue;
            InputStream inputStream = jarFile.getInputStream(zipEntry2);
            JarInputStream jarInputStream = new JarInputStream(inputStream);
            while ((zipEntry = jarInputStream.getNextEntry()) != null) {
                try {
                    zipOutputStream.putNextEntry(new ZipEntry(zipEntry.getName()));
                    Archivist.copyWithoutClose(jarInputStream, zipOutputStream);
                    zipOutputStream.closeEntry();
                }
                catch (ZipException zipException) {}
            }
        }
    }

    public static String getApplicationName(File file) throws IOException {
        block4: {
            if (!file.exists()) {
                throw new IOException(localStrings.getLocalString("enterprise.deployment.exceptionjarfiledoesn'texist", "{0} does not exist", new Object[]{file}));
            }
            JarFile jarFile = new JarFile(file);
            ZipEntry zipEntry = jarFile.getEntry(DEPLOYMENT_DESCRIPTOR_ENTRY);
            if (zipEntry == null) break block4;
            try {
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setValidating(false);
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                XMLValidationHandler xMLValidationHandler = new XMLValidationHandler(false);
                documentBuilder.setEntityResolver(xMLValidationHandler);
                Document document = documentBuilder.parse(new InputSource(jarFile.getInputStream(zipEntry)));
                NodeList nodeList = document.getElementsByTagName("display-name");
                if (nodeList.getLength() == 1) {
                    Node node = nodeList.item(0);
                    return node.getFirstChild().getNodeValue();
                }
            }
            catch (Exception exception) {
                _logger.log(Level.FINEST, "Cannot resolve application name", exception);
            }
        }
        return null;
    }

    protected Vector getListOfExemptForClassLoadableFormat() {
        Vector vector = super.getListOfExemptForClassLoadableFormat();
        vector.addElement(RI_SPECIFIC_DESCRIPTOR_ENTRY);
        return vector;
    }

    public void saveInClassLoadableFormat(AbstractArchive abstractArchive) throws IOException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Vector vector = this.getEntryNames();
        Vector<Object> vector2 = new Vector<Object>();
        JarFile jarFile = new JarFile(this.getApplicationFile());
        Set set = this.application.getArchivableDescriptors();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object6 = (BundleDescriptor)iterator.next();
            object5 = ((BundleDescriptor)object6).getArchivist();
            object4 = jarFile.getEntry(((Archivist)object5).getArchiveUri());
            object3 = new JarInputStream(jarFile.getInputStream((ZipEntry)object4));
            ((Archivist)object5).makeArchiveClassLoadable((JarInputStream)object3, abstractArchive);
            vector.remove(((Archivist)object5).getArchiveUri());
            object2 = ((Archivist)object5).getLibraryJars(this);
            vector2.addAll((Collection<Object>)object2);
            vector.removeAll((Collection<?>)object2);
            object = jarFile.getInputStream((ZipEntry)object4);
            abstractArchive.addEntry(((Archivist)object5).getArchiveUri(), (InputStream)object);
            ((InputStream)object).close();
        }
        object6 = vector.iterator();
        while (object6.hasNext()) {
            object5 = (String)object6.next();
            if (!((String)object5).endsWith(".jar")) continue;
            vector2.add(object5);
        }
        object5 = vector2.iterator();
        while (object5.hasNext()) {
            object4 = (String)object5.next();
            Archivist.extractJarFile(new JarInputStream(jarFile.getInputStream(jarFile.getEntry((String)object4))), abstractArchive);
        }
        object4 = this.getListOfExemptForClassLoadableFormat();
        object3 = vector.iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            if (((Vector)object4).contains(object2) || ((ZipEntry)(object = jarFile.getEntry((String)object2))).isDirectory()) continue;
            InputStream inputStream = jarFile.getInputStream((ZipEntry)object);
            abstractArchive.addEntry((String)object2, inputStream);
        }
    }

    static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Come on, give me an archive !");
            return;
        }
        File file = new File(stringArray[0]);
        if (file.exists()) {
            try {
                String string = System.getProperty("user.dir");
                string = string + File.separator + "explodedTMP";
                File file2 = new File(string);
                file2.mkdirs();
                FileClassLoader fileClassLoader = new FileClassLoader(file2.getAbsolutePath());
                Application application = ApplicationArchivist.open(file, fileClassLoader);
                _logger.log(Level.FINE, "Saving in " + file2.getAbsolutePath());
                DirectoryArchive directoryArchive = new DirectoryArchive(file2.getAbsolutePath());
                application.getApplicationArchivist().saveInClassLoadableFormat(directoryArchive);
                Iterator iterator = directoryArchive.getListOfEntries().iterator();
                while (iterator.hasNext()) {
                    System.out.println(iterator.next());
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            System.err.println("File " + stringArray[0] + "  not found ");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

