/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deployment;

import com.iplanet.ias.tools.common.dd.application.SunApplication;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import com.sun.logging.LogDomains;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Application
extends Descriptor
implements NotificationListener,
Roles {
    private ArrayList iasWebUriList;
    private transient ApplicationArchivist applicationArchivist;
    private Set ejbBundleDescriptors = new HashSet();
    private long uniqueId;
    private boolean virtual = false;
    private Boolean passByReference = null;
    private Set webBundleDescriptors = new HashSet();
    private Set applicationClientDescriptors = new HashSet();
    private Set rarDescriptors = new HashSet();
    private Hashtable cmpDescriptors = null;
    private boolean isDirty;
    private RoleMapper roleMapper;
    private String registrationName;
    private SunApplication sunApp = new SunApplication();
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$deployment$Application == null ? (class$com$sun$enterprise$deployment$Application = Application.class$("com.sun.enterprise.deployment.Application")) : class$com$sun$enterprise$deployment$Application);
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.tools.deployment");
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Application;

    public Application(String string, File file) {
        super(string, localStrings.getLocalString("enterprise.deployment.application.description", "Application description"));
        this.applicationArchivist = new ApplicationArchivist(file, this);
    }

    public Application() {
        super("", localStrings.getLocalString("enterprise.deployment.application.description", "Application description"));
    }

    public SunApplication getSunApp() {
        return this.sunApp;
    }

    public void setSunApp(SunApplication sunApplication) {
        this.sunApp = sunApplication;
    }

    public void setRegistrationName(String string) {
        this.registrationName = string;
    }

    public String getRegistrationName() {
        return this.registrationName;
    }

    public Set getRoles() {
        Object object;
        HashSet hashSet = new HashSet();
        Iterator iterator = this.getWebBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            object = (WebBundleDescriptor)iterator.next();
            hashSet.addAll(((BundleDescriptor)object).getRoles());
        }
        object = this.getEjbBundleDescriptors().iterator();
        while (object.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)object.next();
            hashSet.addAll(ejbBundleDescriptor.getRoles());
        }
        return hashSet;
    }

    public void addRole(Role role) {
        Object object;
        Iterator iterator = this.getWebBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            object = (WebBundleDescriptor)iterator.next();
            ((BundleDescriptor)object).addRole(role);
        }
        object = this.getEjbBundleDescriptors().iterator();
        while (object.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)object.next();
            ejbBundleDescriptor.addRole(role);
        }
        this.changed();
    }

    public void removeRole(Role role) {
        Object object;
        Iterator iterator = this.getWebBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            object = (WebBundleDescriptor)iterator.next();
            ((BundleDescriptor)object).removeRole(role);
        }
        object = this.getEjbBundleDescriptors().iterator();
        while (object.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)object.next();
            ejbBundleDescriptor.removeRole(role);
        }
        this.changed();
    }

    public Set getResourceReferenceDescriptors() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.getEjbBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
            hashSet.addAll(ejbBundleDescriptor.getResourceReferenceDescriptors());
        }
        return hashSet;
    }

    void setApplicationArchivist(ApplicationArchivist applicationArchivist) {
        this.applicationArchivist = applicationArchivist;
    }

    public void setDummyArchivist(ApplicationArchivist applicationArchivist) {
        this.applicationArchivist = applicationArchivist;
    }

    public ApplicationArchivist getApplicationArchivist() {
        return this.applicationArchivist;
    }

    public void setName(String string) {
        string = string.replace('/', '-');
        string = string.replace('\\', '-');
        this.setDirty(true);
        super.setName(string);
        this.getRoleMapper().setName(string);
    }

    public void setDescription(String string) {
        this.setDirty(true);
        super.setDescription(string);
    }

    public void setLargeIconUri(String string) {
        this.setDirty(true);
        super.setLargeIconUri(string);
    }

    public void setSmallIconUri(String string) {
        this.setDirty(true);
        super.setSmallIconUri(string);
    }

    public int getWebComponentCount() {
        int n = 0;
        Iterator iterator = this.getWebBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)iterator.next();
            n += webBundleDescriptor.getWebDescriptors().size();
        }
        return n;
    }

    public int getEjbComponentCount() {
        int n = 0;
        Iterator iterator = this.getEjbBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
            n += ejbBundleDescriptor.getEjbs().size();
        }
        return n;
    }

    public int getRarComponentCount() {
        return this.getRarDescriptors().size();
    }

    public Vector getEjbReferenceDescriptors() {
        Vector vector = new Vector();
        Iterator iterator = this.getNamedDescriptors().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof EjbReferenceDescriptor)) continue;
            vector.addElement(e);
        }
        return vector;
    }

    public EjbBundleDescriptor getEjbBundleByName(String string) {
        Iterator iterator = this.getEjbBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
            if (!ejbBundleDescriptor.getName().equals(string)) continue;
            return ejbBundleDescriptor;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoejbjarnamed", "This application has no ejb jars of name {0}", new Object[]{string}));
    }

    public EjbBundleDescriptor getEjbBundleByUri(String string) {
        Iterator iterator = this.getEjbBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
            if (!ejbBundleDescriptor.getArchivist().getArchiveUri().equals(string)) continue;
            return ejbBundleDescriptor;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoejbjarnamed", "This application has no ejb jars of name {0}", new Object[]{string}));
    }

    public EjbDescriptor getEjbByName(String string) {
        Object var2_2 = null;
        Iterator iterator = this.getEjbBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
            if (!ejbBundleDescriptor.hasEjbByName(string)) continue;
            return ejbBundleDescriptor.getEjbByName(string);
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnobeannamed", "This application has no beans of name {0}", new Object[]{string}));
    }

    public boolean hasEjbByName(String string) {
        Object var2_2 = null;
        Iterator iterator = this.getEjbBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
            if (!ejbBundleDescriptor.hasEjbByName(string)) continue;
            return true;
        }
        return false;
    }

    public ApplicationClientDescriptor getApplicationClientByName(String string) {
        Iterator iterator = this.getApplicationClientDescriptors().iterator();
        while (iterator.hasNext()) {
            ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)iterator.next();
            if (!applicationClientDescriptor.getName().equals(string)) continue;
            return applicationClientDescriptor;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoappclientname", "This application has no application clients of name {0}", new Object[]{string}));
    }

    public ApplicationClientDescriptor getApplicationClientByUri(String string) {
        Iterator iterator = this.getApplicationClientDescriptors().iterator();
        while (iterator.hasNext()) {
            ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)iterator.next();
            if (!applicationClientDescriptor.getArchivist().getArchiveUri().equals(string)) continue;
            return applicationClientDescriptor;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnoappclientname", "This application has no application clients of name {0}", new Object[]{string}));
    }

    public WebBundleDescriptor getWebBundleDescriptorByName(String string) {
        Iterator iterator = this.getWebBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)iterator.next();
            if (!webBundleDescriptor.getName().equals(string)) continue;
            return webBundleDescriptor;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnowebappname", "This application has no web app of name {0}", new Object[]{string}));
    }

    public WebBundleDescriptor getWebBundleDescriptorByUri(String string) {
        Iterator iterator = this.getWebBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            WebBundleDescriptor webBundleDescriptor = (WebBundleDescriptor)iterator.next();
            if (!webBundleDescriptor.getArchivist().getArchiveUri().equals(string)) continue;
            return webBundleDescriptor;
        }
        throw new IllegalArgumentException(localStrings.getLocalString("enterprise.deployment.exceptionapphasnowebappname", "This application has no web app of name {0}", new Object[]{string}));
    }

    public ConnectorDescriptor getRarDescriptorByUri(String string) {
        Iterator iterator = this.getRarDescriptors().iterator();
        while (iterator.hasNext()) {
            ConnectorDescriptor connectorDescriptor = (ConnectorDescriptor)iterator.next();
            if (!connectorDescriptor.getArchivist().getArchiveUri().equals(string)) continue;
            return connectorDescriptor;
        }
        throw new IllegalArgumentException(string);
    }

    public Set getJndiNameEnvironments() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.getWebBundleDescriptors());
        hashSet.addAll(this.getApplicationClientDescriptors());
        hashSet.addAll(this.getEjbDescriptors());
        return hashSet;
    }

    public Set getWebBundleDescriptors() {
        if (this.webBundleDescriptors == null) {
            this.webBundleDescriptors = new HashSet();
        }
        return this.webBundleDescriptors;
    }

    public void addWebBundleDescriptor(WebBundleDescriptor webBundleDescriptor) {
        webBundleDescriptor.addNotificationListener(this);
        webBundleDescriptor.setApplication(this);
        this.getWebBundleDescriptors().add(webBundleDescriptor);
        this.changed(true);
    }

    public void removeWebBundleDescriptor(WebBundleDescriptor webBundleDescriptor) {
        webBundleDescriptor.removeNotificationListener(this);
        webBundleDescriptor.setApplication(null);
        this.getWebBundleDescriptors().remove(webBundleDescriptor);
        this.changed(true);
    }

    public Set getRarDescriptors() {
        if (this.rarDescriptors == null) {
            this.rarDescriptors = new HashSet();
        }
        return this.rarDescriptors;
    }

    public void addRarDescriptor(ConnectorDescriptor connectorDescriptor) {
        connectorDescriptor.addNotificationListener(this);
        connectorDescriptor.setApplication(this);
        this.getRarDescriptors().add(connectorDescriptor);
        this.changed(true);
    }

    public void removeRarDescriptor(ConnectorDescriptor connectorDescriptor) {
        connectorDescriptor.removeNotificationListener(this);
        connectorDescriptor.setApplication(null);
        this.getRarDescriptors().remove(connectorDescriptor);
        this.changed(true);
    }

    public Set getEjbBundleDescriptors() {
        return this.ejbBundleDescriptors;
    }

    public void addEjbBundleDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        this.getEjbBundleDescriptors().add(ejbBundleDescriptor);
        ejbBundleDescriptor.addNotificationListener(this);
        ejbBundleDescriptor.setApplication(this);
        this.changed(true);
    }

    public void removeEjbBundleDescriptor(EjbBundleDescriptor ejbBundleDescriptor) {
        this.getEjbBundleDescriptors().remove(ejbBundleDescriptor);
        ejbBundleDescriptor.removeNotificationListener(this);
        ejbBundleDescriptor.setApplication(null);
        this.changed(true);
    }

    public Set getApplicationClientDescriptors() {
        if (this.applicationClientDescriptors == null) {
            this.applicationClientDescriptors = new HashSet();
        }
        return this.applicationClientDescriptors;
    }

    public void addApplicationClientDescriptor(ApplicationClientDescriptor applicationClientDescriptor) {
        this.getApplicationClientDescriptors().add(applicationClientDescriptor);
        applicationClientDescriptor.addNotificationListener(this);
        applicationClientDescriptor.setApplication(this);
        this.changed(true);
    }

    public void removeApplicationClientDescriptor(ApplicationClientDescriptor applicationClientDescriptor) {
        this.getApplicationClientDescriptors().remove(applicationClientDescriptor);
        applicationClientDescriptor.removeNotificationListener(this);
        applicationClientDescriptor.setApplication(null);
        this.changed(true);
    }

    public EjbCMPEntityDescriptor getCMPDescriptorFor(String string) {
        if (this.cmpDescriptors == null) {
            this.cmpDescriptors = new Hashtable();
            Iterator iterator = this.getEjbBundleDescriptors().iterator();
            while (iterator.hasNext()) {
                EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
                Iterator iterator2 = ejbBundleDescriptor.getEjbs().iterator();
                while (iterator2.hasNext()) {
                    EjbDescriptor ejbDescriptor = (EjbDescriptor)iterator2.next();
                    if (!(ejbDescriptor instanceof EjbCMPEntityDescriptor)) continue;
                    this.cmpDescriptors.put(ejbDescriptor.getEjbImplClassName(), ejbDescriptor);
                }
            }
        }
        return (EjbCMPEntityDescriptor)this.cmpDescriptors.get(string);
    }

    public Vector getNamedReferencePairs() {
        Object object;
        Object object2;
        Vector vector = new Vector();
        Iterator iterator = this.getEjbBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            object2 = (EjbBundleDescriptor)iterator.next();
            vector.addAll(((EjbBundleDescriptor)object2).getNamedReferencePairs());
        }
        object2 = this.getWebBundleDescriptors().iterator();
        while (object2.hasNext()) {
            object = (WebBundleDescriptor)object2.next();
            vector.addAll(((WebBundleDescriptor)object).getNamedReferencePairs());
        }
        object = this.getApplicationClientDescriptors().iterator();
        while (object.hasNext()) {
            ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)object.next();
            vector.addAll(applicationClientDescriptor.getNamedReferencePairs());
        }
        return vector;
    }

    public Collection getNamedDescriptors() {
        Object object;
        Object object2;
        Vector vector = new Vector();
        Iterator iterator = this.getEjbBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            object2 = (EjbBundleDescriptor)iterator.next();
            vector.addAll(((EjbBundleDescriptor)object2).getNamedDescriptors());
        }
        object2 = this.getWebBundleDescriptors().iterator();
        while (object2.hasNext()) {
            object = (WebBundleDescriptor)object2.next();
            vector.addAll(((WebBundleDescriptor)object).getNamedDescriptors());
        }
        object = this.getApplicationClientDescriptors().iterator();
        while (object.hasNext()) {
            ApplicationClientDescriptor applicationClientDescriptor = (ApplicationClientDescriptor)object.next();
            vector.addAll(applicationClientDescriptor.getNamedDescriptors());
        }
        return vector;
    }

    public EjbDescriptor[] getSortedEjbDescriptors() {
        Vector vector = this.getEjbDescriptors();
        EjbDescriptor[] ejbDescriptorArray = vector.toArray(new EjbDescriptor[vector.size()]);
        Arrays.sort(ejbDescriptorArray, new Comparator(){

            public int compare(Object object, Object object2) {
                return ((EjbDescriptor)object).getName().compareTo(((EjbDescriptor)object2).getName());
            }
        });
        return ejbDescriptorArray;
    }

    public void setVirtual(boolean bl) {
        this.virtual = bl;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setUniqueId(long l) {
        _logger.log(Level.FINE, "[Application]uid: " + l);
        this.uniqueId = l;
        EjbDescriptor[] ejbDescriptorArray = this.getSortedEjbDescriptors();
        int n = 0;
        while (n < ejbDescriptorArray.length) {
            ejbDescriptorArray[n].setUniqueId(l | (long)n);
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "[Application]desc name: " + ejbDescriptorArray[n].getName());
                _logger.log(Level.FINE, "[Application]desc id: " + ejbDescriptorArray[n].getUniqueId());
            }
            ++n;
        }
    }

    public long getUniqueId() {
        return this.uniqueId;
    }

    public void setPassByReference(boolean bl) {
        this.passByReference = bl;
    }

    public boolean getPassByReference() {
        boolean bl = false;
        if (this.isPassByReferenceDefined()) {
            bl = this.passByReference;
        }
        return bl;
    }

    public boolean isPassByReferenceDefined() {
        boolean bl = false;
        if (this.passByReference != null) {
            bl = true;
        }
        return bl;
    }

    public void addIasWebUri(String string) {
        if (this.iasWebUriList == null) {
            this.iasWebUriList = new ArrayList();
        }
        this.iasWebUriList.add(string);
    }

    public ArrayList getIasWebUriList() {
        return this.iasWebUriList;
    }

    public Vector getEjbDescriptors() {
        Vector vector = new Vector();
        Iterator iterator = this.getEjbBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            EjbBundleDescriptor ejbBundleDescriptor = (EjbBundleDescriptor)iterator.next();
            vector.addAll(ejbBundleDescriptor.getEjbs());
        }
        return vector;
    }

    public void addApplication(Application application) {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator = application.getEjbBundleDescriptors().iterator();
        while (iterator.hasNext()) {
            object3 = (EjbBundleDescriptor)iterator.next();
            this.addEjbBundleDescriptor((EjbBundleDescriptor)object3);
        }
        object3 = application.getWebBundleDescriptors().iterator();
        while (object3.hasNext()) {
            object2 = (WebBundleDescriptor)object3.next();
            this.addWebBundleDescriptor((WebBundleDescriptor)object2);
        }
        object2 = application.getApplicationClientDescriptors().iterator();
        while (object2.hasNext()) {
            object = (ApplicationClientDescriptor)object2.next();
            this.addApplicationClientDescriptor((ApplicationClientDescriptor)object);
        }
        object = application.getRarDescriptors().iterator();
        while (object.hasNext()) {
            ConnectorDescriptor connectorDescriptor = (ConnectorDescriptor)object.next();
            this.addRarDescriptor(connectorDescriptor);
        }
    }

    public Set getArchivableDescriptors() {
        HashSet hashSet = new HashSet();
        hashSet.addAll(this.getEjbBundleDescriptors());
        hashSet.addAll(this.getWebBundleDescriptors());
        hashSet.addAll(this.getApplicationClientDescriptors());
        hashSet.addAll(this.getRarDescriptors());
        return hashSet;
    }

    public void setRoleMapper(RoleMapper roleMapper) {
        this.roleMapper = roleMapper;
        this.changed(true);
    }

    public boolean hasRuntimeInformation() {
        return true;
    }

    public RoleMapper getRoleMapper() {
        if (this.roleMapper == null) {
            this.roleMapper = RoleMapper.getRoleMapper(this.getName());
        }
        return this.roleMapper;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void addEjbJarFile(File file) throws Exception {
        this.applicationArchivist.addEjbJar(file);
        this.changed(true);
    }

    public void addWebJarFile(File file) throws Exception {
        this.applicationArchivist.addWebJar(file);
        this.changed(true);
    }

    public void addRarFile(File file) throws Exception {
        this.applicationArchivist.addRar(file, null, null);
        this.changed(true);
    }

    public void addAppClientJarFile(File file) throws Exception {
        this.applicationArchivist.addApplicationClientJar(file, new HashSet());
        this.changed(true);
    }

    public void notification(NotificationEvent notificationEvent) {
        this.changed(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changed() {
        NotificationEvent notificationEvent = new NotificationEvent(this, Descriptor.DESCRIPTOR_CHANGED, this);
        Vector vector = null;
        Vector vector2 = this.listeners;
        synchronized (vector2) {
            vector = (Vector)this.listeners.clone();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            NotificationListener notificationListener = (NotificationListener)enumeration.nextElement();
            notificationListener.notification(notificationEvent);
        }
    }

    public String toString() {
        String string = "Application";
        string = string + "\n name " + this.getName();
        string = string + "\n smallIcon " + super.getSmallIconUri();
        string = string + "\n archivist " + this.getApplicationArchivist();
        string = string + "\n EjbBundles: \n" + this.getEjbBundleDescriptors();
        string = string + "\n WebBundleDescriptors " + this.getWebBundleDescriptors();
        string = string + "\n applicationClientDescriptors " + this.getApplicationClientDescriptors();
        string = string + "\n roles " + this.getRoles();
        string = string + "\n RoleMapper " + this.getRoleMapper();
        return string;
    }

    void doneSaving() {
        this.isDirty = false;
        this.changed(false);
    }

    public void doneOpening() {
        this.isDirty = false;
        this.changed(false);
    }

    private void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public void changed(boolean bl) {
        if (bl) {
            this.isDirty = true;
        }
        super.changed();
    }

    public SunApplication getSunDescriptor() {
        return this.sunApp;
    }

    public void setSunDescriptor(SunApplication sunApplication) {
        this.sunApp = sunApplication;
    }

    public void addSunWebUri(String string) {
        this.addIasWebUri(string);
    }

    public ArrayList getSunWebUriList() {
        return this.getIasWebUriList();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

