/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.util.cache;

import com.sun.ejb.containers.BaseBeanCache;
import com.sun.ejb.containers.util.cache.AbstractBeanCache;
import com.sun.ejb.containers.util.cache.Cache;
import java.util.Enumeration;
import java.util.Vector;
import java.util.logging.Level;

public class MultiBeanCache
extends AbstractBeanCache
implements Cache {
    protected int maxBuckets;
    protected int bucketMask;
    protected Cache[] cache;
    protected int numberOfVictimsToSelect;
    protected int idleInCacheTimeoutInSeconds;

    public MultiBeanCache(Cache[] cacheArray) {
        this.cache = cacheArray;
        this.maxBuckets = cacheArray.length;
        this.bucketMask = this.maxBuckets - 1;
        this.numberOfVictimsToSelect = ((AbstractBeanCache)cacheArray[0]).numberOfVictimsToSelect;
        this.idleInCacheTimeoutInSeconds = ((AbstractBeanCache)cacheArray[0]).idleInCacheTimeoutInSeconds;
    }

    public Object get(Object object) {
        int n = Math.abs(object.hashCode()) & this.bucketMask;
        return this.cache[n].get(object);
    }

    public Object put(Object object, Object object2) {
        int n = Math.abs(object.hashCode()) & this.bucketMask;
        return this.cache[n].put(object, object2);
    }

    public void selectVictims(Object object) {
        int n = Math.abs(object.hashCode()) & this.bucketMask;
        ((BaseBeanCache)this.cache[n]).selectVictims();
    }

    public int size(Object object) {
        int n = Math.abs(object.hashCode()) & this.bucketMask;
        return this.cache[n].size();
    }

    public Object remove(Object object) {
        int n = Math.abs(object.hashCode()) & this.bucketMask;
        return this.cache[n].remove(object);
    }

    public boolean contains(Object object) {
        int n = Math.abs(object.hashCode()) & this.bucketMask;
        return this.cache[n].contains(object);
    }

    public Enumeration elements() {
        Vector vector = new Vector(10);
        int n = 0;
        while (n < this.maxBuckets) {
            Enumeration enumeration = this.cache[n].elements();
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
            ++n;
        }
        return vector.elements();
    }

    public void cancelTimerTasks() {
        int n = 0;
        while (n < this.maxBuckets) {
            ((AbstractBeanCache)this.cache[n]).cancelTimerTasks();
            ++n;
        }
    }

    public void clear() {
        int n = 0;
        while (n < this.maxBuckets) {
            AbstractBeanCache._logger.log(Level.FINE, "[MultiBeanCache]: Clearing Cache[" + n + "].....");
            this.cache[n].clear();
            ++n;
        }
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.maxBuckets) {
            n += this.cache[n2].size();
            ++n2;
        }
        return n;
    }

    public int getMaxCacheSize() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.maxBuckets) {
            n += this.cache[n2].getMaxCacheSize();
            ++n2;
        }
        return n;
    }

    public int getCacheHits() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.maxBuckets) {
            n += this.cache[n2].getCacheHits();
            ++n2;
        }
        return n;
    }

    public int getCacheMisses() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.maxBuckets) {
            n += this.cache[n2].getCacheMisses();
            ++n2;
        }
        return n;
    }

    public void incrementCacheSuccess(Object object) {
        int n = Math.abs(object.hashCode()) & this.bucketMask;
        this.cache[n].incrementCacheSuccess();
    }

    public void incrementCacheFailures(Object object) {
        int n = Math.abs(object.hashCode()) & this.bucketMask;
        this.cache[n].incrementCacheFailures();
    }

    public int getCurrentSize() {
        return this.size();
    }

    public int getResizeQuantity() {
        return this.numberOfVictimsToSelect;
    }

    public int getIdleTimeoutInSeconds() {
        return this.idleInCacheTimeoutInSeconds;
    }

    protected void selectVictims() {
    }

    protected void passivateIdleBeans() {
    }
}

