/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerFactoryImpl;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EntityContextImpl;
import com.sun.logging.LogDomains;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;

final class ContainerSynchronization
implements Synchronization {
    private static Logger _logger = null;
    private Vector beans = new Vector();
    private Vector pmSyncs = new Vector();
    private Transaction tx;
    private ContainerFactoryImpl containerFactory;
    static boolean flag;

    ContainerSynchronization(Transaction transaction, ContainerFactoryImpl containerFactoryImpl) {
        this.tx = transaction;
        this.containerFactory = containerFactoryImpl;
    }

    Vector getBeanList() {
        return this.beans;
    }

    void addBean(EJBContextImpl eJBContextImpl) {
        if (this.beans.contains(eJBContextImpl)) {
            return;
        }
        this.beans.add(eJBContextImpl);
    }

    void removeBean(EntityContextImpl entityContextImpl) {
        this.beans.remove(entityContextImpl);
        flag = true;
    }

    void addPMSynchronization(Synchronization synchronization) {
        this.pmSyncs.add(synchronization);
    }

    public void beforeCompletion() {
        BaseContainer baseContainer;
        int n = 0;
        while (n < this.beans.size()) {
            EJBContextImpl eJBContextImpl = (EJBContextImpl)this.beans.elementAt(n);
            baseContainer = (BaseContainer)eJBContextImpl.getContainer();
            try {
                baseContainer.beforeCompletion(eJBContextImpl);
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "ejb.remote_or_txnrollback_exception", exception);
                try {
                    this.tx.setRollbackOnly();
                }
                catch (SystemException systemException) {
                    // empty catch block
                }
                return;
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < this.pmSyncs.size()) {
            baseContainer = (Synchronization)this.pmSyncs.elementAt(n2);
            try {
                baseContainer.beforeCompletion();
            }
            catch (Exception exception) {
                _logger.log(Level.SEVERE, "ejb.remote_or_txnrollback_exception", exception);
                try {
                    this.tx.setRollbackOnly();
                }
                catch (SystemException systemException) {
                    // empty catch block
                }
                return;
            }
            ++n2;
        }
    }

    public void afterCompletion(int n) {
        int n2 = 0;
        while (n2 < this.pmSyncs.size()) {
            Synchronization synchronization = (Synchronization)this.pmSyncs.elementAt(n2);
            try {
                synchronization.afterCompletion(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.beans.size()) {
            EJBContextImpl eJBContextImpl = (EJBContextImpl)this.beans.elementAt(n3);
            BaseContainer baseContainer = (BaseContainer)eJBContextImpl.getContainer();
            try {
                baseContainer.afterCompletion(eJBContextImpl, n);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n3;
        }
        this.containerFactory.removeContainerSync(this.tx);
    }

    static {
        _logger = LogDomains.getLogger("javax.enterprise.system.container.ejb");
        flag = false;
    }
}

