/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.iiop;

import com.iplanet.ias.corba.ee.internal.util.LogWrap;
import com.iplanet.ias.util.collection.QueueClosedException;
import com.iplanet.ias.util.collection.TooManyTasksException;
import com.iplanet.ias.util.threadpool.FastThreadPool;
import com.iplanet.ias.util.threadpool.TaskQueue;
import com.sun.corba.ee.internal.iiop.BufferManagerReadStream;
import com.sun.corba.ee.internal.iiop.ByteBufferWithInfo;
import com.sun.corba.ee.internal.iiop.CDRInputStream_1_0;
import com.sun.corba.ee.internal.iiop.ClientResponseImpl;
import com.sun.corba.ee.internal.iiop.Connection;
import com.sun.corba.ee.internal.iiop.IIOPConnection;
import com.sun.corba.ee.internal.iiop.IIOPInputStream;
import com.sun.corba.ee.internal.iiop.LocateRequestProcessor;
import com.sun.corba.ee.internal.iiop.RequestProcessor;
import com.sun.corba.ee.internal.iiop.ServerRequestImpl;
import com.sun.corba.ee.internal.iiop.messages.CancelRequestMessage_1_0;
import com.sun.corba.ee.internal.iiop.messages.CancelRequestMessage_1_1;
import com.sun.corba.ee.internal.iiop.messages.CancelRequestMessage_1_2;
import com.sun.corba.ee.internal.iiop.messages.FragmentMessage_1_1;
import com.sun.corba.ee.internal.iiop.messages.FragmentMessage_1_2;
import com.sun.corba.ee.internal.iiop.messages.LocateReplyMessage_1_0;
import com.sun.corba.ee.internal.iiop.messages.LocateReplyMessage_1_1;
import com.sun.corba.ee.internal.iiop.messages.LocateReplyMessage_1_2;
import com.sun.corba.ee.internal.iiop.messages.LocateRequestMessage;
import com.sun.corba.ee.internal.iiop.messages.LocateRequestMessage_1_0;
import com.sun.corba.ee.internal.iiop.messages.LocateRequestMessage_1_1;
import com.sun.corba.ee.internal.iiop.messages.LocateRequestMessage_1_2;
import com.sun.corba.ee.internal.iiop.messages.MessageBase;
import com.sun.corba.ee.internal.iiop.messages.ReplyMessage;
import com.sun.corba.ee.internal.iiop.messages.ReplyMessage_1_0;
import com.sun.corba.ee.internal.iiop.messages.ReplyMessage_1_1;
import com.sun.corba.ee.internal.iiop.messages.ReplyMessage_1_2;
import com.sun.corba.ee.internal.iiop.messages.RequestMessage;
import com.sun.corba.ee.internal.iiop.messages.RequestMessage_1_0;
import com.sun.corba.ee.internal.iiop.messages.RequestMessage_1_1;
import com.sun.corba.ee.internal.iiop.messages.RequestMessage_1_2;
import com.sun.corba.ee.internal.orbutil.ORBUtility;
import com.sun.corba.ee.internal.orbutil.Work;
import java.io.IOException;
import java.util.logging.Level;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;

public final class MessageMediator {
    private final TaskQueue taskQueue;
    private IIOPConnection conn;
    private byte[] buf;

    public MessageMediator(IIOPConnection iIOPConnection) {
        this.conn = iIOPConnection;
        FastThreadPool fastThreadPool = iIOPConnection.getORB().getORBWorkersPool();
        this.taskQueue = fastThreadPool.getTaskQueue();
    }

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void processRequest() throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Creating message from stream");
        }
        MessageBase messageBase = (MessageBase)MessageBase.createFromStream(this.conn.getORB(), this.conn.getInputStream());
        this.buf = new byte[messageBase.getSize()];
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Reading the message fully, size =" + messageBase.getSize());
        }
        MessageBase.readFully(this.conn.getInputStream(), this.buf, 12, messageBase.getSize() - 12);
        if (this.conn.getORB().giopDebugFlag) {
            System.arraycopy(messageBase.giopHeader, 0, this.buf, 0, 12);
            this.dprint("Received message:");
            ByteBufferWithInfo byteBufferWithInfo = new ByteBufferWithInfo(this.buf, 0);
            byteBufferWithInfo.buflen = messageBase.getSize();
            CDRInputStream_1_0.printBuffer(byteBufferWithInfo);
        }
        if (!this.conn.isDisabled) {
            messageBase.callback(this);
            return;
        }
        if (messageBase instanceof LocateRequestMessage) {
            LogWrap.logger.log(Level.INFO, "iiop.locate_request_on_disabled_connection");
            messageBase.callback(this);
            return;
        }
        LogWrap.logger.log(Level.WARNING, "iiop.request_on_disabled_connection");
        throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
    }

    public final void handleInput(MessageBase messageBase) {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling other GIOP message: " + messageBase.getType());
        }
        switch (messageBase.getType()) {
            case 5: {
                if (this.conn.getORB().transportDebugFlag) {
                    this.dprint("Connection.processInput: got CloseConn, purging");
                }
                this.conn.purge_calls(1398079697, true, false);
                break;
            }
            case 6: {
                if (this.conn.getORB().transportDebugFlag) {
                    this.dprint("Received MessageError, purging");
                }
                this.conn.purge_calls(1398079698, true, false);
                break;
            }
            default: {
                if (this.conn.getORB().transportDebugFlag) {
                    this.dprint("Connection: bad message type" + messageBase.getType());
                }
                throw new INTERNAL(1398079700, CompletionStatus.COMPLETED_NO);
            }
        }
    }

    public final void handleInput(RequestMessage_1_0 requestMessage_1_0) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.0 request");
        }
        ServerRequestImpl serverRequestImpl = new ServerRequestImpl((Connection)this.conn, this.buf, requestMessage_1_0);
        try {
            this.taskQueue.addLast(new RequestProcessor(this.conn.getServerGIOP().getRequestHandler(), this.conn, serverRequestImpl));
        }
        catch (TooManyTasksException tooManyTasksException) {
            LogWrap.logger.log(Level.WARNING, "", tooManyTasksException);
            throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
        }
        catch (QueueClosedException queueClosedException) {
            LogWrap.logger.log(Level.WARNING, "", queueClosedException);
            throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
        }
    }

    public final void handleInput(RequestMessage_1_1 requestMessage_1_1) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.1 request");
        }
        ServerRequestImpl serverRequestImpl = new ServerRequestImpl((Connection)this.conn, this.buf, requestMessage_1_1);
        if (requestMessage_1_1.moreFragmentsToFollow()) {
            this.conn.theOnly1_1ServerRequestImpl = serverRequestImpl;
        }
        try {
            this.taskQueue.addLast(new RequestProcessor(this.conn.getServerGIOP().getRequestHandler(), this.conn, serverRequestImpl));
        }
        catch (TooManyTasksException tooManyTasksException) {
            LogWrap.logger.log(Level.WARNING, "", tooManyTasksException);
            throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
        }
        catch (QueueClosedException queueClosedException) {
            LogWrap.logger.log(Level.WARNING, "", queueClosedException);
            throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
        }
    }

    public final void handleInput(RequestMessage_1_2 requestMessage_1_2) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.2 request");
        }
        ServerRequestImpl serverRequestImpl = new ServerRequestImpl((Connection)this.conn, this.buf, requestMessage_1_2);
        requestMessage_1_2.unmarshalRequestID(this.buf);
        if (requestMessage_1_2.moreFragmentsToFollow()) {
            this.conn.serverRequestMap.put(new Integer(requestMessage_1_2.getRequestId()), serverRequestImpl);
        }
        try {
            this.taskQueue.addLast(new RequestProcessor(this.conn.getServerGIOP().getRequestHandler(), this.conn, serverRequestImpl));
        }
        catch (TooManyTasksException tooManyTasksException) {
            LogWrap.logger.log(Level.WARNING, "", tooManyTasksException);
            throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
        }
        catch (QueueClosedException queueClosedException) {
            LogWrap.logger.log(Level.WARNING, "", queueClosedException);
            throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
        }
    }

    public final void handleInput(ReplyMessage_1_0 replyMessage_1_0) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.0 reply");
        }
        ClientResponseImpl clientResponseImpl = new ClientResponseImpl((Connection)this.conn, this.buf, replyMessage_1_0);
        clientResponseImpl.unmarshalHeader();
        this.conn.signalReplyReceived(replyMessage_1_0.getRequestId(), clientResponseImpl);
    }

    public final void handleInput(ReplyMessage_1_1 replyMessage_1_1) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.1 reply");
        }
        ClientResponseImpl clientResponseImpl = new ClientResponseImpl((Connection)this.conn, this.buf, replyMessage_1_1);
        if (replyMessage_1_1.moreFragmentsToFollow()) {
            this.conn.theOnly1_1ClientResponseImpl = clientResponseImpl;
            try {
                this.taskQueue.addLast(new ReplyProcessor_1_1(this.conn, clientResponseImpl));
            }
            catch (TooManyTasksException tooManyTasksException) {
                LogWrap.logger.log(Level.WARNING, "", tooManyTasksException);
                throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
            }
            catch (QueueClosedException queueClosedException) {
                LogWrap.logger.log(Level.WARNING, "", queueClosedException);
                throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
            }
        } else {
            clientResponseImpl.unmarshalHeader();
            this.conn.signalReplyReceived(replyMessage_1_1.getRequestId(), clientResponseImpl);
        }
    }

    public final void handleInput(ReplyMessage_1_2 replyMessage_1_2) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.2 reply");
        }
        ClientResponseImpl clientResponseImpl = new ClientResponseImpl((Connection)this.conn, this.buf, replyMessage_1_2);
        replyMessage_1_2.unmarshalRequestID(this.buf);
        if (replyMessage_1_2.moreFragmentsToFollow()) {
            this.conn.clientReplyMap.put(new Integer(replyMessage_1_2.getRequestId()), clientResponseImpl);
        }
        this.conn.signalReplyReceived(replyMessage_1_2.getRequestId(), clientResponseImpl);
    }

    public final void handleInput(LocateRequestMessage_1_0 locateRequestMessage_1_0) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.0 LocateRequest");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, locateRequestMessage_1_0);
        try {
            this.taskQueue.addLast(new LocateRequestProcessor(this.conn.getServerGIOP().getRequestHandler(), this.conn, iIOPInputStream));
        }
        catch (TooManyTasksException tooManyTasksException) {
            LogWrap.logger.log(Level.WARNING, "", tooManyTasksException);
            throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
        }
        catch (QueueClosedException queueClosedException) {
            LogWrap.logger.log(Level.WARNING, "", queueClosedException);
            throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
        }
    }

    public final void handleInput(LocateRequestMessage_1_1 locateRequestMessage_1_1) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.1 LocateRequest");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, locateRequestMessage_1_1);
        try {
            this.taskQueue.addLast(new LocateRequestProcessor(this.conn.getServerGIOP().getRequestHandler(), this.conn, iIOPInputStream));
        }
        catch (TooManyTasksException tooManyTasksException) {
            LogWrap.logger.log(Level.WARNING, "", tooManyTasksException);
            throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
        }
        catch (QueueClosedException queueClosedException) {
            LogWrap.logger.log(Level.WARNING, "", queueClosedException);
            throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
        }
    }

    public final void handleInput(LocateRequestMessage_1_2 locateRequestMessage_1_2) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.2 LocateRequest");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, locateRequestMessage_1_2);
        locateRequestMessage_1_2.unmarshalRequestID(this.buf);
        if (locateRequestMessage_1_2.moreFragmentsToFollow()) {
            this.conn.serverRequestMap.put(new Integer(locateRequestMessage_1_2.getRequestId()), iIOPInputStream);
        }
        try {
            this.taskQueue.addLast(new LocateRequestProcessor(this.conn.getServerGIOP().getRequestHandler(), this.conn, iIOPInputStream));
        }
        catch (TooManyTasksException tooManyTasksException) {
            LogWrap.logger.log(Level.WARNING, "", tooManyTasksException);
            throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
        }
        catch (QueueClosedException queueClosedException) {
            LogWrap.logger.log(Level.WARNING, "", queueClosedException);
            throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
        }
    }

    public final void handleInput(LocateReplyMessage_1_0 locateReplyMessage_1_0) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.0 LocateReply");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, locateReplyMessage_1_0);
        iIOPInputStream.unmarshalHeader();
        this.conn.signalReplyReceived(locateReplyMessage_1_0.getRequestId(), iIOPInputStream);
    }

    public final void handleInput(LocateReplyMessage_1_1 locateReplyMessage_1_1) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.1 LocateReply");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, locateReplyMessage_1_1);
        iIOPInputStream.unmarshalHeader();
        this.conn.signalReplyReceived(locateReplyMessage_1_1.getRequestId(), iIOPInputStream);
    }

    public final void handleInput(LocateReplyMessage_1_2 locateReplyMessage_1_2) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.2 LocateReply");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, locateReplyMessage_1_2);
        locateReplyMessage_1_2.unmarshalRequestID(this.buf);
        if (locateReplyMessage_1_2.moreFragmentsToFollow()) {
            this.conn.clientReplyMap.put(new Integer(locateReplyMessage_1_2.getRequestId()), iIOPInputStream);
        }
        this.conn.signalReplyReceived(locateReplyMessage_1_2.getRequestId(), iIOPInputStream);
    }

    public final void handleInput(FragmentMessage_1_1 fragmentMessage_1_1) throws IOException {
        IIOPInputStream iIOPInputStream;
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.1 Fragment.  Last? " + fragmentMessage_1_1.moreFragmentsToFollow());
        }
        if ((iIOPInputStream = this.conn.isServer() ? this.conn.theOnly1_1ServerRequestImpl : this.conn.theOnly1_1ClientResponseImpl) == null) {
            return;
        }
        iIOPInputStream.getBufferManager().processFragment(this.buf, fragmentMessage_1_1);
        if (!this.conn.isServer() && !fragmentMessage_1_1.moreFragmentsToFollow()) {
            this.conn.theOnly1_1ClientResponseImpl = null;
        }
    }

    public final void handleInput(FragmentMessage_1_2 fragmentMessage_1_2) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.2 Fragment.  Last? " + fragmentMessage_1_2.moreFragmentsToFollow());
        }
        fragmentMessage_1_2.unmarshalRequestID(this.buf);
        Integer n = new Integer(fragmentMessage_1_2.getRequestId());
        IIOPInputStream iIOPInputStream = this.conn.isServer() ? (IIOPInputStream)this.conn.serverRequestMap.get(n) : (IIOPInputStream)this.conn.clientReplyMap.get(n);
        if (iIOPInputStream == null) {
            return;
        }
        iIOPInputStream.getBufferManager().processFragment(this.buf, fragmentMessage_1_2);
        if (!this.conn.isServer() && !fragmentMessage_1_2.moreFragmentsToFollow()) {
            this.conn.clientReplyMap.remove(n);
        }
    }

    private final void processCancelRequest(int n) {
        Object object;
        if (!this.conn.isServer()) {
            return;
        }
        IIOPInputStream iIOPInputStream = (IIOPInputStream)this.conn.serverRequestMap.get(new Integer(n));
        if (iIOPInputStream == null) {
            iIOPInputStream = this.conn.theOnly1_1ServerRequestImpl;
            if (iIOPInputStream == null) {
                return;
            }
            object = iIOPInputStream.getMessage();
            if (object.getType() != 0) {
                return;
            }
            int n2 = ((RequestMessage)object).getRequestId();
            if (n2 == 0) {
                return;
            }
            if (n2 != n) {
                return;
            }
        }
        object = (BufferManagerReadStream)iIOPInputStream.getBufferManager();
        ((BufferManagerReadStream)object).cancelProcessing(n);
    }

    public final void handleInput(CancelRequestMessage_1_0 cancelRequestMessage_1_0) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.0 CancelRequest");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, cancelRequestMessage_1_0);
        cancelRequestMessage_1_0.read(iIOPInputStream);
        this.processCancelRequest(cancelRequestMessage_1_0.getRequestId());
    }

    public final void handleInput(CancelRequestMessage_1_1 cancelRequestMessage_1_1) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.1 CancelRequest");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, cancelRequestMessage_1_1);
        cancelRequestMessage_1_1.read(iIOPInputStream);
        this.processCancelRequest(cancelRequestMessage_1_1.getRequestId());
    }

    public final void handleInput(CancelRequestMessage_1_2 cancelRequestMessage_1_2) throws IOException {
        if (this.conn.getORB().transportDebugFlag) {
            this.dprint("Handling GIOP 1.2 CancelRequest");
        }
        IIOPInputStream iIOPInputStream = new IIOPInputStream(this.conn, this.buf, cancelRequestMessage_1_2);
        cancelRequestMessage_1_2.read(iIOPInputStream);
        this.processCancelRequest(cancelRequestMessage_1_2.getRequestId());
    }

    private static class ReplyProcessor_1_1
    implements Work {
        private static final String name = "ReplyProcessor 1.1";
        private IIOPConnection conn;
        private IIOPInputStream reply;

        ReplyProcessor_1_1(IIOPConnection iIOPConnection, IIOPInputStream iIOPInputStream) {
            this.conn = iIOPConnection;
            this.reply = iIOPInputStream;
        }

        public final String getName() {
            return name;
        }

        public void process() {
            this.reply.unmarshalHeader();
            ReplyMessage replyMessage = (ReplyMessage)this.reply.getMessage();
            this.conn.signalReplyReceived(replyMessage.getRequestId(), this.reply);
        }
    }
}

