/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.ee.internal.core;

import com.sun.corba.ee.internal.core.IOR;
import com.sun.corba.ee.internal.core.ORB;
import com.sun.corba.ee.internal.core.ORBVersionImpl;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public class GIOPVersion {
    public static final GIOPVersion V1_0 = new GIOPVersion(1, 0);
    public static final GIOPVersion V1_1 = new GIOPVersion(1, 1);
    public static final GIOPVersion V1_2;
    public static final GIOPVersion DEFAULT_VERSION;
    public static final int VERSION_1_0 = 256;
    public static final int VERSION_1_1 = 257;
    public static final int VERSION_1_2 = 258;
    public byte major = 0;
    public byte minor = 0;

    public GIOPVersion() {
    }

    public GIOPVersion(byte by, byte by2) {
        this.major = by;
        this.minor = by2;
    }

    public GIOPVersion(int n, int n2) {
        this.major = (byte)n;
        this.minor = (byte)n2;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    public boolean equals(GIOPVersion gIOPVersion) {
        return gIOPVersion.major == this.major && gIOPVersion.minor == this.minor;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof GIOPVersion) {
            return this.equals((GIOPVersion)object);
        }
        return false;
    }

    public boolean lessThan(GIOPVersion gIOPVersion) {
        if (this.major < gIOPVersion.major) {
            return true;
        }
        return this.major == gIOPVersion.major && this.minor < gIOPVersion.minor;
    }

    public int intValue() {
        return this.major << 8 | this.minor;
    }

    public String toString() {
        return this.major + "." + this.minor;
    }

    public static GIOPVersion getInstance(byte by, byte by2) {
        switch (by << 8 | by2) {
            case 256: {
                return V1_0;
            }
            case 257: {
                return V1_1;
            }
            case 258: {
                return V1_2;
            }
        }
        return new GIOPVersion(by, by2);
    }

    public static GIOPVersion parseVersion(String string) {
        int n = string.indexOf(46);
        if (n < 1 || n == string.length() - 1) {
            throw new NumberFormatException("GIOP major, minor, and decimal point required: " + string);
        }
        int n2 = Integer.parseInt(string.substring(0, n));
        int n3 = Integer.parseInt(string.substring(n + 1, string.length()));
        return GIOPVersion.getInstance((byte)n2, (byte)n3);
    }

    public static GIOPVersion chooseRequestVersion(ORB oRB, IOR iOR) {
        GIOPVersion gIOPVersion = oRB.getGIOPVersion();
        GIOPVersion gIOPVersion2 = iOR.getGIOPVersion();
        ORBVersionImpl oRBVersionImpl = (ORBVersionImpl)iOR.getORBVersion();
        if (!oRBVersionImpl.equals(ORBVersionImpl.FOREIGN) && oRBVersionImpl.lessThan(ORBVersionImpl.NEWER)) {
            return V1_0;
        }
        byte by = gIOPVersion2.getMajor();
        byte by2 = gIOPVersion2.getMinor();
        byte by3 = gIOPVersion.getMajor();
        byte by4 = gIOPVersion.getMinor();
        if (by3 < by) {
            return gIOPVersion;
        }
        if (by3 > by) {
            return gIOPVersion2;
        }
        if (by4 <= by2) {
            return gIOPVersion;
        }
        return gIOPVersion2;
    }

    public void read(InputStream inputStream) {
        this.major = inputStream.read_octet();
        this.minor = inputStream.read_octet();
    }

    public void write(OutputStream outputStream) {
        outputStream.write_octet(this.major);
        outputStream.write_octet(this.minor);
    }

    static {
        DEFAULT_VERSION = V1_2 = new GIOPVersion(1, 2);
    }
}

