/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.web.cache.filter;

import com.sun.appserv.web.cache.filter.CachingOutputStreamWrapper;
import com.sun.appserv.web.cache.filter.HttpCacheEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class CachingResponseWrapper
extends HttpServletResponseWrapper {
    int statusCode = -1;
    HashMap headers = new HashMap();
    HashMap dateHeaders = new HashMap();
    ArrayList cookies = new ArrayList();
    int contentLength = -1;
    String contentType;
    Locale locale;
    boolean error = true;
    CachingOutputStreamWrapper cosw;
    PrintWriter writer;

    public CachingResponseWrapper(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    private CachingOutputStreamWrapper createCachingOutputStreamWrapper() throws IOException {
        return new CachingOutputStreamWrapper();
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this.writer != null) {
            throw new IllegalStateException("getOutputStream<>getWriter");
        }
        if (this.cosw == null) {
            this.cosw = this.createCachingOutputStreamWrapper();
        }
        this.error = false;
        return this.cosw;
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer != null) {
            return this.writer;
        }
        if (this.cosw != null) {
            throw new IllegalStateException("getWriter<>getOutputStream");
        }
        this.cosw = this.createCachingOutputStreamWrapper();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)((Object)this.cosw), this.getCharacterEncoding());
        this.writer = new PrintWriter(outputStreamWriter);
        this.error = false;
        return this.writer;
    }

    public void setContentLength(int n) {
        super.setContentLength(n);
        this.contentLength = n;
    }

    public void setContentType(String string) {
        super.setContentType(string);
        this.contentType = string;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        this.locale = locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCookie(Cookie cookie) {
        super.addCookie(cookie);
        ArrayList arrayList = this.cookies;
        synchronized (arrayList) {
            this.cookies.add(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHeader(String string, String string2) {
        super.setHeader(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string2);
        HashMap hashMap = this.headers;
        synchronized (hashMap) {
            this.headers.put(string, arrayList);
        }
    }

    public void setIntHeader(String string, int n) {
        this.setHeader(string, "" + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeader(String string, String string2) {
        super.addHeader(string, string2);
        ArrayList<String> arrayList = (ArrayList<String>)this.headers.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
            HashMap hashMap = this.headers;
            synchronized (hashMap) {
                this.headers.put(string, arrayList);
            }
        }
        arrayList.add(string2);
    }

    public void addIntHeader(String string, int n) {
        this.addHeader(string, "" + n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDateHeader(String string, long l) {
        super.setDateHeader(string, l);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        arrayList.add(new Long(l));
        HashMap hashMap = this.dateHeaders;
        synchronized (hashMap) {
            this.dateHeaders.put(string, arrayList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDateHeader(String string, long l) {
        super.addDateHeader(string, l);
        ArrayList<Long> arrayList = (ArrayList<Long>)this.dateHeaders.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<Long>();
            HashMap hashMap = this.dateHeaders;
            synchronized (hashMap) {
                this.dateHeaders.put(string, arrayList);
            }
        }
        arrayList.add(new Long(l));
    }

    public void setStatus(int n) {
        super.setStatus(n);
        this.statusCode = n;
    }

    public void sendError(int n) throws IOException {
        super.sendError(n);
        this.error = true;
    }

    public void sendError(int n, String string) throws IOException {
        super.sendError(n, string);
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public Long getExpiresDateHeader() {
        return (Long)this.dateHeaders.get("Expires");
    }

    public HttpCacheEntry cacheResponse() throws IOException {
        HttpCacheEntry httpCacheEntry = new HttpCacheEntry();
        httpCacheEntry.responseHeaders = this.headers;
        httpCacheEntry.dateHeaders = this.dateHeaders;
        httpCacheEntry.cookies = this.cookies;
        httpCacheEntry.contentLength = this.contentLength;
        httpCacheEntry.contentType = this.contentType;
        httpCacheEntry.locale = this.locale;
        httpCacheEntry.statusCode = this.statusCode;
        if (this.writer != null) {
            this.writer.flush();
        }
        httpCacheEntry.bytes = this.cosw.getBytes();
        return httpCacheEntry;
    }

    public void clear() {
        this.cosw = null;
        this.writer = null;
    }
}

