/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.web;

import com.iplanet.ias.config.ConfigException;
import com.iplanet.ias.config.serverbeans.Applications;
import com.iplanet.ias.config.serverbeans.HttpService;
import com.iplanet.ias.config.serverbeans.J2eeApplication;
import com.iplanet.ias.config.serverbeans.Server;
import com.iplanet.ias.config.serverbeans.VirtualServerClass;
import com.iplanet.ias.instance.WebModulesManager;
import com.iplanet.ias.server.ApplicationRegistry;
import com.iplanet.ias.util.StringUtils;
import com.iplanet.ias.util.io.FileUtils;
import com.iplanet.ias.web.WebModule;
import com.iplanet.ias.web.WebModuleConfig;
import com.sun.enterprise.Switch;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.logging.LogDomains;
import java.io.File;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;

public final class VirtualServer
extends StandardHost {
    private String _id = null;
    private long _jniVS = 0L;
    private static Logger _logger = null;
    private static ResourceBundle _rb = null;
    private boolean _debug = false;
    private static final String _info = "com.iplanet.ias.web.VirtualServer/1.0";

    public VirtualServer() {
        if (_logger == null) {
            _logger = LogDomains.getLogger("javax.enterprise.system.container.web");
            _rb = _logger.getResourceBundle();
        }
        this._debug = _logger.isLoggable(Level.FINE);
    }

    public String getID() {
        return this._id;
    }

    public void setID(String string) {
        this._id = string;
    }

    public void setJNIVirtualServer(long l) {
        this._jniVS = l;
    }

    public String getInfo() {
        return _info;
    }

    public synchronized void stop() throws LifecycleException {
        Switch switch_ = Switch.getSwitch();
        Container[] containerArray = this.findChildren();
        if (containerArray != null) {
            int n = 0;
            while (n < containerArray.length) {
                switch_.removeDescriptorFor(containerArray[n]);
                ++n;
            }
        }
        super.stop();
    }

    protected List getWebModules(Server server, String string) {
        com.iplanet.ias.config.serverbeans.WebModule[] webModuleArray;
        Vector<WebModuleConfig> vector = new Vector<WebModuleConfig>();
        Applications applications = server.getApplications();
        if (applications != null && (webModuleArray = applications.getWebModule()) != null && webModuleArray.length > 0) {
            int n = 0;
            while (n < webModuleArray.length) {
                com.iplanet.ias.config.serverbeans.WebModule webModule = webModuleArray[n];
                if (this.isActive(webModule)) {
                    WebModuleConfig webModuleConfig;
                    String string2 = webModule.getLocation();
                    File file = new File(string2);
                    if (!file.isAbsolute()) {
                        string2 = string + File.separator + string2;
                        webModule.setLocation(string2);
                    }
                    if ((webModuleConfig = this.loadWebModuleConfig(webModule)) != null) {
                        vector.add(webModuleConfig);
                    }
                } else if (this._debug) {
                    _logger.finer("Web Module [" + webModule.getName() + "] is not applicable for virtual " + " server [" + this.getID() + "]");
                }
                ++n;
            }
        }
        return vector;
    }

    protected WebModuleConfig getUserDefaultWebModuleConfig(Server server) {
        WebModuleConfig webModuleConfig = null;
        VirtualServerClass[] virtualServerClassArray = null;
        Applications applications = server.getApplications();
        HttpService httpService = server.getHttpService();
        if (httpService != null) {
            virtualServerClassArray = httpService.getVirtualServerClass();
        }
        if (virtualServerClassArray == null || applications == null) {
            return null;
        }
        String string = this.getDefaultWebModuleID(virtualServerClassArray);
        if (string != null) {
            Object object;
            webModuleConfig = this.findWebModuleInJ2eeApp(applications, string);
            if (webModuleConfig == null) {
                object = applications.getWebModuleByName(string);
                if (object != null) {
                    if (this.isActive((com.iplanet.ias.config.serverbeans.WebModule)object, false)) {
                        com.iplanet.ias.config.serverbeans.WebModule webModule = new com.iplanet.ias.config.serverbeans.WebModule();
                        webModule.setName(object.getName());
                        webModule.setLocation(object.getLocation());
                        webModule.setEnabled(object.isEnabled());
                        webModule.setContextRoot(object.getContextRoot());
                        webModule.setVirtualServers(this._id);
                        webModuleConfig = this.loadWebModuleConfig(webModule);
                        webModule.setName("default-" + webModule.getName());
                        webModule.setContextRoot("");
                    } else {
                        Object[] objectArray = new Object[]{string, this.getID()};
                        _logger.log(Level.SEVERE, "vs.defaultWebModuleDisabled", objectArray);
                        object = null;
                    }
                }
            } else {
                object = webModuleConfig.getBean();
                object.setVirtualServers(this._id);
                object.setName("default-" + object.getName());
                object.setContextRoot("");
            }
            if (webModuleConfig == null) {
                object = new Object[]{string, this.getID()};
                _logger.log(Level.SEVERE, "vs.defaultWebModuleNotFound", (Object[])object);
            }
        }
        return webModuleConfig;
    }

    protected WebModuleConfig createSystemDefaultWebModuleIfNecessary() {
        WebModuleConfig webModuleConfig = null;
        String string = this.getAppBase();
        if (this.findChild("") == null && string != null) {
            webModuleConfig = new WebModuleConfig();
            com.iplanet.ias.config.serverbeans.WebModule webModule = new com.iplanet.ias.config.serverbeans.WebModule();
            webModule.setName("default-web-module");
            webModule.setContextRoot("");
            webModule.setLocation(string);
            webModuleConfig.setBean(webModule);
            webModuleConfig.setDescriptor(null);
        }
        return webModuleConfig;
    }

    protected void handleCoreMappings() {
        Container[] containerArray = this.findChildren();
        int n = 0;
        while (n < containerArray.length) {
            StandardContext standardContext = (StandardContext)containerArray[n];
            if (standardContext.getAvailable()) {
                Object object;
                int n2;
                String[] stringArray = standardContext.findServletMappings();
                String[] stringArray2 = new String[stringArray.length];
                Object[] objectArray = new StandardWrapper[stringArray.length];
                int n3 = n2 = stringArray.length;
                int n4 = 0;
                while (n4 < stringArray.length) {
                    stringArray2[n4] = standardContext.findServletMapping(stringArray[n4]);
                    objectArray[n4] = (StandardWrapper)standardContext.findChild(stringArray2[n4]);
                    object = objectArray[n4].getServletClass();
                    if (object != null && ((String)object).equals("org.apache.catalina.servlets.InvokerServlet")) {
                        objectArray[n4] = null;
                    }
                    if (stringArray[n4].equals("/") && object != null && ((String)object).equals("org.apache.catalina.servlets.DefaultServlet")) {
                        n2 = n4;
                    }
                    ++n4;
                }
                if (n2 < stringArray.length) {
                    stringArray2[n2] = stringArray2[n3 - 1];
                    stringArray[n2] = stringArray[n3 - 1];
                    objectArray[n2] = objectArray[n3 - 1];
                    --n3;
                }
                object = new int[2 * n3];
                byte[] byArray = null;
                byArray = this.createByteBufferForMapping(n3, stringArray2, stringArray, (int[])object);
                String[] stringArray3 = standardContext.findMimeMappings();
                String[] stringArray4 = new String[stringArray3.length];
                n4 = 0;
                while (n4 < stringArray3.length) {
                    stringArray4[n4] = standardContext.findMimeMapping(stringArray3[n4]);
                    ++n4;
                }
                int[] nArray = new int[2 * stringArray3.length];
                byte[] byArray2 = this.createByteBufferForMapping(stringArray3.length, stringArray3, stringArray4, nArray);
                String[] stringArray5 = standardContext.findWelcomeFiles();
                int[] nArray2 = new int[stringArray5.length];
                byte[] byArray3 = null;
                byArray3 = this.createByteBufferForList(stringArray5, nArray2);
                int[] nArray3 = standardContext.findStatusPages();
                String[] stringArray6 = new String[nArray3.length];
                n4 = 0;
                while (n4 < nArray3.length) {
                    stringArray6[n4] = standardContext.findErrorPage(nArray3[n4]).getLocation();
                    ++n4;
                }
                byte[] byArray4 = null;
                int[] nArray4 = new int[stringArray6.length];
                byArray4 = this.createByteBufferForList(stringArray6, nArray4);
                Object[] objectArray2 = this.handleSecurityConstraints(standardContext);
                Object[] objectArray3 = this.handleFilterMappings(standardContext);
                boolean bl = standardContext.getLoginConfig() != null && standardContext.getLoginConfig().getLoginPage() != null;
                String string = ((WebModule)standardContext).getID();
                this.jniSetContextMapping(this._jniVS, standardContext, string, standardContext.getPath(), standardContext.getDocBase(), ((Object)object).length, (int[])object, byArray, objectArray, nArray.length, nArray, byArray2, nArray2.length, nArray2, byArray3, nArray3.length, nArray3, nArray4, byArray4, ((int[])objectArray2[0]).length, (int[])objectArray2[0], (int[])objectArray2[1], (byte[])objectArray2[2], (Integer)objectArray3[0], (int[])objectArray3[1], (byte[])objectArray3[2], bl);
            }
            ++n;
        }
    }

    private Object[] handleSecurityConstraints(StandardContext standardContext) {
        Object[] objectArray;
        int n;
        Object[] objectArray2;
        int n2;
        Object[] objectArray3;
        SecurityConstraint[] securityConstraintArray = standardContext.findConstraints();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < securityConstraintArray.length) {
            objectArray3 = securityConstraintArray[n6].findCollections();
            n2 = 0;
            while (n2 < objectArray3.length) {
                objectArray2 = objectArray3[n2].findPatterns();
                if (objectArray2.length > 0) {
                    ++n4;
                    n5 += objectArray3[n2].getName().getBytes().length;
                    n = 0;
                    while (n < objectArray2.length) {
                        n5 += objectArray2[n].getBytes().length;
                        ++n3;
                        ++n;
                    }
                }
                ++n2;
            }
            ++n6;
        }
        objectArray3 = new byte[n5];
        objectArray2 = new int[n3 + n4];
        int[] nArray = new int[n4];
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        n6 = 0;
        while (n6 < securityConstraintArray.length) {
            objectArray = securityConstraintArray[n6].findCollections();
            n2 = 0;
            while (n2 < objectArray.length) {
                String[] stringArray = ((SecurityCollection)objectArray[n2]).findPatterns();
                if (stringArray.length > 0) {
                    byte[] byArray = ((SecurityCollection)objectArray[n2]).getName().getBytes();
                    objectArray2[n7] = byArray.length;
                    System.arraycopy(byArray, 0, objectArray3, n8, objectArray2[n7]);
                    n8 += objectArray2[n7++];
                    nArray[n9++] = stringArray.length;
                    n = 0;
                    while (n < stringArray.length) {
                        byArray = stringArray[n].getBytes();
                        objectArray2[n7] = byArray.length;
                        System.arraycopy(byArray, 0, objectArray3, n8, objectArray2[n7]);
                        n8 += objectArray2[n7++];
                        ++n;
                    }
                }
                ++n2;
            }
            ++n6;
        }
        objectArray = new Object[]{nArray, objectArray2, objectArray3};
        return objectArray;
    }

    private Object[] handleFilterMappings(StandardContext standardContext) {
        String string;
        String string2;
        FilterMap[] filterMapArray = standardContext.findFilterMaps();
        int[] nArray = new int[2 * filterMapArray.length];
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < filterMapArray.length) {
            string2 = filterMapArray[n3].getURLPattern();
            if (string2 != null) {
                string = filterMapArray[n3].getFilterName();
                nArray[n] = string.getBytes().length;
                n2 += nArray[n++];
                nArray[n] = string2.getBytes().length;
                n2 += nArray[n++];
            }
            ++n3;
        }
        byte[] byArray = new byte[n2];
        int n4 = 0;
        n = 0;
        n3 = 0;
        while (n3 < filterMapArray.length) {
            string2 = filterMapArray[n3].getURLPattern();
            if (string2 != null) {
                string = filterMapArray[n3].getFilterName();
                System.arraycopy(string.getBytes(), 0, byArray, n4, nArray[n]);
                System.arraycopy(string2.getBytes(), 0, byArray, n4 += nArray[n++], nArray[n]);
                n4 += nArray[n++];
            }
            ++n3;
        }
        Object[] objectArray = new Object[]{new Integer(n), nArray, byArray};
        return objectArray;
    }

    private byte[] createByteBufferForMapping(int n, String[] stringArray, String[] stringArray2, int[] nArray) {
        byte[] byArray;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            byArray = stringArray[n4].getBytes();
            nArray[n3] = byArray.length;
            n2 += nArray[n3++];
            byArray = stringArray2[n4].getBytes();
            nArray[n3] = byArray.length;
            n2 += nArray[n3++];
            ++n4;
        }
        byte[] byArray2 = new byte[n2];
        int n5 = 0;
        n3 = 0;
        n4 = 0;
        while (n4 < n) {
            byArray = stringArray[n4].getBytes();
            System.arraycopy(byArray, 0, byArray2, n5, nArray[n3]);
            int n6 = n3++;
            byArray = stringArray2[n4].getBytes();
            System.arraycopy(byArray, 0, byArray2, n5 += nArray[n6], nArray[n3]);
            n5 += nArray[n3++];
            ++n4;
        }
        return byArray2;
    }

    private byte[] createByteBufferForList(String[] stringArray, int[] nArray) {
        byte[] byArray;
        int n = 0;
        int n2 = 0;
        while (n2 < stringArray.length) {
            byArray = stringArray[n2].getBytes();
            nArray[n2] = byArray.length;
            n += nArray[n2];
            ++n2;
        }
        byte[] byArray2 = new byte[n];
        int n3 = 0;
        n2 = 0;
        while (n2 < stringArray.length) {
            byArray = stringArray[n2].getBytes();
            System.arraycopy(byArray, 0, byArray2, n3, nArray[n2]);
            n3 += nArray[n2];
            ++n2;
        }
        return byArray2;
    }

    private WebModuleConfig loadWebModuleConfig(com.iplanet.ias.config.serverbeans.WebModule webModule) {
        WebModuleConfig webModuleConfig = new WebModuleConfig();
        webModuleConfig.setBean(webModule);
        String string = webModule.getName();
        String string2 = webModule.getLocation();
        try {
            WebBundleDescriptor webBundleDescriptor = WebModulesManager.getDescriptor(string, string2);
            webModuleConfig.setDescriptor(webBundleDescriptor);
        }
        catch (ConfigException configException) {
            webModuleConfig = null;
            String string3 = _rb.getString("vs.moduleConfigError");
            Object[] objectArray = new Object[]{string, this.getID()};
            string3 = MessageFormat.format(string3, objectArray);
            _logger.log(Level.SEVERE, string3, configException);
        }
        return webModuleConfig;
    }

    private boolean isActive(com.iplanet.ias.config.serverbeans.WebModule webModule) {
        return this.isActive(webModule, true);
    }

    private boolean isActive(com.iplanet.ias.config.serverbeans.WebModule webModule, boolean bl) {
        String string = this.getID();
        boolean bl2 = string != null && string.length() > 0;
        if (bl2 &= webModule != null) {
            List list;
            bl2 &= webModule.isEnabled();
            String string2 = webModule.getVirtualServers();
            bl2 = string2 != null && bl ? ((list = StringUtils.parseStringList((String)string2, (String)" ,")) != null ? (bl2 &= list.contains(string.trim())) : (bl2 &= true)) : (bl2 &= true);
        }
        return bl2;
    }

    private String getDefaultWebModuleID(VirtualServerClass[] virtualServerClassArray) {
        String string = null;
        com.iplanet.ias.config.serverbeans.VirtualServer virtualServer = null;
        int n = 0;
        while (n < virtualServerClassArray.length) {
            virtualServer = virtualServerClassArray[n].getVirtualServerById(this._id);
            if (virtualServer != null) break;
            ++n;
        }
        if (virtualServer != null) {
            string = virtualServer.getDefaultWebModule();
            if (string != null && this._debug) {
                Object[] objectArray = new Object[]{string, this._id};
                _logger.log(Level.FINE, "vs.defaultWebModule", objectArray);
            }
        } else {
            _logger.log(Level.SEVERE, "vs.configError", this._id);
        }
        return string;
    }

    private WebModuleConfig findWebModuleInJ2eeApp(Applications applications, String string) {
        int n = string.lastIndexOf(":");
        WebModuleConfig webModuleConfig = null;
        int n2 = string.length();
        if (n != -1 && n < n2 - 1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1);
            J2eeApplication j2eeApplication = applications.getJ2eeApplicationByName(string2);
            if (j2eeApplication != null && j2eeApplication.isEnabled()) {
                Application application;
                String string4 = j2eeApplication.getLocation();
                String string5 = FileUtils.makeFriendlyFilename(string3);
                ApplicationRegistry applicationRegistry = ApplicationRegistry.getInstance();
                ClassLoader classLoader = applicationRegistry.getClassLoaderForApplication(string2);
                if (classLoader != null && (application = applicationRegistry.getApplication(classLoader)) != null) {
                    Set set = application.getWebBundleDescriptors();
                    WebBundleDescriptor webBundleDescriptor = null;
                    Iterator iterator = set.iterator();
                    while (iterator.hasNext()) {
                        webBundleDescriptor = (WebBundleDescriptor)iterator.next();
                        String string6 = webBundleDescriptor.getArchivist().getArchiveUri();
                        if (!string3.equals(string6)) continue;
                        StringBuffer stringBuffer = new StringBuffer(string4);
                        stringBuffer.append(File.separator);
                        stringBuffer.append(string5);
                        com.iplanet.ias.config.serverbeans.WebModule webModule = new com.iplanet.ias.config.serverbeans.WebModule();
                        webModule.setName(string3);
                        webModule.setContextRoot(webBundleDescriptor.getContextRoot());
                        webModule.setLocation(stringBuffer.toString());
                        webModule.setEnabled(true);
                        String string7 = j2eeApplication.getVirtualServers();
                        webModule.setVirtualServers(string7);
                        webModuleConfig = new WebModuleConfig();
                        webModuleConfig.setBean(webModule);
                        webModuleConfig.setDescriptor(webBundleDescriptor);
                        webModuleConfig.setParentLoader(classLoader);
                        break;
                    }
                }
            } else {
                Object[] objectArray = new Object[]{string, this.getID()};
                _logger.log(Level.SEVERE, "vs.defaultWebModuleDisabled", objectArray);
            }
        }
        return webModuleConfig;
    }

    private native void jniSetContextMapping(long var1, Object var3, String var4, String var5, String var6, int var7, int[] var8, byte[] var9, Object[] var10, int var11, int[] var12, byte[] var13, int var14, int[] var15, byte[] var16, int var17, int[] var18, int[] var19, byte[] var20, int var21, int[] var22, int[] var23, byte[] var24, int var25, int[] var26, byte[] var27, boolean var28);
}

