/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.diagnostics;

import com.iplanet.ias.util.Assertion;
import com.iplanet.ias.util.diagnostics.CallerInfo;
import com.iplanet.ias.util.diagnostics.CallerInfoException;
import com.iplanet.ias.util.diagnostics.IReporterEnum;
import com.iplanet.ias.util.diagnostics.ObjectAnalyzer;
import com.iplanet.ias.util.diagnostics.ReporterWriter;
import com.iplanet.ias.util.diagnostics.StackTrace;
import com.sun.logging.LogDomains;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReporterImpl
implements IReporterEnum {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private int severityLevel = 7;
    private String name = "Main";
    private ReporterWriter writer;
    private String className;
    private static final boolean doDebug = false;

    public ReporterImpl() {
        this.ctor(null, -1);
    }

    ReporterImpl(int n) {
        this.ctor(null, n);
    }

    public ReporterImpl(String string) {
        this.ctor(string, -1);
    }

    ReporterImpl(String string, int n) {
        this.ctor(string, n);
    }

    public void setSeverityLevel(int n) {
        this.debug("setSeverityLevel(" + n + ")");
        if (n < 0) {
            n = 0;
        }
        this.severityLevel = n;
    }

    public void setSeverityLevel(String string) {
        this.debug("setSeverityLevel(" + string + ")");
        this.severityLevel = this.calcSeverityLevel(string);
    }

    public int getSeverityLevel() {
        return this.severityLevel;
    }

    public String getSeverityLevelString() {
        if (this.severityLevel <= 7) {
            return IReporterEnum.severityNames[this.severityLevel];
        }
        return IReporterEnum.severityNames[7];
    }

    public void setName(String string) {
        Assertion.check(string);
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void verbose(Object object) {
        if (this.checkSeverity(1)) {
            this.pr(1, object);
        }
    }

    public void info(Object object) {
        if (this.checkSeverity(2)) {
            this.pr(2, object);
        }
    }

    public void warn(Object object) {
        if (this.checkSeverity(3)) {
            this.pr(3, object);
        }
    }

    public void warning(Object object) {
        if (this.checkSeverity(3)) {
            this.pr(3, object);
        }
    }

    public void error(Object object) {
        if (this.checkSeverity(4)) {
            this.pr(4, object);
        }
    }

    public void critical(Object object) {
        if (this.checkSeverity(5)) {
            this.pr(5, object);
        }
    }

    public void crit(Object object) {
        if (this.checkSeverity(5)) {
            this.pr(5, object);
        }
    }

    public void dump(Object object, String string) {
        if (this.checkSeverity(0) && object != null) {
            if (string == null) {
                string = "";
            }
            String string2 = string + "\n**********  Object Dump Start  ***********\n" + ObjectAnalyzer.toStringWithSuper(object) + "\n**********  Object Dump End  ***********";
            this.pr(0, string2);
        }
    }

    public void dump(String string) {
        if (this.checkSeverity(0)) {
            this.pr(0, string);
        }
    }

    public void dump(Object object) {
        this.dump(object, null);
    }

    public void insist(String string) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(string);
            }
            catch (Assertion.Failure failure) {
                this.pr(6, new StackTrace().toString() + failure);
                throw failure;
            }
        }
    }

    public void insist(String string, String string2) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(string, string2);
            }
            catch (Assertion.Failure failure) {
                this.pr(6, new StackTrace().toString() + failure);
                throw failure;
            }
        }
    }

    public void insist(boolean bl) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(bl);
            }
            catch (Assertion.Failure failure) {
                this.pr(6, new StackTrace().toString() + failure);
                throw failure;
            }
        }
    }

    public void insist(boolean bl, String string) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(bl, string);
            }
            catch (Assertion.Failure failure) {
                this.pr(6, new StackTrace().toString() + failure);
                throw failure;
            }
        }
    }

    public void insist(Object object) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(object);
            }
            catch (Assertion.Failure failure) {
                this.pr(6, new StackTrace().toString() + failure);
                throw failure;
            }
        }
    }

    public void insist(Object object, String string) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(object, string);
            }
            catch (Assertion.Failure failure) {
                this.pr(6, new StackTrace().toString() + failure);
                throw failure;
            }
        }
    }

    public void insist(double d) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(d);
            }
            catch (Assertion.Failure failure) {
                this.pr(6, new StackTrace().toString() + failure);
                throw failure;
            }
        }
    }

    public void insist(double d, String string) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(d, string);
            }
            catch (Assertion.Failure failure) {
                this.pr(6, new StackTrace().toString() + failure);
                throw failure;
            }
        }
    }

    public void insist(long l) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(l);
            }
            catch (Assertion.Failure failure) {
                this.pr(6, new StackTrace().toString() + failure);
                throw failure;
            }
        }
    }

    public void insist(long l, String string) {
        if (this.checkSeverity(6)) {
            try {
                Assertion.check(l, string);
            }
            catch (Assertion.Failure failure) {
                this.pr(6, new StackTrace().toString() + failure);
                throw failure;
            }
        }
    }

    public ReporterWriter setWriter(ReporterWriter reporterWriter) {
        ReporterWriter reporterWriter2 = null;
        if (null != reporterWriter) {
            reporterWriter2 = this.writer;
            this.writer = reporterWriter;
        }
        return reporterWriter2;
    }

    private void ctor(String string, int n) {
        if (string != null && string.length() > 0) {
            this.setName(string);
        }
        if (n >= 0) {
            this.setSeverityLevel(n);
        } else {
            String string2 = System.getProperty("ForteReporterDebugLevel");
            if (string2 != null && string2.length() > 0) {
                this.setSeverityLevel(string2);
            }
            if ((string2 = System.getProperty("com.iplanet.util.diagnostic.Reporter.severityLevel")) != null && string2.length() > 0) {
                this.setSeverityLevel(string2);
            }
            if ((string2 = System.getProperty("com.iplanet.ias.util.diagnostic.Reporter.severityLevel")) != null && string2.length() > 0) {
                this.setSeverityLevel(string2);
            }
            if ((string2 = System.getProperty("Reporter")) != null && string2.length() > 0) {
                this.setSeverityLevel(string2);
            }
        }
        this.className = this.getClass().getName();
        this.writer = new ReporterWriter(this.getName());
        this.debug("Ctor called");
        this.debug("ReporterImpl Severity Level:  " + this.getSeverityLevel());
    }

    private boolean checkSeverity(int n) {
        return n >= this.severityLevel;
    }

    private CallerInfo getCallerInfo() {
        try {
            return new CallerInfo(new Object[]{this});
        }
        catch (CallerInfoException callerInfoException) {
            this.debug(callerInfoException.toString());
            return null;
        }
    }

    private void pr(int n, Object object) {
        try {
            String string;
            CallerInfo callerInfo = this.getCallerInfo();
            if (object == null) {
                string = "null Object argument";
            } else {
                string = object.toString();
                if (string == null) {
                    string = "null toString result from Object";
                }
            }
            if (callerInfo != null) {
                string = callerInfo.toString() + ": " + string;
            }
            this.writer.println(n, string);
        }
        catch (Throwable throwable) {
            _logger.log(Level.WARNING, "iplanet_util.pr_exception", throwable);
        }
    }

    private String getClassName() {
        Assertion.check(this.className);
        return this.className;
    }

    /*
     * Unable to fully structure code
     */
    private int calcSeverityLevel(String var1_1) {
        if (var1_1 == null || var1_1.length() <= 0) {
            return 1000;
        }
        var2_2 = var1_1.toUpperCase();
        try {
            var3_3 = Integer.parseInt(var2_2);
            if (var3_3 < 0) {
                var3_3 = 0;
            }
            return var3_3;
        }
        catch (NumberFormatException var3_4) {
            if (var2_2.equals("ALL") || var2_2.equals("NOISY") || var2_2.equals("EVERYTHING") || var2_2.equals("ON") || var2_2.equals("MONDO") || var2_2.equals("YES") || var2_2.equals("TRUE") || var2_2.equals("DUMP") || var2_2.startsWith("MAX")) {
                return 0;
            }
            if (var2_2.startsWith("NO") || var2_2.equals("OFF") || var2_2.equals("FALSE") || var2_2.equals("QUIET") || var2_2.startsWith("MIN")) {
                return 1000;
            }
            var3_5 = var2_2.charAt(0);
            var4_6 = 0;
            ** while (var4_6 < IReporterEnum.severityNames.length)
        }
lbl-1000:
        // 1 sources

        {
            if (IReporterEnum.severityNames[var4_6].toUpperCase().charAt(0) == var3_5) {
                return var4_6;
            }
            ++var4_6;
            continue;
        }
lbl21:
        // 1 sources

        this.debug("Unknown value for commandline argument \"-DIABDebug=" + var1_1 + "\"");
        return 1000;
    }

    private void debug(String string) {
    }
}

