/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.diagnostics;

import com.iplanet.ias.util.StringUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ProfilerImpl {
    Item currItem = null;
    List items = new ArrayList();
    int numBegins = 0;
    int numEnds = 0;
    int numActualEnds = 0;

    public void reset() {
        this.currItem = null;
        this.items.clear();
        this.numBegins = 0;
        this.numEnds = 0;
        this.numActualEnds = 0;
    }

    public void beginItem() {
        this.beginItem("No Description");
    }

    public void beginItem(String string) {
        this.currItem = new Item(string);
        this.items.add(this.currItem);
        ++this.numBegins;
    }

    public void endItem() {
        ++this.numEnds;
        Item item = this.getLastNotEnded();
        if (item != null) {
            item.end();
        }
        ++this.numActualEnds;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\nBegins: " + this.numBegins + ", Ends: " + this.numEnds + ", Actual Ends: " + this.numActualEnds + "\n");
        stringBuffer.append(Item.getHeader());
        stringBuffer.append("\n");
        Iterator iterator = this.items.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            stringBuffer.append(item.toString());
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    private Item getLastNotEnded() {
        int n = this.items.size();
        while (--n >= 0) {
            Item item = (Item)this.items.get(n);
            if (item.hasEnded()) continue;
            return item;
        }
        return null;
    }

    public static void main(String[] stringArray) {
        ProfilerImpl profilerImpl = new ProfilerImpl();
        try {
            profilerImpl.beginItem("first item");
            Thread.sleep(3000L);
            profilerImpl.beginItem("second item here dude whoa yowser yowser");
            Thread.sleep(1500L);
            profilerImpl.endItem();
            profilerImpl.endItem();
            System.out.println("" + profilerImpl);
        }
        catch (Exception exception) {}
    }

    private static class Item {
        String title;
        long startTime;
        long endTime;
        static int longestTitle = 12;
        boolean ended = false;

        Item(String string) {
            this.title = string;
            this.endTime = this.startTime = System.currentTimeMillis();
            if (this.title.length() > longestTitle) {
                longestTitle = this.title.length();
            }
        }

        boolean hasEnded() {
            return this.ended;
        }

        void end() {
            this.endTime = System.currentTimeMillis();
            this.ended = true;
        }

        public String toString() {
            long l = this.hasEnded() ? this.endTime : System.currentTimeMillis();
            String string = "" + (l - this.startTime);
            if (string.equals("0")) {
                string = "< 1";
            }
            String string2 = StringUtils.padRight((String)this.title, (int)(longestTitle + 1));
            String string3 = StringUtils.padLeft((String)string, (int)8);
            if (!this.hasEnded()) {
                string3 = string3 + "  ** STILL RUNNING **";
            }
            return string2 + string3;
        }

        public static String getHeader() {
            return "\n" + StringUtils.padRight((String)"Description", (int)(longestTitle + 1)) + StringUtils.padLeft((String)"msec", (int)8);
        }
    }
}

