/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.collection;

import com.iplanet.ias.util.collection.Bucket;
import com.iplanet.ias.util.collection.SortedArrayListBucket;

public class LongHashMap {
    int maxBuckets = 0;
    Bucket[] buckets;

    public LongHashMap() {
        this(89);
    }

    public LongHashMap(int n) {
        this.maxBuckets = n;
        this.buckets = new Bucket[n];
        int n2 = 0;
        while (n2 < n) {
            this.buckets[n2] = new SortedArrayListBucket();
            ++n2;
        }
    }

    public LongHashMap(Bucket[] bucketArray) {
        this.buckets = bucketArray;
        this.maxBuckets = bucketArray.length;
    }

    public void put(long l, Object object) {
        int n = (int)Math.abs(l % (long)this.maxBuckets);
        this.buckets[n].put(l, object);
    }

    public Object get(long l) {
        int n = (int)Math.abs(l % (long)this.maxBuckets);
        return this.buckets[n].get(l);
    }

    public Object remove(long l) {
        int n = (int)Math.abs(l % (long)this.maxBuckets);
        return this.buckets[n].remove(l);
    }

    public void print() {
        int n = 0;
        while (n < this.maxBuckets) {
            System.out.println("Bucket[" + n + "]: " + this.buckets[n]);
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        int n = 20;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        String string = "SomeData_";
        LongHashMap longHashMap = new LongHashMap();
        long l4 = 0L;
        while (l4 < (long)n) {
            longHashMap.put(l4, string + l4);
            l4 += 5L;
        }
        long l5 = 1L;
        while (l5 < (long)n) {
            longHashMap.put(l5, string + l5);
            l5 += 3L;
        }
        long l6 = 3L;
        while (l6 < (long)n) {
            longHashMap.put(l6, string + l6);
            l6 += 4L;
        }
        long l7 = -23L;
        while (l7 < (long)n) {
            longHashMap.put(l7, string + l7);
            l7 += 4L;
        }
        long l8 = -25L;
        while (l8 < 25L) {
            System.out.println("Key: " + l8 + "; val: " + longHashMap.get(l8));
            ++l8;
        }
        l3 = System.currentTimeMillis();
    }
}

