/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ias.util.cache;

import com.iplanet.ias.util.cache.Cache;
import com.iplanet.ias.util.cache.CacheEventListener;
import com.iplanet.ias.util.cache.CacheNode;
import com.iplanet.ias.util.cache.CacheStore;
import com.iplanet.ias.util.cache.CacheVictimSelector;
import com.iplanet.ias.util.scheduler.PeriodicEventScheduler;
import com.iplanet.ias.util.scheduler.PeriodicallyServicable;
import com.sun.logging.LogDomains;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public class SimpleAssociativeCache
implements Cache,
PeriodicallyServicable {
    static Logger _logger = LogDomains.getLogger("javax.enterprise.system.util");
    private int loWaterMark;
    private int hiWaterMark;
    CacheNode[] buckets;
    Object[] bucketLocks;
    int maxBuckets;
    CacheStore backupStore;
    CacheVictimSelector victimSelector;
    private int size;
    private PeriodicEventScheduler scheduler = PeriodicEventScheduler.getInstance();
    private boolean isSelectingVictims = false;
    private CacheEventListener container;
    private boolean debug = false;

    public SimpleAssociativeCache(int n, int n2, CacheStore cacheStore, CacheVictimSelector cacheVictimSelector) {
        this((int)((double)n2 * 1.5), n, n2, cacheStore, cacheVictimSelector);
    }

    public SimpleAssociativeCache(int n, int n2, int n3, CacheStore cacheStore, CacheVictimSelector cacheVictimSelector) {
        this.buckets = new CacheNode[n];
        this.bucketLocks = new Object[n];
        this.maxBuckets = n;
        int n4 = 0;
        while (n4 < n) {
            this.buckets[n4] = null;
            this.bucketLocks[n4] = new Object();
            ++n4;
        }
        this.backupStore = cacheStore;
        this.victimSelector = cacheVictimSelector;
        this.size = 0;
        this.loWaterMark = n2;
        this.hiWaterMark = n3;
    }

    public boolean contains(Object object) {
        return this.getEntry(object) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getEntry(Object object) {
        CacheNode cacheNode;
        int n = object.hashCode();
        int n2 = (Integer.MAX_VALUE & n) % this.maxBuckets;
        Object object2 = this.bucketLocks[n2];
        synchronized (object2) {
            cacheNode = this.buckets[n2];
            while (cacheNode != null) {
                if (n == cacheNode.keyHashCode && object.equals(cacheNode.key)) break;
                cacheNode = cacheNode.next;
            }
        }
        if (cacheNode != null) {
            this.victimSelector.nodeAccessed(cacheNode);
            return cacheNode.object;
        }
        return this.load(object, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putEntry(Object object, Object object2) {
        CacheNode cacheNode;
        int n = object.hashCode();
        int n2 = (Integer.MAX_VALUE & n) % this.maxBuckets;
        Object object3 = null;
        Object object4 = this.bucketLocks[n2];
        synchronized (object4) {
            cacheNode = this.buckets[n2];
            while (cacheNode != null) {
                if (n == cacheNode.keyHashCode && object.equals(cacheNode.key)) {
                    object3 = cacheNode.object;
                    cacheNode.object = object2;
                    break;
                }
                cacheNode = cacheNode.next;
            }
            if (object3 == null) {
                cacheNode = new CacheNode(object, n, object2);
                cacheNode.next = this.buckets[n2];
                this.buckets[n2] = cacheNode;
            }
        }
        if (object3 != null) {
            this.victimSelector.nodeAccessed(cacheNode);
            return object3;
        }
        this.victimSelector.nodeCreated(cacheNode);
        SimpleAssociativeCache simpleAssociativeCache = this;
        synchronized (simpleAssociativeCache) {
            if (++this.size < this.hiWaterMark || this.isSelectingVictims) {
                return null;
            }
            this.isSelectingVictims = true;
        }
        this.makeRoom();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeEntry(Object object) {
        int n = object.hashCode();
        int n2 = (Integer.MAX_VALUE & n) % this.maxBuckets;
        CacheNode cacheNode = null;
        CacheNode cacheNode2 = null;
        Object object2 = this.bucketLocks[n2];
        synchronized (object2) {
            cacheNode2 = this.buckets[n2];
            while (cacheNode2 != null) {
                if (n == cacheNode2.keyHashCode && object.equals(cacheNode2.key)) break;
                cacheNode = cacheNode2;
                cacheNode2 = cacheNode2.next;
            }
            if (cacheNode2 == null) {
                return this.backupStore.lookup(object);
            }
            if (cacheNode == null) {
                this.buckets[n2] = cacheNode2.next;
            } else {
                cacheNode.next = cacheNode2.next;
            }
            cacheNode2.next = null;
        }
        SimpleAssociativeCache simpleAssociativeCache = this;
        synchronized (simpleAssociativeCache) {
            --this.size;
        }
        this.victimSelector.nodeRemoved(cacheNode2);
        return cacheNode2.object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator keys() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.maxBuckets) {
            Object object = this.bucketLocks[n];
            synchronized (object) {
                CacheNode cacheNode = this.buckets[n];
                while (cacheNode != null) {
                    arrayList.add(cacheNode.key);
                    cacheNode = cacheNode.next;
                }
            }
            ++n;
        }
        return arrayList.iterator();
    }

    private Object load(Object object, int n) {
        Object object2 = this.backupStore.lookup(object);
        if (object2 == null) {
            return null;
        }
        this.putEntry(object, object2);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeRoom() {
        int n = 0;
        CacheNode[] cacheNodeArray = this.victimSelector.selectVictims(this.size - this.loWaterMark);
        CacheNode cacheNode = null;
        int n2 = cacheNodeArray.length;
        while (n2-- > 0) {
            cacheNode = cacheNodeArray[n2];
            if (this.container != null) {
                this.container.victimSelected(cacheNode.object);
            }
            this.backupStore.store(cacheNode.key, cacheNode.object);
            int n3 = (Integer.MAX_VALUE & cacheNode.keyHashCode) % this.maxBuckets;
            Object object = this.bucketLocks[n3];
            synchronized (object) {
                CacheNode cacheNode2 = null;
                CacheNode cacheNode3 = this.buckets[n3];
                while (cacheNode3 != null) {
                    if (cacheNode3 == cacheNode) {
                        if (cacheNode2 == null) {
                            this.buckets[n3].next = cacheNode3.next;
                        } else {
                            cacheNode2.next = cacheNode3.next;
                        }
                        cacheNode3.object = null;
                        cacheNode3.key = null;
                        ++n;
                        break;
                    }
                    cacheNode2 = cacheNode3;
                    cacheNode3 = cacheNode3.next;
                }
            }
        }
        SimpleAssociativeCache simpleAssociativeCache = this;
        synchronized (simpleAssociativeCache) {
            this.isSelectingVictims = false;
            this.size -= n;
        }
    }

    public long getFrequency() {
        return 60000L;
    }

    public boolean getExecuteIfMissed() {
        return true;
    }

    public boolean getExecutionTolerance(long l) {
        return true;
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void prolog() {
    }

    public void service() {
        this.makeRoom();
    }

    public void epilog() {
    }

    public Object getLockForEntry(Object object) {
        int n = object.hashCode();
        int n2 = (Integer.MAX_VALUE & n) % this.maxBuckets;
        return this.bucketLocks[n2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator values() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < this.maxBuckets) {
            Object object = this.bucketLocks[n];
            synchronized (object) {
                CacheNode cacheNode = this.buckets[n];
                while (cacheNode != null && cacheNode.object != null) {
                    arrayList.add(cacheNode.object);
                    cacheNode = cacheNode.next;
                }
            }
            ++n;
        }
        return arrayList.iterator();
    }

    public void setCacheEventListener(CacheEventListener cacheEventListener) {
        this.container = cacheEventListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getKeyEntry(Object object, Object object2) {
        CacheNode cacheNode;
        int n = object.hashCode();
        int n2 = (Integer.MAX_VALUE & n) % this.maxBuckets;
        Object object3 = this.bucketLocks[n2];
        synchronized (object3) {
            cacheNode = this.buckets[n2];
            while (cacheNode != null) {
                if (n == cacheNode.keyHashCode && object.equals(cacheNode.key)) break;
                cacheNode = cacheNode.next;
            }
        }
        if (cacheNode != null) {
            this.victimSelector.nodeAccessed(cacheNode);
            return cacheNode.object;
        }
        return this.load(object, n, object2);
    }

    private Object load(Object object, int n, Object object2) {
        Object object3 = this.backupStore.lookup(object);
        if (object3 == null) {
            return null;
        }
        if (this.container != null) {
            this.container.activate(object, object3, object2);
        }
        this.putEntry(object, object3);
        return object3;
    }
}

